/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.dbUI.graph.jle.AccessibleJLEWindow;
import oracle.bali.dbUI.graph.jle.Content;
import oracle.bali.dbUI.graph.jle.JLEComponentBorder;
import oracle.bali.dbUI.graph.jle.NodeBoundsTool;
import oracle.bali.dbUI.graph.jle.NodeTool;
import oracle.bali.dbUI.graph.jle.TitleBar;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.SynthesizingImageSet;
import oracle.bali.ewt.layout.MaximumBorderLayout;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.ComponentItem;

public class JLEWindow
extends ComponentItem {
    private boolean _selected;
    private boolean _minimized;
    private boolean _resizable;
    private TitleBar _titleBar;
    private Component _content;
    private JLEContainer _middle;
    private PropertyChangeSupport _support;
    private VetoableChangeSupport _vetoSupport;
    private ImageSet _minimizedSet;
    private Rectangle2D _savedBounds;
    private Border _border;
    private MinComp _minimizedComponent;
    private boolean _defaultSize = true;
    private boolean _added = false;

    public JLEWindow() {
        super((Component)((Object)new Content()), 60L);
        Content content = (Content)((Object)this.getComponent());
        content.setWindow(this);
        content.setLayout((LayoutManager)new MaximumBorderLayout());
        content.setBackground(UIManager.getDefaults().getColor(LookAndFeel.CONTROL));
        this._middle = new JLEContainer();
        this._middle.setBackground(UIManager.getDefaults().getColor(LookAndFeel.WINDOW));
        this._middle.setLayout((LayoutManager)new MaximumBorderLayout());
        this._middle.setBorder((Border)new BorderAdapter((BorderPainter)new BP()));
        this._titleBar = new TitleBar(this);
        content.add("North", this._titleBar);
        content.add("Center", this._middle);
        this.setBorder((Border)new BorderAdapter((BorderPainter)new JLEComponentBorder(this._middle, this._titleBar)));
        this._resizable = true;
        this.setForcedMouseConsumption(false);
    }

    public void setToolTipText(String text) {
        this._titleBar.setToolTipText(text);
        if (this._minimizedComponent != null) {
            this._minimizedComponent.setToolTipText(text);
        }
    }

    public String getToolTipText() {
        return this._titleBar.getToolTipText();
    }

    void setAutoDisplayToolTips(boolean autoDisplay) {
        if (this.getAutoDisplayToolTips() != autoDisplay) {
            this._titleBar.setAutoDisplay(autoDisplay);
            if (autoDisplay) {
                if (this._titleBar.isToolTipDefaulted() && this._minimizedComponent != null) {
                    this._minimizedComponent.setToolTipText(this.getTitle());
                }
            } else if (this._titleBar.isToolTipDefaulted() && this._minimizedComponent != null) {
                this._minimizedComponent.setToolTipText(null);
            }
        }
    }

    boolean getAutoDisplayToolTips() {
        return this._titleBar.getAutoDisplay();
    }

    public void setBorder(Border border) {
        Content content = (Content)((Object)this.getComponent());
        content.setBorder(border);
        this._border = border;
    }

    public Border getBorder() {
        return this._border;
    }

    public void setContent(Component content) {
        if (this._content != content) {
            if (this._content != null) {
                this._middle.remove(this._content);
            }
            this._content = content;
            if (this._content != null) {
                Accessible a;
                this._middle.add(this._content, "Center");
                if (this._content instanceof Accessible && (a = (Accessible)((Object)this._content)).getAccessibleContext() != null) {
                    a.getAccessibleContext().setAccessibleParent((Accessible)((Object)this));
                }
            }
            this._invalidateAndRepaint();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Component getContent() {
        return this._content;
    }

    public ImageSet getMinimizedImageSet() {
        return this._minimizedSet;
    }

    public final void setMinimizedImage(Image image) {
        this.setMinimizedImageSet((ImageSet)new SynthesizingImageSet(image));
    }

    public void setMinimizedImageSet(ImageSet imageSet) {
        if (this._minimizedSet != imageSet) {
            this._minimizedSet = imageSet;
            this._invalidateAndRepaint();
        }
    }

    public boolean isEnabled() {
        return this._titleBar.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        Component content;
        this.getComponent().setEnabled(enabled);
        this._titleBar.setEnabled(enabled);
        if (this._minimizedComponent != null) {
            this._minimizedComponent.setEnabled(enabled);
        }
        if ((content = this.getContent()) != null) {
            content.setEnabled(enabled);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            this._selected = selected;
            this._titleBar.setSelected(selected);
            this.firePropertyChange("selected", new Boolean(!this._selected), new Boolean(this._selected));
        }
    }

    public Image getImage() {
        return this._titleBar.getImage();
    }

    public void setImage(Image image) {
        this._titleBar.setImage(image);
    }

    public boolean isClosable() {
        return this._titleBar.isClosable();
    }

    public void setClosable(boolean closable) {
        this._titleBar.setClosable(closable);
    }

    public boolean isMinimized() {
        return !this._middle.isVisible();
    }

    public void setMinimized(boolean minimized) {
        if (this.isMinimized() != minimized) {
            if (this.fireVetoableChange("minimized", new Boolean(!minimized), new Boolean(minimized))) {
                return;
            }
            if (this.getMinimizedImageSet() == null) {
                Dimension oldSize = this.getComponent().getPreferredSize();
                this._middle.setVisible(!minimized);
                this._titleBar.__updateButtons();
                this._invalidateAndRepaint();
                Dimension newSize = this.getComponent().getPreferredSize();
                int width = minimized ? oldSize.width : newSize.width;
                this.setItemSize(width, newSize.height);
            } else {
                this._updateBoundsTool(minimized);
                Content content = (Content)((Object)this.getComponent());
                if (minimized) {
                    this._savedBounds = this.getItemBounds();
                    this._middle.setVisible(false);
                    this._titleBar.setVisible(false);
                    if (this._minimizedComponent == null) {
                        this._minimizedComponent = new MinComp();
                        this._minimizedComponent.setToolTipText(this.getToolTipText());
                        content.add("South", (Component)((Object)this._minimizedComponent));
                    }
                    this._minimizedComponent.setVisible(true);
                    content.setBorder(null);
                    Dimension newSize = this.getComponent().getPreferredSize();
                    double diff = this._savedBounds.getWidth() - (double)newSize.width;
                    this.setItemBounds(this._savedBounds.getX() + diff, this._savedBounds.getY(), newSize.width, newSize.height);
                    this._savedBounds.setRect(diff, 0.0, this._savedBounds.getWidth(), this._savedBounds.getHeight());
                    Window parent = SwingUtilities.windowForComponent(this.getComponent());
                    Component focusComponent = SwingUtilities.findFocusOwner(parent);
                    if (focusComponent != null && ((Container)this.getComponent()).isAncestorOf(focusComponent)) {
                        this.getComponent().requestFocus();
                    }
                } else {
                    UIDefaults defaults = UIManager.getDefaults();
                    this._minimizedComponent.setVisible(false);
                    this._titleBar.setVisible(true);
                    this._middle.setVisible(true);
                    content.setBorder(this.getBorder());
                    this._titleBar.__updateButtons();
                    Rectangle2D oldBounds = this.getItemBounds();
                    this.setItemBounds(oldBounds.getX() - this._savedBounds.getX(), oldBounds.getY(), this._savedBounds.getWidth(), this._savedBounds.getHeight());
                }
                this._invalidateAndRepaint();
            }
            this.firePropertyChange("minimized", new Boolean(!minimized), new Boolean(minimized));
            if (this.getCanvas() != null) {
                this.getCanvas().repaint();
            }
        }
    }

    public String getTitle() {
        return this._titleBar.getTitle();
    }

    public void setTitle(String title) {
        if (this.getTitle() != title) {
            this._titleBar.setTitle(title);
        }
    }

    public void setTitleBarPainter(Painter p) {
        this._titleBar.setPainter(p);
    }

    public Painter getTitleBarPainter() {
        return this._titleBar.getPainter();
    }

    public void setTitleBarBackground(Color color) {
        this._titleBar.setTitleBackground(color);
    }

    public Color getTitleBarBackground() {
        return this._titleBar.getBackground();
    }

    public void setTitleBarForeground(Color color) {
        this._titleBar.setTitleForeground(color);
    }

    public Color getTitleBarForeground() {
        return this._titleBar.getForeground();
    }

    public boolean isVisible() {
        return this.getComponent().isVisible();
    }

    public void setVisible(boolean isVisible) {
        this.getComponent().setVisible(isVisible);
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        if (this._resizable != resizable) {
            this._resizable = resizable;
            NodeBoundsTool.setResizable((LayoutItem)this, (boolean)resizable);
        }
    }

    public boolean close() {
        if (this.fireVetoableChange("closed", Boolean.FALSE, Boolean.TRUE)) {
            return false;
        }
        this.firePropertyChange("closed", Boolean.FALSE, Boolean.TRUE);
        return true;
    }

    void __setItemSize(double width, double height) {
        boolean before = this._defaultSize;
        this.setItemSize(width, height);
        if (!this._added) {
            this._defaultSize = before;
        }
    }

    public void setItemSize(double width, double height) {
        if (width != 0.0 && height != 0.0) {
            this._defaultSize = false;
        }
        Rectangle oldBounds = this.getItemBounds().getBounds();
        Dimension min = this.getComponent().getMinimumSize();
        if (width < (double)min.width) {
            width = min.width;
        }
        if (height < (double)min.height) {
            height = min.height;
        }
        Dimension max = this.getComponent().getPreferredSize();
        if (max.width > 0 && width > (double)max.width) {
            width = max.width;
        }
        if (max.height > 0 && height > (double)max.height) {
            height = max.height;
        }
        super.setItemSize(width, height);
        Rectangle newBounds = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", oldBounds, newBounds);
    }

    public void setItemBounds(double x, double y, double width, double height) {
        if (width != 0.0 && height != 0.0) {
            this._defaultSize = false;
        }
        Rectangle oldBounds = this.getItemBounds().getBounds();
        Dimension min = this.getComponent().getMinimumSize();
        if (width < (double)min.width) {
            width = min.width;
        }
        if (height < (double)min.height) {
            height = min.height;
        }
        Dimension max = this.getComponent().getPreferredSize();
        if (max.width > 0 && width > (double)max.width) {
            width = max.width;
        }
        if (max.height > 0 && height > (double)max.height) {
            height = max.height;
        }
        super.setItemBounds(x, y, width, height);
        Rectangle newBounds = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", oldBounds, newBounds);
    }

    public void setItemLocation(double x, double y) {
        Rectangle oldBounds = this.getItemBounds().getBounds();
        super.setItemLocation(x, y);
        Rectangle newBounds = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", oldBounds, newBounds);
    }

    public void setItemTransform(AffineTransform transform) throws TransformException {
        Rectangle2D bounds = this.getItemBounds();
        Rectangle oldBounds = bounds.getBounds();
        super.setItemTransform(transform);
        Rectangle newBounds = this.getItemBounds().getBounds();
        this.firePropertyChange("bounds", oldBounds, newBounds);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport((Object)this);
        }
        this._support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(listener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport((Object)this);
        }
        this._vetoSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(listener);
        }
    }

    public boolean isActive() {
        return this.isSelected();
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleJLEWindow(this);
    }

    protected void firePropertyChange(String property, Object old, Object newValue) {
        if (this._support != null) {
            this._support.firePropertyChange(property, old, newValue);
        }
    }

    protected boolean fireVetoableChange(String property, Object old, Object newValue) {
        boolean cancelled = false;
        try {
            if (this._vetoSupport != null) {
                this._vetoSupport.fireVetoableChange(property, old, newValue);
            }
        }
        catch (PropertyVetoException pve) {
            cancelled = true;
        }
        return cancelled;
    }

    Rectangle __getTitleBarBounds() {
        return this._titleBar.getBounds();
    }

    Component __getTitleBar() {
        return this._titleBar;
    }

    Component __getMinimizedComponent() {
        return this._minimizedComponent;
    }

    Point __getContentLocation() {
        int x = 0;
        int y = 0;
        for (Component parent = this.getContent(); parent != null && parent != this.getComponent(); parent = parent.getParent()) {
            Point p = parent.getLocation();
            x += p.x;
            y += p.y;
        }
        return new Point(x, y);
    }

    Insets __getBorderInsets() {
        Component c = this.getComponent();
        Border painter = ((JComponent)c).getBorder();
        Insets outerInsets = painter == null ? new Insets(0, 0, 0, 0) : painter.getBorderInsets(c);
        painter = this._middle.getBorder();
        Insets innerInsets = painter == null ? new Insets(0, 0, 0, 0) : painter.getBorderInsets(this._middle);
        return new Insets(outerInsets.top, outerInsets.left + innerInsets.left, outerInsets.bottom, outerInsets.right + innerInsets.right);
    }

    private void _updateBoundsTool(boolean minimized) {
        LayoutTool tool;
        if (minimized) {
            NodeBoundsTool.setResizable((LayoutItem)this, (boolean)false);
        } else {
            NodeBoundsTool.setResizable((LayoutItem)this, (boolean)this._resizable);
        }
        JLECanvas canvas = this.getCanvas();
        if (canvas != null && (tool = canvas.getTool()) instanceof NodeTool) {
            NodeTool nt = (NodeTool)tool;
            nt.getBoundsTool().updateControlPoints((LayoutItem)this);
        }
    }

    private void _invalidateAndRepaint() {
        Component c = this.getComponent();
        c.invalidate();
        c.repaint();
    }

    private class BP
    extends AbstractBorderPainter {
        private ImmInsets _INSETS = new ImmInsets(5, 3, 3, 3);

        private BP() {
        }

        protected ImmInsets getOwnInsets(PaintContext context) {
            return this._INSETS;
        }

        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            int right = x + width + 1;
            int bottom = y + height + 1;
            int state = context.getPaintState();
            UIDefaults defaults = UIManager.getDefaults();
            if (JLEWindow.this.isSelected()) {
                g.setColor(defaults.getColor(LookAndFeel.WINDOW));
            } else {
                g.setColor(defaults.getColor(LookAndFeel.CONTROL));
            }
            g.drawLine(x, y + 1, right, y + 1);
            g.drawLine(x, y + 2, right, y + 2);
            g.drawLine(x + 2, y + 3, x + 2, y + 3);
            g.drawLine(x + 3, y + 3, x + 3, y + 3);
            g.drawLine(x + 2, y + 4, x + 2, y + 4);
            g.drawLine(x, y + 3, x, bottom);
            g.drawLine(x + 1, y + 3, x + 1, bottom);
            g.drawLine(right - 2, y + 3, right - 2, bottom);
            g.drawLine(right - 3, y + 3, right - 3, bottom);
            g.drawLine(right - 4, y + 3, right - 4, y + 3);
            g.drawLine(right - 5, y + 3, right - 5, y + 3);
            g.drawLine(right - 4, y + 4, right - 4, y + 4);
            g.drawLine(x, bottom - 2, right, bottom - 2);
            g.drawLine(x, bottom - 3, right, bottom - 3);
            g.drawLine(x + 2, bottom - 4, x + 2, bottom - 4);
            g.drawLine(x + 3, bottom - 4, x + 3, bottom - 4);
            g.drawLine(x + 2, bottom - 5, x + 2, bottom - 5);
            g.drawLine(right - 4, bottom - 4, right - 4, bottom - 4);
            g.drawLine(right - 5, bottom - 4, right - 5, bottom - 4);
            g.drawLine(right - 4, bottom - 5, right - 4, bottom - 5);
            g.setColor(Color.black);
            g.drawLine(x, y, right, y);
            g.drawLine((x += 2) + 2, y += 3, (right -= 4) - 2, y);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.drawLine(right - 1, y + 1, right - 1, y + 1);
            g.drawLine(x, y + 2, x, (bottom -= 4) - 2);
            g.drawLine(right, y + 2, right, bottom - 2);
            g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
            g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
            g.drawLine(x + 2, bottom, right - 2, bottom);
        }

        protected boolean isBorderTransparent(PaintContext context) {
            return false;
        }
    }

    private class MinComp
    extends PainterComponent {
        public MinComp() {
            this.setPainter((Painter)new PainterJoiner((Painter)new ImageSetPainter(), (Painter)new MinTextPainter(), 5));
            this.enableEvents(16L);
        }

        public void setToolTipText(String value) {
            super.setToolTipText(value);
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        }

        public void doLayout() {
            super.doLayout();
            if (JLEWindow.this._titleBar.isToolTipDefaulted() && JLEWindow.this.getTitle() != null && JLEWindow.this.getTitle().length() > 10) {
                this.setToolTipText(JLEWindow.this.getTitle());
            }
        }

        public Object getPaintData(Object key) {
            if (PaintContext.IMAGESET_KEY.equals(key)) {
                return JLEWindow.this.getMinimizedImageSet();
            }
            if (PaintContext.LABEL_KEY.equals(key)) {
                return JLEWindow.this.getTitle();
            }
            return super.getPaintData(key);
        }

        public int getPaintState() {
            int state = super.getPaintState();
            if (JLEWindow.this.isSelected()) {
                state |= 0x20;
            }
            return state;
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (this.isEnabled() && e.getID() == 500 && e.getClickCount() % 2 == 0) {
                JLEWindow.this.setMinimized(false);
            }
        }
    }

    private class MinTextPainter
    extends TruncatingTextPainter {
        private MinTextPainter() {
        }

        public Dimension getPreferredSize(PaintContext context) {
            Font f;
            String text = this.getStringData(context);
            Dimension d = super.getPreferredSize(context);
            if (text != null && text.length() > 10 + MinTextPainter.getEllipsis((PaintContext)context).length() && (f = context.getPaintFont()) != null) {
                FontMetrics metrics = context.getFontMetrics(f);
                d.width = metrics.stringWidth(text.substring(0, 10)) + metrics.stringWidth(MinTextPainter.getEllipsis((PaintContext)context));
            }
            return d;
        }
    }

    private class JLEContainer
    extends JPanel {
        private JLEContainer() {
        }

        public void addNotify() {
            super.addNotify();
            JLEWindow.this._added = true;
            if (JLEWindow.this._defaultSize) {
                Dimension d = JLEWindow.this.getComponent().getPreferredSize();
                Dimension d1 = this.getPreferredSize();
                int width = Math.min(d.width, d1.width + d1.width / 2);
                JLEWindow.this.setItemSize(width, d.height);
                JLEWindow.this._defaultSize = false;
            }
        }
    }
}

