/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Graphics;
import java.util.EventObject;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.jle.EdgeLinkItem;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.ControlPoint;
import oracle.bali.jle.tool.ControlPointSet;
import oracle.bali.jle.tool.DefaultBoundsPainter;
import oracle.bali.jle.util.AlignmentUtils;
import oracle.bali.jle.util.ItemUtils;

class NodeBoundsTool
extends BoundsTool {
    private static final int _CONTROL_POINT_SIZE = 4;
    private boolean _workaroundComplete = false;
    private boolean _ignoreEvents;
    private boolean _passOnRelease = true;

    public NodeBoundsTool() {
        this.setBoundsPainter((BoundsPainter)new NoControlPointPainter());
        this.setMultipleSelectAllowed(false);
        this.setDeleteAllowed(true);
        this.setMode(32);
    }

    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        if (!this._workaroundComplete) {
            BaseItem b = new BaseItem();
            NodeBoundsTool.setResizable((LayoutItem)b, (boolean)false);
            this.processSelect((LayoutItem)b, null);
            this.processDeselect((LayoutItem)b);
            this._workaroundComplete = true;
        }
    }

    public void updateControlPoints(LayoutItem item) {
        this.clearControlPointSet(item);
        this.refreshSelection(item);
    }

    public boolean processDelete(LayoutItem item, EventObject deletor) {
        boolean result;
        GraphCanvas canvas;
        String name = null;
        Object old = null;
        if (item instanceof JLENodeWindow) {
            name = "nodeCount";
            old = ((JLENodeWindow)item).getNode();
        } else if (item instanceof EdgeLinkItem) {
            name = "edgeCount";
            old = ((EdgeLinkItem)item).getEdge();
        }
        GraphCanvas graphCanvas = canvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        if (canvas != null && name != null) {
            canvas.__removeItem(item);
            if (canvas.__fireVetoableChange(name, old, null)) {
                return false;
            }
        }
        if ((result = super.processDelete(item, deletor)) && canvas != null && name != null) {
            canvas.firePropertyChange(name, old, null);
        }
        return result;
    }

    protected void processKeyPressed(JLEEvent e) {
        super.processKeyPressed(e);
        if (e.getKeyCode() == 121 && e.isShiftDown()) {
            JLECanvas canvas;
            int count;
            LayoutItem[] items = this.getSelectedItems();
            int n = count = items == null ? 0 : items.length;
            if (count == 1 && items[0] instanceof EdgeLinkItem && (canvas = this.getCanvas()) instanceof GraphCanvas) {
                EdgeLinkItem item = (EdgeLinkItem)items[0];
                ((GraphCanvas)canvas).__showMenuForEdge(item.getEdge(), (LayoutItem)item, 0.0, 0.0);
            }
        }
    }

    protected void processMousePressed(JLEEvent e) {
        LayoutItem item = this.getCanvas().getContentItem().getItemAt(e.getX(), e.getY());
        if (e.isConsumed()) {
            if (item != null && !NodeBoundsTool.isSelected((LayoutItem)item)) {
                e = new JLEEvent(e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount());
            }
            this._passOnRelease = false;
        } else {
            this._passOnRelease = true;
        }
        super.processMousePressed(e);
        if (this.isEnabled() && !this.isPrimaryMouseEvent(e)) {
            item = this.getCanvas().getContentItem().getHitItem(e.getX(), e.getY());
            this._processDeselectAll(item, (EventObject)e);
            if (item != this.getCanvas().getContentItem() && item != null && !NodeBoundsTool.isSelected((LayoutItem)item)) {
                this.processSelect(item);
            }
        }
    }

    protected void processMouseReleased(JLEEvent e) {
        if (this._passOnRelease) {
            super.processMouseReleased(e);
        }
        this._passOnRelease = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processDeselectAll(LayoutItem item, EventObject deselector) {
        JLECanvas canvas = this.getCanvas();
        LayoutItem[] items = this.getSelectedItems();
        if (canvas != null) {
            canvas.freezeRepaints();
        }
        try {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == item) continue;
                this.processDeselect(items[i], deselector);
            }
        }
        finally {
            if (canvas != null) {
                canvas.unfreezeRepaints();
            }
        }
    }

    public boolean processSelect(LayoutItem item, EventObject selector) {
        if (this._ignoreEvents) {
            return false;
        }
        GraphCanvas canvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        Node node = null;
        Edge edge = null;
        if (item instanceof JLENodeWindow) {
            node = ((JLENodeWindow)item).getNode();
        } else if (item instanceof EdgeLinkItem) {
            edge = ((EdgeLinkItem)item).getEdge();
        }
        if (canvas != null && (node != null ? canvas.__fireVetoableChange("nodeSelectionCount", null, node) : edge != null && canvas.__fireVetoableChange("edgeSelectionCount", null, edge))) {
            return false;
        }
        this._ignoreEvents = true;
        AlignmentUtils.moveToFront((LayoutItem)item);
        this._ignoreEvents = false;
        boolean ret = super.processSelect(item, selector);
        if (ret) {
            if (item instanceof JLEWindow) {
                this.getCanvas().setFocusedItem(item);
                ((JLEWindow)item).setSelected(true);
                if (item instanceof JLENodeWindow) {
                    JLENodeWindow nodeWindow = (JLENodeWindow)item;
                    if (nodeWindow.isMinimized()) {
                        nodeWindow.getComponent().requestFocus();
                    } else {
                        nodeWindow.getNodeComponent().requestFocus();
                    }
                }
            } else if (item instanceof EdgeLinkItem) {
                this.getCanvas().requestFocus();
            }
            if (canvas != null) {
                if (node != null) {
                    canvas.firePropertyChange("nodeSelectionCount", null, node);
                } else if (edge != null) {
                    canvas.firePropertyChange("edgeSelectionCount", null, edge);
                }
            }
        }
        return ret;
    }

    public boolean processDeselect(LayoutItem item, EventObject deselector) {
        if (this._ignoreEvents) {
            return false;
        }
        GraphCanvas canvas = this.getCanvas() instanceof GraphCanvas ? (GraphCanvas)this.getCanvas() : null;
        Node node = null;
        Edge edge = null;
        if (item instanceof JLENodeWindow) {
            node = ((JLENodeWindow)item).getNode();
        } else if (item instanceof EdgeLinkItem) {
            edge = ((EdgeLinkItem)item).getEdge();
        }
        if (canvas != null && (node != null ? canvas.__fireVetoableChange("nodeSelectionCount", node, null) : edge != null && canvas.__fireVetoableChange("edgeSelectionCount", edge, null))) {
            return false;
        }
        boolean ret = super.processDeselect(item, deselector);
        if (ret) {
            if (item instanceof JLEWindow) {
                ((JLEWindow)item).setSelected(false);
            }
            if (canvas != null) {
                if (node != null) {
                    canvas.firePropertyChange("nodeSelectionCount", node, null);
                } else if (edge != null) {
                    canvas.firePropertyChange("edgeSelectionCount", edge, null);
                }
            }
        }
        return ret;
    }

    protected ControlPointSet fetchControlPointSet(LayoutItem item) {
        int i;
        if (!NodeBoundsTool.isResizable((LayoutItem)item)) {
            return null;
        }
        Rectangle2D rect = ItemUtils.parentToContent((LayoutItem)item, (Rectangle2D)item.getItemBounds());
        double left = rect.getX() + 3.0;
        double top = rect.getY() + 3.0;
        double right = left + rect.getWidth() - 7.0;
        double bottom = top + rect.getHeight() - 7.0;
        double width = rect.getWidth() - 10.0;
        double height = rect.getHeight() - 10.0;
        int pointCount = 4;
        int horizontalCount = (int)(width / 4.0 - 2.0);
        if (horizontalCount < 0) {
            horizontalCount = 0;
        }
        pointCount += 2 * horizontalCount;
        int verticalCount = (int)(height / 4.0 - 2.0);
        if (verticalCount < 0) {
            verticalCount = 0;
        }
        ControlPoint[] points = new ControlPoint[pointCount += 2 * verticalCount];
        points[0] = new ControlPoint(0, left, top, item);
        points[1] = new ControlPoint(2, right, top, item);
        points[2] = new ControlPoint(8, left, bottom, item);
        points[3] = new ControlPoint(10, right, bottom, item);
        double horizontalOffset = width / (double)horizontalCount;
        double verticalOffset = height / (double)verticalCount;
        int inc = 4;
        for (i = 0; i < horizontalCount; ++i) {
            points[i + inc] = new ControlPoint(1, left + (double)(i + 1) * horizontalOffset, top, item);
        }
        inc += horizontalCount;
        for (i = 0; i < horizontalCount; ++i) {
            points[i + inc] = new ControlPoint(9, left + (double)(i + 1) * horizontalOffset, bottom, item);
        }
        inc += horizontalCount;
        for (i = 0; i < verticalCount; ++i) {
            points[i + inc] = new ControlPoint(4, left, top + (double)(i + 1) * verticalOffset, item);
        }
        inc += verticalCount;
        for (i = 0; i < verticalCount; ++i) {
            points[i + inc] = new ControlPoint(6, right, top + (double)(i + 1) * verticalOffset, item);
        }
        return new ControlPointSet(points);
    }

    protected boolean fireBoundsToolEvent(int id, LayoutItem item, double dx, double dy) {
        boolean b = super.fireBoundsToolEvent(id, item, dx, dy);
        if (id == 3) {
            b &= NodeBoundsTool.isResizable((LayoutItem)item);
        } else if (id == 2) {
            this.getCanvas().repaint();
        }
        return b;
    }

    private static class NoControlPointPainter
    extends DefaultBoundsPainter {
        private NoControlPointPainter() {
        }

        public void drawControlPoint(Graphics g, ControlPoint point, int x, int y) {
        }

        public void drawMove(Graphics g, LayoutItem item, int x, int y, int width, int height) {
            if (BoundsTool.isMovable((LayoutItem)item)) {
                super.drawMove(g, item, x, y, width, height);
            }
        }

        public int getControlPointWidth() {
            return 6;
        }

        public int getControlPointHeight() {
            return 6;
        }
    }
}

