/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.tableComponent;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableAdapter;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.tableComponent.ColumnSelectInputHandler;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridEditListener;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.RowGroupingAppearance;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;

public class TableComponent
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTION_CHANGED = "selectedColumns";
    public static final String PROPERTY_COLUMN_LOCATION = "columnLocation";
    public static final String PROPERTY_TABLE = "table";
    public static final int CHECK_COLUMN = 1;
    public static final int PRIMARY_KEY_COLUMN = 2;
    public static final int UNIQUE_KEY_COLUMN = 3;
    public static final int COLUMN_NAME_COLUMN = 4;
    public static final int DEFAULT_COLUMN_COUNT = 5;
    private static final String _ACCESS_BUNDLE = "oracle.bali.dbUI.resource.AccessibleBundle";
    private static final String _KEY_ALL_SELECTED = "TABLECOMPONENT.ALL_COLUMNS";
    private static final String _KEY_NOT_ALL_SELECTED = "TABLECOMPONENT.NOT_ALL_COLUMNS";
    private static final String _KEY_PRIMARY_KEY = "TABLECOMPONENT.PRIMARY_KEY";
    private static final String _KEY_UNIQUE_KEY = "TABLECOMPONENT.UNIQUE_KEY";
    private static final String _KEY_COLUMN_NAME = "TABLECOMPONENT.COLUMN_NAME";
    private static final String _KEY_ALL_SELECTED_DESC = "TABLECOMPONENT.ALL_COLUMNS_DESC";
    private static final String _KEY_NOT_ALL_SELECTED_DESC = "TABLECOMPONENT.NOT_ALL_COLUMNS_DESC";
    private static final String _KEY_PRIMARY_KEY_DESC = "TABLECOMPONENT.PRIMARY_KEY_DESC";
    private static final String _KEY_UNIQUE_KEY_DESC = "TABLECOMPONENT.UNIQUE_KEY_DESC";
    private static final String _KEY_COLUMN_NAME_DESC = "TABLECOMPONENT.COLUMN_NAME_DESC";
    private static final String _KEY_S_P_U = "TABLECOMPONENT.S_P_U";
    private static final String _KEY_S_P = "TABLECOMPONENT.S_P";
    private static final String _KEY_S = "TABLECOMPONENT.S";
    private static final String _KEY_S_U = "TABLECOMPONENT.S_U";
    private static final String _KEY_P_U = "TABLECOMPONENT.P_U";
    private static final String _KEY_P = "TABLECOMPONENT.P";
    private static final String _KEY_U = "TABLECOMPONENT.U";
    private static final String _KEY_NONE = "TABLECOMPONENT.NONE";
    private static final int _DEFAULT_NAME_WIDTH = 150;
    private static final int _HIDDEN_COLUMN = 0;
    private ArrayOneDModel _sortOrder;
    private GridSelectionManager _selection;
    GridSelectionManager _highlight;
    private SpreadTable _spreadTable;
    private JScrollPane _scrollBox;
    private Table _table;
    private int _lastItemSorted;
    private Listener _listener = new Listener();

    public TableComponent() {
        this(null);
    }

    public TableComponent(Table table) {
        DBUILookAndFeel laf = DBUILookAndFeel.getLookAndFeel();
        Painter checkPainter = laf.getCheckPainter((JComponent)((Object)this));
        SortableTwoDModel ds = new SortableTwoDModel(5, 0);
        ArrayOneDModel hds = new ArrayOneDModel(5);
        this._spreadTable = new _Table((TwoDModel)ds, (OneDModel)hds, null);
        Header h = this._spreadTable.getColumnHeader();
        h.setPainter(1, checkPainter);
        h.setItemInputHandler((HeaderItemInputHandler)new Sort());
        h.setCanMoveItems(false);
        h.setCanResizeItems(false);
        h.setHeaderKeyHandler((HeaderKeyHandler)new KeyHandler());
        Grid grid = this._spreadTable.getGrid();
        grid.setHorizontalSeparatorsVisible(false);
        grid.setVerticalSeparatorsVisible(false);
        this._selection = GeneralGridSelectionManager.createSingleRowSelectionManager();
        this._highlight = GeneralGridSelectionManager.createMultipleRowSelectionManager();
        grid.setGridSelectionManager(this._selection);
        grid.setAppearanceManager((AppearanceManager)new Appear());
        grid.setFill(laf.getBackgroundPainter((JComponent)((Object)this)));
        this._spreadTable.setColumnVisible(0, false);
        this._spreadTable.setColumnWidth(1, 20);
        grid.setColumnCellInputHandler(1, (CellInputHandler)new ColumnSelectInputHandler(this));
        this._spreadTable.setBorder(null);
        grid.setColumnPainter(1, checkPainter);
        this._spreadTable.setColumnWidth(2, 20);
        grid.setColumnPainter(2, (Painter)new ImagePainter(PaintContext.IMAGE_KEY, 0));
        this._spreadTable.setColumnWidth(2, 20);
        grid.setColumnPainter(3, (Painter)new ImagePainter(PaintContext.IMAGE_KEY, 0));
        this._spreadTable.setColumnWidth(3, 20);
        this._spreadTable.setColumnWidth(4, 150);
        grid.addEditListener((GridEditListener)this._listener);
        grid.addFocusListener((FocusListener)this._listener);
        this._scrollBox = new JScrollPane((Component)this._spreadTable);
        this._scrollBox.getViewport().addChangeListener(this._listener);
        this.setLayout(new BorderLayout());
        this.add("Center", this._scrollBox);
        this._sortOrder = new ArrayOneDModel(5);
        this._lastItemSorted = -1;
        this.setTable(table);
        this.updateUI();
    }

    public int getSelectedColumnCount() {
        int count = 0;
        TwoDModel ds = this._getGrid().getModel();
        int colCount = ds.getRowCount();
        for (int i = 0; i < colCount; ++i) {
            if (!Boolean.TRUE.equals(ds.getData(1, i))) continue;
            ++count;
        }
        return count;
    }

    public Column[] getSelectedColumns() {
        int count = 0;
        TwoDModel ds = this._getGrid().getModel();
        int colCount = ds.getRowCount();
        Column[] all = new Column[colCount];
        for (int i = 0; i < colCount; ++i) {
            if (ds.getData(1, i) != Boolean.TRUE) continue;
            all[count] = this.getColumn(i);
            ++count;
        }
        Column[] checked = new Column[count];
        System.arraycopy(all, 0, checked, 0, count);
        return checked;
    }

    public boolean isColumnSelected(Column column) {
        int index = this._getColumnIndex(column);
        TwoDModel ds = this._getGrid().getModel();
        return ds.getData(1, index) == Boolean.TRUE;
    }

    public void setColumnSelected(Column column, boolean selected) {
        this._setColumnSelected(column, selected, true);
    }

    public void setAllColumnsSelected(boolean selected) {
        TwoDModel ds = this._getGrid().getModel();
        int rowCount = ds.getRowCount();
        Boolean data = selected ? Boolean.TRUE : Boolean.FALSE;
        ArrayList<Column> columns = new ArrayList<Column>(2);
        for (int i = 0; i < rowCount; ++i) {
            if (data.equals(ds.getData(1, i))) continue;
            ds.setData(1, i, (Object)data);
            columns.add((Column)ds.getData(0, i));
        }
        this._columnSelectionChanged(columns.toArray(new Column[0]), selected);
        this._updateHeaderImage(selected);
    }

    public Table getTable() {
        return this._table;
    }

    public void setTable(Table table) {
        Table oldTable = this.getTable();
        if (table != oldTable) {
            Column[] columns;
            if (oldTable != null && oldTable instanceof DynamicTable) {
                ((DynamicTable)oldTable).removeTableListener(this._listener);
            }
            if ((columns = this.getSelectedColumns()) != null && columns.length > 0) {
                this._columnSelectionChanged(columns, false);
            }
            this._table = table;
            if (this._table != null && this._table instanceof DynamicTable) {
                ((DynamicTable)this._table).addTableListener(this._listener);
            }
            this.firePropertyChange(PROPERTY_TABLE, oldTable, this._table);
            this.updateUI(this._table);
        }
    }

    public void setCellInputHandler(CellInputHandler handler) {
        this._getGrid().setDefaultInputHandler(handler);
    }

    public CellInputHandler getCellInputHandler() {
        return this._getGrid().getDefaultInputHandler();
    }

    public int getColumnLocation(Column column) {
        int index = this._getColumnIndex(column);
        if (index == -1) {
            return -1;
        }
        Grid grid = this._getGrid();
        Dimension d = this.getSize();
        int y = SwingUtilities.convertPoint((Component)grid, (int)0, (int)grid.getRowPosition((int)index), (Component)((Object)this)).y;
        if (y < 0) {
            y = 0;
        } else if (d.height < 0) {
            y = 0;
        } else if (y >= d.height) {
            y = d.height;
        }
        return y;
    }

    public Column getColumnAt(int y) {
        Grid grid = this._getGrid();
        int index = grid.getRowAt(y = SwingUtilities.convertPoint((Component)((Object)this), (int)0, (int)y, (Component)grid).y);
        if (index == -1) {
            return null;
        }
        return this.getColumn(index);
    }

    public void setColumnHighlighted(Column column, boolean highlighted) {
        if (this.isColumnHighlighted(column) != highlighted) {
            int index = this._getColumnIndex(column);
            if (index == -1) {
                return;
            }
            TwoDSelection s = new TwoDSelection(index, true);
            try {
                if (highlighted) {
                    this._highlight.addSelection(s);
                    this._selection.addSelection(s);
                } else {
                    this._highlight.removeSelection(s);
                    this._selection.removeSelection(s);
                }
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    public boolean isColumnHighlighted(Column column) {
        int index = this._getColumnIndex(column);
        if (index == -1) {
            return false;
        }
        return this._highlight.getSelection().containsRow(index);
    }

    public void setAllColumnsHighlighted(boolean highlighted) {
        OneDSelection oneD = new OneDSelection(0, this._getGridModel().getRowCount() - 1);
        TwoDSelection twoD = new TwoDSelection(null, oneD);
        try {
            if (highlighted) {
                this._highlight.addSelection(twoD);
                this._selection.addSelection(twoD);
            } else {
                this._highlight.removeSelection(twoD);
                this._selection.removeSelection(twoD);
            }
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
    }

    public Column getColumn(int index) {
        TwoDModel ds = this._getGrid().getModel();
        return (Column)ds.getData(0, index);
    }

    public int getColumnIndex(Column column) {
        return this._getColumnIndex(column);
    }

    public SpreadTable getSpreadTable() {
        return this._spreadTable;
    }

    public void addColumns(int count) {
        SortableTwoDModel ds = this._getGridModel();
        int start = ds.getColumnCount();
        ds.addColumns(start, count);
        ArrayOneDModel cds = this._getColumnModel();
        cds.addItems(start, count);
        this._sortOrder.addItems(start, count);
    }

    public void removeColumns(int count) {
        SortableTwoDModel ds = this._getGridModel();
        int columnCount = ds.getColumnCount();
        int start = columnCount - count;
        if (start < 5) {
            start = 5;
            count = columnCount - count;
        }
        if (count <= 0) {
            return;
        }
        ds.removeColumns(start, count);
        ArrayOneDModel cds = this._getColumnModel();
        cds.removeItems(start, count);
        this._sortOrder.removeItems(start, count);
    }

    public final boolean areAllColumnsSelected() {
        TwoDModel ds = this._getGrid().getModel();
        int rowCount = ds.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (ds.getData(1, i) != Boolean.FALSE) continue;
            return false;
        }
        return rowCount > 0;
    }

    public Dimension getPreferredSize() {
        Dimension d = this.getSpreadTable().getPreferredSize();
        Insets insets = this._scrollBox.getInsets();
        d.width += insets.left + insets.right + 1;
        d.height += insets.top + insets.bottom + 1;
        return d;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void requestFocus() {
        this.getSpreadTable().getGrid().requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        enabled = this.isEnabled();
        this._scrollBox.setEnabled(enabled);
        this._spreadTable.setEnabled(enabled);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public void updateUI() {
        super.updateUI();
        this.getSpreadTable().setColumnHeaderHeight(this._getHeaderHeight());
    }

    void sortColumn(int item) {
        boolean ascending;
        SortableTwoDModel ds = this._getGridModel();
        Object sort = this._sortOrder.getData(item);
        boolean bl = ascending = sort == null;
        if (this._lastItemSorted == item) {
            if (sort == null) {
                ascending = false;
                this._sortOrder.setData(item, (Object)Boolean.TRUE);
            } else {
                ascending = true;
                this._sortOrder.setData(item, null);
            }
        }
        ds.sort(item, ascending);
        this._lastItemSorted = item;
        this.locationChanged();
    }

    void focusLost(FocusEvent e) {
        Column column;
        Cell focusCell = this._getGrid().getFocusCell();
        if (focusCell != null && !this.isColumnHighlighted(column = this.getColumn(focusCell.row))) {
            TwoDSelection s = new TwoDSelection(focusCell.row, true);
            try {
                this._selection.removeSelection(s);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    void focusGained(FocusEvent e) {
        int row = -1;
        Cell focusCell = this._getGrid().getFocusCell();
        if (focusCell == null) {
            if (this._getGrid().getRowCount() > 0) {
                row = 0;
            }
        } else {
            this._getGrid().requestFocus(focusCell.column, focusCell.row, (AWTEvent)e);
            row = focusCell.row;
        }
        if (row != -1) {
            TwoDSelection s = new TwoDSelection(row, true);
            try {
                this._selection.addSelection(s);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    void selectRow(int row, AWTEvent e) {
        try {
            this._selection.addSelection(new TwoDSelection(row, true));
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
        Grid grid = this._getGrid();
        grid.requestFocus(1, row, e);
        grid.scrollCellIntoView(1, row);
    }

    private void _columnSelectionChanged(Column[] columns, boolean selected) {
        this.firePropertyChange(PROPERTY_SELECTION_CHANGED, selected ? null : columns, selected ? columns : null);
    }

    void locationChanged() {
        this.firePropertyChange(PROPERTY_COLUMN_LOCATION, null, null);
    }

    void updateUI(Table table) {
        SortableTwoDModel ds;
        int oldCount;
        int count = 0;
        if (table != null) {
            count = table.getColumnCount();
        }
        if ((oldCount = (ds = this._getGridModel()).getRowCount()) != count) {
            TwoDModelEvent e;
            ds.removeRows(0, oldCount);
            ds.addRows(0, count);
            int diff = count - oldCount;
            if (diff > 0) {
                e = new TwoDModelEvent((Object)this, 2004, oldCount, diff);
                this._highlight.getTwoDModelListener().rowsAdded(e);
            } else {
                diff = -diff;
                e = new TwoDModelEvent((Object)this, 2005, oldCount - diff, diff);
                this._highlight.getTwoDModelListener().rowsRemoved(e);
            }
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        for (int i = 0; i < count; ++i) {
            ds.setData(0, i, (Object)table.getColumn(i));
            ds.setData(1, i, (Object)Boolean.FALSE);
            ds.setData(2, i, null);
            ds.setData(3, i, null);
            ds.setData(4, i, (Object)table.getColumn(i).getDisplayName(locale));
        }
        this.updatePrimaryKeys();
        this.updateUniqueKeys();
        if (count != 0) {
            this._getGrid().requestFocus(1, 0, null);
        }
        this._lastItemSorted = -1;
        this.invalidate();
        this.locationChanged();
        this.repaint();
    }

    void restoreSelectedColumns(Column[] columns) {
        if (columns != null) {
            int count = columns.length;
            ArrayList<Column> removedColumns = new ArrayList<Column>(2);
            for (int i = 0; i < count; ++i) {
                if (this._getColumnIndex(columns[i]) == -1) {
                    removedColumns.add(columns[i]);
                    continue;
                }
                this._setColumnSelected(columns[i], true, false);
            }
            this._columnSelectionChanged(removedColumns.toArray(new Column[0]), false);
        }
    }

    private void _setColumnSelected(Column column, boolean selected, boolean fireEvent) {
        if (this.isColumnSelected(column) != selected) {
            int index = this._getColumnIndex(column);
            TwoDModel ds = this._getGrid().getModel();
            Boolean data = selected ? Boolean.TRUE : Boolean.FALSE;
            ds.setData(1, index, (Object)data);
            boolean update = !selected ? false : this.areAllColumnsSelected();
            this._updateHeaderImage(update);
            if (fireEvent) {
                this._columnSelectionChanged(new Column[]{column}, selected);
            }
        }
    }

    void updatePrimaryKeys() {
        int i;
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        int count = table.getColumnCount();
        int keyCount = table.getPrimaryKeyCount();
        TwoDModel ds = this.getSpreadTable().getGrid().getModel();
        Image image = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/tableComponent/images/key.gif");
        for (i = 0; i < count; ++i) {
            ds.setData(2, i, null);
        }
        if (keyCount != 0) {
            block1: for (i = 0; i < keyCount; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (!table.getPrimaryKey(i).getName().equals(table.getColumn(j).getName())) continue;
                    ds.setData(2, j, (Object)image);
                    continue block1;
                }
            }
        }
    }

    void updateUniqueKeys() {
        int i;
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        int count = table.getColumnCount();
        int keyCount = table.getUniqueKeyCount();
        TwoDModel ds = this.getSpreadTable().getGrid().getModel();
        Image image = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/tableComponent/images/uniquekey.gif");
        for (i = 0; i < count; ++i) {
            ds.setData(3, i, null);
        }
        if (keyCount != 0) {
            block1: for (i = 0; i < keyCount; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (!table.getUniqueKey(i).getName().equals(table.getColumn(j).getName())) continue;
                    ds.setData(3, j, (Object)image);
                    continue block1;
                }
            }
        }
    }

    private int _getHeaderHeight() {
        DBUILookAndFeel laf = DBUILookAndFeel.getLookAndFeel();
        Painter checkPainter = laf.getCheckPainter((JComponent)((Object)this));
        Header h = this.getSpreadTable().getColumnHeader();
        Dimension d = checkPainter.getPreferredSize(h.getPaintContext());
        ImmInsets insets = h.getAppearance().getInsets();
        ImmInsets borderInsets = h.getBorderInsets();
        return d.height + insets.top + insets.bottom + borderInsets.top + borderInsets.bottom + 4;
    }

    private Grid _getGrid() {
        return this.getSpreadTable().getGrid();
    }

    private void _updateHeaderImage(boolean selected) {
        Boolean b;
        ArrayOneDModel cds = this._getColumnModel();
        Boolean bl = b = selected ? Boolean.TRUE : Boolean.FALSE;
        if (b != cds.getData(1)) {
            cds.setData(1, (Object)b);
        }
    }

    private int _getColumnIndex(Column column) {
        String name = column.getName();
        int count = this._getGrid().getRowCount();
        for (int i = 0; i < count; ++i) {
            Column temp = this.getColumn(i);
            if (!name.equals(temp.getName())) continue;
            return i;
        }
        return -1;
    }

    private ArrayOneDModel _getColumnModel() {
        ArrayOneDModel ds = (ArrayOneDModel)this.getSpreadTable().getColumnHeader().getModel();
        return ds;
    }

    SortableTwoDModel _getGridModel() {
        SortableTwoDModel ds = (SortableTwoDModel)this._getGrid().getModel();
        return ds;
    }

    private class Listener
    extends DynamicTableAdapter
    implements FocusListener,
    GridEditListener,
    ChangeListener {
        private Listener() {
        }

        public void focusGained(FocusEvent e) {
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                final FocusEvent copyEvent = new FocusEvent(e.getComponent(), e.getID(), e.isTemporary());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TableComponent.this.focusGained(copyEvent);
                    }
                });
            } else {
                TableComponent.this.focusGained(e);
            }
        }

        public void focusLost(FocusEvent e) {
            TableComponent.this.focusLost(e);
        }

        public void cellEditing(GridEvent e) {
        }

        public void cellEdited(GridEvent e) {
            if (e.getColumn() == 1) {
                Column column = TableComponent.this.getColumn(e.getRow());
                TableComponent.this._columnSelectionChanged(new Column[]{column}, TableComponent.this.isColumnSelected(column));
                TableComponent.this._updateHeaderImage(TableComponent.this.areAllColumnsSelected());
            }
        }

        public void stateChanged(ChangeEvent e) {
            TableComponent.this.locationChanged();
        }

        public void columnAdded(DynamicTableEvent e) {
            Column[] columns = TableComponent.this.getSelectedColumns();
            TableComponent.this.updateUI(e.getTable());
            TableComponent.this.restoreSelectedColumns(columns);
        }

        public void columnRemoved(DynamicTableEvent e) {
            Column[] columns = TableComponent.this.getSelectedColumns();
            TableComponent.this.updateUI(e.getTable());
            TableComponent.this.restoreSelectedColumns(columns);
        }

        public void primaryKeyAdded(DynamicTableEvent e) {
            TableComponent.this.updatePrimaryKeys();
        }

        public void primaryKeyRemoved(DynamicTableEvent e) {
            TableComponent.this.updatePrimaryKeys();
        }

        public void uniqueKeyAdded(DynamicTableEvent e) {
            TableComponent.this.updateUniqueKeys();
        }

        public void uniqueKeyRemoved(DynamicTableEvent e) {
            TableComponent.this.updateUniqueKeys();
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent e) {
            if (e.getID() == 402 && e.getKeyCode() == 32) {
                int item = header.getFocusItem();
                if (item == 1) {
                    TableComponent.this.setAllColumnsSelected(!TableComponent.this.areAllColumnsSelected());
                } else {
                    TableComponent.this.sortColumn(item);
                }
            }
            super.handleKeyEvent(header, e);
        }
    }

    private class Sort
    extends NullInputHandler {
        private Sort() {
        }

        public void mouseReleased(MouseEvent e, Header header, int item) {
            boolean left;
            int x = e.getX();
            int y = e.getY();
            boolean bl = left = (e.getModifiers() & 0x10) != 0;
            if (x >= 0 && y >= 0 && x <= header.getItemSize(item) && y <= header.getSize().height && left) {
                if (item == 1) {
                    TableComponent.this.setAllColumnsSelected(!TableComponent.this.areAllColumnsSelected());
                } else {
                    TableComponent.this.sortColumn(item);
                }
            }
        }
    }

    private class _Table
    extends SpreadTable {
        _Table(TwoDModel ds, OneDModel cds, OneDModel rds) {
            super(ds, cds, rds);
        }

        protected Grid createGrid(TwoDModel model) {
            return new _Grid(model);
        }

        protected Header createColumnHeader(OneDModel ds) {
            return new _Header(ds);
        }

        Column __getColumn(int row) {
            return TableComponent.this.getColumn(row);
        }

        private class _Header
        extends Header {
            public _Header(OneDModel model) {
                super(model);
            }

            protected Header.AccessibleHeader createAccessibleHeader() {
                return new AHeader();
            }

            private class AHeader
            extends Header.AccessibleHeader {
                private AHeader() {
                    super((Header)_Header.this);
                }

                public String getAccessibleName(int index) {
                    String key = null;
                    String name = null;
                    switch (index) {
                        case 1: {
                            if (TableComponent.this.areAllColumnsSelected()) {
                                key = TableComponent._KEY_ALL_SELECTED;
                                break;
                            }
                            key = TableComponent._KEY_NOT_ALL_SELECTED;
                            break;
                        }
                        case 2: {
                            key = TableComponent._KEY_PRIMARY_KEY;
                            break;
                        }
                        case 3: {
                            key = TableComponent._KEY_UNIQUE_KEY;
                            break;
                        }
                        case 4: {
                            key = TableComponent._KEY_COLUMN_NAME;
                            break;
                        }
                        default: {
                            name = super.getAccessibleName(index);
                        }
                    }
                    if (key != null) {
                        ResourceBundle b = ResourceBundle.getBundle(TableComponent._ACCESS_BUNDLE, this.getLocale());
                        name = b.getString(key);
                    }
                    return name;
                }

                public String getAccessibleDescription(int index) {
                    String desc = null;
                    String key = null;
                    switch (index) {
                        case 1: {
                            if (TableComponent.this.areAllColumnsSelected()) {
                                key = TableComponent._KEY_ALL_SELECTED_DESC;
                                break;
                            }
                            key = TableComponent._KEY_NOT_ALL_SELECTED_DESC;
                            break;
                        }
                        case 2: {
                            key = TableComponent._KEY_PRIMARY_KEY_DESC;
                            break;
                        }
                        case 3: {
                            key = TableComponent._KEY_UNIQUE_KEY_DESC;
                            break;
                        }
                        case 4: {
                            key = TableComponent._KEY_COLUMN_NAME_DESC;
                            break;
                        }
                        default: {
                            desc = super.getAccessibleDescription(index);
                        }
                    }
                    if (key != null) {
                        ResourceBundle b = ResourceBundle.getBundle(TableComponent._ACCESS_BUNDLE, this.getLocale());
                        desc = b.getString(key);
                    }
                    return desc;
                }
            }
        }

        private class _Grid
        extends Grid {
            public _Grid(TwoDModel model) {
                super(model);
            }

            public boolean requestFocus(int column, int row, AWTEvent e) {
                if (column < 5) {
                    column = 1;
                } else {
                    CellInputHandler h = this.getColumnCellInputHandler(column);
                    if (h == this.getDefaultInputHandler()) {
                        column = 1;
                    }
                }
                return super.requestFocus(column, row, e);
            }

            Column __getColumn(int row) {
                return _Table.this.__getColumn(row);
            }

            protected Grid.AccessibleGrid createAccessibleGrid() {
                return new AGrid();
            }

            private class AGrid
            extends Grid.AccessibleGrid {
                private AGrid() {
                    super((Grid)_Grid.this);
                }

                protected String getAccessibleName(int column, int row, Object data) {
                    ResourceBundle b = ResourceBundle.getBundle(TableComponent._ACCESS_BUNDLE, this.getLocale());
                    Column c = _Grid.this.__getColumn(row);
                    boolean selected = TableComponent.this.isColumnSelected(c);
                    TwoDModel ds = _Grid.this.getModel();
                    boolean uniqueKey = ds.getData(3, row) != null;
                    boolean primaryKey = ds.getData(2, row) != null;
                    Object columnName = ds.getData(4, row);
                    Class type = c.getDataType();
                    String typeName = type.toString();
                    int index = typeName.lastIndexOf(".");
                    if (index != -1) {
                        typeName = typeName.substring(index + 1);
                    }
                    String name = columnName + "";
                    String key = this._getKey(selected, primaryKey, uniqueKey);
                    String text = b.getString(key);
                    MessageFormat form = new MessageFormat(text);
                    Object[] args = new Object[]{columnName, typeName};
                    name = form.format(args);
                    return name;
                }

                private String _getKey(boolean selected, boolean primary, boolean unique) {
                    String key = null;
                    key = selected ? (primary ? (unique ? TableComponent._KEY_S_P_U : TableComponent._KEY_S_P) : (unique ? TableComponent._KEY_S_U : TableComponent._KEY_S)) : (primary ? (unique ? TableComponent._KEY_P_U : TableComponent._KEY_P) : (unique ? TableComponent._KEY_U : TableComponent._KEY_NONE));
                    return key;
                }
            }
        }
    }

    private class Appear
    extends RowGroupingAppearance {
        private Appearance _checkAppearance;

        public Appear() {
            Color color = UIManager.getColor("normalIntensity");
            if (color != null) {
                color = ColorUtils.lighterShadeColor((Color)color);
                this.setColor(color);
            }
            this.setRows(1);
        }

        public Appearance getCellPaintingAppearance(int column, int row) {
            Appearance a = super.getCellPaintingAppearance(column, row);
            if (column == 1) {
                if (this._checkAppearance == null) {
                    this._checkAppearance = a.copy();
                    this._checkAppearance.setBackground(UIManager.getColor("control"));
                }
                a = this._checkAppearance;
            }
            return a;
        }
    }
}

