/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.analyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Map;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.MetricDefinition;
import oracle.jdeveloper.audit.extension.PropertyTypeMethod;

public class Metric
extends ExtensionBean {
    protected Class<?> type;
    protected Object threshold;
    protected Comparator<Object> comparator;
    private Category category;
    private boolean enabled;
    private static final Comparator<Object> COMPARABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    private static final Comparator<Object> NO_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return -1;
        }
    };
    public static final String SHORT_LABEL_KEY = "short-label";

    @Override
    protected void copyInternalState(ExtensionBean copy, Map<String, ExtensionBean> context) throws InvocationTargetException {
        Metric metric = (Metric)copy;
        if (this.category != null) {
            metric.category = (Category)this.category.createCopy(context);
        }
        metric.type = this.type;
    }

    @Override
    public MetricDefinition definition() {
        return (MetricDefinition)super.definition();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public Category category() {
        return this.category;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Comparator<Object> comparator() {
        if (this.comparator == null) {
            this.comparator = this.type != null && Comparable.class.isAssignableFrom(this.type) ? COMPARABLE_COMPARATOR : NO_COMPARATOR;
        }
        return this.comparator != NO_COMPARATOR ? this.comparator : null;
    }

    public Object getThreshold() {
        return this.threshold;
    }

    @PropertyTypeMethod(value="getType")
    public void setThreshold(Object newValue) {
        if (newValue != null && this.type != null && !this.getType().isInstance(newValue)) {
            throw new IllegalArgumentException("newValue not value type");
        }
        Object oldValue = this.threshold;
        this.threshold = newValue;
        this.firePropertyChange("threshold", oldValue, newValue);
    }

    public boolean isOutOfBand(Object value) {
        if (this.threshold == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        Comparator<Object> comparator = this.comparator();
        if (comparator == null) {
            return false;
        }
        return comparator.compare(this.threshold, value) < 0;
    }

    public String shortLabel() {
        return this.definition().shortLabel();
    }

    public String representation(Object value) {
        return value != null ? value.toString() : null;
    }

    public String toString() {
        if (this.isEnabled()) {
            return "metric " + this.id();
        }
        return "metric " + this.id() + " (disabled)";
    }
}

