/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.analyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Parameter;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.StyleCategory;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.extension.Value;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;

public class Rule
extends ExtensionBean {
    public static final String MESSAGE_KEY = "message";
    public static final String HTML_MESSAGE_KEY = "html-message";
    public static final int MAX_TRANSFORM_COUNT = 15;
    private String[] variations = NO_VARIATIONS;
    private Severity severity;
    private StyleCategory style;
    private Category category;
    private boolean enabled;
    private Parameter[] parameters;
    private Transform[] transforms = NO_TRANSFORMS;
    private Transform defaultTransform;
    private static final String[] NO_VARIATIONS = new String[0];
    private static final Transform[] NO_TRANSFORMS = new Transform[0];

    @Override
    protected void copyInternalState(ExtensionBean copy, Map<String, ExtensionBean> context) throws InvocationTargetException {
        Rule rule = (Rule)copy;
        if (this.category != null) {
            rule.category = (Category)this.category.createCopy(context);
        }
        rule.parameters = this.parameters;
        rule.variations = this.variations;
        rule.transforms = new Transform[this.transforms.length];
        for (int i = 0; i < this.transforms.length; ++i) {
            Transform transform = this.transforms[i];
            rule.transforms[i] = (Transform)transform.createCopy(null);
            if (transform != this.defaultTransform) continue;
            rule.defaultTransform = rule.transforms[i];
        }
    }

    @Override
    public RuleDefinition definition() {
        return (RuleDefinition)super.definition();
    }

    public final boolean mandatoryError() {
        return this.definition().isMandatoryError();
    }

    public final boolean assist() {
        return this.severity == Severity.ASSIST;
    }

    public Category category() {
        return this.category;
    }

    public Parameter[] parameters() {
        return this.parameters;
    }

    public String[] variations() {
        return this.variations;
    }

    public String message() {
        return this.formattedString(MESSAGE_KEY, null);
    }

    public String[] messages() {
        ArrayList<String> list = new ArrayList<String>();
        String message = this.formattedString(MESSAGE_KEY, null);
        if (message != null) {
            list.add(message);
        }
        for (String variation : this.variations) {
            message = this.formattedString(this.variationKey(MESSAGE_KEY, variation), null);
            if (message == null) continue;
            list.add(message);
        }
        message = this.formattedString(HTML_MESSAGE_KEY, null);
        if (message != null) {
            list.add(message);
        }
        for (String variation : this.variations) {
            message = this.formattedString(this.variationKey(HTML_MESSAGE_KEY, variation), null);
            if (message == null) continue;
            list.add(message);
        }
        return list.toArray(new String[list.size()]);
    }

    public String message(Violation violation) {
        String variation = violation.getVariation();
        String string = this.formattedString(this.variationKey(MESSAGE_KEY, variation), violation);
        if (string == null) {
            string = this.formattedString(this.variationKey(MESSAGE_KEY, null), violation);
        }
        if (string == null) {
            string = this.syntheticMessage(violation);
        }
        return string;
    }

    public String htmlMessage(Violation violation) {
        String variation = violation.getVariation();
        String string = this.formattedString(this.variationKey(HTML_MESSAGE_KEY, variation), violation);
        if (string == null) {
            string = this.formattedString(this.variationKey(MESSAGE_KEY, variation), violation);
        }
        if (string == null) {
            string = this.formattedString(this.variationKey(HTML_MESSAGE_KEY, null), violation);
        }
        if (string == null) {
            string = this.message(violation);
        }
        return string;
    }

    private String variationKey(String key, String variation) {
        return variation != null ? variation + "." + key : key;
    }

    private String syntheticMessage(Violation violation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Rule '");
        builder.append(this.labelOrId());
        builder.append("' violated");
        int count = violation.getParameterCount();
        if (count > 0) {
            builder.append(": ");
            for (int i = 0; i < count; ++i) {
                if (count > 0) {
                    builder.append(", ");
                }
                builder.append(violation.getParameterName(i));
                builder.append("=\"");
                builder.append(violation.getParameterValue(i));
                builder.append("\"");
            }
        }
        return builder.toString();
    }

    public final Transform getDefaultTransform() {
        return this.defaultTransform;
    }

    public void setDefaultTransformName(String newName) {
        String oldName = this.defaultTransform != null ? this.defaultTransform.id() : null;
        Transform newValue = null;
        if (newName != null) {
            boolean found = false;
            for (Transform transform : this.transforms) {
                found = newName.equals(transform.id());
                if (!found) continue;
                newValue = transform;
                break;
            }
            if (!found) {
                newName = null;
                newValue = null;
            }
        }
        this.defaultTransform = newValue;
        this.firePropertyChange("defaultTransformName", oldName, newName);
    }

    public String getDefaultTransformName() {
        return this.defaultTransform != null ? this.defaultTransform.id() : null;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public final Severity getSeverity() {
        if (this.severity == null) {
            Value value = this.definition().getValue("severity");
            if (value != null) {
                this.severity = Severity.valueOf(value.getText());
            }
            if (this.severity == null) {
                this.severity = Severity.ADVISORY;
            }
        }
        return this.severity;
    }

    public final void setSeverity(Severity newValue) {
        if (this.mandatoryError() && newValue != Severity.ERROR) {
            return;
        }
        Severity oldValue = this.severity;
        this.severity = newValue;
        this.firePropertyChange("severity", oldValue, newValue);
    }

    public final StyleCategory getStyle() {
        if (this.style == null) {
            Severity severity = this.getSeverity();
            this.style = severity == Severity.ERROR ? StyleCategory.ERROR : (severity == Severity.WARNING ? StyleCategory.WARNING : (severity == Severity.INCOMPLETE ? StyleCategory.INCOMPLETE : (severity == Severity.ADVISORY ? StyleCategory.ADVISORY : StyleCategory.ASSIST)));
        }
        return this.style;
    }

    public final void setStyle(StyleCategory newValue) {
        assert (newValue != null);
        StyleCategory oldValue = this.getStyle();
        this.style = newValue;
        this.firePropertyChange("style", oldValue, newValue);
    }

    public final Transform[] getTransforms() {
        return this.transforms;
    }

    public String toString() {
        if (this.isEnabled()) {
            return "rule " + this.id();
        }
        return "rule " + this.id() + " (disabled)";
    }
}

