/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.List;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;

public class CategoryDefinition
extends BeanDefinition {
    private CategoryDefinition category;
    private String featureId;
    private Feature feature;
    private FeatureCategory featureCategory;
    private boolean isModelCategory;

    public CategoryDefinition(String id, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
        this.category = category;
    }

    public CategoryDefinition(String id, List<String> featurePath, Feature feature, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
        this.category = category;
        this.featureId = CategoryDefinition.catenate(featurePath);
        this.feature = feature;
    }

    public CategoryDefinition(String id, List<String> featurePath, FeatureCategory featureCategory, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
        this.category = category;
        this.featureId = CategoryDefinition.catenate(featurePath);
        this.featureCategory = featureCategory;
    }

    private static String catenate(List<String> path) {
        StringBuilder builder = new StringBuilder(path.get(0));
        for (int i = 1; i < path.size(); ++i) {
            builder.append(' ').append(path.get(i));
        }
        return builder.toString();
    }

    @Override
    public boolean hasEnabledProperty() {
        return false;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public CategoryDefinition getCategory() {
        return this.category;
    }

    public void setCategory(CategoryDefinition category) {
        this.category = category;
    }

    public boolean isModelCategory() {
        return this.isModelCategory;
    }

    void setModelCategory(boolean modelCategory) {
        this.isModelCategory = modelCategory;
    }

    @Override
    public String label() {
        String label = super.label();
        if (label == null && this.feature != null) {
            return this.feature.getDisplayName();
        }
        if (label == null && this.featureCategory != null) {
            return this.featureCategory.getDisplayName();
        }
        return label;
    }

    @Override
    public String description() {
        String description = super.description();
        if (description == null && this.feature != null) {
            return this.feature.getDescription();
        }
        if (description == null && this.featureCategory != null) {
            return this.featureCategory.getDescription();
        }
        return description;
    }
}

