/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdevimpl.audit.util.Strings;

public abstract class ExtensionBean {
    private BeanDefinition definition;
    private Map<String, DeferredSetter> setters;
    private Map<String, String> strings;
    private PropertyChangeSupport support = null;
    public static final String LABEL_KEY = "label";
    public static final String DESCRIPTION_KEY = "description";

    protected ExtensionBean() {
    }

    public ExtensionBean createCopy(Map<String, ExtensionBean> context) throws InvocationTargetException {
        try {
            ExtensionBean copy;
            String id = this.id();
            if (context != null && (copy = context.get(id)) != null) {
                return copy;
            }
            copy = (ExtensionBean)this.getClass().newInstance();
            copy.definition = this.definition;
            copy.setters = this.setters;
            copy.strings = this.strings;
            this.copyInternalState(copy, context);
            for (PropertyDescriptor property : Introspector.getBeanInfo(copy.getClass()).getPropertyDescriptors()) {
                Method getter;
                Method setter = property.getWriteMethod();
                if (setter == null || (getter = property.getReadMethod()) == null) continue;
                setter.invoke((Object)copy, getter.invoke((Object)this, new Object[0]));
            }
            if (context != null) {
                context.put(id, copy);
            }
            return copy;
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void copyInternalState(ExtensionBean copy, Map<String, ExtensionBean> context) throws InvocationTargetException {
    }

    protected ExtensionBean(BeanDefinition definition) {
        this.definition = definition;
    }

    public String id() {
        return this.definition.getId();
    }

    public BeanDefinition definition() {
        return this.definition;
    }

    public String name() {
        return Strings.lastToken(this.id(), '.');
    }

    public String extensionId() {
        return this.definition.getExtensionId();
    }

    public int extensionLine() {
        return this.definition.getLineNumber();
    }

    public Map<String, DeferredSetter> setters() {
        return this.setters;
    }

    public void logError(Throwable e, String message, Object ... parameters) {
        this.definition.log(Level.SEVERE, e, message, parameters);
    }

    public void logError(String message, Object ... parameters) {
        this.log(Level.SEVERE, message, parameters);
    }

    public void logWarning(String message, Object ... parameters) {
        this.log(Level.WARNING, message, parameters);
    }

    private void log(Level level, String message, Object ... parameters) {
        this.definition.log(level, message, parameters);
    }

    public final String labelOrId() {
        String label = this.label();
        if (label == null) {
            label = this.id();
        }
        return label;
    }

    public String label() {
        return this.definition.label();
    }

    public String description() {
        return this.definition.description();
    }

    public String propertyLabel(String propertyName) {
        return this.definition.propertyLabel(propertyName);
    }

    public String propertyDescription(String propertyName) {
        return this.definition.propertyDescription(propertyName);
    }

    public String string(String name) {
        return this.definition.string(name);
    }

    public String key(String name) {
        return this.definition.key(name);
    }

    public String formattedString(String name) {
        return this.definition.formattedString(name, this);
    }

    public String formattedString(String name, Object context) {
        return this.definition.formattedString(name, context, false);
    }

    public String formattedString(String name, Object context, boolean erase) {
        return this.definition.formattedString(name, context, erase);
    }

    public boolean equals(Object object) {
        return object instanceof ExtensionBean && this.definition.equals(((ExtensionBean)object).definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            return;
        }
        this.support.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.support == null) {
            return;
        }
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object[] oldValue, Object[] newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        if (Arrays.equals(oldValue, newValue)) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }
}

