/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.extension.HasTransformBindings;
import oracle.jdeveloper.audit.extension.ParameterDefinition;
import oracle.jdeveloper.audit.extension.TransformBinding;
import oracle.jdeveloper.audit.extension.Value;

public class RuleDefinition
extends CategoryDefinition
implements HasTransformBindings {
    private boolean mandatoryError;
    private Collection<ParameterDefinition> parameters;
    private Collection<String> variations;
    private Collection<TransformBinding> transformBindings;
    private Collection<String> suppressionIds;

    public RuleDefinition(String id, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, category, bundle, context);
    }

    @Override
    public boolean hasEnabledProperty() {
        return true;
    }

    public Severity getSeverity() {
        if (this.mandatoryError) {
            return Severity.ERROR;
        }
        Value value = this.getValue("severity");
        if (value == null) {
            return Severity.ADVISORY;
        }
        Severity severity = Severity.valueOf(value.getText());
        if (severity == null) {
            severity = Severity.ADVISORY;
        }
        return severity;
    }

    public boolean isAssist() {
        return this.getSeverity() == Severity.ASSIST;
    }

    public void setSeverity(Severity severity) {
        Value value = this.getValue("severity");
        if (value != null) {
            value.setText(severity.toString());
        } else {
            ArraySortedSet values = this.getValues();
            if (values == null) {
                values = new ArraySortedSet();
                this.setValues((Collection<Value>)values);
            }
            values.add(new Value("severity", severity.toString(), new DefinitionContext(this.getExtensionId(), this)));
        }
    }

    public Collection<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public Collection<String> getVariations() {
        return this.variations;
    }

    public void setVariations(Collection<String> variations) {
        this.variations = variations;
    }

    @Override
    public Collection<TransformBinding> getTransformBindings() {
        if (this.transformBindings != null) {
            return this.transformBindings;
        }
        return Collections.emptyList();
    }

    @Override
    public void addTransformBinding(TransformBinding binding) {
        if (this.transformBindings == null) {
            this.transformBindings = new ArrayList<TransformBinding>();
        }
        this.transformBindings.add(binding);
    }

    public boolean isMandatoryError() {
        return this.mandatoryError;
    }

    public void setMandatoryError(boolean mandatoryError) {
        if (this.mandatoryError && !mandatoryError) {
            throw new IllegalStateException("mandatoryError cannot be cleared once set");
        }
        this.mandatoryError = mandatoryError;
    }

    public Collection<String> getSuppressionIds() {
        return this.suppressionIds;
    }

    public void setSuppressionIds(Collection<String> suppressionIds) {
        this.suppressionIds = suppressionIds;
    }
}

