/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import oracle.javatools.util.ArrayMap;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdevimpl.audit.util.Strings;

public abstract class TopLevelDefinition
extends Definition {
    private String id;
    private List<String> deprecatedIds;
    private ExtensionBundle bundle;
    private Map<String, String> strings;
    public static final String LABEL_KEY = "label";
    public static final String DESCRIPTION_KEY = "description";
    private static final int SPACES = 0x200020;
    private static final int QUOTES = 0x220022;
    private static final int APOSTROPHES = 0x270027;

    TopLevelDefinition(String id, ExtensionBundle bundle, DefinitionContext context) {
        super(context);
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (id.endsWith(".null")) {
            throw new IllegalArgumentException("id.endsWith(\".null\")");
        }
        this.id = id;
        this.bundle = bundle;
    }

    public ExtensionBundle getExtensionBundle() {
        return this.bundle;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return Strings.lastToken(this.id, '.');
    }

    public List<String> getDeprecatedIds() {
        if (this.deprecatedIds != null) {
            return this.deprecatedIds;
        }
        return Collections.emptyList();
    }

    public void addDeprecatedId(String id) {
        if (this.deprecatedIds == null) {
            this.deprecatedIds = new ArrayList<String>();
        }
        this.deprecatedIds.add(id);
    }

    public Map<String, String> getStrings() {
        if (this.strings != null) {
            return this.strings;
        }
        return Collections.emptyMap();
    }

    public void setStrings(Map<String, String> strings) {
        this.strings = strings;
    }

    public void addString(String key, String value) {
        if (this.strings == null) {
            this.strings = new ArrayMap();
        }
        this.strings.put(key, value);
    }

    public final String labelOrId() {
        String label = this.label();
        if (label == null) {
            label = this.getId();
        }
        return label;
    }

    public String label() {
        return this.formattedString(LABEL_KEY, null);
    }

    public String description() {
        return this.string(DESCRIPTION_KEY);
    }

    public String propertyLabel(String propertyName) {
        return this.propertyString(propertyName, LABEL_KEY);
    }

    public String propertyDescription(String propertyName) {
        return this.propertyString(propertyName, DESCRIPTION_KEY);
    }

    public String string(String name) {
        try {
            return this.getExtensionBundle().getBundle().getString(this.key(name));
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String key(String name) {
        String key = this.getStrings().get(name);
        if (key == null) {
            key = this.getName() + "." + name;
        }
        return key;
    }

    public String formattedString(String name, Object context) {
        return this.formattedString(name, context, false);
    }

    public String formattedString(String name, Object context, boolean erase) {
        return TopLevelDefinition.instantiate(this.string(name), context, erase);
    }

    public String propertyString(String propertyName, String kind) {
        return this.string(this.propertyKey(propertyName, kind));
    }

    private String propertyKey(String propertyName, String kind) {
        return propertyName + "." + kind;
    }

    public static String instantiate(String message, Object bean, boolean erase) {
        if (message == null) {
            return null;
        }
        int length = message.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        int i = 0;
        while (true) {
            int bufferLength;
            int pair;
            int i0 = i;
            while (true) {
                if (i == length) {
                    buffer.append(message.substring(i0));
                    return buffer.toString();
                }
                char c = message.charAt(i);
                if (c == '{') break;
                ++i;
            }
            buffer.append(message.substring(i0, i));
            int brace = i++;
            i0 = i;
            while (true) {
                if (i == length) {
                    buffer.append(message.substring(brace));
                    return buffer.toString();
                }
                char c = message.charAt(i);
                if (c == '}') break;
                ++i;
            }
            Object parameter = TopLevelDefinition.getValue(message, i0, i++, bean);
            boolean missing = false;
            boolean empty = false;
            if (parameter instanceof Object[]) {
                Object[] array = (Object[])parameter;
                if (array.length > 0) {
                    buffer.append(array[0]);
                    for (int j = 1; j < array.length; ++j) {
                        buffer.append(", ");
                        buffer.append(array[j]);
                    }
                } else {
                    empty = true;
                }
            } else if (parameter instanceof TypeSafeEnumeration) {
                TypeSafeEnumerationFactory factory = TypeSafeEnumerationFactory.factory(parameter.getClass());
                if (factory != null) {
                    buffer.append(factory.label(parameter));
                } else {
                    buffer.append(parameter);
                }
            } else if (parameter != null) {
                String string = String.valueOf(parameter);
                buffer.append(string);
                empty = string.isEmpty();
            } else {
                missing = true;
            }
            if (missing) {
                if (erase) {
                    int bufferLength2 = buffer.length();
                    if (bufferLength2 <= 0 || i >= length) continue;
                    pair = buffer.charAt(bufferLength2 - 1) << 16 | message.charAt(i);
                    if (pair == 0x220022 || pair == 0x270027) {
                        buffer.setLength(--bufferLength2);
                        if (bufferLength2 > 0 && ++i < length) {
                            pair = buffer.charAt(bufferLength2 - 1) << 16 | message.charAt(i);
                        }
                    }
                    if (pair != 0x200020) continue;
                    ++i;
                    continue;
                }
                buffer.append(message, i0 - 1, i);
                continue;
            }
            if (!empty || (bufferLength = buffer.length()) <= 0 || i >= length || (pair = buffer.charAt(bufferLength - 1) << 16 | message.charAt(i)) != 0x200020) continue;
            ++i;
        }
    }

    protected static Object getValue(String string, int first, int last, Object bean) {
        int dot;
        Object context;
        if (bean instanceof TransformContext) {
            context = ((TransformContext)bean).getTransform();
            dot = string.indexOf(46, first);
            if (dot < 0 || dot > last) {
                dot = last;
            }
            int nameLength = dot - first;
            StringBuffer methodName = new StringBuffer(3 + nameLength);
            methodName.append("get");
            if (nameLength <= 1) {
                methodName.append(string.charAt(first));
            } else {
                methodName.append(Character.toUpperCase(string.charAt(first)));
                methodName.append(string.substring(first + 1, dot));
            }
            try {
                Method method = bean.getClass().getMethod(methodName.toString(), new Class[0]);
                bean = method.invoke(bean, new Object[0]);
            }
            catch (Throwable e) {
                bean = ((TransformContext)bean).getViolation();
            }
        }
        if (bean instanceof Violation) {
            char c;
            context = (Violation)bean;
            dot = string.indexOf(46, first);
            if (dot < 0 || dot > last) {
                dot = last;
            }
            if (dot - first == 1 && Character.isDigit(c = string.charAt(first))) {
                int index = c - 48;
                if (index >= context.getParameterCount()) {
                    return null;
                }
                return context.getParameterValue(index);
            }
            bean = context.getParameterValue(string.substring(first, dot));
            if (bean == null) {
                return null;
            }
            first = dot + 1;
        }
        while (first < last && bean != null) {
            int dot2 = string.indexOf(46, first);
            if (dot2 < 0 || dot2 > last) {
                dot2 = last;
            }
            int nameLength = dot2 - first;
            if (bean instanceof Map) {
                bean = ((Map)bean).get(string.substring(first, dot2));
            } else {
                StringBuffer methodName = new StringBuffer(3 + nameLength);
                methodName.append("get");
                if (nameLength <= 1) {
                    methodName.append(string.charAt(first));
                } else {
                    methodName.append(Character.toUpperCase(string.charAt(first)));
                    methodName.append(string.substring(first + 1, dot2));
                }
                try {
                    Method method;
                    if (bean instanceof Object[]) {
                        method = bean.getClass().getComponentType().getMethod(methodName.toString(), new Class[0]);
                        Object[] array = bean;
                        Object[] newArray = (Object[])Array.newInstance(method.getReturnType(), array.length);
                        for (int j = 0; j < array.length; ++j) {
                            newArray[j] = method.invoke(bean, new Object[0]);
                        }
                        bean = newArray;
                    } else {
                        method = bean.getClass().getMethod(methodName.toString(), new Class[0]);
                        bean = method.invoke(bean, new Object[0]);
                    }
                }
                catch (Throwable e) {
                    return null;
                }
            }
            first = dot2 + 1;
        }
        return bean;
    }

    public String getElementName() {
        String name = this.getClass().getSimpleName();
        return name.substring(0, name.length() - "Definition".length()).toLowerCase() + "-definition";
    }

    public boolean equals(Object that) {
        return that instanceof TopLevelDefinition && ((TopLevelDefinition)that).id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String toString() {
        String name = this.getClass().getSimpleName();
        return name.substring(0, name.length() - "Definition".length()).toLowerCase() + " \"" + this.id + "\" definition";
    }
}

