/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.DataContainer;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.Structure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;

public class DependencyStructureListener
extends StructureChangeListener {
    private static final Map<PropertyStorage, DependencyStructureListener> listeners = new IdentityHashMap<PropertyStorage, DependencyStructureListener>();
    private static final Log LOCK_LOG = new Log("status-lock");
    private final PropertyStorage container;
    private final Structure structure;
    private final List<ScopedDependency> dependencies = new ArrayList<ScopedDependency>();
    private static final Log LOG = new Log("dependency");

    public static void addDependency(Dependency dependency, PropertyStorage container) {
        DependencyStructureListener.addDependency(dependency, container, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDependency(Dependency dependency, PropertyStorage container, String scope) {
        DependencyStructureListener listener;
        Map<PropertyStorage, DependencyStructureListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(container);
            if (listener == null) {
                listener = new DependencyStructureListener(container);
                listeners.put(container, listener);
            }
        }
        listener.addDependency(dependency, scope);
    }

    public static void removeDependency(Dependency dependency, PropertyStorage container) {
        DependencyStructureListener.removeDependency(dependency, container, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDependency(Dependency dependency, PropertyStorage container, String scope) {
        boolean removed;
        DependencyStructureListener listener;
        Map<PropertyStorage, DependencyStructureListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(container);
        }
        if (listener != null && (removed = listener.removeDependency(dependency, scope))) {
            Map<PropertyStorage, DependencyStructureListener> map2 = listeners;
            synchronized (map2) {
                listeners.remove(container);
            }
        }
    }

    public DependencyStructureListener(PropertyStorage container) {
        this.container = container;
        this.structure = container.getProperties();
    }

    public synchronized boolean addDependency(Dependency dependency, String scope) {
        boolean added = this.dependencies.isEmpty();
        if (added) {
            LOG.trace("******** adding structure listener {0}", (Object)this);
            this.structure.addStructureChangeListener((StructureChangeListener)this);
        }
        this.dependencies.add(new ScopedDependency(dependency, scope));
        return added;
    }

    public synchronized boolean removeDependency(Dependency dependency, String scope) {
        this.dependencies.remove(new ScopedDependency(dependency, scope));
        boolean removed = this.dependencies.isEmpty();
        if (removed) {
            LOG.trace("******** removing structure listener {0}", (Object)this);
            this.structure.removeStructureChangeListener((StructureChangeListener)this);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void structureValuesChanged(StructureChangeEvent e) {
        if (this.container instanceof DataContainer && !((DataContainer)this.container).isOpen()) {
            LOCK_LOG.trace("structure changed in {0}, closed: \"{1}\"", (Object)this, (Object)e);
            return;
        }
        ArrayList<Dependency> changed = new ArrayList<Dependency>();
        DependencyStructureListener dependencyStructureListener = this;
        synchronized (dependencyStructureListener) {
            block3: for (ScopedDependency dependency : this.dependencies) {
                for (ChangeInfo change : e.getChangeDetails()) {
                    if (change.getChangeType() == 2 || !dependency.applies(change)) continue;
                    changed.add(dependency.dependency);
                    continue block3;
                }
            }
        }
        for (Dependency dependency : changed) {
            dependency.fireDependencyChanged(true);
        }
        LOCK_LOG.trace("structure changed in {0}, open, change {1}: \"{2}\"", (Object)this, (Object)(!changed.isEmpty() ? 1 : 0), (Object)e);
    }

    public String toString() {
        String name = this.container instanceof DataContainer ? ((DataContainer)this.container).getShortLabel() : this.container.getClass().getName();
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.structure + " (" + name + ")";
    }

    private static class ScopedDependency {
        private final Dependency dependency;
        private final String scope;

        private ScopedDependency(Dependency dependency, String scope) {
            this.dependency = dependency;
            this.scope = scope;
        }

        public boolean applies(ChangeInfo change) {
            return this.scope == null || change.getPropertyName().startsWith(this.scope);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ScopedDependency)) {
                return false;
            }
            ScopedDependency that = (ScopedDependency)object;
            return this.dependency.equals(that.dependency) && this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
        }

        public int hashCode() {
            return this.dependency.hashCode() * 37 + (this.scope != null ? this.scope.hashCode() : 0);
        }
    }
}

