/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import oracle.ide.model.DataContainer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.DependencyStructureListener;

public class StructureDependency
extends Dependency {
    private final PropertyStorage container;
    private final String scope;
    private static final Log LOG = new Log("dependency");

    public StructureDependency(PropertyStorage container) {
        this(container, null);
    }

    public StructureDependency(PropertyStorage container, String scope) {
        if (container == null) {
            throw new IllegalArgumentException("container == null");
        }
        this.container = container;
        this.scope = scope;
        LOG.trace("created {0}", (Object)this);
    }

    @Override
    protected void attach() {
        LOG.trace("attaching {0}", (Object)this);
        DependencyStructureListener.addDependency(this, this.container, this.scope);
    }

    @Override
    protected void detach() {
        LOG.trace("detaching {0}", (Object)this);
        DependencyStructureListener.removeDependency(this, this.container, this.scope);
    }

    @Override
    protected String getShortDescription() {
        String label = this.container instanceof DataContainer ? ((DataContainer)this.container).getShortLabel() : this.container.getClass().getSimpleName();
        return label + (this.scope != null ? "[" + this.scope + "]" : "[]");
    }

    @Override
    protected String getLongDescription() {
        String label = this.container instanceof DataContainer ? ((DataContainer)this.container).getLongLabel() : this.container.getClass().getName();
        return label + (this.scope != null ? "[" + this.scope + "]" : "[]");
    }
}

