/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideri.util.Product;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.ExtensionBeanFactory;
import oracle.jdeveloper.audit.extension.ProfileDefinition;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.core.DefaultProfile;
import oracle.jdevimpl.audit.util.Strings;

public class ProfileRepository {
    public static final String AUDIT_RULES = "oracle.ide.audit.audit-rules";
    public static final String CODE_ASSIST_RULES = "oracle.ide.audit.code-assist-rules";
    public static final String COMPILE_RULES = "oracle.jdeveloper.java.compile-rules";
    private boolean scanned;
    private ExtensionBeanFactory factory;
    private URL directory;
    private Map<String, ProfileDefinition> definitions;
    private Map<String, Profile> profilesByName;
    private Map<String, Profile> defaultProfilesById;
    private Profile fallbackProfile;
    private static ProfileRepository defaultRepository;
    private static final Log LOG;
    private boolean scanning = false;

    public static ProfileRepository getDefaultRepository() {
        if (defaultRepository == null) {
            defaultRepository = new ProfileRepository(null, null, null);
        }
        return defaultRepository;
    }

    public ProfileRepository(Map<String, ProfileDefinition> definitions, ExtensionBeanFactory factory, URL directory) {
        LOG.trace("creating profile repository at {0}, factory {1}", (Object)directory);
        this.definitions = definitions;
        this.factory = factory;
        this.directory = directory;
    }

    public synchronized List<Profile> getProfiles() {
        this.scan();
        return new ArrayList<Profile>(this.profilesByName.values());
    }

    public synchronized boolean exists(String name) {
        this.scan();
        return this.profilesByName.containsKey(ProfileRepository.normalizeProfileName(name));
    }

    public synchronized Profile getProfile(String name) {
        if (name == null) {
            return null;
        }
        this.scan();
        return this.profilesByName.get(ProfileRepository.normalizeProfileName(name));
    }

    public synchronized Profile getProfile(String name, String id) {
        Profile profile;
        this.scan();
        if (name != null && (profile = this.profilesByName.get(ProfileRepository.normalizeProfileName(name))) != null) {
            return profile;
        }
        if (id != null) {
            Collection<Profile> profiles = this.profilesByName.values();
            for (Profile profile2 : profiles) {
                if (!id.equals(profile2.getId())) continue;
                return profile2;
            }
        }
        AuditLogger.error("using fallback profile for profile \"{0}\" (id {1})", name, id);
        return this.getFallbackProfile();
    }

    public synchronized Profile getDefaultProfile(String id) {
        if (id == null) {
            return null;
        }
        this.scan();
        return this.defaultProfilesById.get(id);
    }

    public synchronized void save(Profile profile) throws IOException {
        Profile oldProfile;
        String name = profile.getName();
        URL oldUrl = profile.getURL();
        if (oldUrl == null && (oldProfile = this.profilesByName.get(ProfileRepository.normalizeProfileName(name))) != null) {
            oldUrl = oldProfile.getURL();
        }
        URL url = this.getURL(this.directory, name, oldUrl);
        LOG.trace("saving profile {0} to {1}", (Object)profile, (Object)url);
        if (!URLFileSystem.mkdirs((URL)this.directory)) {
            throw new IOException("profile directory " + URLFileSystem.getPlatformPathName((URL)this.directory) + " could not be created");
        }
        profile.save(url);
        this.profilesByName.put(ProfileRepository.normalizeProfileName(name), profile);
    }

    public synchronized void delete(Profile profile) {
        LOG.trace("deleting {0}", (Object)profile);
        URLFileSystem.delete((URL)profile.getURL());
        String name = profile.getName();
        this.profilesByName.remove(ProfileRepository.normalizeProfileName(name));
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan() {
        if (this.scanned) {
            return;
        }
        LOG.trace("scanning profile repository {0}", this.scanning);
        PerformanceLogger.get().startTiming("ProfileRepository.scan");
        this.scanning = true;
        boolean directoryExists = false;
        try {
            if (this.definitions == null) {
                this.definitions = AuditHook.getAuditHook().getProfiles();
            }
            if (this.factory == null) {
                this.factory = AuditManager.getAuditManager().getDefaultExtensionBeanFactory();
            }
            if (this.directory == null) {
                this.directory = ProfileRepository.defaultIdeProfileDirectory();
            }
            this.scanned = true;
            directoryExists = URLFileSystem.exists((URL)this.directory);
            Map<String, Profile> defaultProfilesByName = this.loadDefaultProfiles();
            Set<ProfileDefinition> missingDefaultProfiles = this.scanProfileDirectory(defaultProfilesByName);
            for (ProfileDefinition definition : missingDefaultProfiles) {
                Profile defaultProfile = this.defaultProfilesById.get(definition.getId());
                if (defaultProfile == null) continue;
                LOG.trace("scanning predefined profile {0}", (Object)defaultProfile);
                String name = defaultProfile.getName();
                String normalizedName = ProfileRepository.normalizeProfileName(name);
                if (this.profilesByName.containsKey(normalizedName)) continue;
                URL url = this.getURL(this.directory, name);
                LOG.trace("creating default profile {0} at {1}", (Object)defaultProfile, (Object)url);
                DefaultProfile profile = new DefaultProfile(defaultProfile, url);
                this.profilesByName.put(normalizedName, profile);
            }
            if (this.profilesByName.isEmpty()) {
                this.getFallbackProfile();
            }
            LOG.trace("loaded {0}", this.profilesByName);
            this.scanning = false;
        }
        catch (Throwable throwable) {
            this.scanning = false;
            PerformanceLogger.get().stopTiming("ProfileRepository.scan", directoryExists ? "Scanning existing Audit profile repository" : "Creating and populating Audit profile repository (one-time)", 50);
            throw throwable;
        }
        PerformanceLogger.get().stopTiming("ProfileRepository.scan", directoryExists ? "Scanning existing Audit profile repository" : "Creating and populating Audit profile repository (one-time)", 50);
    }

    private Set<ProfileDefinition> scanProfileDirectory(Map<String, Profile> defaultProfilesByName) {
        LOG.trace("scanning {0}", (Object)this.directory);
        this.profilesByName = new LinkedHashMap<String, Profile>();
        HashSet<ProfileDefinition> missingDefinitions = new HashSet<ProfileDefinition>(this.definitions.values());
        URL[] files = URLFileSystem.list((URL)this.directory);
        if (files != null) {
            for (URL url : files) {
                DefaultProfile profile;
                String fileName = URLFileSystem.getFileName((URL)url);
                if (!fileName.endsWith(".xml") || URLFileSystem.getLength((URL)url) == 0L) continue;
                try {
                    profile = new DefaultProfile(this.factory, url, false);
                }
                catch (IOException e) {
                    AuditLogger.error(e, "Loading profile {0} failed: {1}", url, e);
                    continue;
                }
                String name = ((Profile)profile).getName();
                String normalizedName = ProfileRepository.normalizeProfileName(name);
                ProfileDefinition definition = ((Profile)profile).getDefinition();
                if (definition != null) {
                    name = definition.getName();
                    missingDefinitions.remove(definition);
                } else {
                    if (((Profile)profile).getId() != null) continue;
                    Profile defaultProfile = defaultProfilesByName.get(normalizedName);
                    if (defaultProfile != null) {
                        definition = defaultProfile.getDefinition();
                        profile = new DefaultProfile((Profile)profile, definition);
                        missingDefinitions.remove(definition);
                    }
                }
                this.profilesByName.put(normalizedName, profile);
            }
        }
        return missingDefinitions;
    }

    private Map<String, Profile> loadDefaultProfiles() {
        HashMap<String, Profile> defaultProfilesByName = new HashMap<String, Profile>();
        this.defaultProfilesById = new LinkedHashMap<String, Profile>();
        LOG.trace("scanning predefined profiles");
        for (ProfileDefinition definition : this.definitions.values()) {
            DefaultProfile profile;
            String normalizedName;
            String id = definition.getId();
            if (id == null) {
                definition.log(Level.SEVERE, "profile {0} created with no id", definition);
                continue;
            }
            if (this.defaultProfilesById.containsKey(id)) {
                definition.log(Level.SEVERE, "profile \"{0}\" duplicates profile {1}", id, this.defaultProfilesById.get(id));
                continue;
            }
            String name = definition.label();
            if (name == null) {
                name = Strings.lastToken(definition.getId(), '.');
            }
            if (defaultProfilesByName.containsKey(normalizedName = ProfileRepository.normalizeProfileName(name))) {
                definition.log(Level.SEVERE, "profile \"{0}\" already defined by extension {1}", id, this.defaultProfilesById.get(id).getDefinition().getExtensionId());
                continue;
            }
            URL url = definition.getURL();
            if (url == null) {
                definition.log(Level.SEVERE, "profile \"{0}\" no path defined", id);
                continue;
            }
            if (!URLFileSystem.exists((URL)url)) {
                definition.log(Level.SEVERE, "profile \"{0}\" file not found: {1}", id, url);
                continue;
            }
            try {
                profile = new DefaultProfile(this.factory, definition, name, url);
            }
            catch (IOException e) {
                definition.log(Level.SEVERE, "profile \"{0}\" failed to load: {1}", id, e);
                continue;
            }
            this.defaultProfilesById.put(id, profile);
            defaultProfilesByName.put(normalizedName, profile);
        }
        return defaultProfilesByName;
    }

    private Profile getFallbackProfile() {
        if (this.fallbackProfile == null) {
            String name = "All";
            Log.error((String)"creating fallback profile {0}", (Object)name);
            this.fallbackProfile = new DefaultProfile(this.factory, name, DefaultProfile.ALL_ENABLED);
            this.profilesByName.put(ProfileRepository.normalizeProfileName(name), this.fallbackProfile);
        }
        return this.fallbackProfile;
    }

    public static URL defaultIdeProfileDirectory() {
        return ProfileRepository.profileDirectoryForSystemDirectory(ExtensionRegistry.getExtensionRegistry().getSystemDirectory(Product.getProductID()));
    }

    public static URL profileDirectoryForSystemDirectory(URL system) {
        return URLFactory.newDirURL((URL)URLFactory.newDirURL((URL)system, (String)"audit"), (String)"profiles");
    }

    private URL getURL(URL directory, String name, URL oldURL) {
        URL oldDirectory;
        if (oldURL != null && URLFileSystem.equals((URL)directory, (URL)(oldDirectory = URLFileSystem.getParent((URL)oldURL)))) {
            return oldURL;
        }
        return this.getURL(directory, name);
    }

    private URL getURL(URL directory, String name) {
        String sanitizedName = ProfileRepository.sanitizeFileName(name);
        URL url = URLFactory.newURL((URL)directory, (String)(sanitizedName + ".xml"));
        if (URLFileSystem.exists((URL)url) || !URLFileSystem.canCreate((URL)url)) {
            url = URLFactory.newURL((URL)directory, (String)(sanitizedName + "-1.xml"));
            int i = 2;
            while (URLFileSystem.exists((URL)url)) {
                url = URLFactory.newURL((URL)directory, (String)(sanitizedName + "-" + i + ".xml"));
                ++i;
            }
        }
        return url;
    }

    public static String normalizeProfileName(String name) {
        int length = name.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (Character.isWhitespace(c)) continue;
            buffer.append(Character.toUpperCase(c));
        }
        return buffer.toString();
    }

    public static String sanitizeFileName(String name) {
        name = name.trim();
        StringBuffer buffer = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (c >= '0' && c <= '9') {
                    buffer.append(c);
                    continue;
                }
                if (c >= 'A' && c <= 'Z') {
                    buffer.append((char)(c - 65 + 97));
                    continue;
                }
                if (c >= 'a' && c <= 'z') {
                    buffer.append(c);
                    continue;
                }
                buffer.append(97 + c % 25);
                continue;
            }
            if (Character.isSpaceChar(c)) {
                buffer.append('-');
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }

    static {
        LOG = new Log("audit-initialization");
    }
}

