/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.javatools.util.NullResourceBundle;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;

public class TypeSafeEnumerationFactory {
    private Class type;
    private List<String> tags = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();
    private ResourceBundle bundle;
    private static final Map<Class, TypeSafeEnumerationFactory> instances = new HashMap<Class, TypeSafeEnumerationFactory>();
    private static final Map<Class, Map<String, String>> substitutions = new HashMap<Class, Map<String, String>>();
    private static final int PSF = 25;

    private TypeSafeEnumerationFactory(Class type) {
        assert (TypeSafeEnumeration.class.isAssignableFrom(type));
        this.type = type;
        Constructor<?>[] constructors = type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            assert (Modifier.isPrivate(constructors[i].getModifiers()));
        }
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getModifiers() != 25) continue;
                Object value = fields[i].get(null);
                assert (value != null);
                if (this.values.indexOf(value) >= 0) continue;
                this.values.add(value);
                this.tags.add(String.valueOf(value));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
        }
    }

    public static TypeSafeEnumerationFactory factory(Class type) {
        TypeSafeEnumerationFactory cache = instances.get(type);
        if (cache == null) {
            cache = new TypeSafeEnumerationFactory(type);
            instances.put(type, cache);
        }
        return cache;
    }

    public static void addSubstitution(Class type, String oldTag, String newTag) {
        Map<String, String> tags = substitutions.get(type);
        if (tags == null) {
            tags = new HashMap<String, String>();
            substitutions.put(type, tags);
        }
        tags.put(oldTag.toLowerCase(), newTag);
    }

    public static Object value(Class type, String tag) {
        TypeSafeEnumerationFactory factory = TypeSafeEnumerationFactory.factory(type);
        if (factory == null) {
            return null;
        }
        return factory.value(tag);
    }

    public Object value(String tag) {
        String substitution;
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        String t = tag.toLowerCase();
        Map<String, String> map = substitutions.get(this.type);
        if (map != null && (substitution = map.get(t)) != null) {
            t = substitution;
        }
        String s = this.normalize(t);
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!s.equals(this.normalize(this.tags.get(i)))) continue;
            return this.values.get(i);
        }
        throw new IllegalArgumentException("unrecognized tag " + tag);
    }

    private String normalize(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-' || c == '_') continue;
            builder.append(Character.toLowerCase(c));
        }
        return builder.toString();
    }

    public String tag(Object value) {
        if (value == null) {
            return null;
        }
        int index = this.values.indexOf(value);
        if (index < 0) {
            return null;
        }
        return this.tags.get(index);
    }

    public String label(Object value) {
        String tag = this.tag(value);
        if (tag == null) {
            return null;
        }
        try {
            return this.getBundle().getString(tag);
        }
        catch (MissingResourceException e) {
            return TypeSafeEnumerationFactory.capitalizeAndSeparateAll(tag.replace('-', ' '));
        }
    }

    private static String capitalizeAndSeparateAll(String string) {
        int count = string.length();
        StringBuffer buffer = new StringBuffer(count << 1);
        boolean wasWhiteSpace = true;
        boolean wasUpperCase = true;
        for (int i = 0; i < count; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!wasUpperCase) {
                    buffer.append(' ');
                }
                wasUpperCase = true;
            } else {
                if (wasWhiteSpace) {
                    c = Character.toUpperCase(c);
                }
                wasUpperCase = false;
            }
            wasWhiteSpace = Character.isWhitespace(c);
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[] getLabels() {
        String[] labels = new String[this.tags.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            labels[i] = this.label(this.values.get(i));
        }
        return labels;
    }

    public Object[] getValues() {
        return this.values.toArray();
    }

    protected ResourceBundle getBundle() {
        if (this.bundle == null) {
            String name = this.type.getName() + "Bundle";
            try {
                Locale locale = Locale.getDefault();
                this.bundle = ResourceBundle.getBundle(name, locale);
            }
            catch (MissingResourceException e) {
                this.bundle = NullResourceBundle.instance();
            }
        }
        return this.bundle;
    }
}

