/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import oracle.jdeveloper.audit.extension.DeferredExpression;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.TransformDefinition;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;

public abstract class Transform
extends ExtensionBean {
    public static final String BOUND_LABEL_KEY = "bound-label";
    private TransformAdapter adapter;
    private boolean enabled = true;
    private Collection<String> variations;
    private DeferredExpression condition;

    protected Transform(TransformAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    protected void copyInternalState(ExtensionBean bean, Map<String, ExtensionBean> context) throws InvocationTargetException {
        Transform transform = (Transform)bean;
        transform.adapter = this.adapter;
        transform.variations = this.variations;
        transform.condition = this.condition;
    }

    public TransformContext[] createContexts(Violation violation) {
        return new TransformContext[]{this.adapter().createContext(this, violation, violation.getLocation())};
    }

    @Override
    public TransformDefinition definition() {
        return (TransformDefinition)super.definition();
    }

    public TransformAdapter adapter() {
        return this.adapter;
    }

    public Collection<String> variations() {
        return this.variations;
    }

    public DeferredExpression condition() {
        return this.condition;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String unboundLabel() {
        return this.formattedString("label", this, true);
    }

    public String boundLabel(TransformContext context) {
        String variation = context.getVariation();
        String string = this.formattedString(this.variationKey(BOUND_LABEL_KEY, variation), context);
        if (string == null && variation != null) {
            string = this.formattedString(this.variationKey(BOUND_LABEL_KEY, null), context);
        }
        if (string == null && (string = this.formattedString("label", context)) == null) {
            string = this.id();
        }
        return string;
    }

    private String variationKey(String key, String variation) {
        return variation != null ? variation + "." + key : key;
    }
}

