/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditListener;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Violation;

class AuditListenerList {
    private final Auditor auditor;
    private final CopyOnWriteArrayList<AuditListener> listeners = new CopyOnWriteArrayList();
    private static final Log LOG = new Log("auditor");

    AuditListenerList(Auditor auditor) {
        this.auditor = auditor;
    }

    void addListener(AuditListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    void removeListener(AuditListener listener) {
        this.listeners.remove(listener);
    }

    void fireAuditStarted(List<Metric> columns, List<Location> locations, Location root, Class type) {
        LOG.trace("**** firing audit started at {0}", (Object)root);
        for (AuditListener listener : this.listeners) {
            listener.auditStarted(this.auditor, columns, locations, root, type);
        }
        LOG.trace("completed firing audit started");
    }

    void fireAuditStopped(boolean cancelled) {
        LOG.trace("**** firing audit stopped, cancelled {0}", cancelled);
        for (AuditListener listener : this.listeners) {
            listener.auditStopped(this.auditor, cancelled);
        }
        LOG.trace("completed firing audit stopped, cancelled {0}", cancelled);
    }

    void firePhaseStarted(String phaseName) {
        LOG.trace("**** firing phase {0} started", (Object)phaseName);
        for (AuditListener listener : this.listeners) {
            listener.phaseStarted(this.auditor, phaseName);
        }
        LOG.trace("completed firing phase {0} started", (Object)phaseName);
    }

    void fireModelEntered(ModelAdapter model) {
        LOG.trace("**** firing model {0} started", (Object)model);
        for (AuditListener listener : this.listeners) {
            listener.modelEntered(this.auditor, model);
        }
        LOG.trace("completed firing model {0} started", (Object)model);
    }

    void fireDocumentStopped(ModelAdapter model) {
        LOG.trace("**** firing model {0} stopped", (Object)model);
        for (AuditListener listener : this.listeners) {
            listener.modelExited(this.auditor, model);
        }
        LOG.trace("completed firing model {0} stopped", (Object)model);
    }

    void fireLocationEntered(Location location, Class type) {
        LOG.trace("**** firing {0} entered, type {1}", (Object)location, (Object)type);
        for (AuditListener listener : this.listeners) {
            listener.locationEntered(this.auditor, location, type);
        }
        LOG.trace("completed firing {0} entered", (Object)location, (Object)type);
    }

    void fireLocationExited(Location location) {
        LOG.trace("**** firing {0} exited", (Object)location);
        for (AuditListener listener : this.listeners) {
            listener.locationExited(this.auditor, location);
        }
        LOG.trace("completed firing {0} exited", (Object)location);
    }

    void fireIssueReported(Violation violation, int transformMask) {
        LOG.trace("**** firing {0} reported", (Object)violation);
        if (violation.getRule() == null) {
            IllegalArgumentException exception = new IllegalArgumentException("violation has null rule");
            AuditLogger.error(exception, "internal error detected: {0}", exception);
            return;
        }
        for (AuditListener listener : this.listeners) {
            listener.issueReported(this.auditor, violation, transformMask);
        }
        LOG.trace("**** completed firing {0} reported", (Object)violation);
    }

    void fireValueReported(Location location, Metric metric, Object newValue) {
        LOG.trace("firing {1} value {2} reported at {0)", (Object)location, (Object)metric, newValue);
        for (AuditListener listener : this.listeners) {
            listener.valueReported(this.auditor, location, metric, newValue);
        }
        LOG.trace("completed firing {1} value {2} reported at {0)", (Object)location, (Object)metric, newValue);
    }

    void fireAuditorCleared() {
        LOG.trace("firing auditor cleared");
        for (AuditListener listener : this.listeners) {
            listener.auditorCleared(this.auditor);
        }
        LOG.trace("completed firing auditor cleared");
    }
}

