/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import javax.ide.extension.Extension;
import net.jcip.annotations.GuardedBy;
import oracle.ide.ExtensionRegistry;
import oracle.ide.IdeCore;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryElement;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IntersectedFilters;
import oracle.ideimpl.extension.OnProjectOpenHook;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.data.ListStructure;
import oracle.javatools.management.Memory;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.AnalyzerDefinition;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.Trigger;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.model.CompositeDependency;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditListener;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.core.AnalyzerBinding;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.AuditListenerList;
import oracle.jdevimpl.audit.core.BoundMethod;
import oracle.jdevimpl.audit.core.CoreBeans;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.CountColumn;
import oracle.jdevimpl.audit.core.DefaultAuditContext;
import oracle.jdevimpl.audit.core.DefaultAuditTaskContext;
import oracle.jdevimpl.audit.core.IssueCollector;
import oracle.jdevimpl.audit.core.SeverityColumn;
import oracle.jdevimpl.audit.model.DirectoryModelAdapter;
import oracle.jdevimpl.audit.model.ProjectModelAdapter;
import oracle.jdevimpl.audit.model.RootModelAdapter;
import oracle.jdevimpl.audit.model.WorkspaceModelAdapter;
import oracle.jdevimpl.audit.util.Strings;

public final class DefaultAuditor
extends Auditor
implements Runnable {
    private static final boolean SUPPRESS_PROJECT_CLOSE = Boolean.getBoolean("audit.suppress.project.close");
    private static final boolean PRESENT_ALL = Boolean.getBoolean("audit.present.all");
    private static final String SHOW_COUNTS = System.getProperty("audit.show.issue.counts");
    private static final Set<String> analyzerExcludes;
    private static final Log LOG;
    private static final Log LOG_CANCEL;
    private static final Log LOG_HEAP;
    private static final Log MEMORY_STATISTICS;
    private static final Log ANALYZER_STATISTICS;
    private static final FormatBundle BUNDLE;
    private final ModelTypeFactory typeFactory;
    private final Set<ModelType> modelTypes = new HashSet<ModelType>();
    private final List<Class> typeList = new ArrayList<Class>();
    private final Map<Class<?>, Class<?>> typeMap = new LinkedHashMap();
    private final Map<Object, Object> configurationAttributes = new HashMap<Object, Object>();
    private ModelFactory modelFactory;
    private List<Location> locations = new ArrayList<Location>();
    private Set<Project> scannedProjects = new HashSet<Project>();
    private Map<Object, Set<String>> technologies;
    private CompositeDependency dependenciesCollector;
    private Profile profile;
    private long maximumFileSize;
    private WorkingSet workingSet;
    private IntersectedFilters fileFilters;
    private boolean ignoreAssists;
    private WriteLockRequestListener writeLockRequestListener;
    private boolean visitDescendants = true;
    private boolean visitAncestors = true;
    private AnalyzerBinding binding;
    private final Object stateLock = new Object();
    private boolean cancelOnWait;
    @GuardedBy(value="stateLock")
    private volatile Thread auditingThread;
    private Location commonAncestor;
    private volatile ModelAdapter auditingModel;
    @GuardedBy(value="stateLock")
    private volatile Throwable cancellationCause;
    @GuardedBy(value="stateLock")
    private CancellationException propagatingException;
    private AuditListenerList listeners = new AuditListenerList(this);
    private volatile int runCount;
    private NodeListener closeNodeListener = new NodeListener(){

        public void nodeWillClose(NodeEvent e) {
            LOG.trace("ancestor node will close: {0}", (Object)e);
            Node node = e.getNode();
            if (node instanceof Workspace || node instanceof Project) {
                DefaultAuditor.this.cancel();
            } else {
                Log.error((String)"{0} closed during traversal", (Object)node, (Object)new Throwable(node.getShortLabel()));
            }
        }
    };
    private AuditELContext expressionContext = new AuditELContext();
    private IssueCollector issueCollector;
    private MultiMap<Class<? extends ModelType>, Location> embeddedFragments;
    private Collection<AnalyzerDefinition> analyzerDefinitions;
    private static final Log CONTROLLER_LOG;

    public DefaultAuditor(ModelTypeFactory factory, Class<? extends Analyzer> ... analyzers) {
        this.typeFactory = factory;
        this.modelFactory = this.createModelFactory();
        if (analyzers != null && analyzers.length > 0) {
            this.analyzerDefinitions = new ArrayList<AnalyzerDefinition>(analyzers.length);
            DefinitionContext context = new DefinitionContext("oracle.ide.audit");
            for (Class<? extends Analyzer> analyzerClass : analyzers) {
                this.analyzerDefinitions.add(new AnalyzerDefinition(new TypeDefinition<Analyzer>(analyzerClass, context)));
            }
        }
    }

    private ModelFactory createModelFactory() {
        ModelFactory factory = this.typeFactory.createModelFactory(this.configurationAttributes);
        factory.setWorkingSet(this.getWorkingSet());
        factory.setFileFilters(this.getFileFilters());
        factory.setMaximumFileSize(this.getMaximumFileSize());
        return factory;
    }

    @Override
    public void addAuditListener(AuditListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeAuditListener(AuditListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public boolean isAuditable(Element element, Node node, Project project, Workspace workspace) {
        return !this.getModelAdapters(element, node, project, workspace).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addElement(Element element, Node node, Project project, Workspace workspace) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        Collection<ModelAdapter> models = this.getModelAdapters(element, node, project, workspace);
        if (models.isEmpty()) {
            return false;
        }
        boolean added = false;
        for (ModelAdapter model : models) {
            try {
                model.beginRead();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UnexpectedExceptionError((Throwable)e);
            }
            try {
                Location[] locations = model.getElementLocations(element);
                LOG.trace("found locations {0} for {1}", (Object)locations, (Object)model);
                if (locations == null || locations.length <= 0) continue;
                for (Location location : locations) {
                    this.addLocation(location);
                }
                added = true;
            }
            finally {
                model.endRead();
            }
        }
        return added;
    }

    @Override
    public boolean addElements(Element[] elements, Node node, Project project, Workspace workspace) {
        boolean added = false;
        for (Element element : elements) {
            if (!this.addElement(element, node, project, workspace)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean addNode(Node node, Project project, Workspace workspace) {
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        return this.addElement((Element)node, node, project, workspace);
    }

    @Override
    public boolean addUrl(URL url, Project project, Workspace workspace) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        if (url == null) {
            return false;
        }
        this.activateProjectAndWorkspace(project, workspace);
        Collection<ModelAdapter> models = this.modelFactory.getModelAdapters(null, url, project, workspace);
        for (ModelAdapter model : models) {
            this.addLocation(model.getLocation());
        }
        return !models.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConstruct(Object construct, URL url, Project project, Workspace workspace) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        if (construct == null || url == null) {
            return false;
        }
        this.activateProjectAndWorkspace(project, workspace);
        Collection<ModelAdapter> models = this.modelFactory.getModelAdapters(null, url, project, workspace);
        boolean added = false;
        for (ModelAdapter model : models) {
            try {
                model.beginRead();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UnexpectedExceptionError((Throwable)e);
            }
            try {
                Location location = model.getLocation(construct);
                if (location == null) continue;
                this.addLocation(location);
                added = true;
            }
            finally {
                model.endRead();
            }
        }
        return added;
    }

    private Collection<ModelAdapter> getModelAdapters(Element element, Node node, Project project, Workspace workspace) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        if (!(element instanceof Workspaces || element instanceof Workspace || element instanceof Project || element instanceof RelativeDirectoryElement)) {
            this.activateProjectAndWorkspace(project, workspace);
        }
        Collection<ModelAdapter> models = this.modelFactory.getModelAdapters(element, node != null ? node.getURL() : null, project, workspace);
        LOG.trace("found adapters {0} for {1}", models, (Object)node);
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        boolean cancelling;
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = cancelling = this.auditingThread != null && this.cancellationCause == null;
            if (cancelling) {
                this.auditingThread.interrupt();
                this.cancellationCause = new Throwable("cancellation cause from Thread[" + Thread.currentThread().getName() + "]");
                LOG_CANCEL.trace("asynchronous cancellation requested: {0}", (Object)this.cancellationCause);
            }
        }
        if (cancelling) {
            ModelAdapter model = this.auditingModel;
            if (model != null) {
                model.cancelRead();
            }
            this.binding.cancel();
        }
        return cancelling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CancellationException cancellationException(Throwable handledException) {
        if (handledException == null) {
            throw new NullArgumentException("handledException == null");
        }
        boolean recognizingCancellation = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.auditingThread == null) {
                throw new IllegalStateException("audit not running");
            }
            if (this.cancellationCause == null) {
                recognizingCancellation = true;
                this.cancellationCause = handledException;
                if (handledException instanceof CancellationException) {
                    this.propagatingException = (CancellationException)handledException;
                } else {
                    this.propagatingException = new CancellationException();
                    this.propagatingException.initCause(handledException);
                }
                LOG_CANCEL.trace("cancellation by exception recognized: {0}", (Object)handledException);
            } else if (this.propagatingException == null) {
                recognizingCancellation = true;
                this.propagatingException = new CancellationException();
                this.propagatingException.initCause(handledException);
                Throwable bottom = handledException;
                while (bottom.getCause() != null) {
                    bottom = bottom.getCause();
                }
                bottom.initCause(this.cancellationCause);
                LOG_CANCEL.trace("asynchronous cancellation recognized on exception: {0}", (Object)handledException);
            } else if (handledException == this.propagatingException) {
                LOG_CANCEL.trace("cancellation propagated: {0}", (Object)handledException);
            } else {
                LOG_CANCEL.trace("propagation failed with exception: {0}", (Object)handledException);
                AuditLogger.error(handledException, "Exception while propagating cancellation", new Object[0]);
            }
        }
        if (recognizingCancellation) {
            ModelAdapter model;
            if (handledException instanceof OutOfMemoryError) {
                String path = this.dumpHeap("audit-oome");
                System.err.println("Heap snapshot: " + path);
            }
            if ((model = this.auditingModel) != null) {
                model.cancelRead();
            }
            this.binding.cancel();
        }
        return this.propagatingException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void throwIfCancelled() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.cancellationCause != null) {
                LOG_CANCEL.trace("asynchronous cancellation recognized on poll: {0}", (Object)this.cancellationCause);
                CancellationException cancellation = new CancellationException();
                cancellation.initCause(this.cancellationCause);
                this.propagatingException = cancellation;
                throw cancellation;
            }
        }
    }

    @Override
    public void clear() {
        LOG.trace("clearing locations");
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.locations = new ArrayList<Location>();
        this.scannedProjects = new HashSet<Project>();
        this.dependenciesCollector = null;
        this.listeners.fireAuditorCleared();
        this.modelFactory.close();
        this.modelFactory = this.createModelFactory();
    }

    @Override
    public boolean isAuditableType(URL url) {
        if (URLFileSystem.isRegularFile((URL)url)) {
            try {
                return !this.modelFactory.getModelTypeFactory().getModelTypes((Element)NodeFactory.findOrCreate((URL)url)).isEmpty();
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InstantiationException e) {
                return false;
            }
        }
        return URLFileSystem.isDirectoryPath((URL)url) || URLFileSystem.isDirectory((URL)url);
    }

    private void addLocation(Location location) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        DefaultAuditor.addLocation(location, this.locations);
    }

    private static void addLocation(Location location, List<Location> locations) {
        Location successor;
        int predecessorIndex;
        Location predecessor;
        LOG.trace("adding {0} to {1}", (Object)location, locations);
        if (locations.isEmpty()) {
            LOG.trace("adding initial location {0}", (Object)location);
            locations.add(location);
            return;
        }
        int index = -Collections.binarySearch(locations, location) - 1;
        if (index < 0) {
            return;
        }
        if (index > 0 && (predecessor = locations.get(predecessorIndex = index - 1)).contains(location)) {
            LOG.trace("ignoring {0} for {1}", (Object)location, (Object)predecessor);
            return;
        }
        if (index < locations.size() && location.contains(successor = locations.get(index))) {
            LOG.trace("replacing {0} into {1}", (Object)location, (Object)successor);
            locations.set(index, location);
            return;
        }
        locations.add(index, location);
        LOG.trace("adding {0}", (Object)location);
    }

    @Override
    public ModelFactory getFactory() {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        return this.modelFactory;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    AnalyzerBinding getProfileBinding() {
        return this.binding;
    }

    @Override
    public void setProfile(Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("profile == null");
        }
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.profile = profile;
        this.binding = new AnalyzerBinding(profile);
    }

    @Override
    public void setAttribute(Object key, Object value) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.configurationAttributes.put(key, value);
    }

    @Override
    public boolean isAuditing() {
        return this.auditingThread != null;
    }

    @Override
    public boolean isCancelled() {
        return this.cancellationCause != null;
    }

    Set<String> getTechnologies(Workspace workspace, Project project) {
        Set<String> result = project != null ? this.technologies.get(project) : (workspace != null ? this.technologies.get(workspace) : this.technologies.get(null));
        return result != null ? result : Collections.emptySet();
    }

    @Override
    public long getMaximumFileSize() {
        return this.maximumFileSize > 0L ? this.maximumFileSize : (long)(AuditManager.getAuditManager().getPreferences().getMaximumFileSize() * 1000000.0f);
    }

    @Override
    public void setMaximumFileSize(long size) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor already auditing");
        }
        this.maximumFileSize = size;
        this.modelFactory.setMaximumFileSize(size);
    }

    @Override
    public void setWorkingSet(WorkingSet workingSet) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.workingSet = workingSet;
        this.modelFactory.setWorkingSet(workingSet);
    }

    @Override
    public WorkingSet getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public IntersectedFilters getFileFilters() {
        return this.fileFilters;
    }

    @Override
    public void setFileFilters(IntersectedFilters filters) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.fileFilters = filters;
        this.modelFactory.setFileFilters(filters);
    }

    @Override
    public void setIgnoreAssists(boolean ignore) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.ignoreAssists = ignore;
    }

    @Override
    public boolean isIgnoreAssists() {
        return this.ignoreAssists;
    }

    @Override
    public void setWriteLockRequestListener(WriteLockRequestListener listener) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.writeLockRequestListener = listener;
    }

    @Override
    public void setDependencyCollector(CompositeDependency collector) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.dependenciesCollector = collector;
    }

    @Override
    public void setVisitDescendants(boolean shallow) {
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        this.visitDescendants = shallow;
    }

    @Override
    public boolean isVisitDescendants() {
        return this.visitDescendants;
    }

    @Override
    public void setVisitAncestors(boolean shallow) {
        this.visitAncestors = shallow;
    }

    @Override
    public boolean isVisitAncestors() {
        return this.visitAncestors;
    }

    @Override
    public void run() {
        try {
            this.audit();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Override
    public void runAsynchronously() {
        this.runAsynchronously(null);
    }

    @Override
    public synchronized void runAsynchronously(Thread.UncaughtExceptionHandler handler) {
        LOG.trace("invoking audit asynchronously");
        if (this.isAuditing()) {
            throw new IllegalStateException("Auditor auditing");
        }
        Thread thread = new Thread((Runnable)this, "audit-thread-" + this.runCount);
        thread.setPriority(Math.max(thread.getPriority() - 1, 1));
        if (handler == null) {
            handler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof CancellationException)) {
                        AuditLogger.error(e, "Unexpected exception while auditing: {0}", e);
                    }
                }
            };
        }
        thread.setUncaughtExceptionHandler(handler);
        thread.start();
    }

    @Override
    public void audit() {
        this.audit(false);
    }

    @Override
    public void tryAudit() {
        this.audit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void audit(boolean cancelOnWait) {
        if (this.profile == null) {
            throw new IllegalStateException("profile not set");
        }
        if (this.locations.isEmpty()) {
            throw new IllegalStateException("no locations added");
        }
        LOG.trace("auditing {0} with {1}", this.locations, (Object)this.profile);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.auditingThread != null) {
                throw new IllegalStateException("Auditor already auditing");
            }
            this.cancelOnWait = cancelOnWait;
            this.auditingThread = Thread.currentThread();
            this.cancellationCause = null;
            this.propagatingException = null;
            this.binding.clear();
            this.issueCollector = null;
        }
        IdeCore.setActiveWorkspaceOverrideEnabled((boolean)true);
        try {
            block58: {
                boolean bl;
                List<Location> locations;
                ModelAdapter rootModel;
                ModelFactory modelFactory;
                boolean firstRun;
                boolean bl2 = firstRun = this.runCount++ == 0;
                if (firstRun) {
                    modelFactory = this.modelFactory;
                    rootModel = modelFactory.getModelRoot().getModel();
                    locations = this.locations;
                } else {
                    long start = System.currentTimeMillis();
                    ModelFactory oldModelFactory = this.modelFactory;
                    List<Location> oldLocations = this.locations;
                    modelFactory = this.createModelFactory();
                    locations = new ArrayList<Location>(oldLocations.size());
                    for (Location oldLocation : oldLocations) {
                        ModelAdapter oldModel = oldLocation.getModel();
                        assert (oldModel.getFactory() == oldModelFactory);
                        assert (oldModel.getFactory() != modelFactory);
                        Collection<ModelAdapter> newModels = modelFactory.getModelAdapters(oldModel.getElement(), oldModel.getUrl(), oldModel.getProject(), oldModel.getWorkspace());
                        for (ModelAdapter newModel : newModels) {
                            assert (newModel.getFactory() == modelFactory);
                            Location newLocation = oldLocation.isRoot() ? newModel.getLocation() : newModel.getLocation(oldLocation.getOffset(), oldLocation.getLength());
                            DefaultAuditor.addLocation(newLocation, locations);
                        }
                        this.throwIfCancelled();
                    }
                    if (locations.isEmpty()) {
                        throw new IllegalStateException("no locations valid ");
                    }
                    oldModelFactory.close();
                    this.modelFactory = modelFactory;
                    rootModel = modelFactory.getModelRoot().getModel();
                    this.locations = locations;
                    LOG.trace("recreated locations in {0} ms", System.currentTimeMillis() - start);
                }
                this.commonAncestor = locations.get(0);
                ModelAdapter ancestorModel = this.commonAncestor.getModel();
                Object ancestorConstruct = null;
                for (Location location : locations) {
                    boolean added;
                    ContainerModelAdapter parent;
                    ModelAdapter model = location.getModel();
                    if (!this.commonAncestor.contains(location)) {
                        if (model == ancestorModel) {
                            int begin = Math.min(location.getOffset(), this.commonAncestor.getOffset());
                            int end = Math.max(location.getEndOffset(), this.commonAncestor.getEndOffset());
                            try {
                                ancestorModel.beginRead();
                            }
                            catch (InterruptedException e) {
                                throw this.cancellationException(e);
                            }
                            try {
                                ancestorConstruct = model.getConstruct(model.getLocation(begin, end));
                                this.commonAncestor = model.getLocation(ancestorConstruct);
                            }
                            finally {
                                ancestorModel.endRead();
                            }
                        }
                        ancestorModel = ancestorModel.getContainingAdapter();
                        while (!ancestorModel.contains(model)) {
                            ancestorModel = ancestorModel.getContainingAdapter();
                        }
                        this.commonAncestor = ancestorModel.getLocation();
                        ancestorConstruct = null;
                    }
                    while ((parent = model.getContainingAdapter()) != null && (added = parent.addContainedModel(model))) {
                        model = parent;
                    }
                }
                LOG.trace("found common ancestor {0}", (Object)this.commonAncestor);
                this.throwIfCancelled();
                Set oldTechnologies = this.technologies == null ? Collections.emptySet() : this.technologies.get(null);
                this.technologies = this.gatherProjectTechnologies((RootModelAdapter)rootModel);
                Set<String> allTechnologies = this.technologies.get(null);
                if (!allTechnologies.equals(oldTechnologies)) {
                    ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                    for (Trigger trigger : AuditHook.getAuditHook().getUnloadedTriggers()) {
                        if (!trigger.matches(allTechnologies)) continue;
                        Extension extension = registry.findExtension(trigger.getExtensionId());
                        registry.fullyLoadExtension(extension);
                        this.throwIfCancelled();
                    }
                }
                boolean firedAuditStarted = false;
                try {
                    long start = System.currentTimeMillis();
                    this.throwIfCancelled();
                    ArrayList<Rule> rules = new ArrayList<Rule>();
                    ArrayList<Metric> metrics = new ArrayList<Metric>();
                    ArrayList<SuppressionScheme> suppressionSchemes = new ArrayList<SuppressionScheme>();
                    this.binding.bind(this.analyzerDefinitions, this.ignoreAssists, analyzerExcludes, rules, metrics, suppressionSchemes, false);
                    this.issueCollector = new IssueCollector(this.listeners, this.expressionContext, this.binding.getReviewMethods());
                    this.throwIfCancelled();
                    if (!rules.isEmpty()) {
                        CountColumn issuesColumn;
                        CountColumn visibleIssuesColumn;
                        SeverityColumn severityColumn = CoreBeans.severityColumn();
                        if (severityColumn != null) {
                            severityColumn.setEnabled(true);
                            metrics.add(severityColumn);
                        }
                        if (SHOW_COUNTS != null && (visibleIssuesColumn = CoreBeans.visibleIssuesColumn()) != null) {
                            visibleIssuesColumn.setCount(AuditModel.Count.VISIBLE_ISSUES);
                            visibleIssuesColumn.setEnabled(true);
                            metrics.add(visibleIssuesColumn);
                        }
                        if ("all".equalsIgnoreCase(SHOW_COUNTS) && (issuesColumn = CoreBeans.issuesColumn()) != null) {
                            issuesColumn.setCount(AuditModel.Count.ISSUES);
                            issuesColumn.setEnabled(true);
                            metrics.add(issuesColumn);
                        }
                    }
                    if (ANALYZER_STATISTICS.isEnabled()) {
                        int count = 0;
                        String EOL = System.getProperty("line.separator");
                        StringBuilder builder = new StringBuilder(EOL);
                        Collection<Analyzer> analyzers = this.binding.getAnalyzers();
                        for (Analyzer analyzer : analyzers) {
                            builder.append("  ");
                            ++count;
                            String name = analyzer.getClass().getName();
                            int dot = name.lastIndexOf(46);
                            builder.append(name, dot + 1, name.length());
                            builder.append(" (");
                            builder.append(name, 0, Math.max(dot, 0));
                            builder.append(")");
                            builder.append(EOL);
                        }
                        ANALYZER_STATISTICS.trace("Profile bound in {0} ms, {1} analyzers enabled:{2}", (Object)(System.currentTimeMillis() - start), (Object)count, (Object)builder);
                    }
                    this.throwIfCancelled();
                    if (ancestorConstruct == null) {
                        ancestorModel.beginRead();
                        try {
                            ancestorConstruct = ancestorModel.getConstruct(this.commonAncestor);
                        }
                        finally {
                            ancestorModel.endRead();
                        }
                    }
                    this.listeners.fireAuditStarted(metrics, locations, this.commonAncestor, ancestorConstruct.getClass());
                    firedAuditStarted = true;
                    this.throwIfCancelled();
                    start = System.currentTimeMillis();
                    assert (rootModel.getFactory() == this.commonAncestor.getModel().getFactory());
                    DefaultAuditContext rootContext = new DefaultAuditContext(this, this.listeners, this.issueCollector);
                    if (this.configurationAttributes != null) {
                        for (Map.Entry<Object, Object> entry : this.configurationAttributes.entrySet()) {
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            rootContext.setAttribute(rootContext.sharedKey(key), value);
                        }
                    }
                    this.traverseModel(rootContext, rootModel, true);
                    int count = 0;
                    LinkedBlockingQueue<Violation> queue = new LinkedBlockingQueue<Violation>();
                    Object[] arguments = new Object[1];
                    for (BoundMethod boundMethod : this.binding.getStartTaskMethods()) {
                        Analyzer analyzer = (Analyzer)boundMethod.getTarget();
                        arguments[0] = new DefaultAuditTaskContext(this, analyzer, modelFactory, queue);
                        Object started = boundMethod.invoke(analyzer, arguments);
                        if (!Boolean.TRUE.equals(started)) continue;
                        ++count;
                    }
                    if (count > 0) {
                        this.listeners.firePhaseStarted(BUNDLE.get("phase.background.label"));
                    }
                    while (count > 0) {
                        Violation violation = (Violation)queue.take();
                        if (violation == null) {
                            --count;
                            continue;
                        }
                        this.listeners.fireIssueReported(violation, 0);
                    }
                    this.printRunningStatistics("completed traversals", new Object[0]);
                    this.printMethodStatistics();
                    if (!firedAuditStarted) break block58;
                    bl = this.cancellationCause != null;
                }
                catch (InterruptedException e) {
                    try {
                        throw this.cancellationException(e);
                        catch (CancellationException e2) {
                            throw this.cancellationException(e2);
                        }
                        catch (ExpiredTextBufferException e3) {
                            throw this.cancellationException(e3);
                        }
                        catch (OutOfMemoryError e4) {
                            throw this.cancellationException(e4);
                        }
                        catch (Throwable e5) {
                            this.cancellationException(e5);
                            throw new UnexpectedExceptionError(e5);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!firedAuditStarted) throw throwable;
                        this.listeners.fireAuditStopped(this.cancellationCause != null);
                        throw throwable;
                    }
                }
                this.listeners.fireAuditStopped(bl);
            }
            this.printRunningStatistics("completed audit", new Object[0]);
            return;
        }
        finally {
            object = this.stateLock;
            synchronized (object) {
                this.binding.clear();
                this.cancellationCause = null;
                this.propagatingException = null;
                this.auditingThread = null;
                this.issueCollector = null;
            }
            IdeCore.setActiveWorkspaceOverrideEnabled((boolean)false);
        }
    }

    @Override
    public Throwable applyDefaultTransforms(String label) {
        AuditManager manager = AuditManager.getAuditManager();
        AuditModel model = manager.createModel();
        this.addAuditListener(model);
        this.run();
        Transformer transformer = manager.createTransformer();
        return transformer.applyDefaultTransforms(label, model, new Object[]{model.getRoot()}, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitUpperTree(DefaultAuditContext enclosingContext, ModelAdapter model, Object construct, Location location, boolean ancestor) {
        LOG.trace("visiting upper tree {0} in {1}", construct, (Object)model);
        this.throwIfCancelled();
        boolean atRoot = false;
        if (ancestor) {
            atRoot = this.commonAncestor.equals(location);
            if (atRoot) {
                LOG.trace("auditing root {0}", (Object)location);
                ancestor = false;
            } else {
                int index = -Collections.binarySearch(this.locations, location) - 1;
                LOG.trace("index of {1} in locations is {0}", index, (Object)location);
                assert (index >= 0);
                if (index == this.locations.size()) {
                    LOG.trace("dropping {0}", (Object)location);
                    return;
                }
                Location successor = this.locations.get(index);
                if (!location.contains(successor)) {
                    LOG.trace("dropping {0} for not containing {1}", (Object)location, (Object)successor);
                    return;
                }
            }
        }
        DefaultAuditContext context = enclosingContext.enterContext(model, location, construct, this.getPresentationType(model, construct), atRoot);
        boolean modelOpened = context.isModelRoot();
        boolean modelPresented = atRoot || modelOpened && !ancestor;
        boolean locationEntered = atRoot || !ancestor && context.getPresentationType() != null || PRESENT_ALL;
        try {
            this.throwIfCancelled();
            if (modelPresented) {
                this.listeners.fireModelEntered(model);
            }
            if (locationEntered) {
                this.listeners.fireLocationEntered(location, context.getPresentationType());
            }
            if (modelOpened) {
                context.invokeModelEnterMethod();
            }
            ArrayList<Analyzer> disabledAnalyzers = null;
            if (model instanceof WorkspaceModelAdapter && construct instanceof DirectoryModelAdapter) {
                disabledAnalyzers = new ArrayList<Analyzer>();
                for (Analyzer analyzer : this.binding.getAnalyzers()) {
                    if (analyzer.isApplicationContentSupported() || !analyzer.isEnabled()) continue;
                    analyzer.setEnabled(false);
                    disabledAnalyzers.add(analyzer);
                }
            }
            boolean visitSelf = !ancestor || this.visitAncestors;
            boolean visitChildren = this.visitDescendants || ancestor;
            AnalyzerBinding.EnterExitMethods enterExitMethods = null;
            if (visitSelf) {
                enterExitMethods = this.binding.getEnterExitMethods(construct.getClass());
                context.invokeEnterMethods(enterExitMethods);
            }
            if (visitChildren) {
                if (construct instanceof ModelAdapter) {
                    this.traverseModel(context, (ModelAdapter)construct, ancestor);
                } else {
                    this.traverseConstruct(context, model, construct, ancestor);
                }
            }
            if (visitSelf) {
                context.invokeExitMethods(enterExitMethods);
            }
            if (disabledAnalyzers != null) {
                for (Analyzer analyzer : disabledAnalyzers) {
                    analyzer.setEnabled(true);
                }
            }
        }
        catch (CancellationException e) {
            throw this.cancellationException(e);
        }
        catch (ExpiredTextBufferException e) {
            throw this.cancellationException(e);
        }
        catch (OutOfMemoryError e) {
            throw this.cancellationException(e);
        }
        catch (Throwable e) {
            try {
                context.reportTraversalException(e, construct);
            }
            catch (Throwable f) {
                AuditLogger.error(f, "exception while reporting exception: {0}", f);
                AuditLogger.error(e, "original exception: {0}", e);
            }
        }
        finally {
            if (modelOpened) {
                context.invokeModelExitMethod();
            }
            context.exitContext();
            if (locationEntered) {
                this.listeners.fireLocationExited(location);
            }
            if (modelPresented) {
                this.listeners.fireDocumentStopped(model);
            }
        }
        LOG.trace("completed visiting upper tree {0} in {1}", construct, (Object)model);
    }

    /*
     * Exception decompiling
     */
    private void traverseModel(DefaultAuditContext enclosingContext, ModelAdapter model, boolean ancestor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void traverseConstruct(DefaultAuditContext enclosingContext, ModelAdapter model, Object construct, boolean ancestor) {
        LOG.trace("traversing to {0} in {1}", (Object)model, construct);
        if (enclosingContext == null) {
            throw new NullArgumentException("enclosingContext");
        }
        if (model == null) {
            throw new NullArgumentException("model");
        }
        if (construct == null) {
            throw new NullArgumentException("construct");
        }
        try {
            Iterator iterator = model.getContainedConstructs(construct);
            while (iterator.hasNext()) {
                Object child = iterator.next();
                if (child == null) {
                    AuditLogger.error("null contained construct in {0}", enclosingContext);
                    continue;
                }
                if (ancestor || !model.isFile()) {
                    Location location = model.getLocation(child);
                    if (location == null) {
                        throw new IllegalStateException("null location for construct " + child + " of model " + model);
                    }
                    this.visitUpperTree(enclosingContext, model, child, location, ancestor);
                } else {
                    this.visitLowerTree(enclosingContext, model, child);
                }
                this.throwIfCancelled();
            }
        }
        catch (CancellationException e) {
            throw this.cancellationException(e);
        }
        catch (ExpiredTextBufferException e) {
            throw this.cancellationException(e);
        }
        catch (OutOfMemoryError e) {
            throw this.cancellationException(e);
        }
        catch (Throwable e) {
            enclosingContext.reportTraversalException(e, construct);
        }
        LOG.trace("completed traversing to {0} in {1}", (Object)model, construct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitLowerTree(DefaultAuditContext enclosingContext, ModelAdapter model, Object construct) {
        LOG.trace("visiting lower tree {0} in {1}", construct, (Object)model);
        this.throwIfCancelled();
        Class presentationType = this.getPresentationType(model, construct);
        Location location = presentationType != null || PRESENT_ALL ? model.getLocation(construct) : null;
        DefaultAuditContext context = enclosingContext.enterContext(model, location, construct, presentationType, false);
        try {
            if (location != null) {
                this.listeners.fireLocationEntered(location, presentationType);
            }
            AnalyzerBinding.EnterExitMethods enterExitMethods = this.binding.getEnterExitMethods(construct.getClass());
            context.invokeEnterMethods(enterExitMethods);
            try {
                Iterator iterator = model.getContainedConstructs(construct);
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (child != null) {
                        this.visitLowerTree(context, model, child);
                        this.throwIfCancelled();
                        continue;
                    }
                    AuditLogger.error("null contained construct in {0}", context);
                }
            }
            catch (ExpiredTextBufferException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                context.reportTraversalException(e, construct);
            }
            context.invokeExitMethods(enterExitMethods);
        }
        catch (CancellationException e) {
            throw this.cancellationException(e);
        }
        catch (ExpiredTextBufferException e) {
            throw this.cancellationException(e);
        }
        catch (OutOfMemoryError e) {
            throw this.cancellationException(e);
        }
        catch (Throwable e) {
            context.reportTraversalException(e, construct);
        }
        finally {
            if (location != null) {
                this.listeners.fireLocationExited(location);
            }
            context.exitContext();
        }
        LOG.trace("completed visiting lower tree {0} in {1}", construct, (Object)model);
    }

    private Class getPresentationType(ModelAdapter model, Object construct) {
        Class<?> constructType;
        Class<?> type;
        Collection<Class<?>> presentationTypes;
        ModelType modelType = model.getType();
        if (this.modelTypes.add(modelType) && (presentationTypes = modelType.getPresentationTypes()) != null) {
            for (Class<?> type2 : presentationTypes) {
                this.typeList.add(type2);
                this.typeMap.put(type2, type2);
            }
        }
        if ((type = this.typeMap.get(constructType = construct.getClass())) != null) {
            if (type == Object.class) {
                return null;
            }
            return type;
        }
        for (Class t : this.typeList) {
            if (!t.isInstance(construct)) continue;
            this.typeMap.put(constructType, t);
            return t;
        }
        this.typeMap.put(constructType, Object.class);
        return null;
    }

    void produceFragment(Class<? extends ModelType> fragmentType, Location location) {
        if (location.getLength() <= 0) {
            LOG.trace("zero length {0} fragment at {1}", fragmentType, (Object)location);
            return;
        }
        if (this.embeddedFragments == null) {
            this.embeddedFragments = new MultiMap();
        }
        this.embeddedFragments.add(fragmentType, (Object)location);
        LOG.trace("added {0} fragment at {1}", fragmentType, (Object)location);
    }

    public void addDependency(Dependency dependency) {
        if (this.dependenciesCollector != null) {
            this.dependenciesCollector.addDependency(dependency);
        }
    }

    private void printRunningStatistics(String message, Object ... arguments) {
        if (MEMORY_STATISTICS.isEnabled()) {
            String EOL = System.getProperty("line.separator");
            StringBuilder openNodes = new StringBuilder(EOL);
            Iterator i = NodeFactory.getOpenNodes();
            while (i.hasNext()) {
                openNodes.append("  ");
                openNodes.append(((Node)i.next()).getLongLabel());
                openNodes.append(EOL);
            }
            MEMORY_STATISTICS.trace("{0}: {1} nodes, {2} open nodes:{3}{4}{5}", new Object[]{Log.format((String)message, (Object[])arguments), NodeFactory.getCachedNodeCount(), NodeFactory.getOpenNodeCount(), openNodes, Memory.summary(), EOL});
        }
    }

    private void printMethodStatistics() {
        if (ANALYZER_STATISTICS.isEnabled()) {
            ANALYZER_STATISTICS.trace("{1}Method Statistics{1}{0}{1}", (Object)this.binding.statistics(), (Object)System.getProperty("line.separator"));
        }
    }

    private String dumpHeap(String name) {
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        File file = new File(tmpdir, name + "-" + String.valueOf(System.currentTimeMillis() - Log.TIME_ZERO_MILLI) + ".hprof");
        String path = file.getAbsolutePath();
        Memory.dumpHeap((String)path, (boolean)true);
        return path;
    }

    private void activateProjectAndWorkspace(Project project, Workspace workspace) {
        CONTROLLER_LOG.trace("maybe activating {0} and {1}", (Object)workspace, (Object)project);
        if (workspace != null) {
            CONTROLLER_LOG.trace("opening {0}", (Object)workspace);
            workspace.ensureOpen();
        }
        if (project != null && !project.isOpen() && !this.scannedProjects.contains(project)) {
            CONTROLLER_LOG.trace("scanning {0}", (Object)project);
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            OnProjectOpenHook hook = (OnProjectOpenHook)registry.getHook(OnProjectOpenHook.ELEMENT);
            hook.projectOpen(project);
            this.scannedProjects.add(project);
        }
    }

    private Map<Object, Set<String>> gatherProjectTechnologies(RootModelAdapter rootModel) {
        HashMap<Object, Set<String>> technologies = new HashMap<Object, Set<String>>();
        OnProjectOpenHook hook = (OnProjectOpenHook)ExtensionRegistry.getExtensionRegistry().getHook(OnProjectOpenHook.ELEMENT);
        LinkedHashSet<String> allTechnologies = new LinkedHashSet<String>();
        Iterator i = rootModel.getContainedConstructs(rootModel.getRoot());
        while (i.hasNext()) {
            WorkspaceModelAdapter workspaceModel = (WorkspaceModelAdapter)i.next();
            Workspace workspace = workspaceModel.getWorkspace();
            workspace.ensureOpen();
            LinkedHashSet<String> workspaceTechnologies = new LinkedHashSet<String>();
            Iterator j = workspaceModel.getContainedConstructs(workspace);
            while (j.hasNext()) {
                ListStructure list;
                ModelAdapter model = (ModelAdapter)j.next();
                if (!(model instanceof ProjectModelAdapter)) continue;
                ProjectModelAdapter projectModel = (ProjectModelAdapter)model;
                Project project = projectModel.getProject();
                if (!project.isOpen()) {
                    hook.projectOpen(project);
                }
                if ((list = project.getSharedPropertiesOnly().getListStructure(TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY)) == null) continue;
                LinkedHashSet<String> projectTechnologies = new LinkedHashSet<String>();
                for (Object element : list) {
                    String technology = ((String)element).trim();
                    projectTechnologies.add(technology);
                    workspaceTechnologies.add(technology);
                    allTechnologies.add(technology);
                }
                technologies.put(project, projectTechnologies);
            }
            technologies.put(workspace, workspaceTechnologies);
        }
        technologies.put(null, allTechnologies);
        return technologies;
    }

    static {
        String text = System.getProperty("audit.analyzer.excludes");
        analyzerExcludes = text != null ? new HashSet<String>(Strings.tokens(text, ',')) : Collections.emptySet();
        LOG = new Log("auditor");
        LOG_CANCEL = new Log("auditor-cancel", "auditor");
        LOG_HEAP = new Log("auditor-heap");
        MEMORY_STATISTICS = new Log("memory-statistics", "log");
        ANALYZER_STATISTICS = new Log("statistics", "log");
        BUNDLE = new FormatBundle(CoreBundle.class);
        CONTROLLER_LOG = new Log("audit-controller");
    }
}

