/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ideimpl.controller.CommandExecutionTracker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.ArraySortedSet;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.Tuple;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.SuppressionSchemeDefinition;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.DefaultTransformsAction;
import oracle.jdeveloper.audit.service.HasSuppressionName;
import oracle.jdeveloper.audit.service.Iteration;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdeveloper.audit.service.TransformAction;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.TransformerListener;
import oracle.jdeveloper.audit.service.TransformerQueryInterceptor;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.CompositeTransform;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.TransformFailedException;
import oracle.jdeveloper.audit.transform.TransformSequenceContext;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.util.Beans;

public class DefaultTransformer
implements Transformer {
    private AuditELContext expressionContext = new AuditELContext();
    private boolean queryAllowed = true;
    private Map<Transform, TransformerQueryInterceptor> interceptors;
    private Map<Tuple<ModelAdapter, TransformAdapter>, Boolean> transformable = new HashMap<Tuple<ModelAdapter, TransformAdapter>, Boolean>();
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private static final TransformContext[] NO_TRANSFORMS = new TransformContext[0];
    private static final Log LOG = new Log("transformer");
    private int applicableCount;
    private int transformableCount;
    private long applicableTime;
    private Map<String, Method> mostSpecificMethods = new HashMap<String, Method>();
    private Map<Class<?>, Method[]> allMethods = new HashMap();

    @Override
    public void setQueryAllowed(boolean queryAllowed) {
        LOG.trace("query allowed {0}", queryAllowed);
        this.queryAllowed = queryAllowed;
    }

    @Override
    public void setQueryInterceptor(Transform transform, TransformerQueryInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new HashMap<Transform, TransformerQueryInterceptor>();
        }
        this.interceptors.put(transform, interceptor);
    }

    private List<Violation> getViolationsWithDefaultTransforms(AuditModel model, Object[] objects) {
        final ArrayList<Violation> violations = new ArrayList<Violation>();
        for (Object object : objects) {
            if (object == null) continue;
            model.iterateViolations(object, new Iteration(){

                @Override
                public boolean iteration(Object object) {
                    Violation violation = (Violation)object;
                    if (violation.getDefaultTransform() != null) {
                        violations.add(violation);
                    }
                    return true;
                }
            });
        }
        return violations;
    }

    private TransformContext[] createContexts(Transform transform, Violation violation) {
        TransformContext[] contexts;
        Map<String, DeferredSetter> setters = transform.setters();
        if (setters != null && !setters.isEmpty()) {
            this.expressionContext.setBean(transform, violation.getRule(), violation);
            for (Map.Entry entry : setters.entrySet()) {
                DeferredSetter setter = (DeferredSetter)entry.getValue();
                try {
                    setter.set(transform, this.expressionContext);
                }
                catch (Throwable e) {
                    setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform, setter.getText(), e);
                    return NO_TRANSFORMS;
                }
            }
            this.expressionContext.clear();
        }
        if (transform instanceof CompositeTransform) {
            for (Transform transform2 : ((CompositeTransform)transform).getComponents()) {
                setters = transform2.setters();
                if (setters == null || setters.isEmpty()) continue;
                this.expressionContext.setBean(transform2, violation.getRule(), violation);
                for (Map.Entry<String, DeferredSetter> entry : setters.entrySet()) {
                    DeferredSetter setter = entry.getValue();
                    try {
                        setter.set(transform2, this.expressionContext);
                    }
                    catch (Throwable e) {
                        setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform2, setter.getText(), e);
                        return NO_TRANSFORMS;
                    }
                }
                this.expressionContext.clear();
            }
        }
        if ((contexts = transform.createContexts(violation)) == null) {
            contexts = NO_TRANSFORMS;
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isApplicable(TransformContext context) {
        long start = System.nanoTime();
        int transformableCount = 0;
        Location location = context.getLocation();
        ModelAdapter model = location.getModel();
        try {
            model.beginRead();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        try {
            TransformAdapter adapter = context.getAdapter();
            Tuple key = new Tuple((Object)model, (Object)adapter);
            Boolean isTransformable = this.transformable.get(key);
            if (isTransformable == null) {
                LOG.trace("querying transformable for {0} by {1}", (Object)model, (Object)adapter);
                isTransformable = adapter.isTransformable(model);
                this.transformable.put((Tuple<ModelAdapter, TransformAdapter>)key, isTransformable);
                ++transformableCount;
            }
            if (!isTransformable.booleanValue()) {
                boolean bl = false;
                return bl;
            }
            if (!adapter.isTransformable(location)) {
                boolean bl = false;
                return bl;
            }
            Object construct = model.getConstruct(location);
            Method[] methods = this.methods(context, construct);
            if (methods == null) {
                boolean bl = false;
                return bl;
            }
            Method applicableMethod = methods[0];
            if (applicableMethod != null) {
                boolean applicable = this.invokeBoolean(context.getTransform(), applicableMethod, context, construct);
                LOG.trace("applicable {0} ({1})", applicable, (Object)applicableMethod);
                if (!applicable) {
                    boolean bl = false;
                    return bl;
                }
            }
            LOG.trace("applicable by default");
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            Log.error((String)"exception caught while evaluating transform {0}: {1}", (Object)context.getTransform(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            model.endRead();
            if (LOG.isEnabled()) {
                long time = System.nanoTime() - start;
                this.applicableTime += time;
                this.transformableCount += transformableCount;
                LOG.trace("applicable {4} transformable {0} ({1}) time {2} ({3})", (Object)transformableCount, (Object)this.transformableCount, this.ms(time), this.ms(this.applicableTime), (Object)(++this.applicableCount));
            }
        }
    }

    private Object ms(long time) {
        return (double)time / 1000000.0 + "ms";
    }

    @Override
    public List<TransformAction> createTransformActions(Violation violation, TransformerListener listener, AuditModel model) {
        return this.createTransformActions(Collections.singletonList(violation), listener, model);
    }

    @Override
    public List<TransformAction> createTransformActions(Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        return this.createTransformActions(violations, null, listener, model);
    }

    @Override
    public boolean hasTransforms(Collection<? extends Violation> violations, Profile profile) {
        if (profile == null) {
            AuditManager manager = AuditManager.getAuditManager();
            AuditPreferences preferences = manager.getPreferences();
            ProfileRepository repository = manager.getDefaultProfileRepository();
            profile = repository.getProfile(preferences.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        }
        HashMap<String, ExtensionBean> schemeContext = new HashMap<String, ExtensionBean>();
        ArrayList<SuppressionScheme> schemes = new ArrayList<SuppressionScheme>();
        for (SuppressionSchemeDefinition suppressionSchemeDefinition : AuditHook.getAuditHook().getSuppressionSchemes()) {
            SuppressionScheme scheme;
            if (profile.getDefinition(suppressionSchemeDefinition.getId()) == null || !(scheme = (SuppressionScheme)profile.createBean(suppressionSchemeDefinition, false, schemeContext)).isEnabled()) continue;
            schemes.add(scheme);
        }
        for (Violation violation : violations) {
            Rule rule = violation.getRule();
            if (rule == null) {
                throw new NullArgumentException("null rule in " + violation.getClass());
            }
            if (!rule.mandatoryError() && !rule.assist() && violation.getSuppressionCount() == 0) {
                ArraySortedSet suppressionNames = new ArraySortedSet();
                Set<String> aliases = AuditHook.getAuditHook().getSuppressionNames(rule.definition());
                if (aliases != null) {
                    suppressionNames.addAll(aliases);
                }
                suppressionNames.add(rule.id());
                for (SuppressionScheme scheme : schemes) {
                    for (Transform transform : scheme.getTransforms()) {
                        ((HasSuppressionName)((Object)transform)).setSuppressionName((String)suppressionNames.first());
                        TransformContext[] contexts = this.createContexts(transform, violation);
                        for (String suppressionName : suppressionNames) {
                            ((HasSuppressionName)((Object)transform)).setSuppressionName(suppressionName);
                            boolean applicable = true;
                            for (TransformContext context : contexts) {
                                if (this.isApplicable(context)) continue;
                                applicable = false;
                            }
                            if (!applicable) continue;
                            return true;
                        }
                    }
                }
            }
            for (int i = 0; i < violation.getTransformCount(); ++i) {
                Transform transform = violation.getTransform(i);
                TransformContext[] contexts = this.createContexts(transform, violation);
                if (contexts.length == 0) continue;
                boolean applicable = true;
                for (TransformContext context : contexts) {
                    if (this.isApplicable(context)) continue;
                    applicable = false;
                }
                if (!applicable) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasStandardTransforms(Collection<? extends Violation> violations) {
        for (Violation violation : violations) {
            for (int i = 0; i < violation.getTransformCount(); ++i) {
                Transform transform = violation.getTransform(i);
                TransformContext[] contexts = this.createContexts(transform, violation);
                if (contexts.length == 0) continue;
                boolean applicable = true;
                for (TransformContext context : contexts) {
                    if (this.isApplicable(context)) continue;
                    applicable = false;
                }
                if (!applicable) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSuppressionTransforms(Collection<? extends Violation> violations, Profile profile) {
        if (profile == null) {
            AuditManager manager = AuditManager.getAuditManager();
            AuditPreferences preferences = manager.getPreferences();
            ProfileRepository repository = manager.getDefaultProfileRepository();
            profile = repository.getProfile(preferences.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        }
        HashMap<String, ExtensionBean> schemeContext = new HashMap<String, ExtensionBean>();
        ArrayList<SuppressionScheme> schemes = new ArrayList<SuppressionScheme>();
        for (SuppressionSchemeDefinition suppressionSchemeDefinition : AuditHook.getAuditHook().getSuppressionSchemes()) {
            SuppressionScheme scheme;
            if (profile.getDefinition(suppressionSchemeDefinition.getId()) == null || !(scheme = (SuppressionScheme)profile.createBean(suppressionSchemeDefinition, false, schemeContext)).isEnabled()) continue;
            schemes.add(scheme);
        }
        for (Violation violation : violations) {
            Rule rule = violation.getRule();
            if (rule == null) {
                throw new NullArgumentException("null rule in " + violation.getClass());
            }
            if (rule.mandatoryError() || rule.assist() || violation.getSuppressionCount() != 0) continue;
            ArraySortedSet suppressionNames = new ArraySortedSet();
            Set<String> aliases = AuditHook.getAuditHook().getSuppressionNames(rule.definition());
            if (aliases != null) {
                suppressionNames.addAll(aliases);
            }
            suppressionNames.add(rule.id());
            for (SuppressionScheme scheme : schemes) {
                for (Transform transform : scheme.getTransforms()) {
                    for (String suppressionName : suppressionNames) {
                        ((HasSuppressionName)((Object)transform)).setSuppressionName(suppressionName);
                        TransformContext[] contexts = this.createContexts(transform, violation);
                        boolean applicable = true;
                        for (TransformContext context : contexts) {
                            if (this.isApplicable(context)) continue;
                            applicable = false;
                        }
                        if (!applicable) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public List<TransformAction> createTransformActions(Collection<? extends Violation> violations, Profile profile, TransformerListener listener, AuditModel model) {
        if (profile == null) {
            AuditManager manager = AuditManager.getAuditManager();
            AuditPreferences preferences = manager.getPreferences();
            ProfileRepository repository = manager.getDefaultProfileRepository();
            profile = repository.getProfile(preferences.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        }
        HashMap<String, ExtensionBean> schemeContext = new HashMap<String, ExtensionBean>();
        ArrayList<SuppressionScheme> schemes = new ArrayList<SuppressionScheme>();
        for (SuppressionSchemeDefinition definition : AuditHook.getAuditHook().getSuppressionSchemes()) {
            SuppressionScheme scheme;
            if (profile.getDefinition(definition.getId()) == null || !(scheme = (SuppressionScheme)profile.createBean(definition, false, schemeContext)).isEnabled()) continue;
            schemes.add(scheme);
        }
        ArrayList<TransformAction> actions = new ArrayList<TransformAction>();
        HashSet<String> labels = new HashSet<String>();
        for (Violation violation : violations) {
            Rule rule = violation.getRule();
            Icon icon = rule.getSeverity().getIcon();
            for (int i = 0; i < violation.getTransformCount(); ++i) {
                String label;
                Transform transform = violation.getTransform(i);
                TransformContext[] contexts = this.createContexts(transform, violation);
                if (contexts.length == 0 || !labels.add(label = transform.boundLabel(contexts[0]))) continue;
                DefaultTransformAction action = new DefaultTransformAction(label, icon, Collections.singletonList(violation), transform, null, listener, model);
                for (TransformContext context : contexts) {
                    if (this.isApplicable(context)) continue;
                    action.setEnabled(false);
                    action.putValue("ShortDescription", AuditBundle.get("transform.disabled.tip"));
                    break;
                }
                actions.add(action);
            }
            if (rule.mandatoryError() || rule.assist() || violation.getSuppressionCount() != 0) continue;
            ArrayList<String> suppressionNames = new ArrayList<String>();
            Set<String> aliases = AuditHook.getAuditHook().getSuppressionNames(rule.definition());
            if (aliases != null) {
                suppressionNames.addAll(aliases);
            }
            suppressionNames.add(rule.id());
            String ruleLabel = rule.labelOrId();
            for (SuppressionScheme scheme : schemes) {
                String schemeLabel = scheme.labelOrId();
                for (Transform transform : scheme.getTransforms()) {
                    Iterator i = suppressionNames.iterator();
                    while (i.hasNext()) {
                        String label;
                        String suppressionName = (String)i.next();
                        ((HasSuppressionName)((Object)transform)).setSuppressionName(suppressionName);
                        TransformContext[] contexts = this.createContexts(transform, violation);
                        if (contexts.length == 0 || !labels.add(label = i.hasNext() ? BUNDLE.get("transform.suppress.alias.label", new Object[]{ruleLabel, schemeLabel}) : BUNDLE.get("transform.suppress.id.label", new Object[]{ruleLabel, schemeLabel}))) continue;
                        for (TransformContext context : contexts) {
                            if (!this.isApplicable(context)) continue;
                            ArrayMap properties = new ArrayMap();
                            properties.put("suppressionName", suppressionName);
                            DefaultTransformAction action = new DefaultTransformAction(label, icon, Collections.singletonList(violation), transform, (Map<String, Object>)properties, listener, model);
                            actions.add(action);
                        }
                    }
                    ((HasSuppressionName)((Object)transform)).setSuppressionName(null);
                }
            }
        }
        return actions;
    }

    @Override
    public DefaultTransformsAction createDefaultTransformsAction(String label, Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        DefaultTransformAction action = new DefaultTransformAction(label != null ? label : BUNDLE.get("apply-default-fixes.label"), OracleIcons.getIcon((String)"fix.png"), violations, null, null, listener, model);
        action.setEnabled(false);
        block0: for (Violation violation : violations) {
            Transform transform = violation.getDefaultTransform();
            if (transform == null) continue;
            for (TransformContext context : this.createContexts(transform, violation)) {
                if (!this.isApplicable(context)) continue;
                action.setEnabled(true);
                continue block0;
            }
        }
        return action;
    }

    @Override
    public DefaultTransformsAction createDefaultTransformsAction(String label, AuditModel model, Object[] objects, TransformerListener listener) {
        return this.createDefaultTransformsAction(label, this.getViolationsWithDefaultTransforms(model, objects), listener, model);
    }

    @Override
    public Throwable applyDefaultTransforms(String label, Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        DefaultTransformsAction action = this.createDefaultTransformsAction(label, violations, listener, model);
        return action.apply();
    }

    @Override
    public Throwable applyDefaultTransforms(String label, AuditModel model, Object[] objects, TransformerListener listener) {
        List<Violation> violations = this.getViolationsWithDefaultTransforms(model, objects);
        if (violations.isEmpty()) {
            return null;
        }
        return this.applyDefaultTransforms(label, violations, listener, model);
    }

    private Method[] methods(TransformContext context, Object construct) {
        Transform transform = context.getTransform();
        try {
            if (construct == null) {
                LOG.trace("not applicable: construct null");
                return null;
            }
            Class<?> type = construct.getClass();
            Method applyMethod = this.method("apply", transform, context, construct);
            if (applyMethod == null) {
                LOG.trace("not applicable: no apply method in {0}", type);
                return null;
            }
            Method queryRequiredMethod = this.method("isQueryRequired", transform, context, construct);
            Method queryMethod = this.method("query", transform, context, construct);
            if (!this.queryAllowed && queryMethod != null && queryRequiredMethod == null) {
                LOG.trace("not applicable: query required but queries disallowed");
                return null;
            }
            Method applicableMethod = this.method("isApplicable", transform, context, construct);
            Method[] methods = new Method[]{applicableMethod, queryRequiredMethod, queryMethod, applyMethod};
            LOG.trace("methods {0} for ", (Object)methods, type);
            return methods;
        }
        catch (Throwable e) {
            Log.error((String)"exception caught while evaluating fix {0}: {1}", (Object)transform, (Object)e);
            return null;
        }
    }

    private boolean invokeBoolean(Object target, Method method, TransformContext context, Object construct) throws IllegalAccessException, InvocationTargetException {
        return Boolean.TRUE.equals(this.invoke(target, method, context, construct));
    }

    private Object invoke(Object target, Method method, TransformContext context, Object construct) throws IllegalAccessException, InvocationTargetException {
        Object[] arguments = new Object[]{context, construct};
        return method.invoke(target, arguments);
    }

    private Method method(String name, Object transformOrInterceptor, TransformContext context, Object construct) {
        Class<?> transformType = transformOrInterceptor.getClass();
        Class<?> contextType = context.getClass();
        Class<?> constructType = construct.getClass();
        String key = name + transformType.getName() + contextType.getName() + constructType.getName();
        Method mostSpecificMethod = this.mostSpecificMethods.get(key);
        if (mostSpecificMethod != null) {
            return mostSpecificMethod;
        }
        Method[] methods = this.allMethods.get(transformType);
        if (methods == null) {
            methods = transformType.getMethods();
            this.allMethods.put(transformType, methods);
        }
        ArrayList<Method> maximallySpecificMethods = new ArrayList<Method>();
        for (Method method : methods) {
            Class<?> methodConstructType;
            Class<?> methodContextType;
            if (!name.equals(method.getName())) continue;
            Class<?> returnType = method.getReturnType();
            if ("isApplicable".equals(name) && !Boolean.TYPE.equals(returnType)) {
                Log.error((String)"Method {0} ignored because return type is not boolean", (Object)method);
            } else if ("query".equals(name) && !returnType.equals(Boolean.TYPE)) {
                Log.error((String)"Method {0} ignored because return type is not boolean", (Object)method);
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 2 || !(methodContextType = parameterTypes[0]).isAssignableFrom(contextType) || !(methodConstructType = parameterTypes[1]).isAssignableFrom(constructType)) continue;
            if (maximallySpecificMethods.isEmpty()) {
                maximallySpecificMethods.add(method);
                continue;
            }
            ListIterator<Method> i = maximallySpecificMethods.listIterator();
            while (i.hasNext()) {
                Method maximallySpecificMethod = (Method)i.next();
                Class<?>[] types = maximallySpecificMethod.getParameterTypes();
                boolean contextMoreSpecific = types[0].isAssignableFrom(methodContextType);
                boolean constructMoreSpecific = types[1].isAssignableFrom(methodConstructType);
                if (contextMoreSpecific && constructMoreSpecific) {
                    i.remove();
                    i.add(method);
                    continue;
                }
                if (!contextMoreSpecific && !constructMoreSpecific) continue;
                i.add(method);
            }
        }
        switch (maximallySpecificMethods.size()) {
            case 0: {
                mostSpecificMethod = null;
                break;
            }
            case 1: {
                mostSpecificMethod = (Method)maximallySpecificMethods.iterator().next();
                break;
            }
            default: {
                if (transformOrInterceptor instanceof Transform) {
                    ((Transform)transformOrInterceptor).logError("No {0} method in {1} is unambiguously most specific for {2} - {3}; methods: {4}", name, transformType.getName(), contextType.getName(), constructType.getName(), maximallySpecificMethods);
                } else {
                    ExtensionRegistry.getExtensionRegistry().getManifestLogger().log(Level.WARNING, "No {0} method in {1} is unambiguously most specific for {2} - {3}; methods: {4}", new Object[]{name, transformType.getName(), contextType.getName(), constructType.getName(), maximallySpecificMethods});
                }
                mostSpecificMethod = null;
            }
        }
        this.mostSpecificMethods.put(key, mostSpecificMethod);
        return mostSpecificMethod;
    }

    private Integer getVersion(ModelAdapter model) {
        return model instanceof TextFileModelAdapter ? ((TextFileModelAdapter)model).getTextBuffer().getChangeId() : 0;
    }

    private static class Sequencer {
        private ModelAdapter readModel = null;
        private TransformSequenceContext sequenceContext = null;
        private String label;
        private int applied = 0;

        private Sequencer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean maybeTransition(ModelAdapter newModel) throws InterruptedException {
            ModelAdapter oldModel = this.readModel;
            if (newModel == oldModel) {
                return false;
            }
            try {
                if (this.sequenceContext != null) {
                    assert (oldModel != null);
                    if (this.applied > 0) {
                        this.sequenceContext.getAdapter().endTransformSequence(this.sequenceContext);
                    } else {
                        this.sequenceContext.getAdapter().cancelTransformSequence(this.sequenceContext);
                    }
                    this.sequenceContext = null;
                }
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                AuditLogger.error(e, "exception cancelling transform sequence for {0}: {1}", this.label, e);
            }
            finally {
                this.sequenceContext = null;
                if (oldModel != null) {
                    oldModel.endRead();
                }
            }
            if (newModel != null) {
                newModel.beginRead();
            }
            this.readModel = newModel;
            return newModel != null;
        }

        void maybeBeginSequence(TransformContext context) throws Exception {
            assert (context.getModel() == this.readModel);
            TransformAdapter adapter = context.getAdapter();
            if (this.sequenceContext == null || this.sequenceContext.getAdapter().getClass() != adapter.getClass()) {
                if (this.sequenceContext != null) {
                    if (this.applied > 0) {
                        this.sequenceContext.getAdapter().endTransformSequence(this.sequenceContext);
                    } else {
                        this.sequenceContext.getAdapter().cancelTransformSequence(this.sequenceContext);
                    }
                }
                this.sequenceContext = new TransformSequenceContext(adapter, this.readModel);
                this.applied = 0;
                this.label = context.getTransform().label();
                adapter.beginTransformSequence(this.sequenceContext);
            }
        }

        void transformApplied() {
            ++this.applied;
        }
    }

    private class DefaultTransformAction
    extends DefaultTransformsAction {
        private Collection<? extends Violation> violations;
        private Map<String, Object> properties;
        private AuditModel trackingModel;
        private int applicableTransformCount;
        private Map<String, String> applicableDescriptions;
        private Set<ModelAdapter> applicableDocuments;
        private Set<ModelAdapter> dirtyApplicableDocuments;
        private Map<ModelAdapter, Collection<Violation>> violationsByDocument;
        private List<CodeEditor> openModifiedCodeEditors;
        private Set<ModelAdapter> modifiedDocuments;
        private int appliedTransformCount;

        public DefaultTransformAction(String label, Icon icon, Collection<? extends Violation> violations, Transform transform, Map<String, Object> properties, TransformerListener listener, AuditModel model) {
            super(label, icon, transform);
            this.violations = violations;
            this.properties = properties;
            this.trackingModel = model;
            this.putValue(TransformerListener.class.getName(), listener);
        }

        @Override
        public Throwable apply() {
            IdeMainWindow mainWindow;
            TransformerQueryInterceptor interceptor;
            Transform transform = this.getTransform();
            String label = (String)this.getValue("Name");
            LOG.trace("transform {0}", (Object)transform);
            TransformerListener listener = (TransformerListener)this.getValue(TransformerListener.class.getName());
            if (this.properties != null) {
                for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                    try {
                        Beans.setPropertyValue(transform, entry.getKey(), entry.getValue());
                    }
                    catch (Exception e) {
                        listener.transformFailed(e, this.violations.iterator().next(), transform, label);
                        return e;
                    }
                }
            }
            if ((interceptor = (TransformerQueryInterceptor)this.getValue(TransformerQueryInterceptor.class.getName())) == null && DefaultTransformer.this.interceptors != null) {
                interceptor = (TransformerQueryInterceptor)DefaultTransformer.this.interceptors.get(transform);
            }
            Throwable exception = this.apply(this.violations, transform, label, listener, interceptor, this.trackingModel);
            if (this.getAppliedTransformCount() == 0 && (mainWindow = Ide.getMainWindow()) != null) {
                mainWindow.getToolkit().beep();
            }
            return exception;
        }

        public void actionPerformed(ActionEvent event) {
            this.apply();
        }

        @Override
        public int getApplicableTransformCount() {
            this.scan(this.violations, this.getTransform());
            return this.applicableTransformCount;
        }

        @Override
        public Collection getTransformDescriptions() {
            this.scan(this.violations, this.getTransform());
            return this.applicableDescriptions.values();
        }

        @Override
        public int getApplicableModelCount() {
            this.scan(this.violations, this.getTransform());
            return this.applicableDocuments.size();
        }

        @Override
        public int getDirtyApplicableModelCount() {
            this.scan(this.violations, this.getTransform());
            return this.dirtyApplicableDocuments.size();
        }

        @Override
        public Collection getApplicableModels() {
            this.scan(this.violations, this.getTransform());
            return Collections.unmodifiableSet(this.applicableDocuments);
        }

        @Override
        public int getAppliedTransformCount() {
            return this.appliedTransformCount;
        }

        @Override
        public int getModifiedModelCount() {
            return this.modifiedDocuments.size();
        }

        private void scan(Collection<? extends Violation> violations, Transform transform) {
            EditorManager editorManager;
            if (violations == null) {
                throw new IllegalStateException("no violations set");
            }
            if (this.violationsByDocument != null) {
                return;
            }
            this.applicableTransformCount = 0;
            this.applicableDescriptions = new LinkedHashMap<String, String>();
            this.applicableDocuments = new LinkedHashSet<ModelAdapter>();
            this.dirtyApplicableDocuments = new LinkedHashSet<ModelAdapter>();
            this.violationsByDocument = new LinkedHashMap<ModelAdapter, Collection<Violation>>();
            this.openModifiedCodeEditors = new ArrayList<CodeEditor>();
            LinkedHashSet<Node> openNodes = new LinkedHashSet<Node>();
            if (SwingUtilities.isEventDispatchThread() && (editorManager = EditorManager.getEditorManager()) != null) {
                try {
                    List list = editorManager.getAllEditors();
                    for (Editor editor : list) {
                        Node node = editor.getContext().getNode();
                        openNodes.add(node);
                        if (!node.isDirty() || !(editor instanceof CodeEditor)) continue;
                        this.openModifiedCodeEditors.add((CodeEditor)editor);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            LOG.trace("loaded open nodes {0}", openNodes);
            for (Violation violation : violations) {
                TransformContext[] contexts;
                Transform t = transform;
                if (t == null) {
                    t = violation.getDefaultTransform();
                }
                if (t == null || (contexts = DefaultTransformer.this.createContexts(t, violation)).length == 0) continue;
                ++this.applicableTransformCount;
                String name = t.id();
                if (!this.applicableDescriptions.containsKey(name)) {
                    this.applicableDescriptions.put(name, t.boundLabel(contexts[0]));
                }
                ModelAdapter model = contexts[0].getModel();
                assert (model != null);
                ArrayList<Violation> documentViolations = (ArrayList<Violation>)this.violationsByDocument.get(model);
                if (documentViolations == null) {
                    documentViolations = new ArrayList<Violation>();
                    this.violationsByDocument.put(model, documentViolations);
                }
                documentViolations.add(violation);
                for (TransformContext context : contexts) {
                    model = context.getModel();
                    this.applicableDocuments.add(model);
                    if (!model.getNode().isDirty()) continue;
                    this.dirtyApplicableDocuments.add(model);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Throwable apply(Collection<? extends Violation> violations, Transform explicitTransform, String label, TransformerListener listener, TransformerQueryInterceptor interceptor, AuditModel trackingModel) {
            this.scan(violations, explicitTransform);
            for (CodeEditor editor : this.openModifiedCodeEditors) {
                BasicEditorPane pane = editor.getFocusedEditorPane();
                if (editor == null) continue;
                pane.invokeAction("cancel");
            }
            CommandProcessor processor = CommandProcessor.getInstance();
            TransformEndCommand endCommand = new TransformEndCommand(trackingModel);
            CommandExecutionTracker.commandExecutionTracker().start(label);
            processor.beginTrans(label);
            Throwable exception = null;
            try {
                this.modifiedDocuments = new LinkedHashSet<ModelAdapter>();
                this.appliedTransformCount = 0;
                block30: for (Collection collection : this.violationsByDocument.values()) {
                    if (exception != null) break;
                    Sequencer sequencer = new Sequencer();
                    try {
                        block31: for (Violation violation : collection) {
                            TransformContext[] contexts;
                            if (exception != null) continue block30;
                            Transform transform = explicitTransform;
                            if (transform == null && (transform = violation.getDefaultTransform()) == null || (contexts = DefaultTransformer.this.createContexts(transform, violation)).length == 0) continue;
                            HashMap<ModelAdapter, Integer> dependencies = new HashMap<ModelAdapter, Integer>();
                            try {
                                ModelAdapter model;
                                Location location;
                                TransformContext context;
                                int k;
                                Method[][] contextMethods = new Method[contexts.length][];
                                Object[] constructs = new Object[contexts.length];
                                for (k = 0; k < contexts.length; ++k) {
                                    Object construct;
                                    Method[] methods;
                                    context = contexts[k];
                                    location = context.getLocation();
                                    model = location.getModel();
                                    if (sequencer.maybeTransition(model)) {
                                        if (!context.getAdapter().isTransformable(context.getModel()) || !context.getAdapter().isTransformable(context.getLocation())) {
                                            LOG.trace("not transformable {0}", (Object)location);
                                            continue block31;
                                        }
                                        dependencies.put(model, DefaultTransformer.this.getVersion(model));
                                    } else if (dependencies.isEmpty()) {
                                        dependencies.put(model, DefaultTransformer.this.getVersion(model));
                                    }
                                    if ((methods = (contextMethods[k] = DefaultTransformer.this.methods(context, construct = (constructs[k] = model.getConstruct(location))))) == null) continue block31;
                                    Method applicableMethod = methods[0];
                                    if (applicableMethod == null) continue;
                                    boolean applicable = DefaultTransformer.this.invokeBoolean(context.getTransform(), applicableMethod, context, construct);
                                    LOG.trace("isApplicable: {1} returned {0}", applicable, (Object)applicableMethod);
                                    if (!applicable) continue block31;
                                }
                                for (k = 0; k < contexts.length; ++k) {
                                    Method interceptorQueryMethod;
                                    context = contexts[k];
                                    location = context.getLocation();
                                    model = location.getModel();
                                    Method queryMethod = contextMethods[k][2];
                                    if (queryMethod == null) continue;
                                    Object queryTarget = context.getTransform();
                                    if (interceptor != null && (interceptorQueryMethod = DefaultTransformer.this.method("query", interceptor, context, constructs[k])) != null) {
                                        queryTarget = interceptor;
                                        queryMethod = interceptorQueryMethod;
                                    }
                                    Method queryRequiredMethod = contextMethods[k][1];
                                    boolean queryRequired = true;
                                    if (queryRequiredMethod != null) {
                                        sequencer.maybeTransition(model);
                                        queryRequired = DefaultTransformer.this.invokeBoolean(context.getTransform(), queryRequiredMethod, context, constructs[k]);
                                    }
                                    LOG.trace("isQueryRequired: {1} returned {0}", queryRequired, (Object)queryRequiredMethod);
                                    if (!queryRequired) continue;
                                    if (!DefaultTransformer.this.queryAllowed) continue block31;
                                    sequencer.maybeTransition(null);
                                    boolean ok = DefaultTransformer.this.invokeBoolean(queryTarget, queryMethod, context, constructs[k]);
                                    LOG.trace("query: {1} ok {0}", ok, (Object)queryMethod);
                                    if (!ok) continue block31;
                                }
                                for (Map.Entry entry : dependencies.entrySet()) {
                                    sequencer.maybeTransition((ModelAdapter)entry.getKey());
                                    if (((Integer)entry.getValue()).equals(DefaultTransformer.this.getVersion((ModelAdapter)entry.getKey()))) continue;
                                    throw new ModelChangedException((ModelAdapter)entry.getKey());
                                }
                                for (k = 0; k < contexts.length; ++k) {
                                    Integer dependency;
                                    context = contexts[k];
                                    TransformAdapter adapter = context.getAdapter();
                                    model = context.getModel();
                                    sequencer.maybeTransition(model);
                                    Boolean writable = adapter.makeTransformable(context);
                                    if (writable == null) continue;
                                    if (!writable.booleanValue()) continue block31;
                                    if (listener != null) {
                                        listener.modelWritable(model);
                                    }
                                    if ((dependency = DefaultTransformer.this.getVersion(model)).equals(dependencies.get(model))) continue;
                                    dependencies.put(model, dependency);
                                    constructs[k] = null;
                                    for (int j = k + 1; j < contexts.length; ++j) {
                                        if (contexts[j].getModel() != model) continue;
                                        constructs[j] = null;
                                    }
                                }
                                Object predecessorData = null;
                                for (int k2 = 0; k2 < contexts.length; ++k2) {
                                    TransformContext context2 = contexts[k2];
                                    TransformAdapter adapter = context2.getAdapter();
                                    ModelAdapter model2 = context2.getModel();
                                    sequencer.maybeTransition(model2);
                                    if (!DefaultTransformer.this.getVersion(model2).equals(dependencies.get(model2))) {
                                        throw new ModelChangedException(model2);
                                    }
                                    Object reevaluation = model2.getConstruct(context2.getLocation());
                                    if (reevaluation == null) {
                                        throw new ModelChangedException(model2);
                                    }
                                    if (reevaluation.getClass() != constructs[k2].getClass()) {
                                        constructs[k2] = reevaluation;
                                        contextMethods[k2] = DefaultTransformer.this.methods(contexts[k2], constructs[k2]);
                                    }
                                    adapter.setPredecessorApplyData(context2, predecessorData);
                                    if (explicitTransform != null) {
                                        Location focusLocation = violation.getFocusLocation();
                                        if (focusLocation == null) {
                                            focusLocation = violation.getLocation();
                                        }
                                        focusLocation.getModel().edit(focusLocation);
                                    }
                                    sequencer.maybeBeginSequence(context2);
                                    adapter.beginTransform(context2);
                                    boolean aborting = false;
                                    Method applyMethod = contextMethods[k2][3];
                                    try {
                                        LOG.trace("apply: {0}", (Object)applyMethod);
                                        predecessorData = DefaultTransformer.this.invoke(context2.getTransform(), applyMethod, context2, constructs[k2]);
                                        adapter.endTransform(context2);
                                        dependencies.put(model2, DefaultTransformer.this.getVersion(model2));
                                    }
                                    catch (CancellationException e) {
                                        LOG.trace("{0} cancelled: {1}", (Object)applyMethod, (Object)e);
                                        aborting = true;
                                        throw e;
                                    }
                                    catch (InterruptedException e) {
                                        LOG.trace("{0} interrupted: {1}", (Object)applyMethod, (Object)e);
                                        aborting = true;
                                        throw e;
                                    }
                                    catch (Throwable e) {
                                        aborting = true;
                                        Throwable cause = e.getCause();
                                        if (cause instanceof CancellationException) {
                                            LOG.trace("{0} cancelled: {1}", (Object)applyMethod, (Object)e);
                                            throw cause;
                                        }
                                        if (cause instanceof InterruptedException) {
                                            LOG.trace("{0} interrupted: {1}", (Object)applyMethod, (Object)e);
                                            throw cause;
                                        }
                                        LOG.trace("exception applying {0} to {1}: {2}", (Object)transform, (Object)violation, (Object)e);
                                        throw e;
                                    }
                                    finally {
                                        if (aborting) {
                                            try {
                                                adapter.cancelTransform(context2);
                                            }
                                            catch (Throwable e) {
                                                Log.error((String)"cancelling {0} failed: {1}", (Object)transform, (Object)e);
                                            }
                                        }
                                    }
                                    List deferredCommands = adapter.getDeferredCommands();
                                    int deferredCommandCount = deferredCommands.size();
                                    if (deferredCommandCount > 0) {
                                        sequencer.maybeTransition(null);
                                    }
                                    for (int m = 0; m < deferredCommandCount; ++m) {
                                        CommandProcessor.getInstance().invoke((Command)deferredCommands.get(m));
                                    }
                                }
                            }
                            catch (CancellationException e) {
                                throw e;
                            }
                            catch (InterruptedException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                if (e instanceof InvocationTargetException && e.getCause() != null) {
                                    e = e.getCause();
                                }
                                if (!(e.getCause() instanceof TransformFailedException)) {
                                    AuditLogger.error(e, "exception applying {0} to {1}: {2}", transform, violation, e);
                                } else {
                                    e = e.getCause();
                                }
                                sequencer.maybeTransition(null);
                                boolean ok = listener != null && listener.transformFailed(e, violation, transform, label);
                                if (ok || exception != null) continue block30;
                                exception = e;
                                continue block30;
                            }
                            sequencer.transformApplied();
                            ++this.appliedTransformCount;
                            for (TransformContext context : contexts) {
                                this.modifiedDocuments.add(context.getModel());
                            }
                            endCommand.setTransformApplied(transform, violation);
                        }
                    }
                    finally {
                        sequencer.maybeTransition(null);
                    }
                }
                if (exception == null && !this.modifiedDocuments.isEmpty()) {
                    try {
                        endCommand.setContext(this.modifiedDocuments.iterator().next());
                        processor.invoke((Command)endCommand);
                    }
                    catch (Throwable e) {
                        AuditLogger.error(e, "exception invoking transform end command for {0}: {1}", e, label);
                    }
                }
            }
            catch (CancellationException e) {
                exception = e;
            }
            catch (InterruptedException e) {
                exception = e;
            }
            finally {
                if (exception == null && !this.modifiedDocuments.isEmpty()) {
                    processor.endTrans();
                } else {
                    processor.abortTrans();
                }
                CommandExecutionTracker.commandExecutionTracker().end();
            }
            for (ModelAdapter modelAdapter : this.modifiedDocuments) {
                try {
                    if (!this.dirtyApplicableDocuments.contains(modelAdapter)) {
                        LOG.trace("saving {0}", (Object)modelAdapter);
                        modelAdapter.getNode().save();
                        if (listener == null) continue;
                        listener.modelSaved(modelAdapter);
                        continue;
                    }
                    LOG.trace("not saving {0}", (Object)modelAdapter);
                }
                catch (IOException e) {
                    boolean ok = false;
                    if (listener != null) {
                        ok = listener.saveFailed(e, modelAdapter, label);
                    }
                    if (ok || exception != null) continue;
                    exception = e;
                }
            }
            return exception;
        }
    }

    private static class TransformEndCommand
    extends Command {
        private static final String NAME = "audit-transform-end";
        private static final int CID = Ide.createCmdID((String)"audit-transform-end");
        private WeakReference<AuditModel> model;
        private List<Tuple<Transform, Violation>> appliedTransforms = new ArrayList<Tuple<Transform, Violation>>();

        public TransformEndCommand(AuditModel model) {
            super(CID, 0, NAME);
            this.model = new WeakReference<AuditModel>(model);
        }

        public void setTransformApplied(Transform transform, Violation violation) {
            this.appliedTransforms.add((Tuple<Transform, Violation>)new Tuple((Object)transform, (Object)violation));
        }

        public void setContext(ModelAdapter model) {
            this.setContext(new Context(null, model.getWorkspace(), model.getProject(), model.getNode()));
        }

        public int doit() throws Exception {
            for (Tuple<Transform, Violation> tuple : this.appliedTransforms) {
                Transform transform = (Transform)tuple.object1();
                Violation violation = (Violation)tuple.object2();
                AuditModel model = (AuditModel)this.model.get();
                if (model == null) continue;
                model.setTransformDone(transform, violation);
            }
            return 0;
        }

        public int undo() throws Exception {
            for (Tuple<Transform, Violation> tuple : this.appliedTransforms) {
                Transform transform = (Transform)tuple.object1();
                Violation violation = (Violation)tuple.object2();
                AuditModel model = (AuditModel)this.model.get();
                if (model == null) continue;
                model.setTransformUndone(transform, violation);
            }
            return 0;
        }
    }

    private static class ModelChangedException
    extends Exception {
        private ModelAdapter model;

        public ModelChangedException(ModelAdapter model) {
            this.model = model;
        }

        public ModelAdapter getModel() {
            return this.model;
        }
    }
}

