/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.log.TypeFilter;
import oracle.jdevimpl.audit.model.RootModelType;
import oracle.jdevimpl.audit.swing.DialogFactory;

public class AuditGroupByDialog
implements ChangeListener {
    private TypeFilter filter;
    private List<ModelPanel> subpanels;
    private JButton okButton;
    private MnemonicSolver solver = new MnemonicSolver();
    private static final FormatBundle bundle = new FormatBundle(AuditBundle.class);

    public AuditGroupByDialog(TypeFilter filter) {
        this.filter = filter;
    }

    public void show() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        Collection<ModelType> modelTypes = this.filter.getModelTypes();
        this.subpanels = new ArrayList<ModelPanel>(modelTypes.size());
        for (ModelType type : modelTypes) {
            if (type instanceof RootModelType) continue;
            ModelPanel subpanel = new ModelPanel(type, this.filter, this);
            this.subpanels.add(subpanel);
            panel.add((Component)subpanel, constraints);
            ++constraints.gridy;
        }
        JScrollPane scrollPane = new JScrollPane(panel, 20, 31);
        DialogFactory dialog = new DialogFactory();
        dialog.setTitle(bundle.get("results.group-by.audit.title"));
        dialog.setContent(scrollPane);
        this.okButton = dialog.addOkButton(null);
        this.okButton.setEnabled(false);
        dialog.setDefaultButton(this.okButton);
        dialog.addCancelButton(null);
        dialog.setHelpTopic(bundle.get("results.group-by.audit.help"));
        this.solver.addMenuLabel((AbstractButton)dialog.getHelpButton(), true);
        this.solver.solve();
        JButton result = dialog.show();
        if (result == this.okButton) {
            ArrayList visible = new ArrayList();
            for (ModelPanel subpanel : this.subpanels) {
                subpanel.addVisibleTypes(visible);
            }
            this.filter.setVisible(visible);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ModelPanel subpanel;
        boolean modified = false;
        Iterator<ModelPanel> i$ = this.subpanels.iterator();
        while (i$.hasNext() && !(modified = (subpanel = i$.next()).isModified())) {
        }
        this.okButton.setEnabled(modified);
    }

    private class TypeCheckBox
    extends JPanel
    implements ItemListener {
        private JCheckBox iconCheckBox;
        private Class type;
        private ChangeListener listener;
        private boolean initialState;

        public TypeCheckBox(Class type, TypeFilter filter, ChangeListener listener) {
            super(new FlowLayout(0));
            this.type = type;
            this.listener = listener;
            this.initialState = filter.isVisible(type);
            String label = filter.getLabel(type);
            Icon icon = filter.getIcon(type);
            if (icon == null) {
                icon = new NullIcon();
            }
            String tip = filter.getSummary(type);
            this.iconCheckBox = new JCheckBox("", this.initialState);
            this.iconCheckBox.setFocusable(false);
            this.iconCheckBox.setToolTipText(tip);
            this.iconCheckBox.addItemListener(this);
            this.add(this.iconCheckBox);
            JCheckBox labelCheckBox = new JCheckBox(label, icon, this.initialState);
            labelCheckBox.setModel(this.iconCheckBox.getModel());
            labelCheckBox.setToolTipText(filter.getSummary(type));
            this.add(labelCheckBox);
            AuditGroupByDialog.this.solver.addMenuLabel((AbstractButton)labelCheckBox);
        }

        public Class getType() {
            return this.type;
        }

        public void setSelected(boolean selected) {
            this.iconCheckBox.setSelected(selected);
        }

        public boolean isSelected() {
            return this.iconCheckBox.isSelected();
        }

        public boolean isModified() {
            return this.initialState != this.isSelected();
        }

        @Override
        public float getAlignmentX() {
            return 0.0f;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    private class ModelPanel
    extends JPanel
    implements ChangeListener {
        private ChangeListener listener;

        public ModelPanel(ModelType modelType, TypeFilter filter, ChangeListener listener) {
            super(new GridLayout(0, 1, 0, 0));
            for (Class<?> type : modelType.getPresentationTypes()) {
                if (type == null) continue;
                TypeCheckBox checkbox = new TypeCheckBox(type, filter, this);
                this.add(checkbox);
            }
            this.listener = listener;
        }

        public boolean isModified() {
            Component[] checkboxes = this.getComponents();
            for (int i = 0; i < checkboxes.length; ++i) {
                TypeCheckBox checkbox = (TypeCheckBox)checkboxes[i];
                if (!checkbox.isModified()) continue;
                return true;
            }
            return false;
        }

        public void addVisibleTypes(Collection<Class<?>> types) {
            Component[] checkboxes = this.getComponents();
            for (int i = 0; i < checkboxes.length; ++i) {
                TypeCheckBox checkbox = (TypeCheckBox)checkboxes[i];
                if (!checkbox.isSelected()) continue;
                types.add(checkbox.getType());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }
}

