/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.DefaultTransformsAction;
import oracle.jdeveloper.audit.service.Iteration;
import oracle.jdeveloper.audit.service.TransformAction;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.TransformerListener;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.log.AnomalyFilter;
import oracle.jdevimpl.audit.log.AuditGroupByDialog;
import oracle.jdevimpl.audit.log.AuditTreeTable;
import oracle.jdevimpl.audit.log.AuditTreeTableModel;
import oracle.jdevimpl.audit.log.LogBundle;
import oracle.jdevimpl.audit.log.NameFilter;
import oracle.jdevimpl.audit.log.RuleFilter;
import oracle.jdevimpl.audit.log.SeverityFilter;
import oracle.jdevimpl.audit.log.SuppressionFilter;
import oracle.jdevimpl.audit.log.TypeFilter;
import oracle.jdevimpl.audit.report.AuditXmlReportDialog;
import oracle.jdevimpl.audit.report.AuditXmlReporter;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Strings;

public class AuditLogPanel
extends JPanel
implements ContextMenuListener,
Controller,
TreeSelectionListener,
AuditTreeTable.RowActionListener,
TransformerListener {
    private static final Log LOG = new Log("log");
    private static final Log EVENT_LOG = new Log("treetablemodel-event");
    private Auditor auditor;
    private AuditModel model;
    private View view;
    private AnomalyFilter anomalyFilter;
    private SuppressionFilter suppressionFilter;
    private NameFilter nameFilter;
    private RuleFilter ruleFilter;
    private SeverityFilter severityFilter;
    private TypeFilter typeFilter;
    private AuditTreeTableModel treeTableModel;
    private Component topComponent;
    private Toolbar toolbar;
    private JScrollPane tableScrollPane;
    private JTextField packageFilterField;
    private JTextField fileFilterField;
    private JButton applyFilterButton;
    private JButton clearFilterButton;
    private FixButton fixButton;
    private String label;
    private AuditTreeTable table;
    private MouseListener mouseListener;
    public static final int REFRESH_CID = Ide.findOrCreateCmdID((String)"audit.refresh");
    public static final int CANCEL_CID = Ide.findOrCreateCmdID((String)"audit.cancel");
    public static final int EXPORT_CID = Ide.findOrCreateCmdID((String)"audit.export");
    public static final int EXPAND_ALL_CID = Ide.findOrCreateCmdID((String)"audit.expand-all");
    public static final int COLLAPSE_ALL_CID = Ide.findOrCreateCmdID((String)"audit.collapse-all");
    public static final int GROUP_CID = Ide.findOrCreateCmdID((String)"audit.filter");
    public static final int SHOW_ANOMALIES_CID = Ide.findOrCreateCmdID((String)"audit.show-anomalies");
    public static final int SHOW_SUPPRESSIONS_CID = Ide.findOrCreateCmdID((String)"audit.show-suppressions");
    public static final int SHOW_ERRORS_CID = Ide.findOrCreateCmdID((String)"audit.show-errors");
    public static final int SHOW_WARNINGS_CID = Ide.findOrCreateCmdID((String)"audit.show-warnings");
    public static final int SHOW_INCOMPLETES_CID = Ide.findOrCreateCmdID((String)"audit.show-incompletes");
    public static final int SHOW_ADVISORIES_CID = Ide.findOrCreateCmdID((String)"audit.show-advisories");
    public static final int GOTO_SOURCE_CID = Ide.findOrCreateCmdID((String)"audit.goto-source");
    public static final int ABOUT_CID = Ide.findOrCreateCmdID((String)"audit.about");
    public static final int FIX_CID = Ide.findOrCreateCmdID((String)"audit.fix");
    public static final int DEFAULT_FIX_CID = Ide.findOrCreateCmdID((String)"audit.default-fix");
    public static final int HIDE_ISSUES_CID = Ide.findOrCreateCmdID((String)"audit.hide-issues");
    public static final int UNHIDE_ALL_ISSUES_CID = Ide.findOrCreateCmdID((String)"audit.unhide-all-issues");
    private IdeAction refreshAction;
    private IdeAction cancelAction;
    private IdeAction exportAction;
    private IdeAction expandAllAction;
    private IdeAction collapseAllAction;
    private IdeAction groupAction;
    private IdeAction showAnomaliesAction;
    private IdeAction showSuppressionsAction;
    private IdeAction showErrorsAction;
    private IdeAction showWarningsAction;
    private IdeAction showIncompletesAction;
    private IdeAction showAdvisoriesAction;
    private IdeAction gotoSourceAction;
    private IdeAction aboutAction;
    private IdeAction defaultFixAction;
    private IdeAction hideIssuesAction;
    private IdeAction unhideAllIssuesAction;
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);

    AuditLogPanel(Auditor auditor, AuditModel model, View view, String label) {
        super(new BorderLayout());
        LOG.trace("setting model on {0} to {1}", (Object)this, (Object)model);
        this.auditor = auditor;
        this.model = model;
        this.view = view;
        this.label = label;
        this.setFilters(auditor, model);
        this.toolbar = new Toolbar();
        this.refreshAction = this.action(REFRESH_CID, "refresh", OracleIcons.getIcon((String)"refresh.png"));
        this.toolbar.add((ToggleAction)this.refreshAction);
        this.cancelAction = this.action(CANCEL_CID, "cancel", OracleIcons.getIcon((String)"terminate.png"));
        this.toolbar.add((ToggleAction)this.cancelAction);
        this.exportAction = this.action(EXPORT_CID, "export", OracleIcons.getIcon((String)"export.png"));
        this.toolbar.add((ToggleAction)this.exportAction);
        this.expandAllAction = this.action(EXPAND_ALL_CID, "expand-all", OracleIcons.getIcon((String)"expandall.png"));
        this.toolbar.add((ToggleAction)this.expandAllAction);
        this.collapseAllAction = this.action(COLLAPSE_ALL_CID, "collapse-all", OracleIcons.getIcon((String)"collapseall.png"));
        this.toolbar.add((ToggleAction)this.collapseAllAction);
        this.groupAction = this.action(GROUP_CID, "group", OracleIcons.getIcon((String)"group.png"));
        this.toolbar.add((ToggleAction)this.groupAction);
        this.showAnomaliesAction = this.action(SHOW_ANOMALIES_CID, "show-anomalies", OracleIcons.getIcon((String)"threshold.png"));
        this.showAnomaliesAction.putValue("Check", (Object)Boolean.TRUE);
        Boolean selected = this.anomalyFilter.isAnomaliesOnly();
        this.showAnomaliesAction.putValue("State", (Object)selected);
        ToggleToolButton button = this.toolbar.addToggleButton((ToggleAction)this.showAnomaliesAction);
        button.setToolTipText(BUNDLE.get("results.show-anomalies.label"));
        this.showSuppressionsAction = this.action(SHOW_SUPPRESSIONS_CID, "show-suppressions", OracleIcons.getIcon((String)"annotation.png"));
        this.showSuppressionsAction.putValue("Check", (Object)Boolean.TRUE);
        Boolean suppressionsVisible = this.suppressionFilter.isVisible();
        this.showSuppressionsAction.putValue("State", (Object)suppressionsVisible);
        button = this.toolbar.addToggleButton((ToggleAction)this.showSuppressionsAction);
        button.setToolTipText(BUNDLE.get("results.show-suppressions.label"));
        IdeAction fixAction = this.action(FIX_CID, "fix", OracleIcons.getIcon((String)"fix.png"));
        fixAction.setEnabled(false);
        this.fixButton = new FixButton((ToggleAction)fixAction);
        this.toolbar.add((Component)((Object)this.fixButton));
        this.defaultFixAction = this.action(DEFAULT_FIX_CID, "default-fix", null);
        this.toolbar.addSeparator();
        this.showErrorsAction = this.action(SHOW_ERRORS_CID, "show-errors", OracleIcons.getIcon((String)"error.png"));
        selected = this.severityFilter.isShowErrors();
        this.showErrorsAction.putValue("State", (Object)selected);
        button = this.toolbar.addToggleButton((ToggleAction)this.showErrorsAction);
        button.setToolTipText(BUNDLE.get("results.show-errors.label"));
        this.showWarningsAction = this.action(SHOW_WARNINGS_CID, "show-warnings", OracleIcons.getIcon((String)"warning.png"));
        selected = this.severityFilter.isShowWarnings();
        this.showWarningsAction.putValue("State", (Object)selected);
        button = this.toolbar.addToggleButton((ToggleAction)this.showWarningsAction);
        button.setToolTipText(BUNDLE.get("results.show-warnings.label"));
        this.showIncompletesAction = this.action(SHOW_INCOMPLETES_CID, "show-incompletes", OracleIcons.getIcon((String)"incompletestatus.png"));
        selected = this.severityFilter.isShowIncompletes();
        this.showIncompletesAction.putValue("State", (Object)selected);
        button = this.toolbar.addToggleButton((ToggleAction)this.showIncompletesAction);
        button.setToolTipText(BUNDLE.get("results.show-incompletes.label"));
        this.showAdvisoriesAction = this.action(SHOW_ADVISORIES_CID, "show-advisories", OracleIcons.getIcon((String)"info.png"));
        selected = this.severityFilter.isShowAdvisories();
        this.showAdvisoriesAction.putValue("State", (Object)selected);
        button = this.toolbar.addToggleButton((ToggleAction)this.showAdvisoriesAction);
        button.setToolTipText(BUNDLE.get("results.show-advisories.label"));
        this.toolbar.add(Box.createHorizontalStrut(10));
        JLabel packageLabel = new JLabel(BUNDLE.get("results.filter.package.label"));
        this.packageFilterField = new JTextField(this.nameFilter.getPackageText(), 32);
        Border border = BorderFactory.createEtchedBorder();
        this.packageFilterField.setBorder(border);
        this.packageFilterField.setMaximumSize(this.packageFilterField.getPreferredSize());
        this.packageFilterField.setToolTipText(BUNDLE.get("results.filter.package.tip"));
        JLabel nameLabel = new JLabel(BUNDLE.get("results.filter.name.label"));
        this.fileFilterField = new JTextField(this.nameFilter.getFileText(), 16);
        this.fileFilterField.setBorder(border);
        this.fileFilterField.setMaximumSize(this.fileFilterField.getPreferredSize());
        this.fileFilterField.setToolTipText(BUNDLE.get("results.filter.name.tip"));
        Font font = packageLabel.getFont();
        font = new Font(font.getFamily(), 0, font.getSize() - 2);
        packageLabel.setFont(font);
        nameLabel.setFont(font);
        this.applyFilterButton = new JButton(BUNDLE.get("results.filter.apply.label"));
        this.applyFilterButton.setContentAreaFilled(false);
        this.applyFilterButton.setBorder(border);
        font = this.applyFilterButton.getFont();
        font = new Font(font.getName(), 0, font.getSize() - 2);
        this.applyFilterButton.setFont(font);
        Insets margin = new Insets(0, 0, 0, 0);
        this.applyFilterButton.setMargin(margin);
        this.clearFilterButton = new JButton(BUNDLE.get("results.filter.clear.label"));
        this.clearFilterButton.setContentAreaFilled(false);
        this.clearFilterButton.setFont(font);
        this.clearFilterButton.setMargin(margin);
        this.clearFilterButton.setBorder(border);
        Dimension size = this.fileFilterField.getPreferredSize();
        size.width = Math.max(this.applyFilterButton.getPreferredSize().width, this.clearFilterButton.getPreferredSize().width) + 4;
        this.applyFilterButton.setMaximumSize(size);
        this.applyFilterButton.setPreferredSize(size);
        this.clearFilterButton.setMaximumSize(size);
        this.clearFilterButton.setPreferredSize(size);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add((Component)packageLabel);
        this.toolbar.add((Component)this.packageFilterField);
        this.toolbar.add(Box.createHorizontalStrut(2));
        this.toolbar.add((Component)nameLabel);
        this.toolbar.add((Component)this.fileFilterField);
        this.toolbar.add((Component)this.applyFilterButton);
        this.toolbar.add((Component)this.clearFilterButton);
        this.toolbar.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.gotoSourceAction = this.action(GOTO_SOURCE_CID, "goto-source", null);
        this.aboutAction = this.action(ABOUT_CID, "about", null);
        this.hideIssuesAction = this.action(HIDE_ISSUES_CID, "hide-issues", null);
        this.unhideAllIssuesAction = this.action(UNHIDE_ALL_ISSUES_CID, "unhide-all-issues", null);
        this.tableScrollPane = new JScrollPane();
        this.tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel corner = new JPanel();
        corner.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, IdeConstants.COLOR_IDE_LINES));
        this.tableScrollPane.setCorner("UPPER_RIGHT_CORNER", corner);
        this.tableScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        if (model.getLocations() == null) {
            JLabel startingLabel = new JLabel("Audit starting...");
            startingLabel.setBackground(UIManager.getColor("Table.background"));
            startingLabel.setAlignmentX(0.5f);
            startingLabel.setAlignmentY(0.5f);
            startingLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            startingLabel.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.tableScrollPane.setViewportView(startingLabel);
        } else {
            this.createTable(model);
        }
        this.setBorder(null);
        this.add((Component)this.toolbar, "North");
        this.add(this.tableScrollPane);
        LogManager.getLogManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        FilterListener listener = new FilterListener();
        this.fileFilterField.getDocument().addDocumentListener(listener);
        this.packageFilterField.getDocument().addDocumentListener(listener);
        this.fileFilterField.addActionListener(listener);
        this.clearFilterButton.addActionListener(listener);
        this.packageFilterField.addActionListener(listener);
        this.applyFilterButton.addActionListener(listener);
        listener.synchronize();
        this.refreshAction.setEnabled(!auditor.isAuditing());
        this.exportAction.setEnabled(!auditor.isAuditing());
        this.cancelAction.setEnabled(auditor.isAuditing());
    }

    private void setFilters(Auditor auditor, AuditModel model) {
        String profileName = auditor.getProfile().getName();
        this.ruleFilter = new RuleFilter(profileName + ".rule-filter");
        model.addFilter(this.ruleFilter);
        this.typeFilter = new TypeFilter(profileName + ".type-filter");
        model.addFilter(this.typeFilter);
        this.anomalyFilter = new AnomalyFilter(true, profileName + ".issue-filter");
        model.addFilter(this.anomalyFilter);
        this.suppressionFilter = new SuppressionFilter(false, profileName + ".suppression-filter");
        model.addFilter(this.suppressionFilter);
        this.nameFilter = new NameFilter(profileName + ".name-filter");
        model.addFilter(this.nameFilter);
        this.severityFilter = new SeverityFilter(true, true, true, true, profileName + ".severity-filter");
        model.addFilter(this.severityFilter);
    }

    private IdeAction action(int cid, String name, Icon icon) {
        String label = BUNDLE.get("results." + name + ".label");
        if (label == null) {
            label = name;
        }
        Integer mnemonic = BUNDLE.get("results." + name + ".mnemonic").charAt(0);
        IdeAction globalAction = IdeAction.get((int)cid, null, (String)label, null, (Integer)mnemonic, (Icon)icon, null, (boolean)true);
        IdeAction localAction = globalAction.newLocalAction(this.view);
        if (label.indexOf(" {0}") > 0) {
            localAction.putValue("NoCtxName", (Object)Strings.remove(name, " {0}"));
        }
        localAction.addController((Controller)this);
        return localAction;
    }

    void reset(Auditor newAuditor) {
        this.clear();
        this.model.removeFilter(this.ruleFilter);
        this.model.removeFilter(this.typeFilter);
        this.model.removeFilter(this.anomalyFilter);
        this.model.removeFilter(this.nameFilter);
        this.auditor = newAuditor;
        this.setFilters(newAuditor, this.model);
        this.refreshAction.setEnabled(!this.auditor.isAuditing());
        this.exportAction.setEnabled(!this.auditor.isAuditing());
        this.cancelAction.setEnabled(this.auditor.isAuditing());
    }

    public AuditModel getModel() {
        return this.model;
    }

    public Component getTopComponent() {
        if (this.topComponent == null) {
            this.topComponent = Box.createRigidArea(new Dimension(10, 0));
        }
        return this.topComponent;
    }

    public Toolbar getToolBar() {
        return this.toolbar;
    }

    public void clear() {
        this.model.clear();
    }

    public void auditStarted(AuditModel model, List<Metric> columns, Object root) {
        if (model != this.model) {
            throw new IllegalStateException("conflicting models");
        }
        if (this.table == null || this.model.getColumnCount() - 1 != columns.size()) {
            this.createTable(model);
        }
        this.refreshAction.setEnabled(false);
        this.exportAction.setEnabled(false);
        this.cancelAction.setEnabled(true);
    }

    private void createTable(AuditModel model) {
        if (this.table != null) {
            this.table.removeRowActionListener(this);
            this.table.removeRowSelectionListener(this);
            if (this.mouseListener != null) {
                this.table.removeMouseListener(this.mouseListener);
            }
        }
        this.treeTableModel = new AuditTreeTableModel(model);
        this.table = new AuditTreeTable(this.treeTableModel);
        this.tableScrollPane.setViewportView((Component)((Object)this.table));
        this.table.addRowActionListener(this);
        this.table.addRowSelectionListener(this);
        if (this.mouseListener != null) {
            this.table.addMouseListener(this.mouseListener);
        }
    }

    public void auditStopped(AuditModel model, boolean cancelled) {
        this.refreshAction.setEnabled(true);
        this.exportAction.setEnabled(true);
        this.cancelAction.setEnabled(false);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        EVENT_LOG.trace("row selection changed", (Object[])e.getPaths());
        this.updateFixButton();
    }

    @Override
    public void rowActionPerformed(AuditTreeTable table, int row) {
        this.gotoSourceAtRow(row);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        LOG.trace("adding mouse listener to {0}: {1}", (Object)this, (Object)listener);
        if (listener != null) {
            this.mouseListener = listener;
            super.addMouseListener(listener);
            this.tableScrollPane.getViewport().addMouseListener(listener);
            if (this.table != null) {
                this.table.addMouseListener(listener);
            }
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        LogManager.getLogManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        if (listener != null) {
            this.tableScrollPane.getViewport().removeMouseListener(listener);
            if (this.table != null) {
                this.table.removeMouseListener(listener);
            }
            if (this.mouseListener == listener) {
                this.mouseListener = null;
            }
        }
        this.toolbar.dispose();
    }

    public boolean handleDefaultAction(Context context) {
        LOG.trace("handle default action {0}, context {1}", (Object)this, (Object)context);
        return false;
    }

    public void menuWillHide(ContextMenu menu) {
    }

    public void menuWillShow(ContextMenu menu) {
        String aboutLabel;
        if (menu == null) {
            return;
        }
        Context context = menu.getContext();
        if (context == null || context.getView() != this.view) {
            return;
        }
        menu.removeAll();
        int sections = 1;
        float FIX_SECTION = ++sections;
        float FILTER_SECTION = ++sections;
        float REFRESH_CANCEL_SECTION = ++sections;
        float EXPAND_COLLAPSE_SECTION = ++sections;
        float GOTO_SOURCE_SECTION = ++sections;
        float GOTO_SOURCE_WEIGHT = 1.0f;
        float EXPORT_SECTION = ++sections;
        Object[] selection = this.table.getSelectedObjects();
        if (selection.length > 0) {
            Location location = this.model.getLocation(selection[0]);
            this.gotoSourceAction.setEnabled(location.getModel().isEditable(location));
        } else {
            this.gotoSourceAction.setEnabled(false);
        }
        menu.add((Component)menu.createMenuItem((ToggleAction)this.gotoSourceAction, 1.0f), GOTO_SOURCE_SECTION);
        Violation violation = null;
        if (selection.length == 1) {
            violation = this.model.getViolation(selection[0]);
        }
        if (violation != null) {
            aboutLabel = BUNDLE.get("results.about.selection.label", new Object[]{violation.getRule().labelOrId()});
            this.aboutAction.setEnabled(true);
        } else {
            aboutLabel = BUNDLE.get("results.about.label");
            this.aboutAction.setEnabled(false);
        }
        JMenuItem jMenuItem = menu.createMenuItem((ToggleAction)this.aboutAction);
        jMenuItem.setText(aboutLabel);
        menu.add((Component)jMenuItem, FILTER_SECTION);
        List<? extends ToggleAction> fixes = this.getFixes();
        if (!fixes.isEmpty()) {
            for (ToggleAction toggleAction : fixes) {
                menu.add((Component)menu.createMenuItem(toggleAction), FIX_SECTION);
            }
        }
        menu.add((Component)menu.createMenuItem((ToggleAction)this.groupAction), EXPAND_COLLAPSE_SECTION);
        if (selection.length == 1 && (violation = this.model.getViolation(selection[0])) != null) {
            JMenuItem jMenuItem2 = menu.createMenuItem((ToggleAction)this.hideIssuesAction);
            String name = violation.getRule().labelOrId();
            String label = Strings.toString(jMenuItem2.getText(), name);
            jMenuItem2.setText(label);
            menu.add((Component)jMenuItem2, FILTER_SECTION);
        }
        this.unhideAllIssuesAction.setEnabled(this.ruleFilter.getDisabledCount() > 0);
        menu.add((Component)menu.createMenuItem((ToggleAction)this.unhideAllIssuesAction), FILTER_SECTION);
        menu.add((Component)new ToggleMenuItem((ToggleAction)this.showAnomaliesAction), FILTER_SECTION);
        menu.add((Component)new ToggleMenuItem((ToggleAction)this.showErrorsAction), FILTER_SECTION);
        menu.add((Component)new ToggleMenuItem((ToggleAction)this.showWarningsAction), FILTER_SECTION);
        menu.add((Component)new ToggleMenuItem((ToggleAction)this.showIncompletesAction), FILTER_SECTION);
        menu.add((Component)new ToggleMenuItem((ToggleAction)this.showAdvisoriesAction), FILTER_SECTION);
        menu.add((Component)new ToggleMenuItem((ToggleAction)this.showSuppressionsAction), FILTER_SECTION);
        menu.add((Component)menu.createMenuItem((ToggleAction)this.cancelAction), REFRESH_CANCEL_SECTION);
        menu.add((Component)menu.createMenuItem((ToggleAction)this.refreshAction), REFRESH_CANCEL_SECTION);
        menu.add((Component)menu.createMenuItem((ToggleAction)this.exportAction), EXPORT_SECTION);
        menu.add((Component)menu.createMenuItem((ToggleAction)this.expandAllAction), EXPAND_COLLAPSE_SECTION);
        menu.add((Component)menu.createMenuItem((ToggleAction)this.collapseAllAction), EXPAND_COLLAPSE_SECTION);
    }

    private List<? extends ToggleAction> getFixes() {
        if (this.table == null) {
            return Collections.emptyList();
        }
        Object[] selection = this.table.getSelectedObjects();
        LOG.trace("getting fix actions for selected rows {0}", selection);
        if (selection.length == 1 && this.model.isViolation(selection[0])) {
            Violation violation = this.model.getViolation(selection[0]);
            LOG.trace("getting fix actions for {0}", (Object)violation);
            Transform defaultTransform = violation.getDefaultTransform();
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            List<TransformAction> actions = transformer.createTransformActions(Collections.singletonList(violation), this.model.getProfile(), this, this.model);
            for (TransformAction action : actions) {
                String label = action.getTransform() == defaultTransform ? BUNDLE.get("results.fix.context.default.label") : BUNDLE.get("results.fix.context.label");
                action.putValue("Name", Strings.toString(label, action.getValue("Name")));
            }
            return actions;
        }
        if (this.hasDefaultFix(selection)) {
            this.defaultFixAction.setEnabled(true);
            return Collections.singletonList(this.defaultFixAction);
        }
        return Collections.emptyList();
    }

    private boolean hasFixes() {
        if (this.table == null) {
            return false;
        }
        Object[] selection = this.table.getSelectedObjects();
        if (selection.length == 1 && this.model.isViolation(selection[0])) {
            Violation violation = this.model.getViolation(selection[0]);
            LOG.trace("getting fix actions for {0}", (Object)violation);
            Transform defaultTransform = violation.getDefaultTransform();
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            return transformer.hasTransforms(Collections.singletonList(violation), this.model.getProfile());
        }
        return this.hasDefaultFix(selection);
    }

    public boolean update(IdeAction action, Context context) {
        int cid = action.getCommandId();
        if (cid == REFRESH_CID) {
            return true;
        }
        if (cid == CANCEL_CID) {
            return true;
        }
        if (cid == EXPORT_CID) {
            return true;
        }
        if (cid == EXPAND_ALL_CID) {
            return true;
        }
        if (cid == COLLAPSE_ALL_CID) {
            return true;
        }
        if (cid == GROUP_CID) {
            return true;
        }
        if (cid == SHOW_ANOMALIES_CID) {
            return true;
        }
        if (cid == FIX_CID) {
            this.updateFixButton();
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        LOG.trace("handling action [{0}] in {1}, context {2}", (Object)action, (Object)this, (Object)context);
        int cid = action.getCommandId();
        if (cid == REFRESH_CID) {
            this.auditor.runAsynchronously(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable exception) {
                    if (!(exception instanceof CancellationException)) {
                        if (exception instanceof IllegalStateException) {
                            MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
                            dialog.setTitle(BUNDLE.get("results.refresh.locationschanged.title"));
                            dialog.setContent(Strings.toString(BUNDLE.get("results.refresh.locationschanged.message"), AuditLogPanel.this.label));
                            dialog.show();
                        } else {
                            MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
                            dialog.setTitle(BUNDLE.get("results.refresh.exception.title"));
                            dialog.setContent(Strings.toString(BUNDLE.get("results.refresh.exception.message"), exception));
                            dialog.show();
                            AuditLogger.error(exception, "Refresh of \"{0}\" failed with exception: {1}", AuditLogPanel.this.label, exception);
                        }
                    }
                }
            });
            return true;
        }
        if (cid == CANCEL_CID) {
            this.auditor.cancel();
            return true;
        }
        if (cid == EXPORT_CID) {
            AuditXmlReportDialog<AuditModel> dialog = new AuditXmlReportDialog<AuditModel>(this.model, new AuditXmlReporter(), LogBundle.get("export.dialog.title"), LogBundle.format("export.default-title", this.label), this.label, "f1_aud_saveas_dlg_html", context);
            dialog.show();
            return true;
        }
        if (cid == EXPAND_ALL_CID) {
            this.table.expandAll();
            return true;
        }
        if (cid == COLLAPSE_ALL_CID) {
            this.table.collapseAll();
            return true;
        }
        if (cid == GROUP_CID) {
            new AuditGroupByDialog(this.typeFilter).show();
            return true;
        }
        if (cid == SHOW_ANOMALIES_CID) {
            boolean selected = this.showAnomaliesAction.getValue("State") == Boolean.TRUE;
            this.anomalyFilter.setAnomaliesOnly(selected);
            return true;
        }
        if (cid == SHOW_SUPPRESSIONS_CID) {
            boolean selected = this.showSuppressionsAction.getValue("State") == Boolean.TRUE;
            this.suppressionFilter.setVisible(selected);
            return true;
        }
        if (cid == SHOW_ERRORS_CID) {
            boolean selected = this.showErrorsAction.getValue("State") == Boolean.TRUE;
            this.severityFilter.setShowErrors(selected);
            return true;
        }
        if (cid == SHOW_WARNINGS_CID) {
            boolean selected = this.showWarningsAction.getValue("State") == Boolean.TRUE;
            this.severityFilter.setShowWarnings(selected);
            return true;
        }
        if (cid == SHOW_INCOMPLETES_CID) {
            boolean selected = this.showIncompletesAction.getValue("State") == Boolean.TRUE;
            this.severityFilter.setShowIncompletes(selected);
            return true;
        }
        if (cid == SHOW_ADVISORIES_CID) {
            boolean selected = this.showAdvisoriesAction.getValue("State") == Boolean.TRUE;
            this.severityFilter.setShowAdvisories(selected);
            return true;
        }
        if (cid == GOTO_SOURCE_CID) {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0) {
                this.gotoSourceAtRow(selectedRow);
            }
            return true;
        }
        if (cid == ABOUT_CID) {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0) {
                this.about(selectedRow);
            }
            return true;
        }
        if (cid == DEFAULT_FIX_CID) {
            Object[] selection = this.table.getSelectedObjects();
            this.fix((String)action.getValue("Name"), selection);
            return true;
        }
        if (cid == HIDE_ISSUES_CID) {
            Violation violation;
            Object value;
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0 && (value = this.table.getValueAt(selectedRow, this.table.convertColumnIndexToView(0))) != null && (violation = this.model.getViolation(value)) != null) {
                this.ruleFilter.setEnabled(violation.getRule(), false);
            }
            return true;
        }
        if (cid == UNHIDE_ALL_ISSUES_CID) {
            this.ruleFilter.enableAll();
            return true;
        }
        return false;
    }

    private void gotoSourceAtRow(int row) {
        Object value = this.table.getValueAt(row, this.table.convertColumnIndexToView(0));
        if (value == null) {
            Ide.getStatusBar().setText(BUNDLE.get("results.goto-source.no-file.message"));
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Location location = this.model.getFocusLocation(value);
        if (location == null) {
            location = this.model.getLocation(value);
        }
        if (location == null) {
            Ide.getStatusBar().setText(BUNDLE.get("results.goto-source.no-file.message"));
            Toolkit.getDefaultToolkit().beep();
        } else {
            ModelAdapter model = location.getModel();
            if (model instanceof ContainerModelAdapter) {
                this.table.toggleRow(row);
            } else if (!model.edit(location)) {
                Ide.getStatusBar().setText(BUNDLE.get("results.goto-source.uneditable-file.message", new Object[]{URLFileSystem.getFileName((URL)model.getUrl())}));
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void about(int row) {
        Object value = this.table.getValueAt(row, this.table.convertColumnIndexToView(0));
        if (value == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Violation violation = this.model.getViolation(value);
        if (violation == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Rule rule = violation.getRule();
        String label = rule.labelOrId();
        String help = rule.description();
        final JEditorPane textArea = new JEditorPane("text/html", "");
        textArea.setEditable(false);
        textArea.setText(help);
        int height = 12 * textArea.getFont().getSize();
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 31);
        scrollPane.setPreferredSize(new Dimension(height * 4, height));
        final JDialog dialog = new JDialog((Frame)Ide.getMainWindow(), BUNDLE.get("results.about.title", new Object[]{label}), true);
        dialog.getContentPane().add(scrollPane);
        ComponentInputMap inputMap = new ComponentInputMap(textArea);
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        SwingUtilities.replaceUIInputMap(textArea, 2, inputMap);
        ActionMap actionMap = new ActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        SwingUtilities.replaceUIActionMap(textArea, actionMap);
        dialog.pack();
        this.setLocationRelativeTo(dialog, this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                textArea.scrollRectToVisible(new Rectangle(16, 16));
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void setLocationRelativeTo(JDialog dialog, Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = dialog.getSize();
            Dimension screenSize = dialog.getToolkit().getScreenSize();
            Insets screenInsets = dialog.getToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            dialog.setLocation(screenInsets.left + (screenSize.width - screenInsets.left - screenInsets.right - paneSize.width) / 2, screenInsets.top + (screenSize.height - screenInsets.top - screenInsets.bottom - paneSize.height) / 2);
        } else {
            Point invokerScreenLocation;
            Dimension invokerSize = c.getSize();
            if (root instanceof Applet) {
                invokerScreenLocation = c.getLocationOnScreen();
            } else {
                invokerScreenLocation = new Point(0, 0);
                for (Component tc = c; tc != null; tc = tc.getParent()) {
                    Point tcl = tc.getLocation();
                    invokerScreenLocation.x += tcl.x;
                    invokerScreenLocation.y += tcl.y;
                    if (tc == root) break;
                }
            }
            Rectangle windowBounds = dialog.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
            Dimension ss = dialog.getToolkit().getScreenSize();
            Insets si = dialog.getToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            if (dy + windowBounds.height > ss.height - si.bottom) {
                dy = ss.height - si.bottom - windowBounds.height;
                int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - windowBounds.width;
            }
            if (dx + windowBounds.width > ss.width) {
                dx = ss.width - windowBounds.width;
            }
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            dialog.setLocation(dx, dy);
        }
    }

    @Override
    public String toString() {
        return BUNDLE.get("audit.tab.summary", new Object[]{this.label}) + "#" + System.identityHashCode(this);
    }

    private void updateFixButton() {
        this.fixButton.setEnabled(this.hasFixes());
    }

    private boolean hasDefaultFix(Object[] objects) {
        for (Object object : objects) {
            boolean contains = this.model.iterateViolations(object, new Iteration(){

                @Override
                public boolean iteration(Object object) {
                    Violation violation = (Violation)object;
                    return violation.getDefaultTransform() == null;
                }
            }) != null;
            LOG.trace("item {1} contains transforms {0}", contains, object);
            if (!contains) continue;
            return true;
        }
        return false;
    }

    private int fix(String label, Object[] objects) {
        String text;
        Transformer transformer = AuditManager.getAuditManager().createTransformer();
        DefaultTransformsAction action = transformer.createDefaultTransformsAction(label, this.model, objects, this);
        int documentCount = action.getApplicableModelCount();
        int dirtyCount = action.getDirtyApplicableModelCount();
        if (documentCount > 0) {
            boolean ok;
            String key = documentCount == 1 ? (dirtyCount == 0 ? "fix.confirm.dialog.top-1-all.message" : "fix.confirm.dialog.top-1-none.message") : (dirtyCount == 0 ? "fix.confirm.dialog.top-n-all.message" : (dirtyCount < documentCount ? "fix.confirm.dialog.top-n-some.message" : "fix.confirm.dialog.top-n-none.message"));
            String top = BUNDLE.get(key, new Object[]{documentCount});
            Object[] fileNames = action.getApplicableModels().toArray();
            for (int i = 0; i < fileNames.length; ++i) {
                fileNames[i] = URLFileSystem.getPlatformPathName((URL)((ModelAdapter)fileNames[i]).getUrl());
            }
            JList<Object> fileList = new JList<Object>(fileNames);
            fileList.setVisibleRowCount(4);
            JScrollPane fileScrollPane = new JScrollPane(fileList, 20, 30);
            Object[] fixNames = action.getTransformDescriptions().toArray();
            Arrays.sort(fixNames);
            JList<Object> fixList = new JList<Object>(fixNames);
            fixList.setVisibleRowCount(4);
            JScrollPane fixScrollPane = new JScrollPane(fixList, 20, 31);
            MessageDialog confirmDialog = new MessageDialog(MessageDialog.WARNING);
            confirmDialog.setResizeable(true);
            confirmDialog.setTitle(BUNDLE.get("fix.confirm.dialog.title"));
            confirmDialog.setContent(top);
            confirmDialog.addContent(fileScrollPane);
            confirmDialog.addContent(BUNDLE.get(fixNames.length == 1 ? "fix.confirm.dialog.middle-1.message" : "fix.confirm.dialog.middle-n.message"));
            confirmDialog.addContent(fixScrollPane);
            confirmDialog.addContent(" ");
            String okLabel = BUNDLE.get("fix.confirm.dialog.ok.label");
            String cancelLabel = BUNDLE.get("fix.confirm.dialog.cancel.label");
            confirmDialog.setCommands(okLabel, cancelLabel);
            Object command = confirmDialog.show(null);
            boolean bl = ok = command == okLabel;
            if (!ok) {
                return 0;
            }
        }
        action.apply();
        int count = action.getAppliedTransformCount();
        switch (count) {
            case 0: {
                text = BUNDLE.get("results.fixed.0.message");
                break;
            }
            case 1: {
                text = BUNDLE.get("results.fixed.1.message");
                break;
            }
            default: {
                text = BUNDLE.get("results.fixed.n.message", new Object[]{count});
            }
        }
        Ide.getStatusBar().setText(text);
        return count;
    }

    @Override
    public void modelWritable(ModelAdapter model) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transformFailed(Throwable exception, Violation violation, Transform transform, String label) {
        String line;
        Location location = violation.getLocation();
        ModelAdapter model = location.getModel();
        String url = URLFileSystem.getPlatformPathName((URL)model.getUrl());
        try {
            model.beginRead();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        try {
            line = model.getLine(location.getOffset());
        }
        finally {
            model.endRead();
        }
        Log.error((String)"exception applying {0} to {1} at {2}: {3}", (Object)label, (Object)url, (Object)line, (Object)exception);
        MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
        dialog.setTitle(BUNDLE.get("results.fix.exception.title"));
        dialog.setContent(Strings.toString(BUNDLE.get("results.fix.exception.message"), label, exception));
        dialog.show();
        return true;
    }

    @Override
    public void modelSaved(ModelAdapter model) {
    }

    @Override
    public boolean saveFailed(Throwable exception, ModelAdapter model, String label) {
        String url = URLFileSystem.getPlatformPathName((URL)model.getUrl());
        Log.error((String)"exception saving {0}: {1}", (Object)url, (Object)exception);
        MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
        dialog.setTitle(BUNDLE.get("results.fix.save.exception.title"));
        dialog.setContent(Strings.toString(BUNDLE.get("results.fix.save.exception.message"), url, exception));
        dialog.show();
        return true;
    }

    public AuditTreeTable getTable() {
        return this.table;
    }

    private class FixButton
    extends MenuToolButton
    implements PopupMenuListener {
        public FixButton(ToggleAction buttonAction) {
            super(buttonAction);
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.removeAllPopupItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.removeAllPopupItems();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.removeAllPopupItems();
            for (ToggleAction action : AuditLogPanel.this.getFixes()) {
                this.addPopupItem(action);
            }
        }
    }

    private class FilterListener
    implements ActionListener,
    DocumentListener {
        private FilterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == AuditLogPanel.this.clearFilterButton) {
                AuditLogPanel.this.packageFilterField.setText("");
                AuditLogPanel.this.fileFilterField.setText("");
                this.synchronize();
                if (!AuditLogPanel.this.applyFilterButton.isEnabled()) {
                    return;
                }
            }
            String packageText = AuditLogPanel.this.packageFilterField.getText();
            String fileText = AuditLogPanel.this.fileFilterField.getText();
            LOG.trace("handling action performed from filter, package {0}, name {1}", (Object)packageText, (Object)fileText);
            AuditLogPanel.this.nameFilter.setText(packageText, fileText);
            packageText = AuditLogPanel.this.nameFilter.getPackageText();
            fileText = AuditLogPanel.this.nameFilter.getFileText();
            AuditLogPanel.this.packageFilterField.setText(packageText);
            AuditLogPanel.this.fileFilterField.setText(fileText);
            this.synchronize();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.synchronize();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.synchronize();
        }

        public void synchronize() {
            String packageText = AuditLogPanel.this.packageFilterField.getText();
            String fileText = AuditLogPanel.this.fileFilterField.getText();
            AuditLogPanel.this.applyFilterButton.setEnabled(!packageText.equals(AuditLogPanel.this.nameFilter.getPackageText()) || !fileText.equals(AuditLogPanel.this.nameFilter.getFileText()));
            AuditLogPanel.this.clearFilterButton.setEnabled(packageText.length() > 0 || fileText.length() > 0);
        }
    }
}

