/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.FileModelAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdevimpl.audit.util.Cache;

public class NameFilter
extends AuditModelFilter {
    private List packagePatterns = new ArrayList();
    private List packageMatchers = new ArrayList();
    private List packageIncludes = new ArrayList();
    private String packageKey;
    private List filePatterns = new ArrayList();
    private List fileMatchers = new ArrayList();
    private List fileIncludes = new ArrayList();
    private String fileKey;
    private static final Log LOG = new Log("filter");

    public NameFilter() {
    }

    public NameFilter(String persistenceKey) {
        this.packageKey = persistenceKey + ".package";
        String text = (String)Cache.get(this.packageKey);
        if (text != null && !text.equals("")) {
            this.setPackageText(text);
        }
        this.fileKey = persistenceKey + ".file";
        text = (String)Cache.get(this.fileKey);
        if (text != null && !text.equals("")) {
            this.setFileText(text);
        }
    }

    public void setText(String packageText, String fileText) {
        LOG.trace("setting package and file filter text to \"{0}\" and \"{1}\"", (Object)packageText, (Object)fileText);
        if (this.getPackageText().equals(packageText) && this.getFileText().equals(fileText)) {
            return;
        }
        this.setText(packageText, this.packagePatterns, this.packageMatchers, this.packageIncludes, this.packageKey);
        this.setText(fileText, this.filePatterns, this.fileMatchers, this.fileIncludes, this.fileKey);
        this.fireStateChanged();
    }

    public void setPackageText(String text) {
        LOG.trace("setting package filter text to {0}", (Object)text);
        if (this.getPackageText().equals(text)) {
            return;
        }
        this.setText(text, this.packagePatterns, this.packageMatchers, this.packageIncludes, this.packageKey);
        this.fireStateChanged();
    }

    public String getPackageText() {
        return this.getText(this.packagePatterns, this.packageIncludes);
    }

    public void setFileText(String text) {
        LOG.trace("setting name filter text to {0}", (Object)text);
        if (this.getFileText().equals(text)) {
            return;
        }
        this.setText(text, this.filePatterns, this.fileMatchers, this.fileIncludes, this.fileKey);
        this.fireStateChanged();
    }

    public String getFileText() {
        return this.getText(this.filePatterns, this.fileIncludes);
    }

    private String getText(List patterns, List includes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < patterns.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            if (includes.get(i) == Boolean.FALSE) {
                buffer.append("!");
            }
            buffer.append(patterns.get(i));
        }
        return buffer.toString();
    }

    private void setText(String text, List patterns, List matchers, List includes, String key) {
        patterns.clear();
        matchers.clear();
        includes.clear();
        text = text.trim();
        if (text.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(text, ",;: ");
            while (tokenizer.hasMoreTokens()) {
                this.add(tokenizer.nextToken(), includes, patterns, matchers);
            }
        }
        if (key != null) {
            Cache.put(key, text);
        }
    }

    private void add(String pattern, List includes, List patterns, List matchers) {
        boolean not;
        if ((pattern = pattern.trim()).length() == 0) {
            return;
        }
        boolean bl = not = pattern.charAt(0) == '!';
        if (not) {
            pattern = pattern.substring(1);
        }
        includes.add(!not);
        patterns.add(pattern);
        matchers.add(null);
    }

    @Override
    public boolean isVisible(Object object) {
        boolean visible;
        String name;
        Location location = this.getModel().getLocation(object);
        if (location == null) {
            return true;
        }
        ModelAdapter model = location.getModel();
        ContentDirectory directory = model.getDirectory();
        LOG.trace("filtering {0}, package {1}", (Object)model, (Object)directory);
        if (directory != null) {
            name = directory.getRelativePath();
            visible = this.isVisiblePackage(name);
            LOG.trace("package name {1} visible {0}", visible, (Object)name);
            if (!visible) {
                return false;
            }
        }
        if (model instanceof FileModelAdapter) {
            name = URLFileSystem.getName((URL)model.getUrl());
            visible = this.isVisibleFile(name);
            LOG.trace("name {1} visible {0}", visible, (Object)name);
            return visible;
        }
        return true;
    }

    public boolean isVisiblePackage(String name) {
        return this.isVisible(name, this.packagePatterns, this.packageIncludes, this.packageMatchers);
    }

    public boolean isVisibleFile(String name) {
        return this.isVisible(name, this.filePatterns, this.fileIncludes, this.fileMatchers);
    }

    public boolean isVisible(String name, List patterns, List includes, List matchers) {
        int count = patterns.size();
        if (count == 0) {
            return true;
        }
        boolean included = includes.get(0) != Boolean.TRUE;
        for (int i = 0; i < count; ++i) {
            Matcher matcher = (Matcher)matchers.get(i);
            if (matcher != null) {
                matcher.reset(name);
            } else {
                StringBuffer buffer = new StringBuffer();
                String pattern = (String)patterns.get(i);
                block6: for (int j = 0; j < pattern.length(); ++j) {
                    char c = pattern.charAt(j);
                    switch (c) {
                        case '*': {
                            buffer.append(".*");
                            continue block6;
                        }
                        case '?': {
                            buffer.append('.');
                            continue block6;
                        }
                        case '.': {
                            buffer.append("/");
                            continue block6;
                        }
                        default: {
                            buffer.append(c);
                        }
                    }
                }
                matcher = Pattern.compile(buffer.toString()).matcher(name);
                matchers.set(i, matcher);
            }
            if (includes.get(i) == Boolean.TRUE) {
                if (included) continue;
                included = matcher.matches();
                continue;
            }
            if (!included) continue;
            included = !matcher.matches();
        }
        return included;
    }

    public String toString() {
        return this.getPackageText() + " + " + this.getFileText();
    }
}

