/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.model.DefaultModelTypeFactory;
import oracle.jdevimpl.audit.util.Cache;
import oracle.jdevimpl.audit.util.Strings;

public class TypeFilter
extends AuditModelFilter {
    private ModelTypeFactory factory;
    private List<ModelType> modelTypes = Collections.emptyList();
    private Map<Class<?>, Boolean> visibilityByPresentationType = new LinkedHashMap();
    private Map<Class<?>, ModelType> modelTypeByPresentationType = new LinkedHashMap();
    private String key;
    private static final Log LOG = new Log("typefilter");

    public TypeFilter() {
        this(null, AuditManager.getAuditManager().getDefaultModelTypeFactory());
    }

    public TypeFilter(String persistenceKey) {
        this(persistenceKey, AuditManager.getAuditManager().getDefaultModelTypeFactory());
    }

    public TypeFilter(List<ModelType> modelTypes) {
        this(null, new DefaultModelTypeFactory(modelTypes, null, null));
    }

    public TypeFilter(String persistenceKey, ModelTypeFactory factory) {
        this.key = persistenceKey;
        this.factory = factory;
        this.visibilityByPresentationType.put(Violation.class, Boolean.TRUE);
        this.load();
    }

    @Override
    public boolean isVisible(Object object) {
        return this.isVisible(this.getModel().getType(object));
    }

    public Collection<ModelType> getModelTypes() {
        this.load();
        return this.modelTypes;
    }

    public synchronized void setVisible(Class type, boolean visible) {
        this.load();
        if (Violation.class.isAssignableFrom(type)) {
            return;
        }
        Boolean wasVisible = this.visibilityByPresentationType.get(type);
        assert (wasVisible != null);
        if (visible == wasVisible) {
            return;
        }
        this.visibilityByPresentationType.put(type, visible);
        this.write(this.modelTypeByPresentationType.get(type));
        this.fireStateChanged();
    }

    public void setVisible(Class<?> ... types) {
        this.setVisible(Arrays.asList(types));
    }

    public synchronized void setVisible(List<Class<?>> types) {
        Boolean wasVisible;
        this.load();
        HashSet invisibleTypes = new HashSet(this.visibilityByPresentationType.keySet());
        invisibleTypes.remove(Violation.class);
        HashSet<ModelType> changedModelTypes = new HashSet<ModelType>();
        for (Class<?> clazz : types) {
            assert (this.visibilityByPresentationType.containsKey(clazz));
            invisibleTypes.remove(clazz);
            wasVisible = this.visibilityByPresentationType.put(clazz, Boolean.TRUE);
            if (wasVisible == Boolean.TRUE) continue;
            changedModelTypes.add(this.modelTypeByPresentationType.get(clazz));
        }
        for (Class clazz : invisibleTypes) {
            assert (this.visibilityByPresentationType.containsKey(clazz));
            wasVisible = this.visibilityByPresentationType.put(clazz, Boolean.FALSE);
            if (wasVisible == Boolean.FALSE) continue;
            changedModelTypes.add(this.modelTypeByPresentationType.get(clazz));
        }
        for (ModelType modelType : changedModelTypes) {
            this.write(modelType);
        }
        if (!changedModelTypes.isEmpty()) {
            this.fireStateChanged();
        }
    }

    public synchronized boolean isVisible(Class type) {
        Boolean visible = this.visibilityByPresentationType.get(type);
        if (visible == null) {
            LOG.trace("unrecognized type {0}", (Object)type);
            this.reload();
            visible = this.visibilityByPresentationType.get(type);
            LOG.trace("type {0} visibility after reload: {1}", (Object)type, (Object)visible);
        }
        return visible == Boolean.TRUE;
    }

    public ModelType getModelType(Class type) {
        this.load();
        return this.modelTypeByPresentationType.get(type);
    }

    public String getLabel(Class type) {
        this.load();
        return this.modelTypeByPresentationType.get(type).label(type);
    }

    public String getSummary(Class type) {
        this.load();
        return this.modelTypeByPresentationType.get(type).summary(type);
    }

    public Icon getIcon(Class type) {
        this.load();
        return this.modelTypeByPresentationType.get(type).icon(type);
    }

    private Collection<String> read(ModelType type) {
        return this.key != null ? (Collection)Cache.get(this.getModelTypeKey(type)) : null;
    }

    private void write(ModelType modelType) {
        if (this.key == null) {
            return;
        }
        Collection<Class<?>> types = modelType.getPresentationTypes();
        ArrayList<String> visibleTypes = new ArrayList<String>();
        for (Class<?> type : types) {
            if (!this.isVisible(type)) continue;
            visibleTypes.add(type.getName());
        }
        String key = this.getModelTypeKey(modelType);
        Cache.put(key, visibleTypes);
        LOG.trace("wrote type filter cache {0} to {1}", (Object)key, visibleTypes);
    }

    private String getModelTypeKey(ModelType modelType) {
        return this.key + "." + Strings.removeSuffix(Strings.lastToken(modelType.getClass().getName(), '.'), "Type").toLowerCase();
    }

    private void load() {
        if (this.modelTypes.isEmpty()) {
            this.reload();
        }
    }

    private void reload() {
        int oldSize = this.modelTypes.size();
        this.modelTypes = this.factory.getModelTypes();
        int newSize = this.modelTypes.size();
        for (int i = oldSize; i < newSize; ++i) {
            ModelType modelType = this.modelTypes.get(i);
            LOG.trace("loading model type {0}", (Object)modelType);
            Collection<Class<?>> allTypes = modelType.getPresentationTypes();
            if (allTypes == null) continue;
            Collection<String> names = this.read(modelType);
            if (names != null) {
                for (Class<?> type : allTypes) {
                    this.modelTypeByPresentationType.put(type, modelType);
                    this.visibilityByPresentationType.put(type, names.contains(type.getName()));
                }
                continue;
            }
            for (Class<?> type : allTypes) {
                this.modelTypeByPresentationType.put(type, modelType);
                this.visibilityByPresentationType.put(type, Boolean.FALSE);
            }
            Collection<Class<?>> visibleTypes = modelType.getDefaultPresentationTypes();
            if (visibleTypes == null) continue;
            for (Class<?> type : visibleTypes) {
                this.visibilityByPresentationType.put(type, Boolean.TRUE);
            }
        }
    }
}

