/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.markers;

import java.net.URL;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.TextMarker;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.status.Issue;
import oracle.jdeveloper.audit.markers.AuditMarker;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.markers.AuditMarkerNavigationPoint;

public class AuditMarkerToNavigationPointAdapterFactory
implements AdapterFactory<AuditMarker, NavigationPoint> {
    public NavigationPoint adapt(AuditMarker marker) {
        Context context = this.getContext(marker);
        if (context != null) {
            ModelAdapter model;
            Violation violation;
            Location location;
            Issue issue = (Issue)AdapterManager.Factory.getAdapterManager().adapt((Object)marker, Issue.class);
            if (issue instanceof Violation && (location = (violation = (Violation)issue).getLocation()) != null && (model = location.getModel()) != null) {
                NavigationPoint point = model.getNavigationPoint(location);
                if (point != null) {
                    return point;
                }
                return new AuditMarkerNavigationPoint(context, location);
            }
            if (marker instanceof TextMarker) {
                int offset = Math.max(0, ((TextMarker)marker).offset() - 1);
                return new LineNavigationPoint(context, offset, false);
            }
        }
        return null;
    }

    private Context getContext(AuditMarker marker) {
        try {
            Context context = new Context(marker.context());
            Node node = NodeFactory.findOrCreate((URL)marker.markable().getUrl());
            context.setNode(node);
            return context;
        }
        catch (MarkerException e) {
            AuditMarkerToNavigationPointAdapterFactory.logContextException((Exception)((Object)e));
        }
        catch (InstantiationException e) {
            AuditMarkerToNavigationPointAdapterFactory.logContextException(e);
        }
        catch (IllegalAccessException e) {
            AuditMarkerToNavigationPointAdapterFactory.logContextException(e);
        }
        return null;
    }

    private static void logContextException(Exception e) {
        AuditLogger.log(Level.SEVERE, e, "Unable to get context for marker", new Object[0]);
    }
}

