/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.ContentRoot;
import oracle.jdevimpl.audit.util.Strings;

public class DefaultContentDirectory
implements ContentDirectory {
    private URL url;
    private String relativePath;
    private int depth;
    private Collection<ContentRoot> roots;
    private static Log LOG = new Log("intersection-filter");

    public DefaultContentDirectory(URL url, String relativePath, Collection<ContentRoot> roots) {
        relativePath = Strings.trim(relativePath, '/');
        this.url = url;
        this.relativePath = relativePath;
        this.depth = this.depth(relativePath);
        this.roots = roots;
        if (roots.isEmpty()) {
            throw new IllegalArgumentException("no roots");
        }
        URL rootUrl = null;
        for (ContentRoot root : roots) {
            if (rootUrl == null) {
                rootUrl = root.getUrl();
                continue;
            }
            if (URLFileSystem.equals((URL)rootUrl, (URL)root.getUrl())) continue;
            throw new IllegalArgumentException("unequal roots: " + rootUrl + " != " + root.getUrl());
        }
    }

    private int depth(String relativePath) {
        int count = 0;
        if (!relativePath.equals("")) {
            int index = 0;
            while (true) {
                ++count;
                if ((index = relativePath.indexOf(47, index)) < 0) break;
                ++index;
            }
        }
        return count;
    }

    public DefaultContentDirectory(ContentDirectory parent, String relativePath) {
        this.url = URLFactory.newDirURL((URL)parent.getURL(), (String)relativePath);
        this.relativePath = Strings.trim(parent.getRelativePath() + "/" + Strings.trim(relativePath, '/'), '/');
        this.depth = parent.getDepth() + 1;
        this.roots = parent.getRoots();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getName() {
        return URLFileSystem.getName((URL)this.url);
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public Collection<ContentRoot> getRoots() {
        return this.roots;
    }

    @Override
    public Collection<String> getContentSetKeys() {
        ArraySortedSet keys = new ArraySortedSet();
        for (ContentRoot root : this.roots) {
            keys.add(root.getKey());
        }
        return keys;
    }

    @Override
    public boolean canContainJavaSources() {
        for (ContentRoot root : this.roots) {
            if (!root.canContainJavaSources()) continue;
            return true;
        }
        return false;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public Iterator<Element> getChildren() {
        LOG.trace("**** getting children of {0}", (Object)this);
        ArrayList<DefaultContentDirectory> elements = new ArrayList<DefaultContentDirectory>();
        URLFileSystem.FileInfo[] files = URLFileSystem.ls((URL)this.url);
        if (files != null) {
            URL rootUrl = this.roots.iterator().next().getUrl();
            block2: for (URLFileSystem.FileInfo file : files) {
                URL child = file.getURL();
                String childPath = URLFileSystem.toRelativeSpec((URL)child, (URL)rootUrl, (boolean)true);
                if (childPath == null) continue;
                for (ContentRoot root : this.roots) {
                    boolean included;
                    IntersectedFilters filter = root.getFilters();
                    LOG.trace("processing {0} with {1}", (Object)childPath, (Object)filter);
                    if (childPath.endsWith("/")) {
                        included = filter.inferFromFilters(childPath) != TriStateBoolean.FALSE;
                        LOG.trace("    inferred included {0}", included);
                        if (!included) continue;
                        elements.add(new DefaultContentDirectory(this, URLFileSystem.getFileName((URL)child)));
                        continue block2;
                    }
                    included = filter.isIncluded(childPath);
                    LOG.trace("    included {0}", included);
                    if (!included) continue;
                    try {
                        elements.add((DefaultContentDirectory)NodeFactory.findOrCreate((URL)child));
                        continue block2;
                    }
                    catch (Exception e) {
                    }
                }
            }
        }
        return elements.iterator();
    }

    @Override
    public Attributes getAttributes() {
        return null;
    }

    @Override
    public Object getData() {
        return this;
    }

    public String getShortLabel() {
        if (this.relativePath.equals("")) {
            StringBuilder buffer = new StringBuilder();
            String separator = "";
            for (ContentRoot root : this.roots) {
                buffer.append(separator);
                buffer.append(root.getLabel());
                separator = ", ";
            }
            return buffer.toString();
        }
        return Strings.lastToken(this.relativePath, '/');
    }

    public String getLongLabel() {
        if (this.relativePath.equals("")) {
            StringBuilder buffer = new StringBuilder();
            String separator = "";
            for (ContentRoot root : this.roots) {
                buffer.append(separator);
                buffer.append(root.getLabel());
                separator = ", ";
            }
            buffer.append(" (");
            buffer.append(URLFileSystem.getPlatformPathName((URL)this.url));
            buffer.append(")");
            return buffer.toString();
        }
        return this.canContainJavaSources() ? this.getRelativePath().replace('/', '.') : this.getRelativePath();
    }

    public Icon getIcon() {
        if (this.canContainJavaSources()) {
            return OracleIcons.getIcon((String)"package.png");
        }
        return OracleIcons.getIcon((String)"folder.png");
    }

    public String getToolTipText() {
        return URLFileSystem.getPlatformPathName((URL)this.url);
    }

    public String toString() {
        return "directory [" + this.relativePath + ", " + this.url + ", " + this.roots + "]";
    }
}

