/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import oracle.ide.model.Element;
import oracle.javatools.util.Log;
import oracle.javatools.util.TypeMap;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.model.ContentRootFactory;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdevimpl.audit.model.DefaultModelFactory;

public class DefaultModelTypeFactory
extends ModelTypeFactory {
    private List<ModelType> modelTypes;
    private Collection<TypeDefinition<ModelType>> unloadedModelTypes;
    private HashMap<Class<? extends ModelType>, ModelType> modelTypeByModelTypeClass;
    private TypeMap<Element, ModelType> modelTypeByRootElementType;
    private TypeMap<Element, ModelType> modelTypeByContainedElementType;
    private Collection<ContentRootFactory> contentRootFactories;
    private Collection<TypeDefinition<ContentRootFactory>> unloadedContentRootFactories;
    private static final Log LOG = new Log("model");

    public DefaultModelTypeFactory(List<ModelType> modelTypes, Collection<TypeDefinition<ModelType>> unloadedModelTypes, Collection<TypeDefinition<ContentRootFactory>> contentRootFactories) {
        if (unloadedModelTypes == null) {
            unloadedModelTypes = Collections.emptyList();
        }
        if (modelTypes == null) {
            modelTypes = new ArrayList<ModelType>();
        }
        this.modelTypes = modelTypes;
        this.unloadedModelTypes = unloadedModelTypes;
        this.contentRootFactories = new ArrayList<ContentRootFactory>();
        this.unloadedContentRootFactories = contentRootFactories;
    }

    @Override
    public boolean isModelType(Class<?> type) {
        this.indexModelTypes();
        return this.modelTypeByModelTypeClass.containsKey(type);
    }

    @Override
    public List<ModelType> getModelTypes() {
        return new UnmodifiableFixedCollection<ModelType>(this.loadModelTypes());
    }

    @Override
    public Collection<ContentRootFactory> getContentRootFactories() {
        this.loadContentRootFactories();
        return this.contentRootFactories;
    }

    @Override
    public <T extends ModelType> T getModelType(Class<T> type) {
        this.indexModelTypes();
        return (T)((ModelType)type.cast(this.modelTypeByModelTypeClass.get(type)));
    }

    @Override
    public synchronized Collection<ModelType> getModelTypes(Element element) {
        LOG.trace("getting document type for document {0} element {1}", (Object)element);
        if (element == null) {
            return Collections.emptyList();
        }
        this.indexModelTypes();
        Class<?> elementType = element.getClass();
        ModelType type = (ModelType)this.modelTypeByRootElementType.get(elementType);
        if (type == null) {
            type = (ModelType)this.modelTypeByContainedElementType.get(elementType);
        }
        LOG.trace("got type {0}", (Object)type);
        if (type == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(type);
    }

    @Override
    public ModelFactory createModelFactory(Map attributes) {
        return new DefaultModelFactory(this, attributes);
    }

    private synchronized void indexModelTypes() {
        LOG.trace("indexing model types");
        if (this.modelTypeByModelTypeClass == null) {
            LOG.trace("creating model type indexes");
            this.modelTypeByModelTypeClass = new HashMap();
            this.modelTypeByRootElementType = new TypeMap();
            this.modelTypeByContainedElementType = new TypeMap();
        }
        for (ModelType modelType : this.loadModelTypes()) {
            Collection<Class<? extends Element>> containedElementTypes;
            if (this.modelTypeByModelTypeClass.containsKey(modelType.getClass())) continue;
            this.modelTypeByModelTypeClass.put(modelType.getClass(), modelType);
            Collection<Class<? extends Element>> rootElementTypes = modelType.getRootElementTypes();
            if (rootElementTypes != null) {
                for (Class<? extends Element> type : rootElementTypes) {
                    LOG.trace("... mapping root element type {0} \t-> {1}", type, (Object)modelType);
                    if (type == null) continue;
                    this.modelTypeByRootElementType.put(type, (Object)modelType);
                }
            }
            if ((containedElementTypes = modelType.getContainedElementTypes()) == null) continue;
            for (Class<? extends Element> type : containedElementTypes) {
                LOG.trace("... mapping contained element type {0} \t-> {1}", type, (Object)modelType);
                if (type == null) continue;
                this.modelTypeByContainedElementType.put(type, (Object)modelType);
            }
        }
    }

    private synchronized List<ModelType> loadModelTypes() {
        if (!this.unloadedModelTypes.isEmpty()) {
            ArrayList<TypeDefinition<ModelType>> temporary = null;
            for (TypeDefinition<ModelType> TypeDefinition2 : this.unloadedModelTypes) {
                ModelType modelType = TypeDefinition2.getInstance();
                if (modelType != null) {
                    this.modelTypes.add(modelType);
                    continue;
                }
                if (temporary == null) {
                    temporary = new ArrayList<TypeDefinition<ModelType>>(this.unloadedModelTypes.size());
                }
                temporary.add(TypeDefinition2);
            }
            this.unloadedModelTypes = temporary != null ? temporary : Collections.emptyList();
        }
        return this.modelTypes;
    }

    private synchronized void loadContentRootFactories() {
        if (!this.unloadedContentRootFactories.isEmpty()) {
            ArrayList<TypeDefinition<ContentRootFactory>> temporary = null;
            for (TypeDefinition<ContentRootFactory> deferredFactory : this.unloadedContentRootFactories) {
                ContentRootFactory factory = deferredFactory.getInstance();
                if (factory != null) {
                    this.contentRootFactories.add(factory);
                    continue;
                }
                if (temporary == null) {
                    temporary = new ArrayList<TypeDefinition<ContentRootFactory>>();
                }
                temporary.add(deferredFactory);
            }
            this.unloadedContentRootFactories = temporary != null ? temporary : Collections.emptyList();
        }
    }

    private static class UnmodifiableFixedCollection<E>
    implements List<E> {
        private final List<E> delegate;
        private final int offset;
        private final int size;

        public UnmodifiableFixedCollection(List<E> delegate) {
            this.delegate = delegate;
            this.offset = 0;
            this.size = delegate.size();
        }

        public UnmodifiableFixedCollection(List<E> delegate, int fromIndex, int toIndex) {
            if (fromIndex < 0 || fromIndex > delegate.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (toIndex < 0 || toIndex > delegate.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.delegate = delegate;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size > 0;
        }

        @Override
        public boolean contains(Object object) {
            int limit = this.offset + this.size;
            if (object == null) {
                for (int i = this.offset; i < limit; ++i) {
                    if (this.delegate.get(i) != null) continue;
                    return true;
                }
            } else {
                for (int i = this.offset; i < limit; ++i) {
                    if (!object.equals(this.delegate.get(i))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int index;
                private int limit;
                {
                    this.index = UnmodifiableFixedCollection.this.offset;
                    this.limit = UnmodifiableFixedCollection.this.offset + UnmodifiableFixedCollection.this.size;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.limit;
                }

                @Override
                public E next() {
                    if (this.index >= this.limit) {
                        throw new NoSuchElementException();
                    }
                    return UnmodifiableFixedCollection.this.delegate.get(this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size];
            int limit = this.offset + this.size;
            for (int i = this.offset; i < limit; ++i) {
                array[i] = this.delegate.get(i);
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (array.length != this.size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
            }
            int limit = this.offset + this.size;
            for (int i = this.offset; i < limit; ++i) {
                array[i] = this.delegate.get(i);
            }
            return array;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(E t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException(index + " > " + this.size);
            }
            return this.delegate.get(this.offset + index);
        }

        @Override
        public int indexOf(Object object) {
            int limit = this.offset + this.size;
            if (object == null) {
                for (int i = this.offset; i < limit; ++i) {
                    if (this.delegate.get(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = this.offset; i < limit; ++i) {
                    if (!object.equals(this.delegate.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            if (object == null) {
                for (int i = this.offset + this.size - 1; i >= this.offset; --i) {
                    if (this.delegate.get(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = this.offset + this.size - 1; i >= this.offset; --i) {
                    if (!object.equals(this.delegate.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ListIterator<E>(){
                private int index;
                private int limit;
                {
                    this.index = UnmodifiableFixedCollection.this.offset;
                    this.limit = UnmodifiableFixedCollection.this.offset + UnmodifiableFixedCollection.this.size;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.limit;
                }

                @Override
                public E next() {
                    if (this.index >= this.limit) {
                        throw new NoSuchElementException();
                    }
                    return UnmodifiableFixedCollection.this.delegate.get(this.index++);
                }

                @Override
                public boolean hasPrevious() {
                    return this.index > UnmodifiableFixedCollection.this.offset;
                }

                @Override
                public E previous() {
                    if (this.index <= UnmodifiableFixedCollection.this.offset) {
                        throw new NoSuchElementException();
                    }
                    return UnmodifiableFixedCollection.this.delegate.get(--this.index);
                }

                @Override
                public int nextIndex() {
                    return this.index - UnmodifiableFixedCollection.this.offset;
                }

                @Override
                public int previousIndex() {
                    return this.index - UnmodifiableFixedCollection.this.offset - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return null;
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableFixedCollection<E>(this.delegate, fromIndex, toIndex);
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }
    }
}

