/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public class DirectoryModelAdapter
extends ContainerModelAdapter {
    private ContentDirectory directory;
    private ContainerModelAdapter container;

    DirectoryModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, URL url, ContentDirectory element) {
        super(factory, type, workspace, project, directory, element, url);
        this.directory = element;
        ContainerModelAdapter containerModelAdapter = directory != null ? directory : (this.container = project != null ? project : workspace);
        assert (element != null);
    }

    @Override
    public URL getUrl() {
        return this.directory.getURL();
    }

    @Override
    public ContainerModelAdapter getContainingAdapter() {
        return this.container;
    }

    @Override
    public ContentDirectory getDirectory() {
        return this.directory;
    }

    @Override
    public Location[] getElementLocations(Element element) {
        if (!(element instanceof ContentDirectory) || this.getElement() == element) {
            return new Location[]{this.getLocation()};
        }
        return null;
    }

    @Override
    protected void collectContainedElements() {
        Iterator<Element> i = this.directory.getChildren();
        while (i.hasNext()) {
            Element element = i.next();
            this.addContainedElement(element, ((Locatable)element).getURL());
        }
    }

    @Override
    public int compareTo(Object object) {
        int thatDepth;
        if (object == null) {
            return 1;
        }
        if (this == object) {
            return 0;
        }
        ModelAdapter that = (ModelAdapter)object;
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        int comparison = DirectoryModelAdapter.compareSiblings(this.getWorkspaceAdapter(), that.getWorkspaceAdapter());
        if (comparison != 0) {
            return comparison;
        }
        comparison = DirectoryModelAdapter.compareSiblings(this.getProjectAdapter(), that.getProjectAdapter());
        if (comparison != 0) {
            return comparison;
        }
        ContainerModelAdapter thisDirectory = this;
        ContainerModelAdapter thatDirectory = that.getDirectoryAdapter();
        if (thatDirectory == null) {
            return 1;
        }
        int thisDepth = this.getDirectory().getDepth();
        if (thisDepth > (thatDepth = that.getDirectory().getDepth())) {
            for (int i = thisDepth; i > thatDepth; --i) {
                thisDirectory = ((ModelAdapter)thisDirectory).getContainingAdapter();
            }
            if (thisDirectory == thatDirectory) {
                return 1;
            }
        } else if (thatDepth > thisDepth) {
            for (int i = thatDepth; i > thisDepth; --i) {
                thatDirectory = thatDirectory.getContainingAdapter();
            }
            if (thisDirectory == thatDirectory) {
                return -1;
            }
        }
        ContainerModelAdapter thatParent;
        ContainerModelAdapter thisParent;
        while ((thisParent = ((ModelAdapter)thisDirectory).getContainingAdapter()) != (thatParent = thatDirectory.getContainingAdapter())) {
            thisDirectory = thisParent;
            thatDirectory = thatParent;
        }
        return DirectoryModelAdapter.compareSiblings(thisDirectory, thatDirectory);
    }

    @Override
    public boolean contains(ModelAdapter that) {
        int thatDepth;
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        if (this == that) {
            return true;
        }
        if (this.getWorkspaceAdapter() != that.getWorkspaceAdapter()) {
            return false;
        }
        if (this.getProjectAdapter() != that.getProjectAdapter()) {
            return false;
        }
        ContainerModelAdapter thatDirectory = that.getDirectoryAdapter();
        if (thatDirectory == null) {
            return false;
        }
        int thisDepth = this.getDirectory().getDepth();
        for (int i = thatDepth = that.getDirectory().getDepth(); i > thisDepth; --i) {
            thatDirectory = thatDirectory.getContainingAdapter();
        }
        return this == thatDirectory;
    }

    @Override
    public boolean contains(Object construct, Location location) {
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location;
        assert (this == construct);
        assert (this == location.getModel());
        return true;
    }

    @Override
    public String toString() {
        return (this.directory.getDepth() > 0 ? this.directory.getRelativePath() : "<root>") + " (" + this.directory.getContentSetKeys() + ")";
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public Object label(Object construct) {
        assert (construct == this.directory) : "construct " + construct;
        String label = this.getShortLabel();
        if ("".equals(label)) {
            label = label + " (" + URLFileSystem.getPlatformPathName((URL)this.directory.getURL()) + ")";
        }
        return label;
    }

    @Override
    public Object summary(Object construct) {
        assert (construct == this.directory) : "construct " + construct;
        return URLFileSystem.getPlatformPathName((URL)((ContentDirectory)construct).getURL());
    }

    @Override
    public Icon icon(Object construct) {
        assert (construct == this.directory) : "construct " + construct;
        if (this.directory.canContainJavaSources()) {
            return OracleIcons.getIcon((String)"package.png");
        }
        return OracleIcons.getIcon((String)"folder.png");
    }
}

