/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdevimpl.audit.core.DefaultProfile;
import oracle.jdevimpl.audit.profile.AuditProfilePane;
import oracle.jdevimpl.audit.profile.ProfileBundle;
import oracle.jdevimpl.audit.profile.ProfileComboBox;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.profile.ProfileTreeModel;
import oracle.jdevimpl.audit.report.AuditXmlReportDialog;
import oracle.jdevimpl.audit.report.ProfileXmlReporter;
import oracle.jdevimpl.audit.swing.DelegatingLayout;
import oracle.jdevimpl.audit.swing.DialogFactory;
import oracle.jdevimpl.audit.swing.MenuButton;
import oracle.jdevimpl.audit.swing.Resources;
import oracle.jdevimpl.audit.util.Cache;

public class AuditProfileDialog
implements ActionListener,
ChangeListener,
ListDataListener {
    private static final String PROFILE_HELP_ID = "f1_aud_profile_dlg_html";
    private static final String SAVEAS_DIALOG_HELP_TOPIC = "f1_aud_save_profile_html";
    private static final String IMPORTAS_DIALOG_HELP_TOPIC = "f1_aud_save_profile_html";
    private final ProfileModel model;
    private JComponent component;
    private Font selectorUnmodifiedFont;
    private Font selectorModifiedFont;
    private JComboBox selector;
    private JButton saveButton;
    private MenuButton moreButton;
    private JMenuItem revertButton;
    private JMenuItem resetButton;
    private JMenuItem deleteButton;
    private JMenuItem exportButton;
    private JMenuItem saveReportButton;
    private JMenuItem importButton;
    private JCheckBox sealedCheckBox;
    private Font sealedUnmodifiedFont;
    private Font sealedModifiedFont;
    private JTabbedPane tabbedPane;
    private DialogFactory dialog;
    private JButton dialogOkButton;
    private AuditProfilePane[] panes = new AuditProfilePane[4];
    private static final String IMPORT_EXPORT_DIRECTORY_KEY = "audit.profile.importexport.directory";
    private static final Log LOG = new Log("profile-pane");
    private static ProfileTreeModel.BeanKind[] PARTITIONS = new ProfileTreeModel.BeanKind[]{ProfileTreeModel.BeanKind.RULE, ProfileTreeModel.BeanKind.ASSIST, ProfileTreeModel.BeanKind.METRIC, ProfileTreeModel.BeanKind.SUPPRESSION_SCHEME};

    public AuditProfileDialog(ProfileModel model) {
        this.model = model;
    }

    public Profile show() {
        return this.show(null);
    }

    public Profile show(Component parent) {
        Profile profile;
        JButton command;
        Profile selection;
        if (this.component == null) {
            this.component = (JComponent)this.createComponent();
        }
        if ((selection = this.model.getSelectedItem()) == null) {
            selection = this.model.getProfile(null, "oracle.ide.audit.code-assist-rules");
        }
        this.model.setSelectedItem(selection);
        if (this.dialog == null) {
            this.dialog = new DialogFactory();
            this.dialog.setMinimumInitialSize(new Dimension(750, 500));
            this.dialog.setMinimumSize(new Dimension(600, 400));
            this.dialog.setTitle(ProfileBundle.get("audit.title"));
            this.dialog.setContent(this.component);
            this.dialog.setHelpTopic(PROFILE_HELP_ID);
            this.dialog.setInitialFocus(this.createSelectedPane(selection).getFocusComponent());
            this.dialogOkButton = this.dialog.addOkAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AuditProfileDialog.this.getSelectedPane().flush()) {
                        AuditProfileDialog.this.dialog.hide();
                    }
                }
            });
            this.dialog.addCancelButton(null);
            this.dialog.setDefaultButton(this.dialogOkButton);
        }
        if (this.dialogOkButton == (command = this.dialog.show(parent, this.dialog.getLastBounds()))) {
            this.apply();
            profile = this.model.getSelectedItem();
        } else {
            this.cancel();
            profile = null;
        }
        return profile;
    }

    private AuditProfilePane getSelectedPane() {
        return this.panes[this.tabbedPane.getSelectedIndex()];
    }

    private AuditProfilePane createSelectedPane(Profile profile) {
        int index = this.tabbedPane.getSelectedIndex();
        AuditProfilePane pane = this.panes[index];
        if (pane == null) {
            this.panes[index] = pane = new AuditProfilePane(this.model, PARTITIONS[index]);
            if (profile != null) {
                pane.setProfile(profile);
            }
            JPanel panel = (JPanel)this.tabbedPane.getSelectedComponent();
            panel.add(pane.getComponent());
        } else if (profile != null) {
            pane.setProfile(profile);
        }
        return pane;
    }

    private void apply() {
        LOG.trace("applying changes");
        this.getSelectedPane().flush();
        try {
            this.model.apply();
        }
        catch (IOException e) {
            oracle.jdevimpl.audit.swing.MessageDialog dialog = new oracle.jdevimpl.audit.swing.MessageDialog(oracle.jdevimpl.audit.swing.MessageDialog.ERROR);
            dialog.setTitle(ProfileBundle.get("apply.ioexception.title"));
            Profile profile = this.model.getSelectedItem();
            dialog.setContent(ProfileBundle.format("apply.ioexception.message", profile.getName(), URLFileSystem.getPlatformPathName((URL)profile.getURL()), e));
            dialog.setException(e);
            dialog.show();
        }
    }

    private void cancel() {
        LOG.trace("cancelling changes");
        this.model.cancel();
    }

    protected Component createComponent() {
        this.selector = new ProfileComboBox((ComboBoxModel)this.model);
        this.selector.setToolTipText(ProfileBundle.get("selector.tip"));
        this.selectorUnmodifiedFont = this.selector.getFont();
        this.selectorModifiedFont = this.selectorUnmodifiedFont.deriveFont(2);
        this.selector.setRenderer(new ProfileRenderer(this.selectorUnmodifiedFont, this.selectorModifiedFont));
        JLabel selectorLabel = Resources.labelFor(this.selector, ProfileBundle.get("selector.label"));
        this.saveButton = Resources.button(ProfileBundle.get("saveas.label"), ProfileBundle.get("saveas.tip"));
        this.revertButton = Resources.menuItem(ProfileBundle.get("revert.label"), ProfileBundle.get("revert.tip"));
        this.resetButton = Resources.menuItem(ProfileBundle.get("reset.label"), ProfileBundle.get("reset.tip"));
        this.deleteButton = Resources.menuItem(ProfileBundle.get("delete.label"), ProfileBundle.get("delete.tip"));
        this.exportButton = Resources.menuItem(ProfileBundle.get("export.label"), ProfileBundle.get("export.tip"));
        this.saveReportButton = Resources.menuItem(ProfileBundle.get("save-report.label"), ProfileBundle.get("save-report.tip"));
        this.importButton = Resources.menuItem(ProfileBundle.get("import.label"), ProfileBundle.get("import.tip"));
        this.moreButton = new MenuButton("", null, this.revertButton, this.resetButton, this.deleteButton, this.exportButton, this.saveReportButton, this.importButton);
        Resources.button(this.moreButton, ProfileBundle.get("more.label"), ProfileBundle.get("more.tip"));
        Dimension moreButtonSize = this.moreButton.getPreferredSize();
        this.moreButton.setMinimumSize(moreButtonSize);
        this.moreButton.setPreferredSize(moreButtonSize);
        this.moreButton.setMaximumSize(moreButtonSize);
        String sealedText = ProfileBundle.get("sealed.label");
        this.sealedCheckBox = Resources.checkBox(sealedText, ProfileBundle.get("sealed.tip"));
        this.sealedUnmodifiedFont = this.sealedCheckBox.getFont();
        this.sealedModifiedFont = this.sealedUnmodifiedFont.deriveFont(2);
        JPanel selectorButtonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        selectorButtonPanel.add((Component)selectorLabel, constraints);
        ++constraints.gridx;
        constraints.insets.left = 8;
        selectorButtonPanel.add((Component)this.selector, constraints);
        ++constraints.gridx;
        constraints.insets.left = 8;
        selectorButtonPanel.add((Component)this.saveButton, constraints);
        ++constraints.gridx;
        selectorButtonPanel.add((Component)this.moreButton, constraints);
        ++constraints.gridx;
        constraints.insets.left = 24;
        selectorButtonPanel.add((Component)this.sealedCheckBox, constraints);
        ++constraints.gridx;
        constraints.insets.left = 0;
        constraints.weightx = 1.0;
        selectorButtonPanel.add(Box.createHorizontalGlue(), constraints);
        ++constraints.gridx;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(ProfileBundle.get("rules.label"), this.createTabPanel());
        this.tabbedPane.addTab(ProfileBundle.get("assists.label"), this.createTabPanel());
        this.tabbedPane.addTab(ProfileBundle.get("metrics.label"), this.createTabPanel());
        this.tabbedPane.addTab(ProfileBundle.get("suppression-schemes.label"), this.createTabPanel());
        this.tabbedPane.addChangeListener(this);
        this.component = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.component.add((Component)selectorButtonPanel, constraints);
        ++constraints.gridy;
        constraints.insets.top = 16;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.component.add((Component)this.tabbedPane, constraints);
        ++constraints.gridy;
        this.resetComponents();
        this.saveButton.addActionListener(this);
        this.revertButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.saveReportButton.addActionListener(this);
        this.importButton.addActionListener(this);
        this.sealedCheckBox.addActionListener(this);
        this.model.addListDataListener(this);
        return this.component;
    }

    private JPanel createTabPanel() {
        JPanel panel = new JPanel(new DelegatingLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 0));
        return panel;
    }

    private void resetComponents() {
        Profile profile = this.model.getSelectedItem();
        boolean profileModified = this.model.isModified(profile);
        this.selector.setFont(profileModified ? this.selectorModifiedFont : this.selectorUnmodifiedFont);
        boolean isDefault = profile != null && profile.getId() != null;
        LOG.trace("resetting buttons on profile {1}, default {0}", isDefault, (Object)profile);
        this.revertButton.setEnabled(profileModified);
        if (this.resetButton != null) {
            this.resetButton.setEnabled(isDefault);
        }
        this.deleteButton.setEnabled(profile != null && !isDefault && this.model.getSize() > 1);
        this.saveReportButton.setEnabled(profile != null);
        this.exportButton.setEnabled(profile != null);
        this.sealedCheckBox.setEnabled(profile != null);
        this.sealedCheckBox.setSelected(profile != null && this.model.isSealed());
        boolean sealedModified = profile != null && profile.isSealed() != this.model.isSealed();
        this.sealedCheckBox.setFont(sealedModified ? this.sealedModifiedFont : this.sealedUnmodifiedFont);
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.resetComponents();
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.resetComponents();
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        if (event.getIndex0() == -1 || event.getIndex1() == -1) {
            Profile profile = this.model.getSelectedItem();
            LOG.trace("selected profile changed to {0}", (Object)profile);
            this.createSelectedPane(profile);
            this.resetComponents();
        }
        this.resetComponents();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() instanceof JTabbedPane) {
            LOG.trace("tab changed {0}", (Object)event);
            this.createSelectedPane(this.model.getSelectedItem());
        }
        this.resetComponents();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.saveButton) {
            this.saveAs();
        } else if (source == this.revertButton) {
            this.revert();
        } else if (source == this.resetButton) {
            this.restoreDefault();
        } else if (source == this.deleteButton) {
            this.delete();
        } else if (source == this.importButton) {
            this.importAs();
        } else if (source == this.saveReportButton) {
            this.saveReport();
        } else if (source == this.exportButton) {
            this.export();
        } else if (source == this.sealedCheckBox) {
            this.model.setSealed(this.sealedCheckBox.isSelected());
        } else {
            Log.error((String)"unexpected action source in event {0}", (Object)event);
        }
        this.resetComponents();
    }

    private void saveAs() {
        Profile profile = this.model.getSelectedItem();
        String name = this.promptForNewName(profile.getName(), "saveas.dialog.title", "saveas.dialog.name.label", "saveas.dialog.ok.label", "f1_aud_save_profile_html");
        if (name == null) {
            return;
        }
        Profile overwrittenProfile = this.model.getProfile(name);
        if (!(overwrittenProfile == null || this.model.isNew(overwrittenProfile) || name.equals(profile.getName()) || this.confirmOverwrite(name, overwrittenProfile.getName()))) {
            return;
        }
        try {
            this.model.saveAs(name, overwrittenProfile);
        }
        catch (IOException e) {
            oracle.jdevimpl.audit.swing.MessageDialog dialog = new oracle.jdevimpl.audit.swing.MessageDialog(oracle.jdevimpl.audit.swing.MessageDialog.ERROR);
            dialog.setTitle(ProfileBundle.get("saveas.ioexception.title"));
            dialog.setContent(ProfileBundle.format("saveas.ioexception.message", name, URLFileSystem.getPlatformPathName((URL)profile.getURL()), e));
            dialog.setException(e);
            dialog.show();
        }
    }

    private boolean confirmOverwrite(String name, String overwrittenName) {
        oracle.jdevimpl.audit.swing.MessageDialog confirmDialog = new oracle.jdevimpl.audit.swing.MessageDialog(oracle.jdevimpl.audit.swing.MessageDialog.WARNING);
        confirmDialog.setTitle(ProfileBundle.get("saveas.confirm.dialog.title"));
        String message = name.equals(overwrittenName) ? ProfileBundle.format("saveas.confirm.dialog.message", name) : ProfileBundle.format("saveas.case.confirm.dialog.message", overwrittenName, name);
        confirmDialog.setContent(message);
        String okLabel = ProfileBundle.get("saveas.confirm.dialog.ok.label");
        String cancelLabel = ProfileBundle.get("saveas.confirm.dialog.cancel.label");
        confirmDialog.setCommands(okLabel, cancelLabel);
        return confirmDialog.show(null) == okLabel;
    }

    private boolean confirmDelete(String name) {
        String key;
        MessageDialogPersistence cache = MessageDialog.getPersistence();
        if (!Boolean.TRUE.equals(cache.getConfirmed(key = this.getClass().getName() + "#confirmDelete"))) {
            boolean ok;
            oracle.jdevimpl.audit.swing.MessageDialog confirmDialog = new oracle.jdevimpl.audit.swing.MessageDialog(oracle.jdevimpl.audit.swing.MessageDialog.WARNING);
            confirmDialog.setTitle(ProfileBundle.get("delete.confirm.dialog.title"));
            String message = ProfileBundle.format("delete.confirm.dialog.message", name);
            JCheckBox skipCheckBox = new JCheckBox(ProfileBundle.get("skip-this.label"));
            Component spacer = Box.createRigidArea(new Dimension(250, 10));
            skipCheckBox.setToolTipText(ProfileBundle.get("skip-this.tip"));
            confirmDialog.setContent(message, spacer, skipCheckBox);
            String okLabel = ProfileBundle.get("delete.confirm.dialog.ok.label");
            String cancelLabel = ProfileBundle.get("delete.confirm.dialog.cancel.label");
            confirmDialog.setCommands(okLabel, cancelLabel);
            boolean bl = ok = confirmDialog.show(null) == okLabel;
            if (ok && skipCheckBox.isSelected()) {
                cache.setConfirmed(key, Boolean.valueOf(true));
            }
            return ok;
        }
        return true;
    }

    private String promptForNewName(String oldName, String titleKey, String nameLabelKey, String okLabelKey, String helpTopic) {
        JTextField nameField = new JTextField(oldName, 32);
        nameField.selectAll();
        JLabel label = Resources.labelFor(nameField, ProfileBundle.get(nameLabelKey));
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.right = 10;
        constraints.anchor = 17;
        content.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.insets.right = 0;
        content.add((Component)nameField, constraints);
        DialogFactory dialog = new DialogFactory();
        dialog.setTitle(ProfileBundle.get(titleKey));
        dialog.setContent(content);
        dialog.setResizable(false);
        JButton okButton = dialog.addOkButton(Resources.button(ProfileBundle.get(okLabelKey)));
        dialog.setDefaultButton(okButton);
        dialog.addCancelButton(null);
        new SaveAsListener(nameField.getDocument(), okButton);
        dialog.setHelpTopic(helpTopic);
        JButton button = dialog.show(this.component);
        String name = button == okButton ? nameField.getText().trim() : null;
        return name;
    }

    private void revert() {
        this.model.revert();
    }

    private void restoreDefault() {
        this.model.restoreDefaults();
    }

    private void delete() {
        Profile profile = this.model.getSelectedItem();
        if (this.confirmDelete(profile.getName())) {
            this.model.remove();
        }
    }

    private void importAs() {
        String oldName;
        LOG.trace("importing profile");
        URL directory = this.getDefaultImportExportDirectory();
        URLChooser chooser = DialogUtil.newURLChooser((URL)directory);
        DefaultURLFilter filter = new DefaultURLFilter(ProfileBundle.get("chooser.filter.xml.label"), ".xml");
        chooser.clearChooseableURLFilters();
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(ProfileBundle.get("chooser.filter.all.label")));
        chooser.setURLFilter((URLFilter)filter);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(0);
        int response = chooser.showOpenDialog((Component)this.component, ProfileBundle.get("import.dialog.title"));
        if (response != 0) {
            return;
        }
        URL url = chooser.getSelectedURL();
        Cache.put(IMPORT_EXPORT_DIRECTORY_KEY, URLFileSystem.getParent((URL)url));
        try {
            oldName = DefaultProfile.readName(url);
        }
        catch (IOException e) {
            oracle.jdevimpl.audit.swing.MessageDialog dialog = new oracle.jdevimpl.audit.swing.MessageDialog(oracle.jdevimpl.audit.swing.MessageDialog.ERROR);
            dialog.setTitle(ProfileBundle.get("importas.ioexception.title"));
            dialog.setContent(ProfileBundle.format("importas.ioexception.message", URLFileSystem.getPlatformPathName((URL)url), e));
            dialog.setException(e);
            dialog.show();
            return;
        }
        String name = this.promptForNewName(oldName, "importas.dialog.title", "importas.dialog.name.label", "importas.dialog.ok.label", "f1_aud_save_profile_html");
        if (name == null) {
            return;
        }
        Profile overwrittenProfile = this.model.getProfile(name);
        if (overwrittenProfile != null && !this.model.isNew(overwrittenProfile) && !this.confirmOverwrite(name, overwrittenProfile.getName())) {
            return;
        }
        try {
            this.model.importAs(url, name, overwrittenProfile);
        }
        catch (IOException e) {
            oracle.jdevimpl.audit.swing.MessageDialog dialog = new oracle.jdevimpl.audit.swing.MessageDialog(oracle.jdevimpl.audit.swing.MessageDialog.ERROR);
            dialog.setTitle(ProfileBundle.get("importas.ioexception.title"));
            dialog.setContent(ProfileBundle.format("importas.ioexception.message", URLFileSystem.getPlatformPathName((URL)url), e));
            dialog.setException(e);
            dialog.show();
        }
    }

    private void export() {
        Profile profile = this.model.getSelectedItem();
        LOG.trace("exporting profile {0}", (Object)profile);
        if (profile == null) {
            return;
        }
        URL directory = this.getDefaultImportExportDirectory();
        String name = ProfileRepository.sanitizeFileName(profile.getName());
        URL url = URLFactory.newURL((URL)directory, (String)name);
        URLChooser chooser = DialogUtil.newURLChooser((URL)url);
        DefaultURLFilter filter = new DefaultURLFilter(ProfileBundle.get("chooser.filter.xml.label"), ".xml");
        chooser.clearChooseableURLFilters();
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(ProfileBundle.get("chooser.filter.all.label")));
        chooser.setURLFilter((URLFilter)filter);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(0);
        int response = chooser.showSaveDialog((Component)this.component, ProfileBundle.get("export.dialog.title"));
        if (response == 0) {
            url = chooser.getSelectedURL();
            if ("".equals(URLFileSystem.getSuffix((URL)url))) {
                url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".xml");
            }
            Cache.put(IMPORT_EXPORT_DIRECTORY_KEY, URLFileSystem.getParent((URL)url));
            try {
                this.model.exportAs(url, profile.getName());
            }
            catch (IOException e) {
                oracle.jdevimpl.audit.swing.MessageDialog dialog = new oracle.jdevimpl.audit.swing.MessageDialog(oracle.jdevimpl.audit.swing.MessageDialog.ERROR);
                dialog.setTitle(ProfileBundle.get("export.ioexception.title"));
                dialog.setContent(ProfileBundle.format("export.ioexception.message", name, URLFileSystem.getPlatformPathName((URL)url), e));
                dialog.setException(e);
                dialog.show();
            }
        }
    }

    private void saveReport() {
        Profile profile = this.model.getSelectedItem();
        LOG.trace("saving pretty print profile {0}", (Object)profile);
        if (profile != null) {
            AuditXmlReportDialog<Profile> dialog = new AuditXmlReportDialog<Profile>(profile, new ProfileXmlReporter(), ProfileBundle.get("save-report.dialog.title"), ProfileBundle.format("save-report.default.title", profile.getName()), profile.getName(), "f1_profile_pretty_print_dlg_html", new Context());
            dialog.show();
        }
    }

    private URL getDefaultImportExportDirectory() {
        URL directory = (URL)Cache.get(IMPORT_EXPORT_DIRECTORY_KEY);
        if (directory == null || !URLFileSystem.exists((URL)directory)) {
            directory = URLFactory.newDirURL((String)System.getProperty("user.home"));
        }
        return directory;
    }

    private static class SaveAsListener
    implements DocumentListener {
        private Document document;
        private JButton button;

        public SaveAsListener(Document document, JButton ok) {
            this.document = document;
            this.button = ok;
            document.addDocumentListener(this);
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String text;
            try {
                text = this.document.getText(0, this.document.getLength()).trim();
            }
            catch (BadLocationException e1) {
                throw new UnexpectedExceptionError((Throwable)e1);
            }
            this.button.setEnabled(!text.isEmpty());
        }
    }

    private static class ProfileRenderer
    extends DefaultListCellRenderer {
        private final Font unmodifiedFont;
        private final Font modifiedFont;

        public ProfileRenderer(Font unmodifiedFont, Font modifiedFont) {
            this.unmodifiedFont = unmodifiedFont;
            this.modifiedFont = modifiedFont;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ProfileModel model = (ProfileModel)list.getModel();
            boolean modified = false;
            if (value instanceof Profile) {
                Profile profile = (Profile)value;
                value = profile.getName();
                modified = model.isModified(profile);
            }
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            component.setFont(modified ? this.modifiedFont : this.unmodifiedFont);
            return component;
        }
    }
}

