/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.report.AuditReporter;
import oracle.jdevimpl.audit.report.StyleSheet;
import oracle.jdevimpl.audit.report.XmlReporter;

public class XsltReporter<T>
implements AuditReporter {
    protected URL outputFile;
    protected XmlReporter<T> xmlReporter;
    protected URL intermediateFile;
    protected StyleSheet stylesheet;
    protected String title;
    protected String encoding = IdeUtil.getIdeIanaEncoding();
    private T model;
    private static final Log log = new Log("report");

    public void setEncoding(String encoding) {
        if (encoding == null) {
            encoding = IdeUtil.getIdeIanaEncoding();
        }
        this.encoding = encoding;
    }

    public void setOutputFile(URL file) {
        this.outputFile = file;
    }

    public void setXmlReporter(XmlReporter reporter) {
        this.xmlReporter = reporter;
    }

    public void setIntermediateFile(URL file) {
        this.intermediateFile = file;
    }

    public StyleSheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStyleSheet(StyleSheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public T getModel() {
        return this.model;
    }

    @Override
    public void report() throws InvocationTargetException {
        URL xmlFile;
        if (this.intermediateFile != null) {
            xmlFile = this.intermediateFile;
        } else {
            try {
                xmlFile = URLFileSystem.createTempFile((String)"audit", (String)".tmp", null);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        this.xmlReporter.setTitle(this.title);
        this.xmlReporter.setOutputFile(xmlFile);
        this.xmlReporter.setEncoding(this.encoding);
        this.xmlReporter.setModel(this.model);
        this.xmlReporter.report();
        BufferedInputStream input = null;
        OutputStream output = null;
        InputStream transform = null;
        boolean throwing = false;
        try {
            input = new BufferedInputStream(URLFileSystem.openInputStream((URL)xmlFile));
            transform = new BufferedInputStream(URLFileSystem.openInputStream((URL)this.stylesheet.getUrl()));
            output = this.outputFile != null ? new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.outputFile)) : new BufferedOutputStream(new StandardOutputStream());
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource xsl = new StreamSource(transform);
            Transformer transformer = factory.newTransformer(xsl);
            transformer.setErrorListener(new ThrowingErrorListener());
            StreamSource source = new StreamSource(input);
            source.setSystemId(xmlFile.toString());
            StreamResult result = new StreamResult(output);
            if (this.outputFile != null) {
                result.setSystemId(this.outputFile.toString());
            }
            transformer.setOutputProperty("encoding", this.encoding);
            transformer.setParameter("newline", XsltReporter.getLineBreakSequence());
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            log.trace("unexpected exception creating report {0}: {1}", (Object)this.outputFile, (Object)e);
            throwing = true;
            throw new InvocationTargetException(e);
        }
        finally {
            block35: {
                Node node;
                block34: {
                    block33: {
                        block32: {
                            try {
                                if (input != null) {
                                    ((InputStream)input).close();
                                }
                            }
                            catch (IOException e) {
                                if (throwing) break block32;
                                throw new InvocationTargetException(e);
                            }
                        }
                        try {
                            if (transform != null) {
                                transform.close();
                            }
                        }
                        catch (IOException e) {
                            if (throwing) break block33;
                            throw new InvocationTargetException(e);
                        }
                    }
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException e) {
                        if (throwing) break block34;
                        throw new InvocationTargetException(e);
                    }
                }
                if (this.intermediateFile == null) {
                    URLFileSystem.delete((URL)xmlFile);
                }
                if ((node = NodeFactory.find((URL)this.outputFile)) != null) {
                    try {
                        node.revert();
                    }
                    catch (IOException e) {
                        if (throwing) break block35;
                        throw new InvocationTargetException(e);
                    }
                }
            }
        }
    }

    protected static String getLineBreakSequence() {
        return Ide.getEnvironOptions().getLineBreakSequence();
    }

    protected static class ThrowingErrorListener
    implements ErrorListener {
        protected ThrowingErrorListener() {
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            throw e;
        }
    }

    protected static class StandardOutputStream
    extends PrintStream {
        public StandardOutputStream() {
            super(System.out, false);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

