/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.swing.CheckBoxTree;
import oracle.jdevimpl.audit.swing.CheckBoxTreeCellRenderer;
import oracle.jdevimpl.audit.swing.CheckBoxTreeModel;

public class CheckBoxTreeCellEditor
extends AbstractCellEditor
implements ActionListener,
TreeCellEditor {
    private static final Log LOG = new Log("checkboxtree");
    private final CheckBoxTreeCellRenderer renderer;
    private int checkBoxWidth = 0;
    private CheckBoxTree tree;

    public CheckBoxTreeCellEditor(CheckBoxTreeCellRenderer renderer) {
        this.renderer = renderer;
        renderer.addActionListener(this);
    }

    public void forwardKeyEvent(KeyEvent event) {
        this.renderer.forwardKeyEvent(event);
    }

    public CheckBoxTreeCellRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        LOG.trace("getting editor component for row {0}, value {1}", row, value);
        this.tree = (CheckBoxTree)tree;
        return this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, true);
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        LOG.trace("test cell editable for {0}", (Object)event);
        if (event instanceof MouseEvent) {
            int y;
            int x;
            JTree tree;
            Rectangle bounds;
            if (this.checkBoxWidth == 0) {
                this.checkBoxWidth = this.renderer.getCheckBoxWidth();
            }
            return (bounds = (tree = (JTree)event.getSource()).getPathBounds(tree.getPathForLocation(x = ((MouseEvent)event).getX(), y = ((MouseEvent)event).getY()))) != null && ((MouseEvent)event).getX() <= bounds.x + this.checkBoxWidth;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        boolean selected = this.renderer.isSelected();
        TreePath editingPath = this.tree.getEditingPath();
        LOG.trace("get editor value for {0}, state {1}", (Object)editingPath, (Object)selected);
        CheckBoxTreeModel model = (CheckBoxTreeModel)this.tree.getModel();
        model.stateForPathChanged(editingPath, selected);
        return editingPath.getLastPathComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CheckBoxTree tree = this.tree;
        TreePath editingPath = tree.getEditingPath();
        LOG.trace("handle editor action performed for {0}", editingPath.getLastPathComponent());
        this.stopCellEditing();
        if ((e.getModifiers() & 2) != 0) {
            tree.controlActionPerformed(editingPath);
        }
    }

    @Override
    public boolean stopCellEditing() {
        LOG.trace("stop editor");
        boolean result = super.stopCellEditing();
        this.tree = null;
        return result;
    }

    @Override
    public void cancelCellEditing() {
        LOG.trace("cancel editor");
        super.cancelCellEditing();
        this.tree = null;
    }

    public String toString() {
        return "Editor " + this.renderer;
    }
}

