/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.javatools.util.Log;

public class DropDownButton
extends JToggleButton
implements ChangeListener {
    private static final DropdownIcon DROPDOWN_ICON = new DropdownIcon();
    private JComponent popupComponent;
    private JWindow popupWindow;
    private static Log LOG = new Log("dropdown");

    public DropDownButton(Action action) {
        super(action);
        this.getModel().addChangeListener(this);
    }

    public DropDownButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.getModel().addChangeListener(this);
    }

    public JComponent getPopupComponent() {
        if (this.popupComponent == null) {
            this.popupComponent = this.createPopupComponent();
        }
        return this.popupComponent;
    }

    public void setPopupComponent(JComponent popupComponent) {
        this.popupComponent = popupComponent;
    }

    protected JComponent createPopupComponent() {
        return null;
    }

    protected void showPopup() {
        LOG.trace("showing popup");
        if (this.popupWindow == null) {
            this.popupWindow = this.createPopupWindow();
            new PopupListener(this.popupWindow);
            new InvokerListener(this);
        }
        if (this.popupWindow.isVisible()) {
            return;
        }
        Point location = this.getLocationOnScreen();
        location.y += this.getHeight();
        this.popupWindow.setLocation(location);
        this.popupWindow.show();
    }

    protected void hidePopup() {
        ButtonModel model = this.getModel();
        boolean selected = model.isSelected();
        if (selected) {
            model.setSelected(false);
            model.setPressed(false);
            model.setArmed(false);
        } else if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.hide();
        }
    }

    protected JWindow createPopupWindow() {
        JWindow window = new JWindow(SwingUtilities.getWindowAncestor(this));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(true);
        LookAndFeel.installBorder(panel, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(panel, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
        ComponentInputMap inputMap = new ComponentInputMap(panel);
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        SwingUtilities.replaceUIInputMap(panel, 2, inputMap);
        ActionMap actionMap = new ActionMap();
        actionMap.put("cancel", new CancelAction());
        SwingUtilities.replaceUIActionMap(panel, actionMap);
        panel.add(this.getPopupComponent());
        window.getContentPane().add(panel);
        window.pack();
        return window;
    }

    protected void popupClosed() {
        LOG.trace("handling popup hidden");
        this.getModel().setSelected(false);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ButtonModel model = this.getModel();
        boolean selected = model.isSelected();
        LOG.trace("getting state changed, pressed {0}, armed {1}, selected {2}", (Object)model.isPressed(), (Object)model.isArmed(), (Object)selected);
        if (selected) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += DROPDOWN_ICON.getIconWidth() + 1;
        return size;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int x = this.getWidth() - DROPDOWN_ICON.getIconWidth() - 3;
        int y = (this.getHeight() - DROPDOWN_ICON.getIconHeight()) / 2;
        DROPDOWN_ICON.paintIcon(this, g, x, y);
    }

    private static final class DropdownIcon
    extends Polygon
    implements Icon {
        private static final int SIZE = 4;

        public DropdownIcon() {
            this.addPoint(0, 0);
            this.addPoint(2, 2);
            this.addPoint(4, 0);
        }

        @Override
        public int getIconHeight() {
            return this.getBounds().height;
        }

        @Override
        public int getIconWidth() {
            return this.getBounds().width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                this.paint(g, x, y, c.getForeground());
            } else {
                this.paint(g, x, y, c.getBackground().darker());
            }
        }

        private void paint(Graphics g, int x, int y, Color color) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(color);
            g.fillPolygon(this);
            g.drawPolygon(this);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private class InvokerListener
    implements ComponentListener,
    MouseListener,
    WindowFocusListener,
    WindowListener {
        private AbstractButton button;

        public InvokerListener(AbstractButton button) {
            this.button = button;
            Window window = SwingUtilities.getWindowAncestor(button);
            window.addWindowListener(this);
            window.addWindowFocusListener(this);
            window.addComponentListener(this);
            window.addMouseListener(this);
            this.track(window);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void track(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Component glassPane = null;
                if (container instanceof JRootPane && ((glassPane = ((JRootPane)container).getGlassPane()).getMouseListeners().length > 0 || glassPane.getMouseMotionListeners().length > 0 || glassPane.getMouseWheelListeners().length > 0)) {
                    glassPane = null;
                }
                Component[] components = container.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    Component component = components[i];
                    if (component != glassPane) {
                        component.addMouseListener(this);
                    }
                    if (!(component instanceof Container)) continue;
                    this.track((Container)component);
                }
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            LOG.trace("window activated {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            LOG.trace("window closed {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LOG.trace("window closing {0}", (Object)e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            LOG.trace("window deactivated {0}", (Object)e);
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            LOG.trace("window deiconified {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            LOG.trace("window iconified {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            LOG.trace("window opened {0}", (Object)e);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            LOG.trace("window gained focus {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            LOG.trace("window lost focus {0}", (Object)e);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            LOG.trace("component hidden {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            LOG.trace("component moved {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            LOG.trace("component resized {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            LOG.trace("component shown {0}", (Object)e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LOG.trace("mouse released {0}", (Object)e);
            if (e.getSource() != this.button) {
                DropDownButton.this.hidePopup();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LOG.trace("mouse clicked {0}", (Object)e);
            if (e.getSource() != this.button) {
                DropDownButton.this.hidePopup();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LOG.trace("mouse pressed {0}", (Object)e);
            if (e.getSource() != this.button) {
                DropDownButton.this.hidePopup();
            }
        }
    }

    private class PopupListener
    implements ComponentListener,
    MouseListener,
    WindowFocusListener,
    WindowListener {
        public PopupListener(Window window) {
            window.addWindowListener(this);
            window.addWindowFocusListener(this);
            window.addComponentListener(this);
            window.addMouseListener(this);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            LOG.trace("popup activated {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            LOG.trace("popup closed {0}", (Object)e);
            DropDownButton.this.popupClosed();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LOG.trace("popup closing {0}", (Object)e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            LOG.trace("popup deactivated {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            LOG.trace("popup deiconified {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            LOG.trace("popup iconified {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            LOG.trace("popup opened {0}", (Object)e);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            LOG.trace("popup gained focus {0}", (Object)e);
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            LOG.trace("popup lost focus {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            LOG.trace("popup hidden {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            LOG.trace("popup moved {0}", (Object)e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            LOG.trace("popup resized {0}", (Object)e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            LOG.trace("popup shown {0}", (Object)e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LOG.trace("popup mouse released {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LOG.trace("popup mouse clicked {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            LOG.trace("popup mouse entered {0}", (Object)e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LOG.trace("popup mouse exited {0}", (Object)e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LOG.trace("popup mouse pressed {0}", (Object)e);
            DropDownButton.this.hidePopup();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DropDownButton.this.hidePopup();
        }
    }
}

