/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import oracle.javatools.ui.ExpansionTip;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.swing.FocusBorder;

public class LabelTextArea
extends JTextArea {
    private Log LOG = new Log("label");

    public LabelTextArea() {
        this((String)null);
    }

    public LabelTextArea(String text) {
        super(text);
        this.setEditable(false);
        this.setFocusable(true);
        this.setOpaque(false);
        this.setFont(UIManager.getFont("Label.font"));
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("Label.background"));
        this.setBorder(new FocusBorder(this));
        ExpansionTip.attach((JTextArea)this);
    }

    public void setFontStyle(int style) {
        this.setFont(this.getFont().deriveFont(style));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (bounds.width > 0 && bounds.height > 0 && bounds.width < this.getPreferredSize().width) {
            Insets insets = this.getInsets();
            Font font = this.getFont();
            FontMetrics metrics = this.getFontMetrics(font);
            int ascent = metrics.getAscent();
            String ellipsis = (font.canDisplay('\u202f') ? (char)'\u202f' : ' ') + (font.canDisplay('\u2026') ? "\u2026" : "...");
            int ellipsisWidth = metrics.stringWidth(ellipsis);
            int ellipsisLimit = bounds.width - ellipsisWidth - insets.right;
            int offset = this.viewToModel(new Point(ellipsisLimit, ascent));
            try {
                int ellipsisActual = this.modelToView((int)offset).x;
                if (ellipsisActual > ellipsisLimit) {
                    ellipsisActual = this.modelToView((int)(--offset)).x;
                }
                Rectangle clip = g.getClipBounds();
                Rectangle leftClip = new Rectangle(clip.x, clip.y, ellipsisActual - clip.x, clip.height);
                g.setClip(leftClip);
                super.paintComponent(g);
                g.setClip(clip);
                Color color = g.getColor();
                int selection0 = this.getSelectionStart();
                int selection1 = this.getSelectionEnd();
                boolean selected = selection0 <= offset && offset < selection1;
                g.setColor(selected ? this.getSelectedTextColor() : this.getForeground());
                g.drawString(ellipsis, ellipsisActual, insets.top + ascent);
                g.setColor(color);
                return;
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        super.paintComponent(g);
    }
}

