/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import oracle.javatools.icons.OracleIcons;

public class MenuButton
extends JToggleButton
implements MenuElement {
    private JPopupMenu popupMenu;
    private JMenuItem[] menuItems;
    private transient Tracker tracker = new Tracker();
    private transient Dimension preferredSize = new Dimension();
    private transient Icon dropDownArrowIcon;
    private transient Icon disabledDropDownArrowIcon;
    private static final int TEXT_DROPDOWN_ICON_GAP = 2;

    public MenuButton(Action action, JMenuItem ... menuItems) {
        this.configure(menuItems);
        this.setAction(action);
    }

    public MenuButton(String text, Icon icon, JMenuItem ... menuItems) {
        super(text, icon);
        this.configure(menuItems);
    }

    private void configure(JMenuItem[] menuItems) {
        this.menuItems = menuItems;
        this.setHorizontalAlignment(10);
        MenuButtonModel model = new MenuButtonModel();
        this.setModel(model);
        model.addItemListener(this.tracker);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.setInvoker(this);
        for (JMenuItem item : this.menuItems) {
            menu.add(item);
        }
        menu.addPropertyChangeListener("visible", this.tracker);
        menu.addMenuKeyListener(this.tracker);
        return menu;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        return this.popupMenu;
    }

    protected void showPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        if (this.popupMenu.isVisible()) {
            return;
        }
        this.popupMenu.pack();
        Point location = this.getLocationOnScreen();
        location.y += this.getHeight();
        this.popupMenu.show(this, 0, this.getHeight());
    }

    protected void hidePopupMenu() {
        if (this.isSelected()) {
            this.setSelected(false);
        } else if (this.popupMenu != null && this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
    }

    protected boolean isPopupVisible() {
        return this.popupMenu != null && this.popupMenu.isVisible();
    }

    public int getMenuComponentCount() {
        return this.popupMenu != null ? this.popupMenu.getComponentCount() : 0;
    }

    public Component getMenuComponent(int index) {
        return this.popupMenu != null ? this.popupMenu.getComponent(index) : null;
    }

    public JMenuItem getMenuItem(int index) {
        Component component = this.getMenuComponent(index);
        return component instanceof JMenuItem ? (JMenuItem)component : null;
    }

    public Component[] getMenuComponents() {
        return this.popupMenu != null ? this.popupMenu.getComponents() : new Component[]{};
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        this.setSelected(isIncluded);
    }

    @Override
    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        return new MenuElement[]{this.popupMenu};
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (this.tracker.popupCancelling()) {
            e.consume();
        } else if (e.getID() == 501 && !this.isPopupVisible() && !this.hasFocus()) {
            this.requestFocus();
            super.processMouseEvent(e);
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int width = size.width + this.getDropDownArrowIcon().getIconWidth() + 2;
        if (this.preferredSize.width != width || this.preferredSize.height != size.height) {
            this.preferredSize = new Dimension(width, size.height);
        }
        return this.preferredSize;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Icon icon = this.getDropDownArrowIcon();
        Insets insets = this.getInsets();
        int x = this.getWidth() - insets.right - icon.getIconWidth();
        int y = (this.getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(this, g, x, y);
    }

    private Icon getDropDownArrowIcon() {
        if (this.isEnabled()) {
            if (this.dropDownArrowIcon == null) {
                this.dropDownArrowIcon = OracleIcons.getIcon((String)"extras/dropdown.png");
            }
            return this.dropDownArrowIcon;
        }
        if (this.disabledDropDownArrowIcon == null) {
            this.disabledDropDownArrowIcon = OracleIcons.getIcon((String)"extras/dropdown_gray.png");
        }
        return this.disabledDropDownArrowIcon;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMenuButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMenuButton
    extends AbstractButton.AccessibleAbstractButton
    implements AccessibleSelection,
    ChangeListener {
        private boolean isArmed;
        private boolean hasFocus;
        private boolean isPressed;
        private boolean isSelected;

        public AccessibleMenuButton() {
            super(MenuButton.this);
            this.isArmed = false;
            this.hasFocus = false;
            this.isPressed = false;
            this.isSelected = false;
            MenuButton.this.addChangeListener(this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            Component[] children = MenuButton.this.getMenuComponents();
            int count = 0;
            for (Component child : children) {
                if (!(child instanceof Accessible)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            Component[] children = MenuButton.this.getMenuComponents();
            int count = 0;
            for (Component child : children) {
                if (!(child instanceof Accessible)) continue;
                if (count == i) {
                    if (child instanceof JComponent) {
                        AccessibleContext ac = child.getAccessibleContext();
                        ac.setAccessibleParent(MenuButton.this);
                    }
                    return (Accessible)((Object)child);
                }
                ++count;
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                for (int i = 0; i < me.length; ++i) {
                    if (me[i] != MenuButton.this || i + 1 >= me.length) continue;
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (i < 0 || i >= MenuButton.this.getMenuComponentCount()) {
                return null;
            }
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                for (int j = 0; j < me.length; ++j) {
                    if (me[j] != MenuButton.this) continue;
                    while (++j < me.length) {
                        if (!(me[j] instanceof JMenuItem)) continue;
                        return (Accessible)((Object)me[j]);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                JMenuItem mi = MenuButton.this.getMenuItem(i);
                for (int j = 0; j < me.length; ++j) {
                    if (me[j] != mi) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int i) {
            if (i < 0 || i >= MenuButton.this.getMenuComponentCount()) {
                return;
            }
            JMenuItem mi = MenuButton.this.getMenuItem(i);
            if (mi != null) {
                if (mi instanceof JMenu) {
                    MenuElement[] me = this.buildMenuElementArray((JMenu)mi);
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                } else {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            if (i < 0 || i >= MenuButton.this.getMenuComponentCount()) {
                return;
            }
            JMenuItem mi = MenuButton.this.getMenuItem(i);
            if (mi instanceof JMenu && mi.isSelected()) {
                MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] me = new MenuElement[old.length - 2];
                for (int j = 0; j < old.length - 2; ++j) {
                    me[j] = old[j];
                }
                MenuSelectionManager.defaultManager().setSelectedPath(me);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
            if (old != null) {
                for (int j = 0; j < old.length; ++j) {
                    if (old[j] != MenuButton.this) continue;
                    MenuElement[] me = new MenuElement[j + 1];
                    System.arraycopy(old, 0, me, 0, j);
                    me[j] = MenuButton.this.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                }
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
        }

        private MenuElement[] buildMenuElementArray(JMenu leaf) {
            Vector<JComponent> elements = new Vector<JComponent>();
            Component current = leaf.getPopupMenu();
            while (true) {
                if (current instanceof JPopupMenu) {
                    JPopupMenu popup = current;
                    elements.insertElementAt(popup, 0);
                    current = popup.getInvoker();
                    continue;
                }
                if (!(current instanceof MenuButton)) continue;
                MenuButton button = (MenuButton)current;
                elements.insertElementAt(button, 0);
                current = button.getParent();
            }
        }

        private void fireAccessibilityFocusedEvent(MenuButton toCheck) {
            MenuElement menuItem;
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 0 && toCheck == (menuItem = path[path.length - 1])) {
                this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
            if (MenuButton.this.getModel().isArmed()) {
                if (!this.isArmed) {
                    this.isArmed = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
                    this.fireAccessibilityFocusedEvent(MenuButton.this);
                }
            } else if (this.isArmed) {
                this.isArmed = false;
                this.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
            }
            if (MenuButton.this.isFocusOwner()) {
                if (!this.hasFocus) {
                    this.hasFocus = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            } else if (this.hasFocus) {
                this.hasFocus = false;
                this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
            if (MenuButton.this.getModel().isPressed()) {
                if (!this.isPressed) {
                    this.isPressed = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.PRESSED);
                }
            } else if (this.isPressed) {
                this.isPressed = false;
                this.firePropertyChange("AccessibleState", AccessibleState.PRESSED, null);
            }
            if (MenuButton.this.isSelected()) {
                if (!this.isSelected) {
                    this.isSelected = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                    this.fireAccessibilityFocusedEvent(MenuButton.this);
                }
            } else if (this.isSelected) {
                this.isSelected = false;
                this.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
            }
        }
    }

    private static class MenuButtonModel
    extends JToggleButton.ToggleButtonModel {
        private MenuButtonModel() {
        }

        @Override
        public void setArmed(boolean armed) {
            if (this.isArmed() == armed || !this.isEnabled()) {
                return;
            }
            if (!armed && this.isPressed() || this.isSelected()) {
                return;
            }
            super.setArmed(armed);
            if (armed) {
                this.setPressed(true);
            }
        }

        @Override
        public void setPressed(boolean pressed) {
            if (this.isPressed() == pressed || !this.isEnabled()) {
                return;
            }
            if (!pressed && this.isSelected()) {
                return;
            }
            if (pressed) {
                this.setArmed(true);
            }
            this.stateMask = pressed ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (pressed) {
                this.setSelected(true);
            } else {
                this.setArmed(false);
            }
        }

        @Override
        public void setSelected(boolean selected) {
            if (this.isSelected() == selected || !this.isEnabled()) {
                return;
            }
            if (selected) {
                this.setPressed(true);
            }
            super.setSelected(selected);
            if (!selected) {
                this.setPressed(false);
            }
        }
    }

    private class Tracker
    implements ItemListener,
    PropertyChangeListener,
    MenuKeyListener {
        private boolean cancelling;

        private Tracker() {
        }

        public boolean popupCancelling() {
            return this.cancelling;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (MenuButton.this.isSelected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuButton.this.showPopupMenu();
                    }
                });
            } else {
                MenuButton.this.hidePopupMenu();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean visible = (Boolean)e.getNewValue();
            if (visible) {
                this.cancelling = false;
            } else {
                this.cancelling = true;
                MenuButton.this.setSelected(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Tracker.this.cancelling = false;
                    }
                });
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            if (e.getKeyCode() == 27) {
                MenuButton.this.hidePopupMenu();
                e.consume();
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }
    }
}

