/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;

public class Resources {
    private Resources() {
    }

    public static JLabel label(String text) {
        return Resources.label(text, null, 10);
    }

    public static JLabel label(String text, Icon icon) {
        return Resources.label(text, icon, 10);
    }

    public static JLabel label(String text, Icon icon, int horizontalAlignment) {
        JLabel label = new JLabel(Resources.text(text), icon, horizontalAlignment);
        label.setDisplayedMnemonic(Resources.key(text));
        label.setDisplayedMnemonicIndex(Resources.index(text));
        return label;
    }

    public static JLabel label(JLabel label, String text) {
        label.setText(Resources.text(text));
        label.setDisplayedMnemonic(Resources.key(text));
        label.setDisplayedMnemonicIndex(Resources.index(text));
        return label;
    }

    public static JLabel labelFor(Component component, String text) {
        return Resources.labelFor(component, text, null, 10);
    }

    public static JLabel labelFor(JComponent component, String text, String tip) {
        return Resources.labelFor(component, text, null, 10, tip);
    }

    public static JLabel labelFor(Component component, String text, Icon icon, int horizontalAlignment) {
        JLabel label = new JLabel(Resources.text(text), icon, horizontalAlignment);
        label.setDisplayedMnemonic(Resources.key(text));
        label.setDisplayedMnemonicIndex(Resources.index(text));
        label.setLabelFor(component);
        return label;
    }

    public static JLabel labelFor(JComponent component, String text, Icon icon, int horizontalAlignment, String tip) {
        JLabel label = Resources.labelFor(component, text, icon, horizontalAlignment);
        component.setToolTipText(tip);
        return label;
    }

    public static JButton button(String text) {
        return Resources.button(text, null, null);
    }

    public static JButton button(String text, String tip) {
        return Resources.button(text, null, tip);
    }

    public static JButton button(String text, Icon icon) {
        return Resources.button(text, icon, null);
    }

    public static JButton button(String text, Icon icon, String tip) {
        JButton button = new JButton(Resources.text(text), icon);
        button.setMnemonic(Resources.key(text));
        button.setDisplayedMnemonicIndex(Resources.index(text));
        button.setToolTipText(tip);
        return button;
    }

    public static JToggleButton toggleButton(String text) {
        return Resources.toggleButton(text, null, false, null);
    }

    public static JToggleButton toggleButton(String text, String tip) {
        return Resources.toggleButton(text, null, false, tip);
    }

    public static JToggleButton toggleButton(String text, boolean selected) {
        return Resources.toggleButton(text, null, selected, null);
    }

    public static JToggleButton toggleButton(String text, boolean selected, String tip) {
        return Resources.toggleButton(text, null, selected, tip);
    }

    public static JToggleButton toggleButton(String text, Icon icon) {
        return Resources.toggleButton(text, icon, false, null);
    }

    public static JToggleButton toggleButton(String text, Icon icon, String tip) {
        return Resources.toggleButton(text, icon, false, tip);
    }

    public static JToggleButton toggleButton(String text, Icon icon, boolean selected) {
        return Resources.toggleButton(text, icon, selected, null);
    }

    public static JToggleButton toggleButton(String text, Icon icon, boolean selected, String tip) {
        JToggleButton button = new JToggleButton(Resources.text(text), icon, selected);
        button.setMnemonic(Resources.key(text));
        button.setDisplayedMnemonicIndex(Resources.index(text));
        button.setToolTipText(tip);
        return button;
    }

    public static JCheckBox checkBox(String text) {
        return Resources.checkBox(text, null, false, null);
    }

    public static JCheckBox checkBox(String text, String tip) {
        return Resources.checkBox(text, null, false, tip);
    }

    public static JCheckBox checkBox(String text, boolean selected) {
        return Resources.checkBox(text, null, selected, null);
    }

    public static JCheckBox checkBox(String text, boolean selected, String tip) {
        return Resources.checkBox(text, null, selected, tip);
    }

    public static JCheckBox checkBox(String text, Icon icon, boolean selected) {
        return Resources.checkBox(text, icon, selected, null);
    }

    public static JCheckBox checkBox(String text, Icon icon, boolean selected, String tip) {
        JCheckBox checkBox = new JCheckBox(Resources.text(text), icon, selected);
        checkBox.setMnemonic(Resources.key(text));
        checkBox.setDisplayedMnemonicIndex(Resources.index(text));
        checkBox.setToolTipText(tip);
        return checkBox;
    }

    public static JMenuItem menuItem(String text) {
        return Resources.menuItem(text, null, null);
    }

    public static JMenuItem menuItem(String text, String tip) {
        return Resources.menuItem(text, null, tip);
    }

    public static JMenuItem menuItem(String text, Icon icon) {
        return Resources.menuItem(text, icon, null);
    }

    public static JMenuItem menuItem(String text, Icon icon, String tip) {
        JMenuItem menuItem = new JMenuItem(Resources.text(text), icon);
        menuItem.setMnemonic(Resources.key(text));
        menuItem.setDisplayedMnemonicIndex(Resources.index(text));
        menuItem.setToolTipText(tip);
        return menuItem;
    }

    public static <T extends AbstractButton> T button(T button, String text) {
        return Resources.button(button, text, null);
    }

    public static <T extends AbstractButton> T button(T button, String text, String tip) {
        button.setText(Resources.text(text));
        button.setMnemonic(Resources.key(text));
        button.setDisplayedMnemonicIndex(Resources.index(text));
        button.setToolTipText(tip);
        return button;
    }

    private static String text(String text) {
        int index = text.indexOf(38);
        if (index >= 0) {
            text = text.substring(0, index) + text.substring(index + 1);
        }
        if (text.endsWith("...")) {
            text = text.substring(0, text.length() - 3) + '\u2026';
        }
        return text;
    }

    private static int key(String text) {
        int index = text.indexOf(38);
        if (index < 0) {
            return 0;
        }
        char c = text.charAt(index + 1);
        return c;
    }

    private static int index(String text) {
        return text.indexOf(38);
    }
}

