/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.traversal.ConcreteTreeTraversalTreeWalker;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.NodeFilterTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversalNodeIterator;
import oracle.bali.xml.dom.util.ArrayNodeList;
import oracle.bali.xml.dom.util.EmptyNodeList;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.sax.StringCaptureXmlFilter;
import oracle.bali.xml.sax.TreeWalkerXmlReader;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomUtils {
    public static final String DOM_SUBTREE_MODIFIED_EVENT_TYPE = "DOMSubtreeModified";
    public static final String DOM_NODE_INSERTED_EVENT_TYPE = "DOMNodeInserted";
    public static final String DOM_NODE_REMOVED_EVENT_TYPE = "DOMNodeRemoved";
    public static final String DOM_ATTR_MODIFIED_EVENT_TYPE = "DOMAttrModified";
    public static final String DOM_CHARACTER_DATA_MODIFIED_EVENT_TYPE = "DOMCharacterDataModified";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA_LOCATION_ATTR = "schemaLocation";
    public static final String NO_NAMESPACE_ATTR = "noNamespaceSchemaLocation";
    public static final String TYPE_ATTR = "type";
    private static volatile Document _sScratchDocument = null;
    private static final Object _sScratchDocumentLock = new Object();
    private static final NamedNodeMap _EMPTY_NODE_MAP = new EmptyNamedNodeMap();

    public static QualifiedName getQualifiedName(Node node) {
        if (node == null) {
            return null;
        }
        return QualifiedName.getQualifiedName(node.getNamespaceURI(), DomUtils.getLocalName(node));
    }

    public static boolean isAllNodeType(Collection<? extends Node> nodes, int type) {
        for (Node node : nodes) {
            if (DomUtils.isNodeType(node, type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNodeType(Node node, int type) {
        return node != null && node.getNodeType() == type;
    }

    public static boolean isAttribute(Node node) {
        return DomUtils.isNodeType(node, 2);
    }

    public static boolean isText(Node node) {
        return DomUtils.isNodeType(node, 3);
    }

    public static boolean isElement(Node node) {
        return DomUtils.isNodeType(node, 1);
    }

    public static boolean isDocument(Node node) {
        return DomUtils.isNodeType(node, 9);
    }

    public static Element asElement(Node node) {
        return DomUtils.isElement(node) ? (Element)node : null;
    }

    public static void setAttribute(Element ownerElement, String namespaceURI, String localName, String value) {
        DomUtils.setAttribute(ownerElement, namespaceURI, localName, value, "ns");
    }

    public static void setAttribute(Element ownerElement, String namespaceURI, String localName, String value, String preferredPrefix) {
        DomUtils.setAttribute(ownerElement, namespaceURI, localName, value, preferredPrefix, ownerElement.getOwnerDocument().getDocumentElement());
    }

    public static void setAttribute(Element ownerElement, String namespaceURI, String localName, String value, String preferredPrefix, Element rootElement) {
        DomUtils.setAttribute(ownerElement, namespaceURI, localName, value, preferredPrefix, rootElement, ownerElement);
    }

    public static void setAttribute(Element ownerElement, String namespaceURI, String localName, String value, String preferredPrefix, Element rootElement, Element searchElement) {
        String qName = localName;
        if (namespaceURI != null) {
            if (namespaceURI.length() == 0) {
                namespaceURI = null;
            } else if (!XMLNS_NAMESPACE_URI.equals(namespaceURI)) {
                String prefix = namespaceURI.equals(DomUtils.lookupNamespacePrefix(preferredPrefix, searchElement)) ? preferredPrefix : DomUtils._lookupNamespacePrefix(DocumentTreeTraversal.INSTANCE, namespaceURI, searchElement, searchElement, false);
                if (prefix == null) {
                    int i = 0;
                    do {
                        prefix = i == 0 ? preferredPrefix : preferredPrefix + i;
                        ++i;
                    } while (DomUtils.lookupNamespacePrefix(prefix, searchElement) != null);
                    DomUtils.addXmlns(rootElement, prefix, namespaceURI);
                }
                qName = prefix + ":" + localName;
            }
        }
        ownerElement.setAttributeNS(namespaceURI, qName, value);
    }

    public static Attr getAttribute(Element element, QualifiedName qname) {
        return element.getAttributeNodeNS(qname.getNamespace(), qname.getName());
    }

    public static int getAttributeCount(Node node) {
        if (node == null) {
            return 0;
        }
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return 0;
        }
        return attrs.getLength();
    }

    public static Attr removeAttribute(Element element, QualifiedName qname) {
        Attr a = DomUtils.getAttribute(element, qname);
        if (a != null) {
            element.removeAttributeNode(a);
        }
        return a;
    }

    public static final String getTextNodeValue(Node node) {
        if (node.hasChildNodes()) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue();
            }
        }
        return null;
    }

    public static final void setTextNodeValue(Node node, String value) {
        Node textNode = null;
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) continue;
                textNode = child;
                break;
            }
        }
        if (textNode == null) {
            textNode = node.getOwnerDocument().createTextNode(value);
            node.appendChild(textNode);
        }
        textNode.setNodeValue(value);
    }

    public static final String getTextContent(Node node) {
        boolean bFound = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeValue;
            if (child.getNodeType() != 3 && child.getNodeType() != 4 || (nodeValue = child.getNodeValue()) == null) continue;
            stringBuffer.append(nodeValue);
            bFound = true;
        }
        if (bFound) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static final void setTextContent(Node node, String value, boolean prefersCDATA) {
        String oldValue = DomUtils.getTextContent(node);
        if (value == oldValue || value != null && value.equals(oldValue)) {
            return;
        }
        Document document = node.getOwnerDocument();
        Node lastExistingChild = null;
        for (Node child = node.getLastChild(); child != null; child = child.getPreviousSibling()) {
            Node currChild = child;
            if (!DomUtils.isText(currChild) && currChild.getNodeType() != 4) continue;
            if (lastExistingChild == null) {
                lastExistingChild = currChild;
                continue;
            }
            node.removeChild(currChild);
        }
        if (lastExistingChild != null) {
            lastExistingChild.setNodeValue(value);
        } else {
            Text text = prefersCDATA ? document.createCDATASection(value) : document.createTextNode(value);
            node.appendChild(text);
        }
    }

    public static final void removeTextContent(Node node) {
        for (Node child = node.getLastChild(); child != null; child = child.getPreviousSibling()) {
            Node currChild = child;
            if (!DomUtils.isText(currChild) && currChild.getNodeType() != 4) continue;
            node.removeChild(currChild);
        }
    }

    public static void setNamedChildValue(Node parent, String childNamespace, String childName, String value) {
        Node child = DomUtils.getNamedChild(parent, childNamespace, childName);
        if (child == null) {
            child = DomUtils.createNode(parent, childNamespace, childName, value);
            parent.appendChild(child);
        } else {
            DomUtils.setTextNodeValue(child, value);
        }
    }

    public static Node createNode(Node parent, String childNamespace, String elementName, String textValue) {
        Document ownerDocument = DomUtils.getOwnerDocument(parent);
        Element e = ownerDocument.createElementNS(childNamespace, elementName);
        if (textValue != null) {
            Text t = ownerDocument.createTextNode(textValue);
            e.appendChild(t);
        }
        return e;
    }

    public static final boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public static void addXmlns(Element ownerElement, String prefix, String uri) {
        ownerElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + prefix, uri);
    }

    public static String getLocalName(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    if (node.getNamespaceURI() == null) {
                        return node.getNodeName();
                    }
                    return node.getLocalName();
                }
            }
        }
        return null;
    }

    public static DomPosition getPositionFromComparator(Node parent, Node newChild, Comparator comparator) {
        if (parent == null || newChild == null) {
            return null;
        }
        if (!parent.hasChildNodes()) {
            return DomPositionFactory.inside(parent);
        }
        if (comparator == null) {
            return null;
        }
        NodeList existingNodeList = parent.getChildNodes();
        int numOldChildren = existingNodeList.getLength();
        Node[] existingChildren = new Node[numOldChildren];
        for (int i = 0; i < numOldChildren; ++i) {
            existingChildren[i] = existingNodeList.item(i);
        }
        Arrays.sort(existingChildren, comparator);
        int searchResult = Arrays.binarySearch(existingChildren, newChild, comparator);
        if (searchResult >= 0) {
            return DomPositionFactory.after(existingChildren[searchResult]);
        }
        int insertionIndex = -(searchResult + 1);
        if (insertionIndex >= numOldChildren) {
            return DomPositionFactory.inside(parent);
        }
        return DomPositionFactory.before(existingChildren[insertionIndex]);
    }

    public static void insertNodeAtPosition(DomPosition position, Node node) {
        if (position.hasAttributeQName() || position.hasTextOffset()) {
            throw new IllegalArgumentException("position had attr qname or text offset!");
        }
        Node target = position.getTargetNode();
        if (position.isInside()) {
            target.appendChild(node);
        } else {
            Node parent = target.getParentNode();
            Node refChild = position.isBefore() ? target : target.getNextSibling();
            parent.insertBefore(node, refChild);
        }
    }

    public static void insertChildAtIndex(Node newChild, Node parent, int index) {
        Node nextSibling = DomUtils.getChildAtIndex(parent, index);
        parent.insertBefore(newChild, nextSibling);
    }

    public static Node insertAfter(Node newChild, Node refChild) {
        Node parentNode = refChild.getParentNode();
        Node nextSibling = refChild.getNextSibling();
        return parentNode.insertBefore(newChild, nextSibling);
    }

    public static boolean isNodeOrDescendant(Node possibleDescendant, Node possibleAncestor) {
        return DomUtils.isNodeOrDescendant(DocumentTreeTraversal.INSTANCE, possibleDescendant, possibleAncestor);
    }

    public static boolean isNodeOrDescendant(TreeTraversal traversal, Node possibleDescendant, Node possibleAncestor) {
        if (possibleDescendant == possibleAncestor && possibleDescendant != null) {
            return true;
        }
        return DomUtils.isDescendant(traversal, possibleDescendant, possibleAncestor);
    }

    public static boolean isDescendant(TreeTraversal traversal, Node possibleDescendant, Node possibleAncestor) {
        Document ancestorDocument;
        if (possibleDescendant == null || possibleAncestor == null) {
            return false;
        }
        Document descendantDocument = DomUtils.getOwnerDocument(possibleDescendant);
        if (descendantDocument != (ancestorDocument = DomUtils.getOwnerDocument(possibleAncestor))) {
            return false;
        }
        Node currAncestor = possibleDescendant;
        do {
            if ((currAncestor = traversal.getParentNode(currAncestor)) != possibleAncestor) continue;
            return true;
        } while (currAncestor != null);
        return false;
    }

    public static boolean isDescendant(Node possibleDescendant, Node possibleAncestor) {
        return DomUtils.isDescendant(DocumentTreeTraversal.INSTANCE, possibleDescendant, possibleAncestor);
    }

    public static String lookupPrefix(String namespaceURI, Node lookupNode) {
        if (namespaceURI != null) {
            return DomUtils.lookupPrefix(DocumentTreeTraversal.INSTANCE, namespaceURI, lookupNode);
        }
        return null;
    }

    public static String lookupPrefix(TreeTraversal traversal, String namespaceURI, Node lookupNode) {
        short type = lookupNode.getNodeType();
        switch (type) {
            case 1: {
                return DomUtils._lookupNamespacePrefix(traversal, namespaceURI, (Element)lookupNode, (Element)lookupNode, true);
            }
            case 9: {
                return DomUtils._lookupNamespacePrefix(traversal, namespaceURI, ((Document)lookupNode).getDocumentElement());
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                Element ownerElement = ((Attr)lookupNode).getOwnerElement();
                if (ownerElement != null) {
                    return DomUtils._lookupNamespacePrefix(traversal, namespaceURI, ownerElement);
                }
                return null;
            }
        }
        Element ancestor = (Element)traversal.getParentNode(lookupNode);
        if (ancestor != null) {
            return DomUtils._lookupNamespacePrefix(traversal, namespaceURI, ancestor);
        }
        return null;
    }

    public static String lookupPrefix(String namespaceURI, DomPosition dp) {
        Node lookupNode = null;
        lookupNode = dp.getRelativePosition() == 2 || dp.getRelativePosition() == 1 ? dp.getTargetNode().getParentNode() : dp.getTargetNode();
        return DomUtils.lookupPrefix(namespaceURI, lookupNode);
    }

    public static String lookupNamespacePrefix(String prefix, Node lookupNode) {
        return DomUtils.lookupNamespacePrefix(DocumentTreeTraversal.INSTANCE, prefix, lookupNode);
    }

    public static String lookupNamespacePrefix(TreeTraversal traversal, String prefix, Node lookupNode) {
        String fullPrefix = "xmlns";
        if (prefix != null && !"".equals(prefix)) {
            fullPrefix = fullPrefix + ':' + prefix;
        }
        short type = lookupNode.getNodeType();
        switch (type) {
            case 1: {
                return DomUtils._lookupPrefixNamespace(traversal, fullPrefix, (Element)lookupNode);
            }
            case 9: {
                return DomUtils._lookupPrefixNamespace(traversal, fullPrefix, ((Document)lookupNode).getDocumentElement());
            }
            case 2: {
                Element ownerElement = ((Attr)lookupNode).getOwnerElement();
                if (ownerElement != null) {
                    return DomUtils._lookupPrefixNamespace(traversal, fullPrefix, ownerElement);
                }
                return null;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
        }
        Element ancestor = (Element)traversal.getParentNode(lookupNode);
        if (ancestor != null) {
            return DomUtils._lookupPrefixNamespace(traversal, fullPrefix, ancestor);
        }
        return null;
    }

    public static Node lowestCommonAncestor(TreeTraversal traversal, Node node1, Node node2) {
        if (node1 == node2) {
            return node1;
        }
        if (node1 == null) {
            return node2;
        }
        if (node2 == null) {
            return node1;
        }
        Document ownerDocument1 = node1.getOwnerDocument();
        Document ownerDocument2 = node2.getOwnerDocument();
        if (ownerDocument1 == node2) {
            return node2;
        }
        if (ownerDocument2 == node1) {
            return node1;
        }
        if (ownerDocument1 != ownerDocument2 || ownerDocument1 == null) {
            return node2;
        }
        int depth1 = DomUtils.getNodeDepth(traversal, node1);
        int depth2 = DomUtils.getNodeDepth(traversal, node2);
        if (depth1 == -1) {
            if (depth2 == -1) {
                throw new IllegalStateException("neither node is in the tree");
            }
            return node2;
        }
        if (depth2 == -1) {
            return node1;
        }
        if (depth1 < depth2) {
            node2 = DomUtils.getAncestor(traversal, node2, depth2 - depth1);
        } else if (depth2 < depth1) {
            node1 = DomUtils.getAncestor(traversal, node1, depth1 - depth2);
        }
        while (node1 != node2) {
            node1 = traversal.getParentNode(node1);
            node2 = traversal.getParentNode(node2);
        }
        return node1;
    }

    public static Node lowestCommonAncestor(Node node1, Node node2) {
        return DomUtils.lowestCommonAncestor(DocumentTreeTraversal.INSTANCE, node1, node2);
    }

    public static Node getAncestor(TreeTraversal traversal, Node node, int generations) {
        while (generations > 0) {
            node = traversal.getParentNode(node);
            --generations;
        }
        return node;
    }

    public static Node getAncestor(Node node, int generations) {
        return DomUtils.getAncestor(DocumentTreeTraversal.INSTANCE, node, generations);
    }

    public static boolean isInDocumentHierarchy(TreeTraversal traversal, Node node) {
        Node testNode = node;
        if (DomUtils.isAttribute(testNode)) {
            testNode = ((Attr)testNode).getOwnerElement();
        }
        return DomUtils.getNodeDepth(traversal, testNode) != -1;
    }

    public static boolean isInDocumentHierarchy(Node node) {
        return DomUtils.isInDocumentHierarchy((TreeTraversal)DocumentTreeTraversal.INSTANCE, node);
    }

    public static boolean isInDocumentHierarchy(DomPosition pos) {
        return DomUtils.isInDocumentHierarchy((TreeTraversal)DocumentTreeTraversal.INSTANCE, pos);
    }

    public static boolean isInDocumentHierarchy(TreeTraversal traversal, DomPosition pos) {
        if (pos == null) {
            return false;
        }
        return DomUtils.isInDocumentHierarchy(traversal, pos.getTargetNode());
    }

    public static Node laterPreorderNode(TreeTraversal traversal, Node node1, Node node2) {
        if (node1 == node2) {
            return node1;
        }
        if (node1 == null) {
            return node2;
        }
        if (node2 == null) {
            return node1;
        }
        Node earlierNode = DomUtils.earlierPreorderNode(traversal, node1, node2);
        if (earlierNode == node1) {
            return node2;
        }
        return node1;
    }

    public static Node laterPreorderNode(Node node1, Node node2) {
        return DomUtils.laterPreorderNode(DocumentTreeTraversal.INSTANCE, node1, node2);
    }

    public static Node earlierPreorderNode(TreeTraversal traversal, Node node1, Node node2) {
        int node2Depth;
        Document node2Document;
        if (node1 == node2) {
            return node1;
        }
        if (node1 == null) {
            return node2;
        }
        if (node2 == null) {
            return node1;
        }
        Document node1Document = DomUtils.getOwnerDocument(node1);
        if (node1Document != (node2Document = DomUtils.getOwnerDocument(node2))) {
            throw new IllegalArgumentException("nodes must be in same document");
        }
        int node1Depth = DomUtils.getNodeDepth(traversal, node1);
        int comparisonCount = node1Depth < (node2Depth = DomUtils.getNodeDepth(traversal, node2)) ? node1Depth : node2Depth;
        for (int i = 0; i <= comparisonCount; ++i) {
            int index2;
            Node currParent1 = DomUtils.getAncestor(traversal, node1, node1Depth - i);
            Node currParent2 = DomUtils.getAncestor(traversal, node2, node2Depth - i);
            assert (traversal.getParentNode(currParent1) == traversal.getParentNode(currParent2));
            if (currParent1 == currParent2) continue;
            int index1 = DomUtils.getChildIndex(traversal, currParent1);
            if (index1 < (index2 = DomUtils.getChildIndex(traversal, currParent2))) {
                return node1;
            }
            return node2;
        }
        if (node1Depth < node2Depth) {
            return node1;
        }
        return node2;
    }

    public static Node earlierPreorderNode(Node node1, Node node2) {
        return DomUtils.earlierPreorderNode(DocumentTreeTraversal.INSTANCE, node1, node2);
    }

    public static int getNodeDepth(TreeTraversal traversal, Node node) {
        Document ownerDoc = DomUtils.getOwnerDocument(node);
        int pathLength = 0;
        while (node != ownerDoc) {
            ++pathLength;
            Node childNode = node;
            node = traversal.getParentNode(node);
            if (childNode == ownerDoc.getDocumentElement()) {
                boolean childNodeFoundUsingTraversal = false;
                Node currChild = traversal.getFirstChild(node);
                while (currChild != null) {
                    if (currChild == childNode) {
                        childNodeFoundUsingTraversal = true;
                        break;
                    }
                    currChild = traversal.getNextSibling(currChild);
                }
                if (!childNodeFoundUsingTraversal) {
                    node = null;
                }
            }
            if (node != null) continue;
            return -1;
        }
        return pathLength;
    }

    public static int getNodeDepth(Node node) {
        return DomUtils.getNodeDepth(DocumentTreeTraversal.INSTANCE, node);
    }

    public static int[] getPathToNode(Node node) {
        return DomUtils.getPathToNode(DocumentTreeTraversal.INSTANCE, node);
    }

    public static int[] getPathToNode(TreeTraversal traversal, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        int depth = DomUtils.getNodeDepth(traversal, node);
        if (depth == -1) {
            throw new IllegalStateException("node not in tree: " + node);
        }
        int[] path = new int[depth];
        Node walkNode = node;
        for (int i = depth - 1; i >= 0; --i) {
            int index = DomUtils.getChildIndex(traversal, walkNode);
            if (index == -1) {
                throw new IllegalStateException("node not in tree: " + walkNode);
            }
            path[i] = index;
            walkNode = traversal.getParentNode(walkNode);
        }
        return path;
    }

    public static Node getNodeFromPath(Document doc, int[] path) {
        return DomUtils.getNodeFromPath(DocumentTreeTraversal.INSTANCE, doc, path);
    }

    public static Node getNodeFromPath(TreeTraversal traversal, Document doc, int[] path) {
        Node walkNode = doc;
        for (int i = 0; i < path.length; ++i) {
            if ((walkNode = DomUtils.getChildAtIndex(traversal, walkNode, path[i])) != null) continue;
            return null;
        }
        return walkNode;
    }

    public static List getNodePath(Node targetNode, List<Node> targetList) {
        return DomUtils.getNodePath(DocumentTreeTraversal.INSTANCE, targetNode, targetList);
    }

    public static List<Node> getNodePath(TreeTraversal traversal, Node targetNode, List<Node> targetList) {
        if (targetList == null) {
            targetList = new LinkedList<Node>();
        } else {
            targetList.clear();
        }
        if (targetNode != null) {
            Node currTarget = targetNode;
            while (currTarget != null && !DomUtils.isDocument(currTarget)) {
                targetList.add(0, currTarget);
                currTarget = traversal.getParentNode(currTarget);
            }
            if (currTarget == null) {
                targetList.clear();
            }
        }
        return targetList;
    }

    public static int getNodeSubtreeDepth(TreeTraversal traversal, Node node) {
        int pathLength = 0;
        while (node != null) {
            ++pathLength;
            node = traversal.getParentNode(node);
        }
        return pathLength;
    }

    public static int getNodeSubtreeDepth(Node node) {
        return DomUtils.getNodeSubtreeDepth(DocumentTreeTraversal.INSTANCE, node);
    }

    public static int getChildIndex(TreeTraversal traversal, Node node) {
        if (node == null) {
            return -1;
        }
        Node parentNode = traversal.getParentNode(node);
        if (parentNode == null || !DomUtils.isStandardChildNode(node)) {
            return -1;
        }
        int childIndex = 0;
        Node currSibling = traversal.getFirstChild(parentNode);
        while (currSibling != node) {
            if (currSibling == null) {
                throw new IllegalStateException("Traversal " + traversal + " thinks " + parentNode + " is the parent of " + node + " but the parent doesn't believe that it is its child");
            }
            if (DomUtils.isStandardChildNode(currSibling)) {
                ++childIndex;
            }
            currSibling = traversal.getNextSibling(currSibling);
        }
        return childIndex;
    }

    public static int getChildIndex(Node node) {
        return DomUtils.getChildIndex(DocumentTreeTraversal.INSTANCE, node);
    }

    public static boolean isStandardChildNode(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 7: {
                return !"xml".equals(((ProcessingInstruction)node).getTarget());
            }
        }
        return false;
    }

    public static Node getNamedChild(TreeTraversal traversal, Node parentNode, String childNamespace, String childLocalName) {
        Node currChild = traversal.getFirstChild(parentNode);
        while (currChild != null) {
            if (childLocalName.equals(DomUtils.getLocalName(currChild)) && (childNamespace == currChild.getNamespaceURI() || childNamespace != null && childNamespace.equals(currChild.getNamespaceURI()))) {
                return currChild;
            }
            currChild = traversal.getNextSibling(currChild);
        }
        return null;
    }

    public static Node getNamedChild(Node parentNode, String childNamespace, String childLocalName) {
        return DomUtils.getNamedChild(DocumentTreeTraversal.INSTANCE, parentNode, childNamespace, childLocalName);
    }

    public static List<Element> getNamedChildElements(TreeTraversal traversal, Element parent, List<QualifiedName> names) {
        List list = null;
        Node currChild = traversal.getFirstChild(parent);
        while (currChild != null) {
            if (DomUtils.isElement(currChild) && names.contains(DomUtils.getQualifiedName(currChild))) {
                if (list == null) {
                    list = new ArrayList(5);
                }
                list.add((Element)currChild);
            }
            currChild = traversal.getNextSibling(currChild);
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static List<Element> getNamedChildElements(Element parent, List<QualifiedName> names) {
        return DomUtils.getNamedChildElements((TreeTraversal)DocumentTreeTraversal.INSTANCE, parent, names);
    }

    public static List<Element> getNamedChildElements(TreeTraversal traversal, Element parent, QualifiedName name) {
        return DomUtils.getNamedChildElements(traversal, parent, Collections.singletonList(name));
    }

    public static List<Element> getNamedChildElements(Element parent, QualifiedName name) {
        return DomUtils.getNamedChildElements((TreeTraversal)DocumentTreeTraversal.INSTANCE, parent, name);
    }

    public static Node getChildAtIndex(Node parentNode, int childIndex) {
        return DomUtils.getChildAtIndex(DocumentTreeTraversal.INSTANCE, parentNode, childIndex);
    }

    public static Node getChildAtIndex(TreeTraversal traversal, Node parentNode, int childIndex) {
        int i = 0;
        Node child = traversal.getFirstChild(parentNode);
        while (child != null) {
            if (DomUtils.isStandardChildNode(child)) {
                if (i == childIndex) {
                    return child;
                }
                ++i;
            }
            child = traversal.getNextSibling(child);
        }
        return null;
    }

    public static Node getLastDescendant(TreeTraversal traversal, Node parentNode) {
        Node lastChild = parentNode;
        while (true) {
            Node nextChild;
            if ((nextChild = traversal.getLastChild(lastChild)) == null) {
                if (lastChild != parentNode) {
                    return lastChild;
                }
                return null;
            }
            lastChild = nextChild;
        }
    }

    public static Node getLastDescendant(Node parentNode) {
        return DomUtils.getLastDescendant(DocumentTreeTraversal.INSTANCE, parentNode);
    }

    public static Element getFirstElementChild(Node parentNode) {
        for (Node currSibling = parentNode.getFirstChild(); currSibling != null; currSibling = currSibling.getNextSibling()) {
            if (currSibling.getNodeType() != 1) continue;
            return (Element)currSibling;
        }
        return null;
    }

    public static Element getNextElementSibling(Node node) {
        for (Node currSibling = node.getNextSibling(); currSibling != null; currSibling = currSibling.getNextSibling()) {
            if (currSibling.getNodeType() != 1) continue;
            return (Element)currSibling;
        }
        return null;
    }

    public static TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, TreeTraversal baseTraversal) {
        NodeFilterTreeTraversal traversal = new NodeFilterTreeTraversal(baseTraversal, whatToShow, filter);
        return new ConcreteTreeTraversalTreeWalker(traversal, root);
    }

    public static void removeCommentsAndProcessingInstructions(Document doc) {
        Node currNode;
        DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
        NodeIterator removeIterator = traversal.createNodeIterator(doc, 192, null, true);
        while ((currNode = removeIterator.nextNode()) != null) {
            currNode.getParentNode().removeChild(currNode);
        }
        removeIterator.detach();
    }

    public static String getAttribute(Node node, String attrName) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return null;
        }
        Node attrNode = map.getNamedItem(attrName);
        if (attrNode == null) {
            return null;
        }
        return ((Attr)attrNode).getValue();
    }

    public static String getAttributeNS(Node node, String namespace, String attrName) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return null;
        }
        Node attrNode = map.getNamedItemNS(namespace, attrName);
        if (attrNode == null) {
            return null;
        }
        return ((Attr)attrNode).getValue();
    }

    public static DOMImplementation getDOMImplementation() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.getDOMImplementation();
        }
        catch (Throwable t) {
            String message = "DomUtils.getScratchDocument() no namespace awareJAXP parser could be located.";
            IllegalStateException newException = new IllegalStateException(message);
            newException.initCause(t);
            throw newException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getScratchDocument() {
        if (_sScratchDocument == null) {
            Object object = _sScratchDocumentLock;
            synchronized (object) {
                if (_sScratchDocument == null) {
                    _sScratchDocument = new XMLDocument();
                    ((XMLDocument)_sScratchDocument).setNodeFlag(0x2000000);
                    _sScratchDocument.appendChild(_sScratchDocument.createElementNS("scratch-namespace", "scratch-document"));
                }
            }
        }
        return _sScratchDocument;
    }

    public static void printNode(Node node) {
        Element element;
        NamedNodeMap attrs;
        if (node == null) {
            System.out.println("Node: is null");
            return;
        }
        System.out.println("Node: " + node.getNamespaceURI() + " " + node.getNodeName() + " \"" + node.getNodeValue() + "\"");
        if (DomUtils.isElement(node) && (attrs = (element = (Element)node).getAttributes()) != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                System.out.println("Attribute:  " + attr.getNamespaceURI() + " " + attr.getName() + " " + attr.getValue());
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DomUtils.printNode(child);
        }
    }

    public static String getEventDebugMsg(MutationEvent e) {
        boolean showValues = false;
        String type = e.getType();
        if (DOM_ATTR_MODIFIED_EVENT_TYPE.equals(type)) {
            type = "attr ";
            switch (e.getAttrChange()) {
                case 1: {
                    type = type + "modified";
                    showValues = true;
                    break;
                }
                case 2: {
                    type = type + "added";
                    break;
                }
                case 3: {
                    type = type + "removed";
                    break;
                }
                default: {
                    type = type + "??? " + e.getAttrChange();
                    break;
                }
            }
        } else if (DOM_CHARACTER_DATA_MODIFIED_EVENT_TYPE.equals(type)) {
            type = "char data modified";
            showValues = true;
        } else if (DOM_NODE_INSERTED_EVENT_TYPE.equals(type)) {
            type = "node inserted";
        } else if (DOM_NODE_REMOVED_EVENT_TYPE.equals(type)) {
            type = "node removed";
        } else if (DOM_SUBTREE_MODIFIED_EVENT_TYPE.equals(type)) {
            type = "subtree modified";
        }
        String ret = "MutationEvent: " + type + " target=" + e.getTarget() + " related=" + e.getRelatedNode();
        if (showValues) {
            ret = ret + " prevValue=" + e.getPrevValue();
            ret = ret + " newValue=" + e.getNewValue();
        }
        return ret;
    }

    public static void moveChildElements(Node source, Node destination) {
        DomUtils.moveChildNodes(source, destination, Collections.singletonList(new Integer(1)));
    }

    public static void moveChildNodes(Node source, Node destination, Collection<Integer> childTypes) {
        for (Node child = source.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (!childTypes.contains(child.getNodeType())) continue;
            destination.appendChild(child);
        }
    }

    public static Node surroundNode(Node targetNode, String namespace, String localName) {
        Document ownerDoc = targetNode.getOwnerDocument();
        if (ownerDoc == null) {
            throw new IllegalArgumentException("Can't surround a document with an element");
        }
        Node originalParent = targetNode.getParentNode();
        Element surroundingNode = ownerDoc.createElementNS(namespace, localName);
        targetNode = originalParent.replaceChild(surroundingNode, targetNode);
        surroundingNode.appendChild(targetNode);
        return surroundingNode;
    }

    public static Collection getNodesForOwnerDoc(Document doc, Collection orig) {
        if (DomUtils.areNodesOfOwnerDoc(doc, orig)) {
            return orig;
        }
        ArrayList<Node> ret = new ArrayList<Node>(orig.size());
        for (Node node : orig) {
            ret.add(doc.importNode(node, true));
        }
        return ret;
    }

    public static boolean areNodesOfOwnerDoc(Document doc, Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            if (DomUtils.getOwnerDocument(node) == doc) continue;
            return false;
        }
        return true;
    }

    public static void addAttr(Element parent, Attr attrClone) {
        Document doc = parent.getOwnerDocument();
        Attr importedAttr = (Attr)doc.importNode(attrClone, true);
        parent.setAttributeNodeNS(importedAttr);
    }

    public static void removeAttr(Element parent, Attr attrClone) {
        parent.removeAttributeNS(attrClone.getNamespaceURI(), DomUtils.getLocalName(attrClone));
    }

    public static void removeChild(Document doc, NodeRef ref) {
        Node child = ref.getCorrespondingNode(doc);
        Node parent = child.getParentNode();
        parent.removeChild(child);
    }

    public static void addChild(Document doc, NodeRef ref, Node childClone) {
        Node importedChild = doc.importNode(childClone, true);
        ref.putCorrespondingNode(doc, importedChild);
    }

    public static void replaceChild(Document doc, NodeRef ref, Node newChildClone) {
        Node importedChild = doc.importNode(newChildClone, true);
        Node currentChild = ref.getCorrespondingNode(doc);
        Node currentParent = currentChild.getParentNode();
        currentParent.replaceChild(importedChild, currentChild);
    }

    public static void syncNode(Node destNode, Node sourceNode) {
        int destNodeCount;
        String name;
        String ns;
        int i;
        if (destNode == null || sourceNode == null) {
            throw new IllegalArgumentException("nodes must be non null");
        }
        if (DomUtils.isInDocumentHierarchy(destNode)) {
            throw new IllegalArgumentException("destNode must be in a document.");
        }
        destNode.setNodeValue(sourceNode.getNodeValue());
        NamedNodeMap destAttrs = destNode.getAttributes();
        NamedNodeMap srcAttrs = sourceNode.getAttributes();
        int destCount = destAttrs == null ? 0 : destAttrs.getLength();
        int srcCount = srcAttrs == null ? 0 : srcAttrs.getLength();
        for (i = destCount - 1; i >= 0; --i) {
            Node n;
            Node destAttr = destAttrs.item(i);
            ns = destAttr.getNamespaceURI();
            name = DomUtils.getLocalName(destAttr);
            Node node = n = srcAttrs == null ? null : srcAttrs.getNamedItemNS(ns, name);
            if (n != null) continue;
            destAttrs.removeNamedItemNS(ns, name);
        }
        if (DomUtils.isElement(destNode)) {
            for (i = 0; i < srcCount; ++i) {
                Node srcAttr = srcAttrs.item(i);
                ns = srcAttr.getNamespaceURI();
                name = srcAttr.getNodeName();
                ((Element)destNode).setAttributeNS(ns, name, srcAttr.getNodeValue());
            }
        }
        boolean needCopy = sourceNode.getOwnerDocument() != destNode.getOwnerDocument();
        NodeList srcChildNodes = sourceNode.getChildNodes();
        NodeList destChildNodes = destNode.getChildNodes();
        int srcNodeCount = srcChildNodes.getLength();
        if (srcNodeCount > (destNodeCount = destChildNodes.getLength())) {
            int i2;
            DomUtils._syncNodeLists(srcChildNodes, destChildNodes, destNode, destNodeCount, needCopy);
            Node[] array = new Node[srcNodeCount - destNodeCount];
            for (i2 = 0; i2 < array.length; ++i2) {
                array[i2] = srcChildNodes.item(destNodeCount + i2);
            }
            for (i2 = 0; i2 < array.length; ++i2) {
                Node srcChildNode = array[i2];
                if (needCopy) {
                    srcChildNode = DomUtils.copyNode(srcChildNode, destNode.getOwnerDocument());
                }
                destNode.appendChild(srcChildNode);
            }
        } else if (destNodeCount > srcNodeCount) {
            DomUtils._syncNodeLists(srcChildNodes, destChildNodes, destNode, srcNodeCount, needCopy);
            for (int i3 = destNodeCount - 1; i3 >= srcNodeCount; --i3) {
                Node destChildNode = destChildNodes.item(i3);
                destNode.removeChild(destChildNode);
            }
        } else {
            DomUtils._syncNodeLists(srcChildNodes, destChildNodes, destNode, srcNodeCount, needCopy);
        }
    }

    public static Document getOwnerDocument(Node node) {
        assert (node != null) : "Node was null!";
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Set<String> getNamespacesInSubtree(Node node) {
        assert (node != null) : "Node was null!";
        NodeFilterTreeTraversal traversal = new NodeFilterTreeTraversal(1, null);
        TreeTraversalNodeIterator itor = new TreeTraversalNodeIterator(traversal, node);
        HashSet<String> nsSet = new HashSet<String>();
        Node next = itor.nextNode();
        while (next != null) {
            String ns = next.getNamespaceURI();
            if (ns != null) {
                nsSet.add(ns);
            }
            next = itor.nextNode();
        }
        itor.detach();
        return nsSet;
    }

    public static Map<String, Set<String>> getNamespacesMapInSubtree(Node node) {
        assert (node != null) : "Node was null!";
        NodeFilterTreeTraversal traversal = new NodeFilterTreeTraversal(1, null);
        TreeTraversalNodeIterator itor = new TreeTraversalNodeIterator(traversal, node);
        HashMap<String, Set<String>> nsMap = new HashMap<String, Set<String>>();
        Node next = itor.nextNode();
        while (next != null) {
            String ns = next.getNamespaceURI();
            if (ns != null) {
                String prefix = next.getPrefix();
                Set<String> prefixSet = null;
                if (!nsMap.containsKey(ns)) {
                    prefixSet = new HashSet();
                    nsMap.put(ns, prefixSet);
                } else {
                    prefixSet = (Set)nsMap.get(ns);
                }
                if (prefix != null && !"".equals(prefix)) {
                    prefixSet.add(prefix);
                }
            }
            next = itor.nextNode();
        }
        itor.detach();
        return nsMap;
    }

    public static Set<Node> getNodesInSubtree(TreeTraversal traversal, Node root) {
        LinkedHashSet<Node> set = new LinkedHashSet<Node>();
        DomUtils.addNodesInSubtreeToSet(set, traversal, root);
        return set;
    }

    public static void addNodesInSubtreeToSet(Set<? super Node> set, TreeTraversal traversal, Node root) {
        set.add(root);
        Node child = traversal.getFirstChild(root);
        while (child != null) {
            DomUtils.addNodesInSubtreeToSet(set, traversal, child);
            child = traversal.getNextSibling(child);
        }
    }

    public static Collection<Node> rationalizeCollectionOfNodes(TreeTraversal traversal, Collection<Node> input) {
        if (input.size() <= 1) {
            return input;
        }
        LinkedList<Node> out = new LinkedList<Node>();
        LinkedHashSet<Object> set = input instanceof LinkedHashSet ? (LinkedHashSet<Object>)input : new LinkedHashSet<Node>(input);
        for (Node node : set) {
            boolean foundParent = false;
            Node parent = traversal.getParentNode(node);
            while (parent != null) {
                if (set.contains(parent)) {
                    foundParent = true;
                    break;
                }
                parent = traversal.getParentNode(parent);
            }
            if (foundParent) continue;
            out.add(node);
        }
        return out;
    }

    public static NodeList collectionToNodeList(Collection<? extends Node> input) {
        int size = input.size();
        if (size == 0) {
            return EmptyNodeList.INSTANCE;
        }
        return new ArrayNodeList(input.toArray(new Node[size]));
    }

    public static List<Node> nodeListToList(NodeList input) {
        int size = input.getLength();
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(input.item(0));
            }
        }
        ArrayList<Node> list = new ArrayList<Node>(size);
        for (int i = 0; i < size; ++i) {
            list.add(input.item(i));
        }
        return Collections.unmodifiableList(list);
    }

    public static List<Node> nodeToList(Node input) {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (DomUtils.isNodeType(input, 11)) {
            return DomUtils.nodeListToList(input.getChildNodes());
        }
        return Collections.singletonList(input);
    }

    public static Set<Node> getAncestorSet(TreeTraversal traversal, Node node) {
        HashSet<Node> s = new HashSet<Node>(17);
        while (node != null) {
            s.add(node);
            node = traversal.getParentNode(node);
        }
        return s;
    }

    public static void sortByDepth(final TreeTraversal traversal, List<? extends Node> list, final boolean childrenFirst) {
        Comparator<Node> comp = new Comparator<Node>(){

            @Override
            public int compare(Node na, Node nb) {
                int depthA = DomUtils.getNodeDepth(traversal, na);
                int depthB = DomUtils.getNodeDepth(traversal, nb);
                int delta = depthA - depthB;
                if (childrenFirst) {
                    return -delta;
                }
                return delta;
            }
        };
        Collections.sort(list, comp);
    }

    public static boolean containsPositionOrEquivalent(TreeTraversal traversal, Set<DomPosition> set, DomPosition pos) {
        Node lastChild;
        if (pos == null) {
            return false;
        }
        if (set.contains(pos)) {
            return true;
        }
        DomPosition other = null;
        Node targetNode = pos.getTargetNode();
        if (pos.isBefore()) {
            Node prevSibling = traversal.getPreviousSibling(targetNode);
            if (prevSibling != null) {
                other = DomPositionFactory.after(prevSibling);
            }
        } else if (pos.isAfter()) {
            Node nextSibling = traversal.getNextNode(targetNode);
            if (nextSibling != null) {
                other = DomPositionFactory.before(nextSibling);
            }
        } else if (pos.isInside() && !pos.hasTextOffset() && (lastChild = traversal.getLastChild(targetNode)) != null) {
            other = DomPositionFactory.after(lastChild);
        }
        return other != null && set.contains(other);
    }

    private static void _syncNodeLists(NodeList srcChildNodes, NodeList destChildNodes, Node destNode, int count, boolean needCopy) {
        for (int i = count - 1; i >= 0; --i) {
            Node srcChild = srcChildNodes.item(i);
            Node destChild = destChildNodes.item(i);
            if (DomUtils._stringEquals(srcChild.getNamespaceURI(), destChild.getNamespaceURI()) && DomUtils._stringEquals(DomUtils.getLocalName(srcChild), DomUtils.getLocalName(destChild))) {
                DomUtils.syncNode(destChild, srcChild);
                continue;
            }
            if (needCopy) {
                srcChild = DomUtils.copyNode(srcChild, destNode.getOwnerDocument());
            }
            destNode.replaceChild(srcChild, destChild);
        }
    }

    public static Node copyNode(Node n, Document d) {
        if (n.getOwnerDocument() == d) {
            return n;
        }
        Node copy = null;
        switch (n.getNodeType()) {
            case 2: {
                copy = d.createAttributeNS(n.getNamespaceURI(), n.getLocalName());
                break;
            }
            case 4: {
                copy = d.createCDATASection(n.getNodeValue());
                break;
            }
            case 8: {
                copy = d.createComment(n.getNodeValue());
                break;
            }
            case 11: {
                copy = d.createDocumentFragment();
                break;
            }
            case 1: {
                copy = d.createElementNS(n.getNamespaceURI(), n.getLocalName());
                break;
            }
            case 5: {
                copy = d.createEntityReference(n.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                copy = d.createProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 3: {
                copy = d.createTextNode(n.getNodeValue());
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                return n;
            }
        }
        DomUtils.syncNode(copy, n);
        return copy;
    }

    public static String nodeToText(Node node) {
        TreeWalker walker = DomUtils.createTreeWalker(node, -1, null, DocumentTreeTraversal.INSTANCE);
        TreeWalkerXmlReader twxr = new TreeWalkerXmlReader(walker);
        twxr.setNamespacePrefixesFeature(true);
        StringCaptureXmlFilter s = new StringCaptureXmlFilter(twxr, false);
        try {
            s.parse("ignored");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return s.getXMLSource();
    }

    public static boolean isSameName(Node a1, Node a2) {
        return DomUtils._stringEquals(a1.getNamespaceURI(), a2.getNamespaceURI()) && DomUtils._stringEquals(DomUtils.getLocalName(a1), DomUtils.getLocalName(a2));
    }

    public static Comparator<Node> getNodeByAttributeValueComparator(final QualifiedName attrQName, final boolean caseSensitive) {
        return new Comparator<Node>(){

            @Override
            public int compare(Node a, Node b) {
                String valA = this._attrValue(a);
                String valB = this._attrValue(b);
                if (valA == null && valB == null) {
                    return a.hashCode() - b.hashCode();
                }
                if (valA == null) {
                    return -1;
                }
                if (valB == null) {
                    return 1;
                }
                if (caseSensitive) {
                    return valA.compareTo(valB);
                }
                return valA.compareToIgnoreCase(valB);
            }

            private String _attrValue(Node n) {
                if (DomUtils.isElement(n)) {
                    return DomUtils.getAttributeNS(n, attrQName.getNamespace(), attrQName.getName());
                }
                return null;
            }
        };
    }

    public static Node createNodeFromKey(Document doc, XmlKey key) {
        if (doc == null || key == null) {
            throw new IllegalArgumentException("null doc or key!");
        }
        switch (key.getNodeType()) {
            case 2: {
                return DomUtils.createAttributeNode(doc, key.getAttributeQName());
            }
            case 1: {
                QualifiedName qName = key.getElementQName();
                Element elem = DomUtils.createElementNode(doc, qName);
                String attrName = qName.getAttributeName();
                String attrValue = qName.getAttributeValue();
                if (attrName != null && attrValue != null) {
                    DomUtils.setAttribute(elem, qName.getAttributeNamespace(), attrName, attrValue);
                }
                return elem;
            }
            case 8: {
                return doc.createComment("");
            }
            case 7: {
                return doc.createProcessingInstruction("target", "");
            }
            case 4: {
                return doc.createCDATASection("");
            }
            case 3: {
                return doc.createTextNode("");
            }
        }
        throw new IllegalArgumentException("can't create node for key: " + key);
    }

    public static Attr createAttributeNode(Document doc, QualifiedName name) {
        return doc.createAttributeNS(name.getNamespace(), name.getName());
    }

    public static Element createElementNode(Document doc, QualifiedName name) {
        Element elem = doc.createElementNS(name.getNamespace(), name.getName());
        String fixedAttrNS = name.getAttributeNamespace();
        String fixedAttrName = name.getAttributeName();
        String fixedAttrValue = name.getAttributeValue();
        if (fixedAttrName != null && fixedAttrValue != null) {
            elem.setAttributeNS(fixedAttrNS, fixedAttrName, fixedAttrValue);
        }
        return elem;
    }

    public static Attributes getSAXAttributesProxy(Element element) {
        if (element == null) {
            return null;
        }
        return new DomToAttributes(element);
    }

    public static Iterable<Attr> getAttributesIterable(Node node) {
        if (node == null) {
            return null;
        }
        final NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return null;
        }
        final int size = map.getLength();
        if (size == 0) {
            return null;
        }
        return new Iterable<Attr>(){

            @Override
            public Iterator<Attr> iterator() {
                return new I();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class I
            implements Iterator<Attr> {
                private int _next = 0;

                I() {
                }

                @Override
                public boolean hasNext() {
                    return this._next < size;
                }

                @Override
                public Attr next() {
                    try {
                        Node item = map.item(this._next);
                        ++this._next;
                        return (Attr)item;
                    }
                    catch (Exception e) {
                        NoSuchElementException nsee = new NoSuchElementException("index " + this._next);
                        nsee.initCause(e);
                        throw nsee;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        };
    }

    private static boolean _stringEquals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    private static String _lookupNamespacePrefix(TreeTraversal traversal, String namespaceURI, Element currentElement) {
        return DomUtils._lookupNamespacePrefix(traversal, namespaceURI, currentElement, null, true);
    }

    private static String _lookupNamespacePrefix(TreeTraversal traversal, String namespaceURI, Element currentElement, Element originalElement, boolean allowDefaultNamespace) {
        Node ancestor;
        NamedNodeMap attributes;
        String currentElementNS = currentElement.getNamespaceURI();
        if (currentElementNS != null && currentElementNS.equals(namespaceURI)) {
            String prefix = currentElement.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (namespaceURI.equals(DomUtils.lookupNamespacePrefix(prefix, originalElement)) && (allowDefaultNamespace || !"".equals(prefix))) {
                return prefix;
            }
        }
        if ((attributes = currentElement.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String attrPrefix = attr.getPrefix();
                String attrLocalName = DomUtils.getLocalName(attr);
                String attrValue = attr.getValue();
                if (attrPrefix == null || !attrPrefix.equals("xmlns") || attrValue == null || !attrValue.equals(namespaceURI)) continue;
                return attrLocalName;
            }
        }
        if ((ancestor = traversal.getParentNode(currentElement)) != null && DomUtils.isElement(ancestor)) {
            return DomUtils._lookupNamespacePrefix(traversal, namespaceURI, (Element)ancestor, originalElement, allowDefaultNamespace);
        }
        return null;
    }

    private static String _lookupPrefixNamespace(TreeTraversal traversal, String prefix, Element currentElement) {
        Node ancestor;
        NamedNodeMap attributes = currentElement.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getName();
                String attrValue = attr.getValue();
                if (!prefix.equals(attrName)) continue;
                return attrValue;
            }
        }
        if ((ancestor = traversal.getParentNode(currentElement)) != null && DomUtils.isElement(ancestor)) {
            return DomUtils._lookupPrefixNamespace(traversal, prefix, (Element)ancestor);
        }
        return null;
    }

    public static List<Node> cloneRangeToList(TreeTraversal traversal, DomRange range) {
        Node ancestorClone;
        if (range.isInsideAttributeValue()) {
            return Collections.emptyList();
        }
        Position pos = DomUtils.flatten(traversal, range.getStart());
        Node startNode = pos.node;
        int startOffset = pos.index;
        pos = DomUtils.flatten(traversal, range.getEnd());
        Node endNode = pos.node;
        int endOffset = pos.index;
        if (startNode == endNode) {
            Node clonedPart = DomUtils.cloneWithin(startNode, startOffset, endOffset);
            if (!DomUtils.isText(clonedPart)) {
                NodeList children = clonedPart.getChildNodes();
                return DomUtils.nodeListToList(children);
            }
            return Collections.singletonList(clonedPart);
        }
        ArrayList<Node> list = new ArrayList<Node>(20);
        Node commonAncestor = DomUtils.lowestCommonAncestor(startNode, endNode);
        Node endClone = null;
        Node startClone = null;
        int commonEnd = endOffset;
        int commonStart = startOffset;
        if (endNode != commonAncestor) {
            endClone = DomUtils.cloneWithin(endNode, 0, endOffset);
            commonEnd = DomUtils.getChildIndex(endNode);
            for (Node endAncestor = endNode.getParentNode(); endAncestor != commonAncestor; endAncestor = endAncestor.getParentNode()) {
                ancestorClone = DomUtils.cloneWithin(endAncestor, 0, commonEnd);
                ancestorClone.appendChild(endClone);
                endClone = ancestorClone;
                commonEnd = DomUtils.getChildIndex(endAncestor);
            }
        }
        if (startNode != commonAncestor) {
            startClone = DomUtils.cloneWithin(startNode, startOffset, DomUtils.getLastOffset(traversal, startNode));
            commonStart = DomUtils.getChildIndex(startNode);
            for (Node startAncestor = startNode.getParentNode(); startAncestor != commonAncestor; startAncestor = startAncestor.getParentNode()) {
                ancestorClone = DomUtils.cloneWithin(startAncestor, commonStart + 1, DomUtils.getLastOffset(traversal, startAncestor));
                ancestorClone.insertBefore(startClone, ancestorClone.getFirstChild());
                startClone = ancestorClone;
                commonStart = DomUtils.getChildIndex(startAncestor);
            }
            ++commonStart;
        }
        if (startClone != null) {
            list.add(startClone);
        }
        for (int i = commonStart; i < commonEnd; ++i) {
            Node child = DomUtils.getChildAtIndex(commonAncestor, i);
            Node copy = child.cloneNode(true);
            list.add(copy);
        }
        if (endClone != null) {
            list.add(endClone);
        }
        list.trimToSize();
        return list;
    }

    public static Node cloneWithin(Node node, int startOffset, int endOffset) {
        Node clone;
        if (DomPosition.isContainerNode(node)) {
            clone = node.cloneNode(false);
            for (int i = startOffset; i < endOffset; ++i) {
                Node child = DomUtils.getChildAtIndex(node, i);
                Node clonedChild = child.cloneNode(true);
                clone.appendChild(clonedChild);
            }
        } else if (DomUtils.isText(node)) {
            String text = ((Text)node).getData();
            text = text.substring(startOffset, endOffset);
            clone = DomUtils.getOwnerDocument(node).createTextNode(text);
        } else {
            clone = node.cloneNode(true);
        }
        return clone;
    }

    private static int getLastOffset(TreeTraversal traversal, Node node) {
        if (DomUtils.isText(node)) {
            return ((Text)node).getLength();
        }
        return traversal.getChildCount(node);
    }

    private static Position flatten(TreeTraversal traversal, DomPosition position) {
        Position pos = new Position();
        pos.node = position.getContainerNode(traversal);
        try {
            if (position.isInside()) {
                pos.index = position.hasTextOffset() && !position.hasAttributeQName() ? position.getTextOffset() : DomUtils.getLastOffset(traversal, pos.node);
            } else {
                pos.index = DomUtils.getChildIndex(traversal, position.getTargetNode());
                if (position.isAfter()) {
                    ++pos.index;
                }
            }
        }
        catch (IllegalStateException exc) {
            pos.index = -1;
        }
        return pos;
    }

    public static Node findNode(Node contextNode, Collection<QualifiedName> qNamePath, TreeTraversal treeTraversal) {
        Node currNode = contextNode;
        for (QualifiedName qn : qNamePath) {
            Node newNode = DomUtils.getNamedChild(treeTraversal, currNode, qn.getNamespace(), qn.getName());
            if (newNode == null) {
                return null;
            }
            currNode = newNode;
        }
        return currNode;
    }

    private DomUtils() {
    }

    private static class EmptyNamedNodeMap
    implements NamedNodeMap {
        private EmptyNamedNodeMap() {
        }

        public int getLength() {
            return 0;
        }

        public Node getNamedItem(String name) {
            return null;
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            return null;
        }

        public Node item(int index) {
            return null;
        }

        public Node removeNamedItem(String name) throws DOMException {
            return this._err();
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            return this._err();
        }

        public Node setNamedItem(Node arg) throws DOMException {
            return this._err();
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            return this._err();
        }

        private Node _err() {
            throw new DOMException(7, "Can't mutate empty NamedNodeMap object!");
        }
    }

    private static class DomToAttributes
    implements Attributes {
        private final Element _element;

        public DomToAttributes(Element element) {
            this._element = element;
        }

        public int getIndex(String qName) {
            NamedNodeMap attrs = this._attrs();
            return this._findIndex(attrs, attrs.getNamedItem(qName));
        }

        public int getIndex(String uri, String localName) {
            NamedNodeMap attrs = this._attrs();
            Node item = attrs.getNamedItemNS(this._nsSaxToDom(uri), localName);
            return this._findIndex(attrs, item);
        }

        public int getLength() {
            return this._attrs().getLength();
        }

        public String getLocalName(int index) {
            Node node = this._item(index);
            return node == null ? null : DomUtils.getLocalName(node);
        }

        public String getQName(int index) {
            Node node = this._item(index);
            return node == null ? null : node.getNodeName();
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String qName) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getURI(int index) {
            Node node = this._item(index);
            return node == null ? null : this._nsDomToSax(node.getNamespaceURI());
        }

        public String getValue(int index) {
            Node node = this._item(index);
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String qName) {
            Node node = this._attrs().getNamedItem(qName);
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String uri, String localName) {
            Node node = this._attrs().getNamedItemNS(uri, localName);
            return node == null ? null : node.getNodeValue();
        }

        private String _nsDomToSax(String domNamespace) {
            if (domNamespace == null) {
                return "";
            }
            return domNamespace;
        }

        private String _nsSaxToDom(String saxNamespace) {
            if ("".equals(saxNamespace)) {
                return null;
            }
            return saxNamespace;
        }

        private int _findIndex(NamedNodeMap attrs, Node itemToFind) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.item(i) != itemToFind) continue;
                return i;
            }
            return -1;
        }

        private Node _item(int index) {
            return this._attrs().item(index);
        }

        private NamedNodeMap _attrs() {
            NamedNodeMap attrs;
            if (this._element != null && (attrs = this._element.getAttributes()) != null) {
                return attrs;
            }
            return _EMPTY_NODE_MAP;
        }
    }

    private static class Position {
        public Node node;
        public int index;

        private Position() {
        }
    }
}

