/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.LayeredGrammarProvider;

public class SimpleGrammarProvider
extends LayeredGrammarProvider {
    private static final String _ERROR_DUPLICATE_NAMESPACE = "A different Grammar with the same targetNamespace has already been registered with this provider:";
    private LinkedHashMap _grammarMap = new LinkedHashMap(13);

    public SimpleGrammarProvider() {
        this(null);
    }

    public SimpleGrammarProvider(GrammarProvider base) {
        super(base);
    }

    public void addGrammar(Grammar grammar) throws GrammarException {
        if (grammar != null) {
            String targetNamespace = grammar.getTargetNamespace();
            Grammar previousGrammar = (Grammar)this._grammarMap.get(targetNamespace);
            if (previousGrammar == null) {
                this._grammarMap.put(targetNamespace, grammar);
                this.fireGrammarAddedEvent(grammar);
            } else if (previousGrammar != grammar) {
                throw new GrammarException(_ERROR_DUPLICATE_NAMESPACE + targetNamespace);
            }
        }
    }

    public void removeGrammar(Grammar grammar) {
        String targetNamespace;
        Grammar previousGrammar;
        if (grammar != null && grammar == (previousGrammar = (Grammar)this._grammarMap.get(targetNamespace = grammar.getTargetNamespace()))) {
            this._grammarMap.remove(targetNamespace);
            this.fireGrammarRemovedEvent(grammar);
        }
    }

    public void clearProvider() {
        HashSet removedGrammarSet = new HashSet(this._grammarMap.values());
        this._grammarMap.clear();
        this.fireEvent(Collections.EMPTY_SET, removedGrammarSet, Collections.EMPTY_SET);
    }

    protected Map getLayerGrammarMap() {
        return this._grammarMap;
    }
}

