/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.util.HashSet;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.util.xpath.XPathEvaluator;
import oracle.bali.xml.util.xpath.XPathEvaluatorFactory;
import oracle.bali.xml.validator.PerValidationState;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ValidationContext {
    public static final String FEATURE_ID_VALIDATION = "ID_VALIDATION";
    public static final String FEATURE_UNIQUE_KEY_KEYREF_VALIDATION = "UNIQUE_KEY_KEYREF_VALIDATION";
    public static final String FEATURE_RESPECT_GROUP_RULES = "RESPECT_GROUP_RULES";
    public static final String FEATURE_TOLERATE_UNKNOWN_ATTRS = "TOLERATE_UNKNOWN_ATTRS";
    public static final String FEATURE_IMPROVED_INCOMPLETE_ERRORS = "IMPROVED_INCOMPLETE_ERRORS";
    public static final String FEATURE_GRAMMAR_UNAVAILABLE_AS_ERROR = "GRAMMAR_UNAVAILABLE_AS_ERROR";
    private GrammarResolver _grammarResolver = null;
    private HashSet _enabledFeatures = new HashSet();
    private XPathEvaluator _xPathEvaluator;

    public ValidationContext(GrammarResolver grammarResolver) {
        this._grammarResolver = grammarResolver;
        this.setFeature(FEATURE_RESPECT_GROUP_RULES, true);
        this.setFeature(FEATURE_UNIQUE_KEY_KEYREF_VALIDATION, true);
        this.setFeature(FEATURE_IMPROVED_INCOMPLETE_ERRORS, true);
    }

    public GrammarResolver getGrammarResolver() {
        return this._grammarResolver;
    }

    public final boolean getFeature(String feature) {
        return this._enabledFeatures.contains(feature);
    }

    public final void setFeature(String feature, boolean enable) {
        if (enable) {
            this._enabledFeatures.add(feature);
        } else {
            this._enabledFeatures.remove(feature);
        }
    }

    public final void reportError(PerValidationState validationState, int type, String message, Node invalidNode, Exception sourceException, Object relatedObject) {
        boolean couldBeResolvedByAddingNodes = false;
        boolean displayAsIncompleteSeverity = false;
        if (this.getFeature(FEATURE_IMPROVED_INCOMPLETE_ERRORS)) {
            switch (type) {
                case 23: 
                case 32: {
                    couldBeResolvedByAddingNodes = true;
                    displayAsIncompleteSeverity = true;
                    break;
                }
                case 45: {
                    couldBeResolvedByAddingNodes = true;
                }
            }
        }
        this.reportError(validationState, type, message, invalidNode, sourceException, relatedObject, couldBeResolvedByAddingNodes, displayAsIncompleteSeverity);
    }

    public final void reportError(PerValidationState validationState, int type, String message, Node invalidNode, Exception sourceException, Object relatedObject, boolean couldBeResolvedByAddingNodes, boolean displayAsIncompleteSeverity) {
        ValidationException ve = new ValidationException(type, message, invalidNode, sourceException);
        ve.setRelatedObject(relatedObject);
        ve.setIncompletenessParams(couldBeResolvedByAddingNodes, displayAsIncompleteSeverity);
        this.reportError(validationState, ve);
    }

    public final void reportError(PerValidationState validationState, ValidationException error) {
        validationState.setStillValid(false);
        this.reportErrorImpl(error);
    }

    public final void reportWarning(PerValidationState validationState, int type, String message, Node invalidNode, Object relatedObject) {
        ValidationException ve = new ValidationException(type, message, invalidNode);
        ve.setRelatedObject(relatedObject);
        this.reportWarning(validationState, ve);
    }

    public final void reportWarning(PerValidationState validationState, ValidationException warning) {
        this.reportWarningImpl(warning);
    }

    public void performAdditionalValidation(PerValidationState validationState, Document document) {
    }

    public void performAdditionalValidation(PerValidationState validationState, Element element, ElementDef elementDef, int processingRule, boolean deep) {
    }

    public void performAdditionalValidation(PerValidationState validationState, Attr attribute, AttributeDef attributeDef, int processingRule) {
    }

    public final XPathEvaluator getXPathEvaluator() {
        if (this._xPathEvaluator == null) {
            this._xPathEvaluator = XPathEvaluatorFactory.getInstance().createDefaultXPathEvaluator();
        }
        return this._xPathEvaluator;
    }

    protected abstract void reportErrorImpl(ValidationException var1);

    protected abstract void reportWarningImpl(ValidationException var1);
}

