/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.Particle;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.automata.AutomataBuilder;
import oracle.bali.xml.grammar.automata.ElementDefTransition;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.automata.Transition;
import oracle.bali.xml.grammar.automata.TransitionUtils;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.validator.CachingValidatorCallback;
import oracle.bali.xml.validator.IdentityConstraintValidation;
import oracle.bali.xml.validator.PerValidationState;
import oracle.bali.xml.validator.UniqueException;
import oracle.bali.xml.validator.ValidationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Validator {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String IGNORED_NAMESPACE = "http://xmlns.oracle.com/jdeveloper/xmlef/ignored";
    public static final String INVALID_NAMESPACE_SUBSTITUTE = "error:invalid-namespace";
    private static Logger _sLogger = null;
    private static final HashSet<String> _IGNORED_ATTR_NAMESPACES = new HashSet();
    private static final HashSet<QualifiedName> _IGNORED_ELEMENTS = new HashSet();
    private static final HashSet<String> _LAX_WILDCARD_NAMESPACES = new HashSet();
    private static final String _VALIDATOR_BUNDLE = "oracle.bali.xml.validator.resource.ValidatorBundle";
    private static final String _KEY_WARNING_GRAMMAR_UNAVAILABLE = "WARNING_GRAMMAR_UNAVAILABLE";
    private static final String _KEY_WARNING_ABSENT_NS_GRAMMAR_UNAVAILABLE = "WARNING_ABSENT_NS_GRAMMAR_UNAVAILABLE";
    private static final String _KEY_ERROR_ELEMENT_UNKNOWN = "ERROR_ELEMENT_UNKNOWN";
    private static final String _KEY_ERROR_ELEMENT_UNEXPECTED = "ERROR_ELEMENT_UNEXPECTED";
    private static final String _KEY_ERROR_ELEMENT_UNEXPECTED_DETAILED = "ERROR_ELEMENT_UNEXPECTED_DETAILED";
    private static final String _KEY_ERROR_ELEMENT_SIMPLE_TYPE = "ERROR_ELEMENT_SIMPLE_TYPE";
    private static final String _KEY_ERROR_ELEMENT_SIMPLE_TYPE_ANON = "ERROR_ELEMENT_SIMPLE_TYPE_ANON";
    private static final String _KEY_ERROR_ELEMENT_MISSING = "ERROR_ELEMENT_MISSING";
    private static final String _KEY_ERROR_ELEMENT_MISSING_UNSPECIFIED = "ERROR_ELEMENT_MISSING_UNSPECIFIED";
    private static final String _KEY_ERROR_ELEMENT_MISSING_BEFORE = "ERROR_ELEMENT_MISSING_BEFORE";
    private static final String _KEY_ERROR_ELEMENT_MISSING_BEFORE_UNSPECIFIED = "ERROR_ELEMENT_MISSING_BEFORE_UNSPECIFIED";
    private static final String _KEY_ERROR_ELEMENT_AMBIGUOUS = "ERROR_ELEMENT_AMBIGUOUS";
    private static final String _KEY_ERROR_ELEMENT_RESTRICTED = "ERROR_ELEMENT_RESTRICTED";
    private static final String _KEY_ERROR_ELEMENT_FIXED = "ERROR_ELEMENT_FIXED";
    private static final String _KEY_WARNING_ELEMENT_TYPE_NULL = "WARNING_ELEMENT_TYPE_NULL";
    private static final String _KEY_ERROR_ATTRIBUTE_UNKNOWN = "ERROR_ATTRIBUTE_UNKNOWN";
    private static final String _KEY_ERROR_ATTRIBUTE_SIMPLE_TYPE = "ERROR_ATTRIBUTE_SIMPLE_TYPE";
    private static final String _KEY_ERROR_ATTRIBUTE_SIMPLE_TYPE_ANON = "ERROR_ATTRIBUTE_SIMPLE_TYPE_ANON";
    private static final String _KEY_ERROR_ATTRIBUTE_MISSING = "ERROR_ATTRIBUTE_MISSING";
    private static final String _KEY_ERROR_ATTRIBUTE_FIXED = "ERROR_ATTRIBUTE_FIXED";
    private static final String _KEY_WARNING_ATTRIBUTE_TYPE_NULL = "WARNING_ATTRIBUTE_TYPE_NULL";
    private static final String _KEY_WARNING_ATTRIBUTE_UNKNOWN = "WARNING_ATTRIBUTE_UNKNOWN";
    private static final String _KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED = "ERROR_CHARACTER_DATA_NOT_ALLOWED";
    private static final String _KEY_ERROR_TOO_MANY = "ERROR_TOO_MANY";
    private static final String _KEY_ERROR_TOO_FEW = "ERROR_TOO_FEW";
    private static final String _KEY_ERROR_SEQUENCE = "ERROR_SEQUENCE";
    private static final String _KEY_ERROR_UNIQUE_IN_FILE = "ERROR_UNIQUE_IN_FILE";
    private static final String _KEY_ERROR_UNBOUND_IDREF = "ERROR_UNBOUND_IDREF";
    private static final String _ERROR_ARG_NULL = "Null DOM node passed as argument to Validator";
    private static final String _ERROR_NO_OWNER = "Attr with no owner Element passed as argument to Validator";
    private static final String _ERROR_NULL_DOCUMENT_ELEMENT = "Document has no root element";

    public static boolean validateSubtree(ValidationContext context, Node root) {
        boolean stillValid = true;
        if (root.getNodeType() == 9) {
            Document document = (Document)root;
            stillValid = Validator.validateDocument(context, document);
        } else if (root.getNodeType() == 1) {
            Element element = (Element)root;
            stillValid = Validator.validateElement(context, element);
        } else if (root.getNodeType() == 2) {
            Attr attr = (Attr)root;
            stillValid = Validator.validateAttribute(context, attr);
        }
        return stillValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateDocument(ValidationContext context, Document document) {
        if (document == null) {
            throw new IllegalArgumentException(_ERROR_ARG_NULL);
        }
        PerValidationState validationState = new PerValidationState();
        CachingValidatorCallback.enableCaching(document);
        try {
            try {
                context.performAdditionalValidation(validationState, document);
            }
            catch (RuntimeException e) {
                Validator.getLogger().log(Level.SEVERE, "Unexpected exception encountered during performAdditionalValidation", e);
            }
            Element rootElement = document.getDocumentElement();
            if (rootElement != null) {
                ElementDef elementDef = Validator._getStarterElementDef(context, rootElement);
                Validator._validateElement(context, validationState, rootElement, elementDef, 0, true);
                if (context.getFeature("ID_VALIDATION")) {
                    Validator._validateIdReferences(context, validationState);
                }
            } else {
                context.reportError(validationState, 53, _ERROR_NULL_DOCUMENT_ELEMENT, document, null, null);
            }
        }
        finally {
            CachingValidatorCallback.disableCaching(document);
        }
        return validationState.isStillValid();
    }

    public static boolean validateElement(ValidationContext context, Element root) {
        return Validator.validateElement(context, root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateElement(ValidationContext context, Element element, boolean deep) {
        if (element == null) {
            throw new IllegalArgumentException(_ERROR_ARG_NULL);
        }
        PerValidationState validationState = new PerValidationState();
        Document ownerDocument = element.getOwnerDocument();
        CachingValidatorCallback.enableCaching(ownerDocument);
        try {
            ElementDef elementDef = Validator._getStarterElementDef(context, element);
            Validator._validateElement(context, validationState, element, elementDef, 0, deep);
        }
        finally {
            CachingValidatorCallback.disableCaching(ownerDocument);
        }
        return validationState.isStillValid();
    }

    public static boolean validateAttribute(ValidationContext context, Attr attribute) {
        ComplexType complexType;
        Wildcard attributeWildcard;
        Type type;
        String attrLocalName;
        String attrNamespace;
        if (attribute == null) {
            throw new IllegalArgumentException(_ERROR_ARG_NULL);
        }
        Element ownerElement = attribute.getOwnerElement();
        if (ownerElement == null) {
            throw new IllegalArgumentException(_ERROR_NO_OWNER);
        }
        PerValidationState validationState = new PerValidationState();
        ElementDef ownerDef = Validator._getStarterElementDef(context, ownerElement);
        AttributeDef attributeDef = null;
        int processingRule = 0;
        if (ownerDef != null && (attributeDef = ownerDef.getAttributeDefByName(attrNamespace = attribute.getNamespaceURI(), attrLocalName = Validator._getLocalName(attribute))) == null && (type = ownerDef.getType()) instanceof ComplexType && (attributeWildcard = (complexType = (ComplexType)type).getAttributeWildcard()) != null && TypeUtils.wildcardAllowsName(attributeWildcard, QualifiedName.getQualifiedName(attrNamespace, attrLocalName))) {
            processingRule = attributeWildcard.getProcessingRule();
            GrammarResolver resolver = context.getGrammarResolver();
            Grammar g = resolver.getGrammarForNamespace(attrNamespace);
            if (g != null) {
                attributeDef = g.getAttributeDefByName(attrLocalName);
            }
        }
        Validator._validateAttribute(context, validationState, attribute, attributeDef, processingRule);
        return validationState.isStillValid();
    }

    protected static String getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle(_VALIDATOR_BUNDLE, Locale.getDefault());
            return b.getString(key);
        }
        catch (Exception e) {
            Validator.getLogger().log(Level.SEVERE, "Error fetching resource for key: " + key, e);
            return "???" + key + "???";
        }
    }

    protected static String getTranslatedString(String key, String arg0, String arg1) {
        try {
            String pattern = Validator.getTranslatedString(key);
            Object[] args = new Object[]{arg0, arg1};
            return MessageFormat.format(pattern, args);
        }
        catch (Exception e) {
            Validator.getLogger().log(Level.SEVERE, "Error fetching resource for key: " + key, e);
            return "???" + key + "???";
        }
    }

    protected static Logger getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger("oracle.bali.xml.validator");
        }
        return _sLogger;
    }

    private static void _validateElement(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, int processingRule, boolean deep) {
        Validator._validateElement(context, validationState, element, elementDef, null, null, processingRule, deep);
    }

    private static void _validateElement(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, State previousAutomataState, Transition matchingTransition, int processingRule, boolean deep) {
        if (processingRule != 2) {
            try {
                context.performAdditionalValidation(validationState, element, elementDef, processingRule, deep);
            }
            catch (RuntimeException e) {
                Validator.getLogger().log(Level.SEVERE, "Unexpected exception encountered during performAdditionalValidation", e);
            }
            if (elementDef == null) {
                String elementLocalName;
                String elementNamespace;
                QualifiedName elementQName;
                if (processingRule == 0 && !_IGNORED_ELEMENTS.contains(elementQName = QualifiedName.getQualifiedName(elementNamespace = element.getNamespaceURI(), elementLocalName = Validator._getLocalName(element)))) {
                    GrammarResolver resolver = context.getGrammarResolver();
                    Grammar g = resolver.getGrammarForNamespace(elementNamespace);
                    if (g != null) {
                        if (previousAutomataState != null) {
                            String expected = null;
                            if (matchingTransition == null) {
                                expected = TransitionUtils.summarizeTransitionsFromState(previousAutomataState);
                            }
                            String message = expected != null ? Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNEXPECTED_DETAILED, element.getTagName(), expected) : Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNEXPECTED, element.getTagName(), "");
                            context.reportError(validationState, 21, message, element, null, null);
                        } else {
                            String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNKNOWN, element.getTagName(), element.getParentNode().getNodeName());
                            context.reportError(validationState, 20, message, element, null, null);
                        }
                    } else {
                        boolean isError = context.getFeature("GRAMMAR_UNAVAILABLE_AS_ERROR");
                        int errorType = isError ? 12 : 10;
                        Node parentNode = element.getParentNode();
                        if (parentNode.getNodeType() == 9) {
                            errorType = isError ? 13 : 11;
                        }
                        String message = null;
                        message = elementNamespace != null ? Validator.getTranslatedString(_KEY_WARNING_GRAMMAR_UNAVAILABLE, elementNamespace, elementLocalName) : Validator.getTranslatedString(_KEY_WARNING_ABSENT_NS_GRAMMAR_UNAVAILABLE, elementNamespace, elementLocalName);
                        if (isError) {
                            context.reportError(validationState, errorType, message, element, null, null);
                        } else {
                            context.reportWarning(validationState, errorType, message, element, null);
                        }
                    }
                }
            } else {
                Type type = elementDef.getType();
                if (type == null) {
                    String message = Validator.getTranslatedString(_KEY_WARNING_ELEMENT_TYPE_NULL, element.getTagName(), "");
                    context.reportWarning(validationState, 26, message, element, null);
                    return;
                }
                ComplexType complexType = null;
                SimpleType simpleType = null;
                Wildcard attributeWildcard = null;
                if (type instanceof SimpleType) {
                    simpleType = (SimpleType)type;
                } else {
                    complexType = (ComplexType)type;
                    attributeWildcard = complexType.getAttributeWildcard();
                }
                Validator._validateAttributes(context, validationState, element, elementDef, attributeWildcard);
                if (simpleType != null) {
                    Validator._validateElementSimpleContent(context, validationState, element, elementDef, simpleType);
                } else {
                    int variety = complexType.getVariety();
                    if (variety == 5) {
                        simpleType = TypeUtils.getSimpleTypeAncestor(complexType);
                        Validator._validateElementSimpleContent(context, validationState, element, elementDef, simpleType);
                    } else if (deep) {
                        ContentGroup group = complexType.getContentGroup();
                        boolean isMixed = variety == 4;
                        Validator._validateChildren(context, validationState, element, elementDef, group, isMixed);
                    }
                }
            }
            if (context.getFeature("UNIQUE_KEY_KEYREF_VALIDATION") && elementDef != null && elementDef.hasIdentityConstraints()) {
                IdentityConstraintValidation.validateConstraints(element, elementDef, context, validationState);
            }
        }
    }

    private static void _validateChildren(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, ContentGroup group, boolean isMixed) {
        if (group != null) {
            if (context.getFeature("RESPECT_GROUP_RULES")) {
                GrammarResolver resolver = context.getGrammarResolver();
                State currentState = AutomataBuilder.buildAutomata(group);
                ContentGroup allGroup = Validator._shouldValidateAllGroup(group);
                if (allGroup != null) {
                    Validator._validateAllGroupChildren(context, validationState, element, elementDef, allGroup, resolver, currentState, isMixed);
                } else {
                    for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                        short nodeType = child.getNodeType();
                        if (nodeType == 1) {
                            Element childElement = (Element)child;
                            String namespace = childElement.getNamespaceURI();
                            String localName = Validator._getLocalName(childElement);
                            QualifiedName qName = QualifiedName.getQualifiedName(namespace, localName);
                            ElementDef childDef = null;
                            int childProcessingRule = 0;
                            Transition transition = currentState.getTransitionFromState(resolver, qName);
                            if (transition == null && context.getFeature("IMPROVED_INCOMPLETE_ERRORS")) {
                                String message;
                                String expected;
                                TransitionUtils.SearchResult searchResult = TransitionUtils.searchForUnambigousMatchingTransition(resolver, currentState, qName, element, _LAX_WILDCARD_NAMESPACES);
                                transition = searchResult.getTransition();
                                if (transition != null) {
                                    expected = TransitionUtils.summarizeTransitionsFromState(currentState);
                                    message = expected != null ? Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING_BEFORE, expected, childElement.getTagName()) : Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING_BEFORE_UNSPECIFIED, childElement.getTagName(), "");
                                    context.reportError(validationState, 23, message, childElement, null, null);
                                } else if (searchResult.foundConflict()) {
                                    expected = TransitionUtils.summarizeTransitionsFromState(currentState);
                                    message = expected != null ? Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING_BEFORE, expected, childElement.getTagName()) : Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING_BEFORE_UNSPECIFIED, childElement.getTagName(), "");
                                    context.reportError(validationState, 23, message, childElement, null, null);
                                    message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_AMBIGUOUS, childElement.getTagName(), "");
                                    context.reportError(validationState, 21, message, childElement, null, null);
                                    childProcessingRule = 2;
                                }
                            }
                            if (transition != null) {
                                childDef = TransitionUtils.getElementDefFromTransition(resolver, transition, qName, childElement);
                                childProcessingRule = TransitionUtils.getProcessingRuleFromTransition(resolver, transition, _LAX_WILDCARD_NAMESPACES);
                            }
                            Validator._validateElement(context, validationState, childElement, childDef, currentState, transition, childProcessingRule, true);
                            if (transition == null) continue;
                            currentState = transition.getToState();
                            continue;
                        }
                        if (nodeType != 3 && nodeType != 4 || isMixed || !Validator._hasNonWhitespaceChars(child.getNodeValue())) continue;
                        String message = Validator.getTranslatedString(_KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED, element.getTagName(), "");
                        context.reportError(validationState, 38, message, child, null, null);
                    }
                    if (!currentState.isFinalState()) {
                        String message = null;
                        String transSummary = TransitionUtils.summarizeTransitionsFromState(currentState);
                        message = transSummary != null ? Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING, transSummary, element.getTagName()) : Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING_UNSPECIFIED, element.getTagName(), "");
                        if (context.getFeature("IMPROVED_INCOMPLETE_ERRORS")) {
                            context.reportError(validationState, 23, message, element, null, currentState);
                        } else {
                            context.reportWarning(validationState, 23, message, element, currentState);
                        }
                    }
                }
            } else {
                Validator._validateChildrenIgnoringGroup(context, validationState, element, elementDef, isMixed);
            }
        } else {
            Validator._checkForIllegalChildren(context, validationState, element, isMixed);
        }
    }

    private static void _validateAllGroupChildren(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, ContentGroup allGroup, GrammarResolver resolver, State currentState, boolean isMixed) {
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        transitions.addAll(currentState.getTransitionsFromState());
        int originalSize = transitions.size();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                Element childElement = (Element)child;
                String namespace = childElement.getNamespaceURI();
                String localName = Validator._getLocalName(childElement);
                QualifiedName qName = QualifiedName.getQualifiedName(namespace, localName);
                ElementDef childDef = null;
                for (int i = 0; i < transitions.size(); ++i) {
                    Transition transition = (Transition)transitions.get(i);
                    if (!(transition instanceof ElementDefTransition) || !transition.accepts(resolver, qName)) continue;
                    childDef = ((ElementDefTransition)transition).getElementDef(resolver, qName, childElement);
                    transitions.remove(i);
                    break;
                }
                if (childDef == null) {
                    String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNEXPECTED, childElement.getTagName(), "");
                    context.reportError(validationState, 21, message, childElement, null, null);
                }
                int childProcessingRule = 0;
                Validator._validateElement(context, validationState, childElement, childDef, childProcessingRule, true);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || isMixed || !Validator._hasNonWhitespaceChars(child.getNodeValue())) continue;
            String message = Validator.getTranslatedString(_KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED, element.getTagName(), "");
            context.reportError(validationState, 38, message, child, null, null);
        }
        if (!(transitions.isEmpty() || allGroup.getMinOccurs() == 0 && transitions.size() == originalSize)) {
            for (Transition transition : transitions) {
                ElementDef childDef;
                if (!(transition instanceof ElementDefTransition) || (childDef = ((ElementDefTransition)transition).getElementDef()).getMinOccurs() <= 0) continue;
                String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_MISSING, childDef.getName(), element.getTagName());
                if (context.getFeature("IMPROVED_INCOMPLETE_ERRORS")) {
                    context.reportError(validationState, 23, message, element, null, null);
                    continue;
                }
                context.reportWarning(validationState, 23, message, element, null);
            }
        }
    }

    private static void _validateChildrenIgnoringGroup(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, boolean isMixed) {
        GrammarResolver resolver = context.getGrammarResolver();
        List wildcards = TypeUtils.getElementWildcards(elementDef);
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                Wildcard matchingWildcard;
                Element childElement = (Element)child;
                String namespace = childElement.getNamespaceURI();
                String localName = Validator._getLocalName(childElement);
                ElementDef childDef = elementDef.getElementDefByName(namespace, localName);
                int childProcessingRule = 0;
                if (childDef == null && (matchingWildcard = TypeUtils.getMatchingWildcard(wildcards, namespace)) != null && TypeUtils.wildcardAllowsName(matchingWildcard, QualifiedName.getQualifiedName(namespace, localName))) {
                    childProcessingRule = matchingWildcard.getProcessingRule();
                    Grammar g = resolver.getGrammarForNamespace(namespace);
                    if (g != null) {
                        childDef = g.getElementDefByName(localName);
                    }
                }
                Validator._validateElement(context, validationState, childElement, childDef, childProcessingRule, true);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || isMixed || !Validator._hasNonWhitespaceChars(child.getNodeValue())) continue;
            String message = Validator.getTranslatedString(_KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED, element.getTagName(), "");
            context.reportError(validationState, 38, message, child, null, null);
        }
    }

    private static void _checkForIllegalChildren(ValidationContext context, PerValidationState validationState, Element simpleElement, boolean isMixed) {
        for (Node child = simpleElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            String message;
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_UNKNOWN, child.getNodeName(), simpleElement.getNodeName());
                context.reportError(validationState, 20, message, child, null, null);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || isMixed || !Validator._hasNonWhitespaceChars(child.getNodeValue())) continue;
            message = Validator.getTranslatedString(_KEY_ERROR_CHARACTER_DATA_NOT_ALLOWED, simpleElement.getTagName(), "");
            context.reportError(validationState, 38, message, child, null, null);
        }
    }

    private static void _validateAttributes(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, Wildcard attributeWildcard) {
        Collection attrDefs = elementDef.getAttributeDefs();
        Iterator attrIter = attrDefs.iterator();
        boolean hasAttribute = false;
        while (attrIter.hasNext()) {
            AttributeDef attrDef = (AttributeDef)attrIter.next();
            if (!attrDef.isRequired()) continue;
            String ns = attrDef.getTargetNamespace();
            if ("".equals(ns)) {
                ns = null;
            }
            if (hasAttribute = element.hasAttributeNS(ns, attrDef.getName())) continue;
            String message = Validator.getTranslatedString(_KEY_ERROR_ATTRIBUTE_MISSING, attrDef.getQualifiedName().getQualifiedName(), element.getTagName());
            context.reportError(validationState, 32, message, element, null, attrDef.getQualifiedName());
        }
        Attr currentAttr = null;
        AttributeDef currentDef = null;
        String attrNamespace = null;
        String attrLocalName = null;
        GrammarResolver resolver = context.getGrammarResolver();
        NamedNodeMap attrMap = element.getAttributes();
        if (attrMap != null) {
            int length = attrMap.getLength();
            for (int i = 0; i < length; ++i) {
                currentAttr = (Attr)attrMap.item(i);
                attrNamespace = currentAttr.getNamespaceURI();
                attrLocalName = Validator._getLocalName(currentAttr);
                currentDef = elementDef.getAttributeDefByName(attrNamespace, attrLocalName);
                int processingRule = 0;
                if (currentDef == null && attributeWildcard != null && TypeUtils.wildcardAllowsName(attributeWildcard, QualifiedName.getQualifiedName(attrNamespace, attrLocalName))) {
                    processingRule = attributeWildcard.getProcessingRule();
                    Grammar g = resolver.getGrammarForNamespace(attrNamespace);
                    if (g != null) {
                        currentDef = g.getAttributeDefByName(attrLocalName);
                    }
                }
                Validator._validateAttribute(context, validationState, currentAttr, currentDef, processingRule);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void _validateAttribute(ValidationContext context, PerValidationState validationState, Attr attribute, AttributeDef attributeDef, int processingRule) {
        if (processingRule != 2) {
            if (attributeDef == null) {
                if (processingRule == 0 && !Validator._IGNORED_ATTR_NAMESPACES.contains(attrNamespace = attribute.getNamespaceURI())) {
                    if (context.getFeature("TOLERATE_UNKNOWN_ATTRS")) {
                        message = Validator.getTranslatedString("WARNING_ATTRIBUTE_UNKNOWN", attribute.getName(), attribute.getOwnerElement().getTagName());
                        context.reportWarning(validationState, 35, message, attribute, null);
                    } else {
                        message = Validator.getTranslatedString("ERROR_ATTRIBUTE_UNKNOWN", attribute.getName(), attribute.getOwnerElement().getTagName());
                        context.reportError(validationState, 30, message, attribute, null, null);
                    }
                }
            } else {
                simpleType = attributeDef.getType();
                attributeValue = attribute.getValue();
                if (simpleType != null) {
                    try {
                        simpleType.validateValue(attributeValue);
                        if (attributeValue == null) ** GOTO lbl45
                        if (TypeUtils.isIdType(simpleType)) {
                            duplicate = validationState.addId(attributeValue, attribute);
                            if (!duplicate || !context.getFeature("ID_VALIDATION")) ** GOTO lbl45
                            originalNode = validationState.getNodeForId(attributeValue);
                            message = Validator.getTranslatedString("ERROR_UNIQUE_IN_FILE", attributeValue, "");
                            ve = new UniqueException(100, message, (Node)attribute, Collections.singletonList(originalNode));
                            context.reportError(validationState, ve);
                        }
                        if (TypeUtils.isIdRefType(simpleType)) {
                            validationState.addIdReference(attributeValue, attribute);
                        }
                        if (!TypeUtils.isIdRefsType(simpleType)) ** GOTO lbl45
                        refs = attributeValue.split(" ");
                        for (i = 0; i < refs.length; ++i) {
                            ref = refs[i].trim();
                            if (ref.length() <= 0) continue;
                            validationState.addIdReference(ref, attribute);
                        }
                    }
                    catch (GrammarException sourceException) {
                        message = null;
                        attributeName = attribute.getName();
                        typeName = simpleType.getName();
                        message = typeName == null ? Validator.getTranslatedString("ERROR_ATTRIBUTE_SIMPLE_TYPE_ANON", attributeName, "") : Validator.getTranslatedString("ERROR_ATTRIBUTE_SIMPLE_TYPE", attributeName, typeName);
                        context.reportError(validationState, 31, message, attribute, sourceException, null);
                    }
                } else {
                    message = Validator.getTranslatedString("WARNING_ATTRIBUTE_TYPE_NULL", attribute.getName(), attribute.getOwnerElement().getTagName());
                    context.reportWarning(validationState, 34, message, attribute, null);
                }
lbl45:
                // 8 sources

                fixedValue = attributeDef.getFixedValue();
                if (fixedValue != null && !(valuesMatch = Validator._validateFixedValue(fixedValue, attributeValue, simpleType))) {
                    message = Validator.getTranslatedString("ERROR_ATTRIBUTE_FIXED", attribute.getName(), fixedValue);
                    context.reportError(validationState, 33, message, attribute, null, null);
                }
            }
            try {
                context.performAdditionalValidation(validationState, attribute, attributeDef, processingRule);
            }
            catch (RuntimeException e) {
                Validator.getLogger().log(Level.SEVERE, "Unexpected exception encountered during performAdditionalValidation", e);
            }
        }
    }

    private static ElementDef _getStarterElementDef(ValidationContext context, Element element) {
        LinkedList<Element> documentPath = new LinkedList<Element>();
        Element currentElement = element;
        while (currentElement != null) {
            documentPath.addFirst(currentElement);
            Node parentNode = currentElement.getParentNode();
            if (parentNode.getNodeType() == 1) {
                currentElement = (Element)parentNode;
                continue;
            }
            currentElement = null;
        }
        GrammarResolver resolver = context.getGrammarResolver();
        ListIterator listIter = documentPath.listIterator();
        ElementDef currentDef = null;
        while (listIter.hasNext()) {
            Grammar grammar;
            Element anElement = (Element)listIter.next();
            ElementDef tempDef = null;
            String namespace = anElement.getNamespaceURI();
            String localName = Validator._getLocalName(anElement);
            if (currentDef != null) {
                tempDef = currentDef.getElementDefByName(namespace, localName);
            }
            if (tempDef == null && (grammar = resolver.getGrammarForNamespace(namespace)) != null) {
                tempDef = grammar.getElementDefByName(localName);
            }
            currentDef = tempDef;
        }
        return currentDef;
    }

    private static void _validateElementSimpleContent(ValidationContext context, PerValidationState validationState, Element element, ElementDef elementDef, SimpleType simpleType) {
        if (simpleType != null) {
            boolean valuesMatch;
            StringBuffer stringBuffer = new StringBuffer();
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                String nodeValue;
                if (child.getNodeType() != 3 && child.getNodeType() != 4 || (nodeValue = child.getNodeValue()) == null) continue;
                stringBuffer.append(nodeValue);
            }
            String simpleValue = stringBuffer.toString();
            try {
                simpleType.validateValue(simpleValue);
            }
            catch (GrammarException sourceException) {
                String message = null;
                String elementTagName = element.getTagName();
                String typeName = simpleType.getName();
                message = typeName == null ? Validator.getTranslatedString(_KEY_ERROR_ELEMENT_SIMPLE_TYPE_ANON, elementTagName, "") : Validator.getTranslatedString(_KEY_ERROR_ELEMENT_SIMPLE_TYPE, elementTagName, typeName);
                context.reportError(validationState, 22, message, element, sourceException, null);
            }
            String fixedValue = elementDef.getFixedValue();
            if (fixedValue != null && !(valuesMatch = Validator._validateFixedValue(fixedValue, simpleValue, simpleType))) {
                String message = Validator.getTranslatedString(_KEY_ERROR_ELEMENT_FIXED, element.getTagName(), fixedValue);
                context.reportError(validationState, 25, message, element, null, null);
            }
        }
        Validator._checkForIllegalChildren(context, validationState, element, true);
    }

    private static void _validateIdReferences(ValidationContext context, PerValidationState validationState) {
        Set<String> referencedIds = validationState.getReferencedIds();
        for (String idReference : referencedIds) {
            if (validationState.getNodeForId(idReference) != null) continue;
            List<Node> invalidNodes = validationState.getIdReferenceNodes(idReference);
            for (Node invalidNode : invalidNodes) {
                String message = Validator.getTranslatedString(_KEY_ERROR_UNBOUND_IDREF, idReference, "");
                context.reportError(validationState, 45, message, invalidNode, null, null);
            }
        }
    }

    private static boolean _validateFixedValue(String fixedValue, String actualValue, SimpleType simpleType) {
        boolean equalValues = false;
        if (fixedValue.equals(actualValue)) {
            equalValues = true;
        } else if (simpleType != null) {
            if ("QName".equals(simpleType.getName())) {
                return true;
            }
            try {
                Object obj1 = simpleType.convertToJavaType(fixedValue);
                Object obj2 = simpleType.convertToJavaType(actualValue);
                if (obj1 != null && obj2 != null) {
                    if (obj1.equals(obj2)) {
                        equalValues = true;
                    } else if (obj1 instanceof Comparable && ((Comparable)obj1).compareTo(obj2) == 0) {
                        equalValues = true;
                    }
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return equalValues;
    }

    private static String _getLocalName(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    if (node.getNamespaceURI() == null) {
                        return node.getNodeName();
                    }
                    return node.getLocalName();
                }
            }
        }
        return null;
    }

    private static boolean _hasNonWhitespaceChars(String characterData) {
        char[] cArr = characterData.toCharArray();
        block3: for (int i = 0; i < cArr.length; ++i) {
            char c = cArr[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    private static ContentGroup _shouldValidateAllGroup(ContentGroup group) {
        ContentGroup childGroup;
        Particle particle;
        ContentGroup allGroup;
        ContentGroup contentGroup = allGroup = group.getVariety() == 7 ? group : null;
        if (allGroup == null && group.getVariety() == 9 && group.getComponents().size() == 1 && (particle = (Particle)group.getComponents().iterator().next()) instanceof ContentGroup && (childGroup = (ContentGroup)particle).getVariety() == 7) {
            allGroup = childGroup;
        }
        if (allGroup != null) {
            if (allGroup.getMaxOccurs() != 1) {
                return null;
            }
            Collection children = allGroup.getComponents();
            for (Particle child : children) {
                if (child instanceof ElementDef && child.getMaxOccurs() == 1) continue;
                return null;
            }
        }
        return allGroup;
    }

    static {
        _IGNORED_ATTR_NAMESPACES.add(XML_NAMESPACE);
        _IGNORED_ATTR_NAMESPACES.add(XMLNS_NAMESPACE);
        _IGNORED_ATTR_NAMESPACES.add(XSI_NAMESPACE);
        _IGNORED_ATTR_NAMESPACES.add(IGNORED_NAMESPACE);
        QualifiedName jspComment10 = QualifiedName.getQualifiedName("http://java.sun.com/products/jsp/dtd/jsp_1_0.dtd", "jspComment");
        QualifiedName jspComment20 = QualifiedName.getQualifiedName("http://java.sun.com/products/jsp/dtd/jsp_2_0.dtd", "jspComment");
        _IGNORED_ELEMENTS.add(jspComment10);
        _IGNORED_ELEMENTS.add(jspComment20);
        _LAX_WILDCARD_NAMESPACES.add("http://java.sun.com/JSF/Configuration");
    }
}

