/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import oracle.jdeveloper.xml.dtd.DtdRegistry;
import oracle.jdevimpl.xml.dtd.parser.DocumentHandler;
import oracle.jdevimpl.xml.dtd.parser.ParserConstants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class MarkupDefaultHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DocumentHandler,
ParserConstants {
    protected boolean insideDTD = false;
    private Locator locator;
    private HashMap systemResourceMap = new HashMap();
    private HashMap publicResourceMap = new HashMap();
    static final String JAR_URL_SEPARATOR = "!/";

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
        this.insideDTD = false;
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.insideDTD = true;
    }

    public void startEntity(String name) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputStream resource;
        block17: {
            URL resourceLocation = null;
            if (systemId == null || systemId.length() == 0) {
                resourceLocation = DtdRegistry.getPublicIdLocation(publicId);
                if (resourceLocation != null) {
                    systemId = resourceLocation.toExternalForm();
                }
            } else {
                resourceLocation = DtdRegistry.getSystemIdLocation(systemId);
            }
            if (resourceLocation == null) {
                try {
                    resourceLocation = new URL(systemId);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            resource = null;
            if (resourceLocation != null) {
                try {
                    if (resourceLocation.getProtocol().equalsIgnoreCase("file")) {
                        String s = resourceLocation.getFile();
                        resource = new FileInputStream(s);
                        break block17;
                    }
                    if (MarkupDefaultHandler.isJarURL(resourceLocation)) {
                        URL jarFileUrl = MarkupDefaultHandler.getJarFileURL(resourceLocation);
                        if (jarFileUrl.getProtocol().equalsIgnoreCase("file")) {
                            URLConnection resourceConnection = resourceLocation.openConnection();
                            resourceConnection.setUseCaches(false);
                            resource = resourceConnection.getInputStream();
                        }
                        break block17;
                    }
                    if (!resourceLocation.getProtocol().equalsIgnoreCase("http")) {
                        resource = resourceLocation.openStream();
                        break block17;
                    }
                    InputSource is = new InputSource();
                    is.setPublicId(publicId);
                    is.setSystemId(systemId);
                    is.setCharacterStream(new StringReader(""));
                    return is;
                }
                catch (IOException ioExc) {
                    try {
                        if (resource != null) {
                            resource.close();
                            resource = null;
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        }
        if (resource != null) {
            InputSource is = new InputSource(resource);
            is.setPublicId(publicId);
            is.setSystemId(systemId);
            return is;
        }
        return null;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void jspComment(char[] ch, int start, int length) throws SAXException {
    }

    public void directive(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
    }

    public void declaration(String declaration) throws SAXException {
    }

    public void expression(String expression) throws SAXException {
    }

    public void scriptlet(String scriptlet) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
    }

    public void setElementStartLocationInfo(int startOffset, int endOffset) throws SAXException {
    }

    public void setElementEndLocationInfo(int startOffset, int endOffset) throws SAXException {
    }

    public void setEmptyElementEndLocationInfo(String namespace, String qName, int startOffset, int endOffset) throws SAXException {
    }

    public void startRepeatElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
    }

    public void endRepeatElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void setRepeatElementStartLocationInfo(int startOffset, int endOffset) throws SAXException {
    }

    public void setRepeatElementEndLocationInfo(int startOffset, int endOffset) throws SAXException {
    }

    public void setDocumentNamespace(String namespaceURI) throws SAXException {
    }

    public void setDefaultNamespace(String namespaceURI) throws SAXException {
    }

    public void xmlDeclaration(String version, String standalone, String encoding, int[] xmlDeclOffsets, int[] xmlDeclVersionOffsets, int[] xmlDeclStandaloneOffsets, int[] xmlDeclEncodingOffsets) throws SAXException {
    }

    public void setTextStartOffset(int startOffset) {
    }

    static int typeToInt(String s) {
        if ((s = s.intern()) == "ID") {
            return 1;
        }
        if (s == "IDREF") {
            return 2;
        }
        if (s == "IDREFS") {
            return 3;
        }
        if (s == "ENTITY") {
            return 4;
        }
        if (s == "ENTITIES") {
            return 5;
        }
        if (s == "NMTOKEN") {
            return 6;
        }
        if (s == "NMTOKENS") {
            return 7;
        }
        if (s == "NOTATION") {
            return 8;
        }
        return s != "CDATA" ? -1 : 0;
    }

    static boolean isJarURL(URL jarURL) {
        return jarURL != null ? jarURL.getProtocol().equals("jar") || jarURL.getProtocol().equals("wsjar") : false;
    }

    static URL getJarFileURL(URL jarURL) {
        String urlPathStr;
        int bangPos;
        if (MarkupDefaultHandler.isJarURL(jarURL) && (bangPos = (urlPathStr = jarURL.getPath()).indexOf(JAR_URL_SEPARATOR)) >= 0) {
            String resultStr = urlPathStr.substring(0, bangPos);
            return MarkupDefaultHandler.newJarFileURLImpl(resultStr);
        }
        return jarURL;
    }

    static String getJarEntry(URL jarURL) {
        String urlPathStr;
        int bangPos;
        if (MarkupDefaultHandler.isJarURL(jarURL) && (bangPos = (urlPathStr = jarURL.getPath()).indexOf(JAR_URL_SEPARATOR)) >= 0) {
            return urlPathStr.substring(bangPos + 2);
        }
        return null;
    }

    static URL newJarFileURLImpl(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

