/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.DefaultXMIMetaModelProvider;
import oracle.mof.xmi.ResourcesSingleton;
import oracle.mof.xmi.UnsupportedLogger;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIMetaModelProvider;
import oracle.mof.xmi.XMIModelBuilder;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIPropertyType;
import oracle.mof.xmi.XMIType;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMIReader {
    private static final String XMI = "XMI";
    private static final String XMI_1X_VERSION = "xmi.version";
    private static final String XMI_2X_VERSION = "version";
    private static final String XMI_2X_ID = "id";
    private static final String XMI_2X_UUID = "uuid";
    private static final String XMI_2X_LABEL = "label";
    private static final String XMI_2X_TYPE = "type";
    private EntityResolver m_entityResolver = new DefaultHandler();
    private ErrorHandler m_errorHandler = new DefaultHandler();
    private boolean m_validating;
    private boolean m_logUnsupported;
    private int m_unsupportedCount;
    private XMIMetaModelProvider m_metamodelProvider;
    private final HashMap<String, XMIHandler> m_strategies = new HashMap();
    private SAXParser m_parser;
    private XMIModelBuilder<?> m_builder;
    private final HashMap<String, ArrayList<String>> m_prefixMapping = new HashMap();
    private final ElementHandler m_ignoreHandler = new IgnoreHandler();
    private final XMLUniversalName m_lookupWrapper = new XMLUniversalName();
    private final StringBuilder m_contentBuffer = new StringBuilder();
    private final XMIHandler m_rootHandler = new XMIHandler();
    private XMIHandler m_versionStrategy;
    private final ArrayList<ElementHandler> m_handlerStack = new ArrayList();
    private final ArrayList<Object> m_instanceStack = new ArrayList();
    private Locator m_locator;

    public void setMetaModelProvider(XMIMetaModelProvider provider) {
        ContractUtils.checkNull(provider, "Provider must not be null");
        this.m_metamodelProvider = provider;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler == null ? new DefaultHandler() : errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.m_entityResolver = resolver == null ? new DefaultHandler() : resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.m_entityResolver;
    }

    public void setLogUnsupported(boolean logUnsupported) {
        this.m_logUnsupported = logUnsupported;
    }

    public boolean logUnsupported() {
        return this.m_logUnsupported;
    }

    private void report(XMIException e) throws SAXException {
        e.report(this.m_locator, this.m_parser.getErrorHandler());
    }

    private void fatalError(String message) throws SAXException {
        SAXParseException e = new SAXParseException(message, this.m_locator);
        this.m_parser.getErrorHandler().fatalError(e);
        throw e;
    }

    private void fatalError(Exception e) throws SAXException {
        SAXParseException saxe = new SAXParseException(null, this.m_locator, e);
        this.m_parser.getErrorHandler().fatalError(saxe);
        throw saxe;
    }

    public void setValidation(boolean validating) {
        this.m_validating = validating;
    }

    public boolean isValidating() {
        return this.m_validating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(XMIModelBuilder<T> builder, InputSource inputSource) throws SAXException {
        ContractUtils.checkNull(builder, "Missing builder");
        ContractUtils.checkNull(inputSource, "Missing input source");
        if (this.m_metamodelProvider == null) {
            throw new IllegalStateException("No metamodel provider registered");
        }
        try {
            this.m_builder = builder;
            this.m_builder.startDocument(this, inputSource);
            this.m_unsupportedCount = 0;
            this.m_locator = null;
            this.m_parser = new SAXParser();
            this.m_parser.setFeature("http://xml.org/sax/features/validation", this.m_validating);
            this.m_parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            this.m_parser.setErrorHandler((ErrorHandler)this.m_rootHandler);
            this.m_parser.setEntityResolver((EntityResolver)this.m_rootHandler);
            this.setStrategy(this.m_rootHandler);
            try {
                this.m_parser.parse(inputSource);
            }
            catch (IOException ioe) {
                this.fatalError(ioe);
            }
            if (this.m_unsupportedCount != 0 && !this.logUnsupported()) {
                this.m_errorHandler.warning(new SAXParseException(ResourcesSingleton.getPicker().getString(this.m_unsupportedCount == 1 ? "TotalIgnoresSingular.text" : "TotalIgnoresPlural.text", (Object)new Integer(this.m_unsupportedCount)), null));
            }
        }
        finally {
            this.m_builder = null;
            this.m_prefixMapping.clear();
            this.m_handlerStack.clear();
            this.m_instanceStack.clear();
            this.m_parser = null;
            this.m_locator = null;
            this.m_contentBuffer.setLength(0);
            this.m_versionStrategy = null;
            try {
                InputStream is = inputSource.getByteStream();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return builder.endDocument();
    }

    private void addPrefixMapping(String prefix, String uri) {
        ArrayList<String> stack = this.m_prefixMapping.get(prefix);
        if (stack == null) {
            stack = new ArrayList();
            this.m_prefixMapping.put(prefix, stack);
        }
        stack.add(uri);
    }

    private void removePrefixMapping(String prefix) {
        ArrayList<String> stack = this.m_prefixMapping.get(prefix);
        int size = stack.size();
        if (size == 1) {
            this.m_prefixMapping.remove(prefix);
        } else {
            stack.remove(size - 1);
        }
    }

    private String getPrefixMapping(String prefix) {
        ArrayList<String> stack = this.m_prefixMapping.get(prefix);
        if (stack == null || stack.size() == 0) {
            return null;
        }
        return stack.get(stack.size() - 1);
    }

    private Set<String> getPrefixNamespaces() {
        HashSet<String> namespaces = new HashSet<String>(this.m_prefixMapping.size() * 2);
        for (ArrayList<String> stack : this.m_prefixMapping.values()) {
            if (stack == null || stack.size() <= 0) continue;
            namespaces.add(stack.get(stack.size() - 1));
        }
        return namespaces;
    }

    private void pushInstance(Object instance) {
        ContractUtils.checkNull(instance, "Missing instance");
        this.m_instanceStack.add(instance);
    }

    private Object popInstance() {
        return this.m_instanceStack.remove(this.m_instanceStack.size() - 1);
    }

    private Object peekInstance() {
        return this.m_instanceStack.get(this.m_instanceStack.size() - 1);
    }

    private void pushHandler(ElementHandler handler) {
        this.m_parser.setContentHandler((ContentHandler)handler);
        this.m_handlerStack.add(handler);
    }

    private void pushIgnoreHandler() {
        this.pushHandler(this.m_ignoreHandler);
    }

    private ElementHandler popHandler() {
        ElementHandler handler = this.m_handlerStack.remove(this.m_handlerStack.size() - 1);
        this.m_parser.setContentHandler((ContentHandler)this.peekHandler(0));
        return handler;
    }

    private ElementHandler peekHandler(int position) {
        return (position += this.m_handlerStack.size() - 1) < 0 ? this.m_ignoreHandler : this.m_handlerStack.get(position);
    }

    private XMIHandler getStrategy(String version) throws SAXException {
        XMIHandler strategy = this.m_strategies.get(version);
        if (strategy == null) {
            if ("1.0".compareTo(version) <= 0 && "2.0".compareTo(version) > 0) {
                strategy = new XMI1XHandler();
            } else if ("2.0".compareTo(version) <= 0 && "2.2".compareTo(version) > 0) {
                strategy = new XMI2XHandler("http://schema.omg.org/spec/XMI/" + version);
            } else if ("2.4".equals(version)) {
                strategy = new XMI2XHandler("http://www.omg.org/spec/XMI/20100901");
            } else if ("2.4.1".equals(version)) {
                strategy = new XMI2XHandler("http://www.omg.org/spec/XMI/20110701");
            } else {
                this.fatalError(ResourcesSingleton.getPicker().getString("UnsupportedXMIVersion.text", (Object)version));
            }
            this.m_strategies.put(version, strategy);
        }
        return strategy;
    }

    private void setStrategy(XMIHandler strategy) {
        this.m_versionStrategy = strategy;
        this.pushHandler(strategy);
    }

    private class DatatypeHandler
    extends ValueHandler {
        private boolean m_attributeValue;
        private boolean m_complexContent;

        public DatatypeHandler(XMIProperty property) {
            super(property);
        }

        @Override
        public void addValue(Object instance, Object value) throws SAXException {
            try {
                this.m_property.addValue(instance, value);
            }
            catch (XMIException e) {
                XMIReader.this.report(e);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.m_complexContent = true;
            XMIReader.this.m_versionStrategy.handleNestedDatatype(this.m_property, atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XMIReader.this.popHandler();
            if (XMIReader.this.m_contentBuffer.length() > 0) {
                if (this.m_complexContent) {
                    if (XMIReader.this.m_contentBuffer.toString().trim().length() > 0) {
                        XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("MixedDatatypeContent.text"), null, 1));
                    }
                } else if (this.m_attributeValue) {
                    XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("MixedDatatypeContent.text"), null, 1));
                } else {
                    this.addValue(XMIReader.this.peekInstance(), XMIReader.this.m_contentBuffer.toString());
                }
            }
        }

        @Override
        public void handleAttributes(Attributes atts) throws SAXException {
            this.m_complexContent = false;
            XMIReader.this.m_contentBuffer.setLength(0);
            this.m_attributeValue = XMIReader.this.m_versionStrategy.handleDatatype(this.m_property, atts);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            XMIReader.this.m_contentBuffer.append(ch, start, length);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            XMIReader.this.m_contentBuffer.append(ch, start, length);
        }
    }

    private class CompositeHandler
    extends ValueHandler {
        public CompositeHandler(XMIProperty property) {
            super(property);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            XMIReader.this.m_versionStrategy.handleComposite(namespaceURI, localName, atts);
        }

        @Override
        public void handleAttributes(Attributes atts) throws SAXException {
            XMIReader.this.m_versionStrategy.handleComposite(this.m_property, atts);
        }

        @Override
        public void addValue(Object instance, Object value) throws SAXException {
            XMIReader.this.m_versionStrategy.handleCompositeValue(instance, this.m_property, (String)value);
        }

        @Override
        public void addInstance(Object instance) {
            XMIReader.this.m_builder.addInstance(XMIReader.this.m_locator, XMIReader.this.peekInstance(), this.m_property, instance);
        }

        @Override
        public void endInstance() {
            XMIReader.this.m_versionStrategy.endComposite();
        }
    }

    private class ReferenceHandler
    extends ValueHandler {
        public ReferenceHandler(XMIProperty property) {
            super(property);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            XMIReader.this.m_versionStrategy.handleNestedReference(this.m_property, atts);
        }

        @Override
        public void handleAttributes(Attributes atts) throws SAXException {
            XMIReader.this.m_versionStrategy.handleReference(this.m_property, atts);
        }

        @Override
        public void addValue(Object instance, Object value) {
            XMIReader.this.m_versionStrategy.handleReferenceValue(instance, this.m_property, (String)value);
        }
    }

    private class UUIDHandler
    extends ValueHandler {
        public UUIDHandler(XMIProperty property) {
            super(property);
        }

        @Override
        public void addValue(Object instance, Object value) throws SAXException {
            super.addValue(instance, value);
            try {
                XMIReader.this.m_builder.addInstanceByUUID((String)value, instance);
            }
            catch (XMIException e) {
                XMIReader.this.report(e);
            }
        }
    }

    private class IdHandler
    extends ValueHandler {
        public IdHandler(XMIProperty property) {
            super(property);
        }

        @Override
        public void addValue(Object instance, Object value) throws SAXException {
            super.addValue(instance, value);
            try {
                XMIReader.this.m_builder.addInstanceById((String)value, instance);
            }
            catch (XMIException e) {
                XMIReader.this.report(e);
            }
        }
    }

    private class ValueHandler
    extends ElementHandler {
        protected XMIProperty m_property;

        public ValueHandler(XMIProperty property) {
            this.m_property = property;
        }

        @Override
        public void addValue(Object instance, Object value) throws SAXException {
            try {
                if (this.m_property != null) {
                    this.m_property.addValue(instance, value);
                }
            }
            catch (XMIException e) {
                XMIReader.this.report(e);
            }
        }
    }

    private class InstanceHandler
    extends ElementHandler {
        private final XMIType m_type;
        private final HashMap<XMLUniversalName, ElementHandler> m_valueHandlers;

        public InstanceHandler(XMIType type) throws SAXException {
            ContractUtils.checkNull(type, "Missing xmi type");
            this.m_type = type;
            this.m_valueHandlers = XMIReader.this.m_versionStrategy.createAttributeValueHandlers(type);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ElementHandler handler = this.getValueHandler(namespaceURI, localName, true);
            XMIReader.this.pushHandler(handler);
            handler.handleAttributes(atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XMIReader.this.popInstance();
            XMIReader.this.popHandler();
            XMIReader.this.peekHandler(0).endInstance();
        }

        @Override
        public void handleAttributes(Attributes atts) throws SAXException {
            try {
                Object instance = this.m_type.createInstance(XMIReader.this.m_locator);
                if (instance == null) {
                    throw new XMIException(ResourcesSingleton.getPicker().getString("InstanceCreationFailed.text"), null, 1);
                }
                XMIReader.this.peekHandler(-1).addInstance(instance);
                XMIReader.this.pushInstance(instance);
                for (int i = atts.getLength() - 1; i >= 0; --i) {
                    ElementHandler handler = this.getValueHandler(atts.getURI(i), atts.getLocalName(i), false);
                    handler.addValue(instance, atts.getValue(i));
                }
            }
            catch (XMIException e) {
                XMIReader.this.popHandler();
                XMIReader.this.peekHandler(0).endInstance();
                XMIReader.this.pushIgnoreHandler();
                XMIReader.this.peekHandler(0).handleAttributes(atts);
                XMIReader.this.report(e);
            }
        }

        public ElementHandler getValueHandler(String namespaceURI, String localName, boolean asElement) throws SAXException {
            XMIReader.this.m_lookupWrapper.setName(namespaceURI, localName);
            ElementHandler handler = this.m_valueHandlers.get(XMIReader.this.m_lookupWrapper);
            if (handler == null) {
                handler = asElement ? XMIReader.this.m_versionStrategy.createElementValueHandler(this, namespaceURI, localName) : XMIReader.this.m_versionStrategy.createAttributeValueHandler(this.m_type, namespaceURI, localName);
                this.m_valueHandlers.put(new XMLUniversalName(namespaceURI, localName), handler);
            }
            return handler;
        }
    }

    private class XMI2XHandler
    extends XMIHandler {
        private String m_namespace;
        private boolean m_xmiRoot;
        private HashMap<String, ElementHandler> m_typeMap;

        public XMI2XHandler(String namespace) {
            this.m_typeMap = new HashMap();
            this.m_namespace = namespace;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.m_namespace.equals(namespaceURI)) {
                XMIReader.this.pushIgnoreHandler();
            } else {
                this.handleInstance(namespaceURI, localName, atts);
            }
        }

        @Override
        public void handleAttributes(String namespaceURI, String localName, Attributes atts) throws SAXException {
            String version = atts.getValue(namespaceURI, XMIReader.XMI_2X_VERSION);
            if (version != null && !namespaceURI.endsWith("/" + version)) {
                XMIReader.this.fatalError(ResourcesSingleton.getPicker().getString("VersionMismatch.text", new Object[]{version, namespaceURI}));
            }
            for (String namespace : XMIReader.this.getPrefixNamespaces()) {
                if (this.m_namespace.equals(namespace) || XMIReader.this.m_metamodelProvider.getMetaModel(namespace) != null) continue;
                XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("UnknownNamespace.text", (Object)namespace), null, 0));
            }
            if (this.m_namespace.equals(namespaceURI)) {
                if (!XMIReader.XMI.equals(localName)) {
                    XMIReader.this.fatalError(ResourcesSingleton.getPicker().getString("WrongXMI2XRoot.text"));
                }
                this.m_xmiRoot = true;
            } else {
                this.m_xmiRoot = false;
                this.handleInstance(namespaceURI, localName, atts);
            }
        }

        @Override
        public void ignoreAttributes(ElementHandler contextHandler, Attributes atts) throws SAXException {
            contextHandler.logUnsupportedElement(atts.getValue(this.m_namespace, XMIReader.XMI_2X_ID), atts.getValue(this.m_namespace, XMIReader.XMI_2X_UUID));
        }

        @Override
        public XMLUniversalName getIdKey() {
            return new XMLUniversalName(this.m_namespace, XMIReader.XMI_2X_ID);
        }

        @Override
        public XMLUniversalName getUUIDKey() {
            return new XMLUniversalName(this.m_namespace, XMIReader.XMI_2X_UUID);
        }

        @Override
        public XMLUniversalName getLabelKey() {
            return new XMLUniversalName(this.m_namespace, XMIReader.XMI_2X_LABEL);
        }

        @Override
        public void endInstance() {
            if (!this.m_xmiRoot) {
                XMIReader.this.popHandler();
            }
        }

        @Override
        public void handleReference(XMIProperty property, Attributes atts) throws SAXException {
            this.handleReferenceImpl(property, atts);
        }

        public boolean handleReferenceImpl(XMIProperty property, Attributes atts) throws SAXException {
            String idref = atts.getValue(this.m_namespace, "idref");
            String href = atts.getValue("href");
            if (idref != null) {
                if (href == null) {
                    XMIReader.this.m_builder.addIdref(XMIReader.this.m_locator, XMIReader.this.peekInstance(), property, idref);
                    return true;
                }
            } else if (href != null) {
                XMIReader.this.m_builder.addHref(XMIReader.this.m_locator, XMIReader.this.peekInstance(), property, href);
                return true;
            }
            return false;
        }

        @Override
        public void handleNestedReference(XMIProperty property, Attributes atts) throws SAXException {
            XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("XMI2XCompositeElement.text"), null, 0));
            XMIReader.this.pushIgnoreHandler();
        }

        @Override
        public boolean handleDatatype(XMIProperty property, Attributes atts) throws SAXException {
            String value = atts.getValue("nil");
            if (value != null) {
                if ("true".equals(value)) {
                    try {
                        property.addValue(XMIReader.this.peekInstance(), null);
                    }
                    catch (XMIException e) {
                        XMIReader.this.report(e);
                    }
                } else {
                    XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("NilDatatypeNotTrue.text"), null, 1));
                }
                return true;
            }
            return false;
        }

        @Override
        public void handleNestedDatatype(XMIProperty property, Attributes atts) throws SAXException {
            super.handleNestedDatatype(property, atts);
            XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("ComplexDatatypeContent.text"), null, 1));
        }

        @Override
        public void handleCompositeValue(Object instance, XMIProperty property, String refs) throws SAXException {
            this.handleReferenceValue(instance, property, refs);
        }

        @Override
        public void handleComposite(String namespaceURI, String localName, Attributes atts) throws SAXException {
            XMIReader.this.fatalError(ResourcesSingleton.getPicker().getString("XMI2XCompositeElement.text"));
        }

        @Override
        public void handleComposite(XMIProperty property, Attributes atts) throws SAXException {
            if (!this.handleReferenceImpl(property, atts)) {
                ElementHandler ih;
                String qName = atts.getValue(this.m_namespace, XMIReader.XMI_2X_TYPE);
                if (qName == null) {
                    XMIType type = property.getType();
                    if (type == null) {
                        XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("UnknownCompositeType.text", (Object)property.getName()), null, 1));
                        ih = XMIReader.this.m_ignoreHandler;
                    } else {
                        ih = this.getInstanceHandler(type.getMetaModel().getNSURI(), type.getName());
                    }
                } else {
                    ih = this.getInstanceHandler(qName);
                }
                if (ih instanceof IgnoreHandler) {
                    XMIReader.this.popHandler();
                }
                XMIReader.this.pushHandler(ih);
                ih.handleAttributes(atts);
            }
        }

        @Override
        public void endComposite() {
            XMIReader.this.popHandler();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            super.startPrefixMapping(prefix, uri);
            this.m_typeMap.clear();
        }

        @Override
        public void endPrefixMapping(String prefix) {
            super.endPrefixMapping(prefix);
            this.m_typeMap.clear();
        }

        private ElementHandler getInstanceHandler(String qName) throws SAXException {
            ElementHandler ih = this.m_typeMap.get(qName);
            if (ih == null) {
                String[] pair = qName.split(":");
                String namespaceURI = XMIReader.this.getPrefixMapping(pair[0]);
                ih = namespaceURI != null ? this.getInstanceHandler(namespaceURI, pair[1]) : XMIReader.this.m_ignoreHandler;
                this.m_typeMap.put(qName, ih);
            }
            return ih;
        }
    }

    private class XMI1XHandler
    extends XMIHandler {
        private boolean m_inHeader;
        private boolean m_inContent;
        private final HashMap m_namespaceMap;

        private XMI1XHandler() {
            this.m_namespaceMap = new HashMap();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.m_inContent) {
                String id = atts.getValue("xmi.id");
                String idref = atts.getValue("xmi.idref");
                String href = atts.getValue("href");
                if (idref != null) {
                    if (href == null) {
                        try {
                            XMIReader.this.m_builder.addIdrefProxy(XMIReader.this.m_locator, id, idref);
                        }
                        catch (XMIException e) {
                            XMIReader.this.report(e);
                        }
                    } else {
                        return;
                    }
                    XMIReader.this.pushIgnoreHandler();
                } else if (href != null) {
                    href = href.replace('|', '#');
                    try {
                        XMIReader.this.m_builder.addHrefProxy(XMIReader.this.m_locator, id, href);
                    }
                    catch (XMIException e) {
                        XMIReader.this.report(e);
                    }
                    XMIReader.this.pushIgnoreHandler();
                } else {
                    this.handleInstance(namespaceURI, localName, atts);
                }
            } else if ("XMI.content".equals(qName)) {
                this.m_inContent = true;
                for (String namespace : XMIReader.this.getPrefixNamespaces()) {
                    if (this.m_namespaceMap.containsKey(namespace) || XMIReader.this.m_metamodelProvider.getMetaModel(namespace) != null) continue;
                    XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("UnknownNamespace.text", (Object)namespace), null, 0));
                }
            } else if (this.m_inHeader) {
                if ("XMI.metamodel".equals(qName)) {
                    String name = atts.getValue("xmi.name");
                    String version = atts.getValue(XMIReader.XMI_1X_VERSION);
                    String uri = atts.getValue("href");
                    if (name != null && version != null) {
                        String nsURI = XMIReader.this.getPrefixMapping(name);
                        String fakeURI = DefaultXMIMetaModelProvider.createFakeURI(name, version);
                        if (XMIReader.this.m_metamodelProvider.getMetaModel(fakeURI) != null) {
                            if (uri != null) {
                                this.m_namespaceMap.put(uri, fakeURI);
                            }
                            if (nsURI != null) {
                                this.m_namespaceMap.put(nsURI, fakeURI);
                            } else {
                                this.m_namespaceMap.put("", fakeURI);
                            }
                        } else if (uri != null && XMIReader.this.m_metamodelProvider.getMetaModel(uri) != null) {
                            if (nsURI != null) {
                                this.m_namespaceMap.put(nsURI, uri);
                            }
                        } else {
                            XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("UnknownMetamodel.text", new Object[]{name, version}), null, 0));
                        }
                    }
                } else if ("XMI.model".equals(qName)) {
                    XMIReader.this.m_builder.setName(atts.getValue("xmi.name"));
                    XMIReader.this.m_builder.setVersion(atts.getValue(XMIReader.XMI_1X_VERSION));
                }
                XMIReader.this.pushIgnoreHandler();
            } else if ("XMI.header".equals(qName)) {
                this.m_inHeader = true;
            } else {
                XMIReader.this.pushIgnoreHandler();
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.m_inHeader) {
                if ("XMI.header".equals(qName)) {
                    this.m_inHeader = false;
                }
            } else if (this.m_inContent) {
                if ("XMI.content".equals(qName)) {
                    this.m_inContent = false;
                }
            } else if (XMIReader.XMI.equals(qName)) {
                XMIReader.this.popHandler();
                XMIReader.this.m_versionStrategy = XMIReader.this.m_rootHandler;
            }
        }

        @Override
        public void handleAttributes(String namespaceURI, String localName, Attributes atts) throws SAXException {
            if (!XMIReader.XMI.equals(localName)) {
                XMIReader.this.fatalError(ResourcesSingleton.getPicker().getString("WrongXMI1XRoot.text"));
            }
            this.m_inHeader = false;
            this.m_inContent = false;
            this.m_namespaceMap.clear();
        }

        @Override
        protected XMIType getType(XMIMetaModel metamodel, String localName) throws XMIException {
            int dotIndex = localName.lastIndexOf(46);
            if (dotIndex != -1) {
                localName = localName.substring(dotIndex + 1);
            }
            return super.getType(metamodel, localName);
        }

        @Override
        protected void transformName(XMLUniversalName xmlName) {
            String uri;
            String localName = xmlName.getLocalName();
            if (!localName.startsWith("XMI.") && !localName.startsWith("xmi.") && (uri = (String)this.m_namespaceMap.get(xmlName.getNamespace())) != null) {
                xmlName.setName(uri, localName);
            }
        }

        @Override
        public void ignoreAttributes(ElementHandler contextHandler, Attributes atts) throws SAXException {
            contextHandler.logUnsupportedElement(atts.getValue("xmi.id"), atts.getValue("xmi.uuid"));
        }

        @Override
        public XMLUniversalName getIdKey() {
            return new XMLUniversalName("", "xmi.id");
        }

        @Override
        public XMLUniversalName getUUIDKey() {
            return new XMLUniversalName("", "xmi.uuid");
        }

        @Override
        public XMLUniversalName getLabelKey() {
            return new XMLUniversalName("", "xmi.label");
        }

        @Override
        public ElementHandler createElementValueHandler(InstanceHandler ih, String namespaceURI, String localName) throws SAXException {
            int dotIndex = localName.lastIndexOf(46);
            if (dotIndex != -1) {
                localName = localName.substring(dotIndex + 1);
            }
            return super.createElementValueHandler(ih, namespaceURI, localName);
        }

        @Override
        public void addReference(Object instance, XMIProperty property, String ref) {
            if ((ref = ref.replace('|', '#')).indexOf(35) == -1) {
                super.addReference(instance, property, ref);
            } else {
                XMIReader.this.m_builder.addHref(XMIReader.this.m_locator, instance, property, ref);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleReference(XMIProperty property, Attributes atts) throws SAXException {
            String idref = atts.getValue("xmi.idref");
            String href = atts.getValue("href");
            if (idref != null) {
                if (href != null) return;
                this.addReference(XMIReader.this.peekInstance(), property, idref);
            } else {
                if (href == null) return;
                href = href.replace('|', '#');
                XMIReader.this.m_builder.addHref(XMIReader.this.m_locator, XMIReader.this.peekInstance(), property, href);
            }
            String xmiId = atts.getValue("xmi.id");
            if (xmiId == null) return;
            try {
                if (idref != null) {
                    XMIReader.this.m_builder.addIdrefProxy(XMIReader.this.m_locator, xmiId, idref);
                    return;
                } else {
                    XMIReader.this.m_builder.addHrefProxy(XMIReader.this.m_locator, xmiId, href);
                }
                return;
            }
            catch (XMIException e) {
                XMIReader.this.report(e);
            }
        }

        @Override
        public void handleNestedReference(XMIProperty property, Attributes atts) throws SAXException {
            this.handleReference(property, atts);
            XMIReader.this.pushIgnoreHandler();
        }

        @Override
        public boolean handleDatatype(XMIProperty property, Attributes atts) throws SAXException {
            String value = atts.getValue("xmi.value");
            if (value != null) {
                try {
                    property.addValue(XMIReader.this.peekInstance(), value);
                }
                catch (XMIException e) {
                    XMIReader.this.report(e);
                }
                return true;
            }
            return false;
        }

        @Override
        public void handleComposite(String namespaceURI, String localName, Attributes atts) throws SAXException {
            this.handleInstance(namespaceURI, localName, atts);
        }

        @Override
        public void handleComposite(XMIProperty property, Attributes atts) throws SAXException {
            if (atts.getLength() > 0) {
                XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("XMI1XCompositePropertyAttributes.text"), null, 0));
            }
        }
    }

    private class XMIHandler
    extends ElementHandler {
        private final HashMap<XMLUniversalName, ElementHandler> m_instanceHandlerCache;

        private XMIHandler() {
            this.m_instanceHandlerCache = new HashMap();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String version = null;
            for (String namespace : XMIReader.this.getPrefixNamespaces()) {
                if (namespace.startsWith("http://schema.omg.org/spec/XMI/")) {
                    version = namespace.substring("http://schema.omg.org/spec/XMI/".length());
                    break;
                }
                if (namespace.equals("http://www.omg.org/spec/XMI/20100901")) {
                    version = "2.4";
                    break;
                }
                if (!namespace.equals("http://www.omg.org/spec/XMI/20110701")) continue;
                version = "2.4.1";
                break;
            }
            if (version == null && (version = atts.getValue(XMIReader.XMI_1X_VERSION)) == null) {
                XMIReader.this.fatalError(ResourcesSingleton.getPicker().getString("UnknownXMIVersion.text"));
            }
            XMIReader.this.setStrategy(XMIReader.this.getStrategy(version));
            XMIReader.this.m_versionStrategy.handleAttributes(namespaceURI, localName, atts);
            XMIReader.this.m_builder.setXMIVersion(version);
        }

        @Override
        public final void handleAttributes(Attributes atts) {
            throw new UnsupportedOperationException("XMI handler must have all start element data to handle attributes");
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            XMIReader.this.addPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) {
            XMIReader.this.removePrefixMapping(prefix);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            XMIReader.this.m_errorHandler.error(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            for (int i = XMIReader.this.m_handlerStack.size() - 1; i >= 0; --i) {
                XMIReader.this.m_handlerStack.set(i, XMIReader.this.m_ignoreHandler);
            }
            XMIReader.this.m_parser.setContentHandler((ContentHandler)XMIReader.this.m_ignoreHandler);
            XMIReader.this.m_errorHandler.fatalError(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            XMIReader.this.m_errorHandler.warning(exception);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource is = null;
            try {
                is = XMIReader.this.m_entityResolver.resolveEntity(publicId, systemId);
            }
            catch (IOException e) {
                XMIReader.this.fatalError(e);
            }
            catch (SAXException e) {
                XMIReader.this.fatalError(e);
            }
            if (is == null) {
                XMIReader.this.fatalError(ResourcesSingleton.getPicker().getString("EntityNotResolved.text", (Object)systemId));
            }
            return is;
        }

        protected ElementHandler getInstanceHandler(String namespaceURI, String localName) throws SAXException {
            XMIReader.this.m_lookupWrapper.setName(namespaceURI, localName);
            this.transformName(XMIReader.this.m_lookupWrapper);
            ElementHandler handler = this.m_instanceHandlerCache.get(XMIReader.this.m_lookupWrapper);
            if (handler == null) {
                namespaceURI = XMIReader.this.m_lookupWrapper.getNamespace();
                localName = XMIReader.this.m_lookupWrapper.getLocalName();
                XMIMetaModel metamodel = XMIReader.this.m_metamodelProvider.getMetaModel(namespaceURI);
                if (metamodel != null) {
                    try {
                        XMIType type = this.getType(metamodel, localName);
                        if (type != null) {
                            handler = type instanceof UnsupportedLogger ? new UnsupportedLoggerHandler((UnsupportedLogger)((Object)type)) : new InstanceHandler(type);
                        }
                    }
                    catch (XMIException e) {
                        XMIReader.this.report(e);
                    }
                }
                if (handler == null) {
                    handler = XMIReader.this.m_ignoreHandler;
                }
                this.m_instanceHandlerCache.put(new XMLUniversalName(namespaceURI, localName), handler);
            }
            return handler;
        }

        protected void transformName(XMLUniversalName name) {
        }

        protected XMIType getType(XMIMetaModel metamodel, String localName) throws XMIException {
            return metamodel.getTypeByName(localName);
        }

        public void ignoreAttributes(ElementHandler contextHandler, Attributes atts) throws SAXException {
        }

        public ElementHandler createAttributeValueHandler(XMIType type, String namespaceURI, String localName) throws SAXException {
            return XMIReader.this.m_ignoreHandler;
        }

        public final HashMap<XMLUniversalName, ElementHandler> createAttributeValueHandlers(XMIType type) throws SAXException {
            HashMap<XMLUniversalName, ElementHandler> valueHandlers = new HashMap<XMLUniversalName, ElementHandler>();
            try {
                boolean hasIdProperty = false;
                boolean hasUUIDProperty = false;
                boolean hasLabelProperty = false;
                Collection<? extends XMIProperty> properties = type.getProperties();
                if (properties != null) {
                    block9: for (XMIProperty xMIProperty : properties) {
                        String name = xMIProperty.getName();
                        XMLUniversalName key = null;
                        ElementHandler valueHandler = null;
                        if (xMIProperty instanceof UnsupportedLogger) {
                            valueHandler = new UnsupportedLoggerHandler((UnsupportedLogger)((Object)xMIProperty));
                        } else {
                            valueHandler = XMIReader.this.m_ignoreHandler;
                            XMIPropertyType propertyType = xMIProperty.getPropertyType();
                            switch (propertyType) {
                                case ID: {
                                    if (hasIdProperty) {
                                        XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("MultipleIdProperties.text", (Object)type.getName()), null, 1));
                                        continue block9;
                                    }
                                    hasIdProperty = true;
                                    if (name == null || "".equals(name)) {
                                        key = this.getIdKey();
                                    }
                                    valueHandler = new IdHandler(xMIProperty);
                                    break;
                                }
                                case UUID: {
                                    if (hasUUIDProperty) {
                                        XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("MultipleUUIDProperties.text", (Object)type.getName()), null, 1));
                                        continue block9;
                                    }
                                    hasUUIDProperty = true;
                                    key = this.getUUIDKey();
                                    valueHandler = new UUIDHandler(xMIProperty);
                                    break;
                                }
                                case LABEL: {
                                    if (hasLabelProperty) {
                                        XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("MultipleLabelProperties.text", (Object)type.getName()), null, 1));
                                        continue block9;
                                    }
                                    hasLabelProperty = true;
                                    key = this.getLabelKey();
                                    valueHandler = new ValueHandler(xMIProperty);
                                    break;
                                }
                                case COMPOSITE: {
                                    valueHandler = new CompositeHandler(xMIProperty);
                                    break;
                                }
                                case REFERENCE: {
                                    valueHandler = new ReferenceHandler(xMIProperty);
                                    break;
                                }
                                default: {
                                    valueHandler = new DatatypeHandler(xMIProperty);
                                }
                            }
                        }
                        valueHandlers.put(key == null ? new XMLUniversalName("", name) : key, valueHandler);
                    }
                }
                if (!hasIdProperty) {
                    valueHandlers.put(this.getIdKey(), new IdHandler(null));
                }
            }
            catch (XMIException e) {
                XMIReader.this.report(e);
            }
            return valueHandlers;
        }

        public XMLUniversalName getIdKey() {
            return null;
        }

        public XMLUniversalName getUUIDKey() {
            return null;
        }

        public XMLUniversalName getLabelKey() {
            return null;
        }

        public ElementHandler createElementValueHandler(InstanceHandler ih, String namespaceURI, String localName) throws SAXException {
            return ih.getValueHandler("", localName, false);
        }

        public void handleAttributes(String namespaceURI, String localName, Attributes atts) throws SAXException {
        }

        @Override
        public void addInstance(Object instance) {
            XMIReader.this.m_builder.addInstance(XMIReader.this.m_locator, null, null, instance);
        }

        protected void handleInstance(String namespaceURI, String localName, Attributes atts) throws SAXException {
            ElementHandler handler = this.getInstanceHandler(namespaceURI, localName);
            XMIReader.this.pushHandler(handler);
            handler.handleAttributes(atts);
        }

        @Override
        public void endInstance() {
        }

        public void handleReferenceValue(Object instance, XMIProperty property, String refs) {
            int start = 0;
            int end = this.findWhitespace(refs, 0);
            while (end != -1) {
                this.createReference(instance, property, start, end, refs);
                start = end + 1;
                end = this.findWhitespace(refs, start);
            }
            this.createReference(instance, property, start, refs.length(), refs);
        }

        private int findWhitespace(String refs, int start) {
            int size = refs.length();
            for (int i = start; i < size; ++i) {
                if (!Character.isWhitespace(refs.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        private void createReference(Object instance, XMIProperty property, int start, int end, String refs) {
            if (end > start) {
                this.addReference(instance, property, refs.substring(start, end));
            }
        }

        public void addReference(Object instance, XMIProperty property, String ref) {
            XMIReader.this.m_builder.addIdref(XMIReader.this.m_locator, instance, property, ref);
        }

        public void handleReference(XMIProperty property, Attributes atts) throws SAXException {
        }

        public void handleNestedReference(XMIProperty property, Attributes atts) throws SAXException {
        }

        public boolean handleDatatype(XMIProperty property, Attributes atts) throws SAXException {
            return false;
        }

        public void handleNestedDatatype(XMIProperty property, Attributes atts) throws SAXException {
            XMIReader.this.pushIgnoreHandler();
        }

        public void handleCompositeValue(Object instance, XMIProperty property, String refs) throws SAXException {
            XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("CompositeAsValue.text"), null, 1));
        }

        public void handleComposite(XMIProperty property, Attributes atts) throws SAXException {
        }

        public void handleComposite(String namespaceURI, String localName, Attributes atts) throws SAXException {
        }

        public void endComposite() {
        }
    }

    private class UnsupportedLoggerHandler
    extends IgnoreHandler {
        private UnsupportedLogger m_logger;

        public UnsupportedLoggerHandler(UnsupportedLogger logger) {
            this.m_logger = logger;
        }

        @Override
        public void logUnsupportedElement(String id, String uuid) throws SAXException {
            try {
                this.m_logger.logUnsupported(XMIReader.this.m_locator, id, uuid);
            }
            catch (XMIException e) {
                XMIReader.this.report(e);
            }
        }
    }

    private class IgnoreHandler
    extends ElementHandler {
        private IgnoreHandler() {
        }
    }

    private class ElementHandler
    extends DefaultHandler {
        private ElementHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            XMIReader.this.m_locator = locator;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            XMIReader.this.pushHandler(this);
            this.handleAttributes(atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XMIReader.this.popHandler();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            XMIReader.this.m_versionStrategy.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) {
            XMIReader.this.m_versionStrategy.endPrefixMapping(prefix);
        }

        public void handleAttributes(Attributes atts) throws SAXException {
            XMIReader.this.m_versionStrategy.ignoreAttributes(this, atts);
        }

        public void addValue(Object instance, Object value) throws SAXException {
        }

        public void addInstance(Object instance) {
            throw new UnsupportedOperationException("Cannot add an instance to an ignore handler");
        }

        public void endInstance() {
            throw new UnsupportedOperationException("Cannot end an instance on an ignore handler");
        }

        public void logUnsupportedElement(String id, String uuid) throws SAXException {
            if (id != null || uuid != null) {
                ++XMIReader.this.m_unsupportedCount;
                if (id != null) {
                    XMIReader.this.m_builder.addIgnoredInstanceById(XMIReader.this.m_locator, id);
                }
                if (uuid != null) {
                    XMIReader.this.m_builder.addIgnoredInstanceByUUID(XMIReader.this.m_locator, uuid);
                }
                if (XMIReader.this.logUnsupported()) {
                    XMIReader.this.report(new XMIException(ResourcesSingleton.getPicker().getString("IgnoreElement.text", (Object)(id == null ? uuid : id)), null, 0));
                }
            }
        }
    }

    private static final class XMLUniversalName {
        private String m_namespace;
        private String m_localName;

        public XMLUniversalName() {
        }

        public XMLUniversalName(String namespace, String localName) {
            this.setName(namespace, localName);
        }

        public String getNamespace() {
            return this.m_namespace;
        }

        public String getLocalName() {
            return this.m_localName;
        }

        public void setName(String namespace, String localName) {
            this.m_namespace = namespace;
            this.m_localName = localName;
        }

        public boolean equals(Object o) {
            XMLUniversalName xun = (XMLUniversalName)o;
            return this.m_localName.equals(xun.m_localName) && this.m_namespace.equals(xun.m_namespace);
        }

        public int hashCode() {
            return this.m_localName.hashCode();
        }
    }
}

