/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.mof.xmi.XMI11Writer;
import oracle.mof.xmi.XMI211Writer;
import oracle.mof.xmi.XMI21Writer;
import oracle.mof.xmi.XMI241Writer;
import oracle.mof.xmi.XMI24Writer;
import oracle.mof.xmi.XMIWriter;

public class XMIWriterFactory {
    public static final List<String> AVAILABLE_VERSIONS = Collections.unmodifiableList(Arrays.asList("1.1", "2.1", "2.1.1", "2.4", "2.4.1"));

    private XMIWriterFactory() {
    }

    public static XMIWriter createWriter(String xmiVersion) {
        if (xmiVersion == null) {
            return new XMI241Writer();
        }
        if (xmiVersion.startsWith("http://schema.omg.org/spec/XMI/")) {
            xmiVersion = xmiVersion.substring("http://schema.omg.org/spec/XMI/".length());
        }
        if ("1.1".equals(xmiVersion)) {
            return new XMI11Writer();
        }
        if ("2.1".equals(xmiVersion)) {
            return new XMI21Writer();
        }
        if ("2.1.1".equals(xmiVersion)) {
            return new XMI211Writer();
        }
        if ("2.4".equals(xmiVersion) || "http://www.omg.org/spec/XMI/20100901".equals(xmiVersion)) {
            return new XMI24Writer();
        }
        if ("2.4.1".equals(xmiVersion) || "http://www.omg.org/spec/XMI/20110701".equals(xmiVersion)) {
            return new XMI241Writer();
        }
        throw new IllegalArgumentException("Unsupported XMI version");
    }
}

