/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.regex.Pattern;

public final class XMLUtils {
    public static final String NC_NAME_START_CHAR = XMLUtils.createNameStartCharPattern();
    public static final String NC_NAME_CHAR = NC_NAME_START_CHAR + "\\-.0-9\u00b7\u0300-\u036f\u203f-\u2040";
    private static final Pattern NC_NAME = Pattern.compile("[" + NC_NAME_START_CHAR + "]" + "[" + NC_NAME_CHAR + "]*");

    private XMLUtils() {
    }

    public static boolean isValidNCName(String name) {
        return name != null && NC_NAME.matcher(name).matches();
    }

    private static String createNameStartCharPattern() {
        StringBuilder sb = new StringBuilder("A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd");
        sb.appendCodePoint(65536);
        sb.append('-');
        sb.appendCodePoint(983039);
        return sb.toString();
    }
}

