/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.generic.util.VCSCompareCommand;
import oracle.jdevimpl.vcs.git.GITHistoryEntryProducer;
import oracle.jdevimpl.vcs.git.res.Resource;

public abstract class GITAbstractCompareOperation
extends VCSCompareCommand {
    public GITAbstractCompareOperation(String commandId) {
        super(commandId);
    }

    protected CompareContributor getHistoricalContributor(VCSProfile profile, Locatable source, Object revisionObject) throws Exception {
        URL sourceUrl = source.getURL();
        String resourceName = this.getResourceName(sourceUrl, revisionObject);
        InputStream in = GITHistoryEntryProducer.openInputStream(sourceUrl, (String)revisionObject);
        if (VCSFileSystemUtils.isContentTypeBinary((URL)sourceUrl)) {
            return new BinaryCompareContributor(in, URLFileSystem.getFileName((URL)sourceUrl), resourceName, resourceName);
        }
        return new InputStreamTextContributor(in, resourceName, resourceName, URLFileSystem.getSuffix((URL)sourceUrl));
    }

    protected String getResourceName(URL url, Object revisionObject) {
        return MessageFormat.format(Resource.get("COMPARE_CONTRIBUTOR_NAME"), (String)revisionObject, URLFileSystem.getPlatformPathName((URL)url));
    }
}

