/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.generic.HistoryEntryProducer;
import oracle.jdeveloper.vcs.generic.VCSHistoryEntry;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.history.ViewableHistoryEntry;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.GITVersionBrowsable;
import oracle.jdevimpl.vcs.git.GITVersionURL;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITHistoryEntryProducer
implements HistoryEntryProducer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryEntry[] produceEntries(URL target) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(target);
            URL[] urls = new URL[]{target};
            Collection<File> files = GITUtil.convertURLToFile(urls);
            SearchCriteria crit = new SearchCriteria();
            crit.setFiles(files.toArray(new File[0]));
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            GitRevisionInfo[] revInfos = client.log(crit, (ProgressMonitor)monitor);
            ArrayList<GITHistoryEntryImpl> entries = new ArrayList<GITHistoryEntryImpl>();
            for (GitRevisionInfo rev : revInfos) {
                GITHistoryEntryImpl entry = new GITHistoryEntryImpl(target, rev.getRevision(), null, new Date(rev.getCommitTime()), rev.getFullMessage(), rev.getAuthor().getName());
                entries.add(entry);
            }
            HistoryEntry[] historyEntryArray = entries.toArray(new HistoryEntry[0]);
            return historyEntryArray;
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITHistoryEntryProducer.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return new HistoryEntry[0];
    }

    public static final InputStream openInputStream(String path, String version) throws Exception {
        return GITHistoryEntryProducer.openInputStream(URLFactory.newURL((String)path), version);
    }

    public static final InputStream openInputStream(URL url, String version) throws Exception {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Cat");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File file = new File(url.getPath());
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            boolean stat = client.catFile(file, version, (OutputStream)out, (ProgressMonitor)monitor);
            if (!stat) {
                throw new Exception(Resource.format("HISTORY_FILE_CONTENT", url.getPath()));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (GitException ex) {
            throw new GITProcessException(Resource.format("HISTORY_FILE_CONTENT", url.getPath()), ex.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private class GITHistoryEntryImpl
    extends VCSHistoryEntry
    implements ViewableHistoryEntry {
        GITHistoryEntryImpl(URL url, String revision, String version, Date date, String description, String user) {
            super(url, VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git"));
            RevisionIdentifier revisionIdentifier = new RevisionIdentifier((Icon)ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("VCS_ICON"))), revision);
            revisionIdentifier.setCurrent(version != null && revision.equals(version));
            this.setValue(SharedProperties.getDateProperty(), date);
            this.setValue(SharedProperties.getRevisionProperty(), revisionIdentifier);
            this.setValue(SharedProperties.getDescriptionProperty(), description);
            this.setValue("oracle.jdeveloper.git.history.AUTHOR", user);
        }

        public CompareContributor getCompareContributor() throws Exception {
            return URLFileSystem.isDirectoryPath((URL)this._url) ? null : super.getCompareContributor();
        }

        protected InputStream getContent(URL url, RevisionIdentifier rev) throws Exception {
            return GITHistoryEntryProducer.openInputStream(url, rev.getLabel());
        }

        protected String getResourceName(URL url, RevisionIdentifier rev) {
            return MessageFormat.format(Resource.get("COMPARE_CONTRIBUTOR_NAME"), rev.getLabel(), URLFileSystem.getPlatformPathName((URL)url));
        }

        public void view(final Context context) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    URL realUrl = HistoryContext.getRealURL((Context)context);
                    if (realUrl == null) {
                        realUrl = context.getNode().getURL();
                    }
                    if (URLFileSystem.isDirectoryPath((URL)realUrl)) {
                        return;
                    }
                    try {
                        EditorManager.getEditorManager().openDefaultEditorInFrame(new Context((Node)new GITVersionBrowsable(new GITVersionURL(URLFileSystem.getPlatformPathName((URL)realUrl), ((RevisionIdentifier)GITHistoryEntryImpl.this.getValue(SharedProperties.getRevisionProperty())).getLabel()).toURL())));
                    }
                    catch (MalformedURLException murle) {
                        Assert.printStackTrace((Throwable)murle);
                    }
                }
            });
        }

        public URL getOwner() {
            return this._url;
        }
    }
}

