/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import oracle.ide.model.Locatable;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.git.GITAbstractCompareOperation;

public class GITOperationCompareLatest
extends GITAbstractCompareOperation {
    public GITOperationCompareLatest() {
        super("oracle.jdeveloper.git.comparelatest");
    }

    protected Object getContextRevision(VCSProfile profile, Locatable locatable) throws Exception {
        return "T";
    }

    protected HistoryEntrySelector getHistoryEntrySelector(VCSProfile profile, Locatable source, Object revision) throws Exception {
        return new HistoryEntrySelector(){

            public HistoryEntry select(HistoryModel historyModel) {
                ArrayList<HistoryEntry> list = new ArrayList<HistoryEntry>();
                for (int i = 0; i < historyModel.getSize(); ++i) {
                    RevisionIdentifier revisionIdentifier = (RevisionIdentifier)historyModel.getEntry(i).getValue(SharedProperties.getRevisionProperty());
                    if (revisionIdentifier == null || !revisionIdentifier.getLabel().matches("\\d+")) continue;
                    list.add(historyModel.getEntry(i));
                }
                Collections.sort(list, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        RevisionIdentifier revisionIdentifier1 = (RevisionIdentifier)((HistoryEntry)o1).getValue(SharedProperties.getRevisionProperty());
                        RevisionIdentifier revisionIdentifier2 = (RevisionIdentifier)((HistoryEntry)o2).getValue(SharedProperties.getRevisionProperty());
                        return revisionIdentifier1.compareTo((Object)revisionIdentifier2);
                    }
                });
                return list.size() > 0 ? (HistoryEntry)list.get(list.size() - 1) : null;
            }
        };
    }
}

