/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;

public class GITRepositoryManager {
    private final Set<GITConnectionInfo> _gitRoots = Collections.synchronizedSet(new HashSet());
    private SoftReference<Collection<VCSHashURL>> _notgit = new SoftReference(new ArrayList());
    private static GITRepositoryManager _manager = new GITRepositoryManager();

    private GITRepositoryManager() {
    }

    public static GITRepositoryManager getInstance() {
        return _manager;
    }

    public final void clear() {
        this.getNonGitCache().clear();
    }

    public final boolean isWorkingCopy(URL url) {
        return this.getRootContaining(url) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getRootContaining(URL url) {
        Set<GITConnectionInfo> set = this._gitRoots;
        synchronized (set) {
            for (GITConnectionInfo root : this._gitRoots) {
                if (!URLFileSystem.isBaseURLFor((URL)root.getRootURL(), (URL)url)) continue;
                return root.getRootURL();
            }
        }
        if (this.searched(url)) {
            return null;
        }
        URL root = null;
        root = this.findAdminRoot(url);
        if (root == null) {
            SoftReference<Collection<VCSHashURL>> softReference = this._notgit;
            synchronized (softReference) {
                if (!URLFileSystem.isDirectoryPath((URL)url)) {
                    this.getNonGitCache().add(new VCSHashURL(URLFileSystem.getParent((URL)url)));
                } else {
                    this.getNonGitCache().add(new VCSHashURL(url));
                }
            }
        }
        return root == null ? null : root;
    }

    public Collection<GITConnectionInfo> list() {
        return new ArrayList<GITConnectionInfo>(this._gitRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findAdminRoot(URL url) {
        URL hg;
        if (!URLFileSystem.isLocal((URL)url)) {
            return null;
        }
        if (URLFileSystem.isDirectoryPath((URL)url) && URLFileSystem.exists((URL)(hg = URLFactory.newDirURL((URL)url, (String)".git/")))) {
            GITConnectionInfoImpl info = new GITConnectionInfoImpl(url);
            Set<GITConnectionInfo> set = this._gitRoots;
            synchronized (set) {
                this._gitRoots.add(info);
            }
            if (!IdeUtil.isHeadless()) {
                GITRepositoryNavigator.getInstance().createRepositoryConnection(info);
            }
            return url;
        }
        URL parent = URLFileSystem.getParent((URL)url);
        if (parent != null && !parent.equals(url)) {
            return this.findAdminRoot(parent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searched(URL url) {
        URL sUrl = url;
        if (!URLFileSystem.isDirectoryPath((URL)url)) {
            sUrl = URLFileSystem.getParent((URL)url);
        }
        if (sUrl == null) {
            return true;
        }
        SoftReference<Collection<VCSHashURL>> softReference = this._notgit;
        synchronized (softReference) {
            return this.getNonGitCache().contains(new VCSHashURL(sUrl));
        }
    }

    private Collection<VCSHashURL> getNonGitCache() {
        Collection<VCSHashURL> cache = this._notgit.get();
        if (cache == null) {
            this._notgit = new SoftReference(new ArrayList());
        }
        return this._notgit.get();
    }

    private static class GITConnectionInfoImpl
    implements GITConnectionInfo {
        private VCSHashURL _rootUrl;

        GITConnectionInfoImpl(URL url) {
            this._rootUrl = new VCSHashURL(url);
        }

        @Override
        public URL getRootURL() {
            return this._rootUrl.getURL();
        }
    }
}

