/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.RestoreFromRevisionClass;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITRestoreFromRevisionClass
extends RestoreFromRevisionClass {
    public boolean canRestore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(urls[0]);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Log");
            monitor.setLog(false);
            GitRevisionInfo info = client.log(revision, (ProgressMonitor)monitor);
            Map files = info.getModifiedFiles();
            for (URL url : urls) {
                if (this.isMemberOf(files, url.getPath())) continue;
                GITProfile.getQualifiedLogger(GITRestoreFromRevisionClass.class.getName()).log(Level.WARNING, url.getPath() + " is not in revision " + revision);
                boolean bl = false;
                return bl;
            }
        }
        catch (GitException ge) {
            throw new Exception(ge.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("catFile");
            monitor.setLog(false);
            for (URL url : urls) {
                BufferedOutputStream bos = null;
                if (client == null) {
                    client = GITClientAdaptor.getClient(url);
                }
                try {
                    bos = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url));
                    File file = new File(url.getPath());
                    if (client.catFile(file, revision, (OutputStream)bos, (ProgressMonitor)monitor)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (GitException ge) {
            throw new Exception(ge.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        this.clear(urls);
        return true;
    }

    private void clear(URL[] urls) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        profile.getStatusCacheBridge().clear(urls);
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    private boolean isMemberOf(Map<File, GitRevisionInfo.GitFileInfo> files, String path) {
        Iterator<File> it = files.keySet().iterator();
        while (it.hasNext()) {
            String rvFilePath = it.next().getPath();
            if (!path.equals(rvFilePath)) continue;
            return true;
        }
        return false;
    }
}

