/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.BaseStatusResolver;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITOverlayItemProducer;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITStatusResolver
extends BaseStatusResolver {
    public static final String STATUS_ID_UNRECOGNIZED = "UNRECOGNIZED";
    public static final String STATUS_ID_UNVERSIONED = "UNVERSIONED";
    public static final String STATUS_ID_ADDED = "ADDED";
    public static final String STATUS_ID_ADDED_MODIFIED = "ADDED_MODIFIED";
    public static final String STATUS_ID_UNCHANGED = "UNCHANGED";
    public static final String STATUS_ID_PENDING = "PENDING";
    public static final String STATUS_ID_PENDING_MODIFIED = "PENDING_MODIFIED";
    public static final String STATUS_ID_MODIFIED = "MODIFIED";
    public static final String STATUS_ID_DELETED = "DELETED";
    public static final String STATUS_ID_RENAMED = "RENAMED";
    public static final String STATUS_ID_RENAMED_MODIFIED = "RENAMED_MODIFIED";
    public static final String STATUS_ID_CONFLICT = "CONFLICT";
    public static final String STATUS_ID_IGNORED = "IGNORED";
    public static final String STATUS_ID_NOHISTORY = "NOHISTORY";

    public static final boolean isDeleted(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_REMOVED) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_REMOVED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL);
    }

    public static final boolean isAdded(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_ADDED) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_ADDED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL);
    }

    public static final boolean isAddedModified(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_ADDED) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_ADDED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_MODIFIED);
    }

    public static final boolean isPendingModified(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_MODIFIED) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_MODIFIED);
    }

    public static final boolean isPending(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_MODIFIED) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL);
    }

    public static final boolean isUnversioned(GitStatus status) {
        if (status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_REMOVED) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_NORMAL) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_ADDED)) {
            return true;
        }
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_NORMAL) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_ADDED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_ADDED);
    }

    public static final boolean isIgnored(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_NORMAL) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_ADDED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_IGNORED);
    }

    public static final boolean isUnchnaged(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_NORMAL) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_NORMAL) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL);
    }

    public static final boolean isModified(GitStatus status) {
        return status.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_NORMAL) && status.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) && status.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_MODIFIED);
    }

    public void populateStatuses(VCSProfile profile, URL[] urls, VCSStatus[] statuses) throws Exception {
        for (int i = 0; i < urls.length; ++i) {
            statuses[i] = profile.getStatusInstance(STATUS_ID_UNRECOGNIZED);
        }
        this._populateStatuses(profile, urls, statuses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _populateStatuses(VCSProfile profile, URL[] urls, VCSStatus[] statuses) throws Exception {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(urls[0]);
            if (client == null) {
                return;
            }
            Map<String, GitBranch> branches = null;
            Collection<File> files = GITUtil.convertURLToFile(urls, new URLFilter(){

                public boolean accept(URL url) {
                    if (URLFileSystem.isDirectoryPath((URL)url)) {
                        return false;
                    }
                    return !JarUtil.isJarURL((URL)url) || JarUtil.getJarEntry((URL)url) == null;
                }
            });
            if (files.isEmpty()) {
                for (int u = 0; u < urls.length; ++u) {
                    if (!URLFileSystem.isDirectoryPath((URL)urls[u])) continue;
                    statuses[u] = profile.getStatusInstance(STATUS_ID_NOHISTORY);
                }
                return;
            }
            Map status = client.getStatus(files.toArray(new File[0]), (ProgressMonitor)new GITCommandProgressMonitor("status"));
            for (int u = 0; u < urls.length; ++u) {
                if (URLFileSystem.isDirectoryPath((URL)urls[u])) {
                    statuses[u] = profile.getStatusInstance(STATUS_ID_NOHISTORY);
                    continue;
                }
                File key = new File(urls[u].getPath());
                if (!status.containsKey(key)) continue;
                GitStatus stat = (GitStatus)status.get(key);
                statuses[u] = GITStatusResolver.getVCSStatus(profile, stat);
                if (!URLFileSystem.getSuffix((URL)urls[u]).equals(".jpr")) continue;
                if (branches == null) {
                    branches = this.getBranches(client);
                }
                GITOverlayItemProducer.cacheVersion(urls[u], Resource.get("OVERLAY_NO_BRANCH"));
                Iterator<String> it = branches.keySet().iterator();
                while (it.hasNext()) {
                    GitBranch branch = branches.get(it.next());
                    if (!branch.isActive()) continue;
                    GITOverlayItemProducer.cacheVersion(urls[u], branch.getName());
                }
            }
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    static VCSStatus getVCSStatus(VCSProfile profile, GitStatus stat) {
        if (stat.getConflictDescriptor() != null) {
            return profile.getStatusInstance(STATUS_ID_CONFLICT);
        }
        if (GITStatusResolver.isUnchnaged(stat)) {
            return profile.getStatusInstance(STATUS_ID_UNCHANGED);
        }
        if (stat.isRenamed()) {
            if (stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_MODIFIED)) {
                return profile.getStatusInstance(STATUS_ID_RENAMED_MODIFIED);
            }
            return profile.getStatusInstance(STATUS_ID_RENAMED);
        }
        if (GITStatusResolver.isAddedModified(stat)) {
            return profile.getStatusInstance(STATUS_ID_ADDED_MODIFIED);
        }
        if (GITStatusResolver.isPendingModified(stat)) {
            return profile.getStatusInstance(STATUS_ID_PENDING_MODIFIED);
        }
        if (GITStatusResolver.isPending(stat)) {
            return profile.getStatusInstance(STATUS_ID_PENDING);
        }
        if (GITStatusResolver.isUnversioned(stat)) {
            return profile.getStatusInstance(STATUS_ID_UNVERSIONED);
        }
        if (GITStatusResolver.isIgnored(stat)) {
            return profile.getStatusInstance(STATUS_ID_IGNORED);
        }
        if (GITStatusResolver.isDeleted(stat)) {
            return profile.getStatusInstance(STATUS_ID_DELETED);
        }
        if (GITStatusResolver.isAdded(stat)) {
            return profile.getStatusInstance(STATUS_ID_ADDED);
        }
        if (GITStatusResolver.isModified(stat)) {
            return profile.getStatusInstance(STATUS_ID_MODIFIED);
        }
        return profile.getStatusInstance(STATUS_ID_UNRECOGNIZED);
    }

    private Map<String, GitBranch> getBranches(GitClient client) {
        Map branches;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
        try {
            branches = client.getBranches(false, (ProgressMonitor)monitor);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITStatusResolver.class.getName()).log(Level.WARNING, e.getMessage());
            return Collections.emptyMap();
        }
        return branches;
    }
}

