/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.awt.Component;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.ide.webbrowser.AuthenticatorManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRepositoryManager;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITUtil {
    private GITUtil() {
    }

    public static boolean insideWorkingCopy(URL url) {
        if (url == null) {
            return false;
        }
        return GITRepositoryManager.getInstance().getRootContaining(url) != null;
    }

    public static URL getRootContaining(URL url) {
        return GITRepositoryManager.getInstance().getRootContaining(GITNavURLFileSystemHelper.fromNavigatorURL(url));
    }

    public static Locatable[] convertURLToLocatable(Collection<URL> urls) {
        ArrayList<Node> locs = new ArrayList<Node>();
        for (URL url : urls) {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                locs.add(node);
            }
            catch (Exception e) {}
        }
        return locs.toArray(new Locatable[0]);
    }

    public static Collection<URL> convertFileToUrl(File[] files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            urls.add(URLFactory.newFileURL((File)file));
        }
        return urls;
    }

    public static Collection<File> convertURLToFile(URL[] urls) {
        ArrayList<File> files = new ArrayList<File>();
        for (URL url : urls) {
            files.add(new File(url.getPath()));
        }
        return files;
    }

    public static Collection<File> convertURLToFile(URL[] urls, URLFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        for (URL url : urls) {
            if (!filter.accept(url)) continue;
            files.add(new File(url.getPath()));
        }
        return files;
    }

    public static Collection<File> convertLocatableToFile(Locatable[] locs) {
        ArrayList<File> files = new ArrayList<File>();
        for (Locatable loc : locs) {
            files.add(new File(loc.getURL().getPath()));
        }
        return files;
    }

    public static Collection<URL> convertLocatableToURL(Locatable[] locs) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Locatable loc : locs) {
            urls.add(loc.getURL());
        }
        return urls;
    }

    public static boolean isRepositoryNavigatorView(View view) {
        return ConnectionProvider.isVersioningConnectionView((View)view);
    }

    public static GITRemote[] getGitRemoteNodes(Context context) {
        ArrayList<GITRemote> nodes = null;
        Element[] elms = context.getSelection();
        if (elms != null) {
            for (Element elm : elms) {
                if (!(elm instanceof GITRemote)) continue;
                if (nodes == null) {
                    nodes = new ArrayList<GITRemote>();
                }
                nodes.add((GITRemote)elm);
            }
        }
        return nodes == null ? new GITRemote[]{} : nodes.toArray(new GITRemote[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLatest(URL root, String branchName, String revision) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            GitRevisionInfo[] info = client.log(GITUtil.getSearchCriteria(root, branchName), (ProgressMonitor)monitor);
            if (info.length == 1 && info[0].getRevision().equals(revision)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, e.getMessage());
        }
        catch (URISyntaxException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return false;
    }

    public static GitBranch getActiveBranch(Map<String, GitBranch> gitBranch) {
        for (String branch : gitBranch.keySet()) {
            GitBranch gBranch = gitBranch.get(branch);
            if (!gBranch.isActive()) continue;
            return gBranch;
        }
        return null;
    }

    public static void logMergeConflicts(GitMergeResult result) {
        Collection conflicts = result.getConflicts();
        if (conflicts.isEmpty()) {
            return;
        }
        GITUtil.log(Resource.get("MERGE_FAIL_OP_CONFLICT"));
        Iterator it = conflicts.iterator();
        while (it.hasNext()) {
            GITUtil.log(((File)it.next()).getPath());
        }
    }

    public static void logMergeFailures(GitMergeResult result) {
        Collection failures = result.getFailures();
        if (failures.isEmpty()) {
            return;
        }
        GITUtil.log(Resource.get("MERGE_FAIL_OP_FAILURE"));
        Iterator it = failures.iterator();
        while (it.hasNext()) {
            GITUtil.log(((File)it.next()).getPath());
        }
    }

    public static void reportMergeFailures(Collection<File> failures) {
        if (failures.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Resource.get("MERGE_FAIL_OP_UI_FAILURE"));
        Iterator<File> it = failures.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getPath());
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)sb.toString(), (String)Resource.get("MERGE_FAILED_TITLE"), null);
    }

    private static SearchCriteria getSearchCriteria(URL url, String branch) throws URISyntaxException {
        SearchCriteria search = new SearchCriteria();
        File[] files = new File[]{new File(url.toURI())};
        search.setFiles(files);
        search.setLimit(1);
        search.setRevisionTo(branch);
        return search;
    }

    private static void log(String message) {
        if (VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.git").getAutoLogMessages()) {
            LogManager.getLogManager().getMsgPage().log((Object)message);
        }
    }

    public static String getRemoteBranchName(String name, String branch) {
        StringBuilder sb = new StringBuilder(name);
        sb.append("/");
        sb.append(branch);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, GitBranch> getBranches(URL root) {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
            client = GITClientAdaptor.getClient(root);
            Map map = client.getBranches(true, (ProgressMonitor)monitor);
            return map;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, e.getMessage());
            Map<String, GitBranch> map = Collections.emptyMap();
            return map;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, GitTag> getTags(URL root) {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("getTags");
        GitClient client = null;
        try {
            Map tags;
            client = GITClientAdaptor.getClient(root);
            Map map = tags = client.getTags((ProgressMonitor)monitor, true);
            return map;
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, ge.getMessage());
            Map<String, GitTag> map = Collections.emptyMap();
            return map;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public static boolean isConflict(URL url) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        try {
            VCSStatus status = (VCSStatus)profile.getStatusCacheBridge().get(url);
            return status.equals(profile.getStatusInstance("CONFLICT"));
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, "Failed to get status of " + URLFileSystem.getPlatformPathName((URL)url));
            return false;
        }
    }

    public static boolean authenticator(String urlStr) {
        if (urlStr.startsWith("http://") || urlStr.startsWith("https://")) {
            AuthenticatorManager.getInstance().pushAuthenticator(null);
            return true;
        }
        return false;
    }

    public static void authenricatorRestore(boolean restore) {
        if (restore) {
            AuthenticatorManager.getInstance().popAuthenticator();
        }
    }
}

