/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.branchcompare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.bali.ewt.util.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Ellipses;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.ActionTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.ui.table.LabelTableCellRenderer;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITHistoryEntryProducer;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.branchcompare.BranchListItem;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchCompare;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchCompareMenuListener;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchMenuController;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchMergeCommand;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchTableModel;
import oracle.jdevimpl.vcs.git.branchcompare.spi.TableDockableWindow;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITBranchCompareWindow
extends TableDockableWindow {
    static final String ACTIVE_BRANCH = "ActiveBranch";
    static final String COMPARE_BRANCH = "CompareBranch";
    private static URL _gitRoot;
    private JLabel _branchNameLabel;
    private String _activeBranch;
    private String _trackBranch;
    private JComboBox _branchesCombo;
    private PopupMenuListener _listener;
    private GITLabelTableCellEllipseRenderer _labelEllipseRenderer;
    private GITLabelTableCellIconRenderer _labelIconRenderer;
    private boolean _noBranch = false;
    private boolean _noDiffItems = false;

    GITBranchCompareWindow(String viewId) {
        super(viewId);
        Ide.getSystem().attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
                if (Boolean.getBoolean("ide.vcs.noapplications") || Product.isRaptor()) {
                    return;
                }
                if (change.getMessageID() != IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    return;
                }
                Workspace workspace = (Workspace)change.getModifyObjects().get(1);
                if (workspace == null) {
                    return;
                }
                URL root = GITBranchCompareWindow.this.getGitClientRoot(workspace);
                if (root != null && !URLFileSystem.equals((URL)_gitRoot, (URL)root)) {
                    GITBranchCompareWindow.this.refresh();
                }
            }
        });
        this.setType(32);
    }

    String getActiveBranch() {
        return this._activeBranch;
    }

    String getTrackBranch() {
        return this._trackBranch;
    }

    String getBranchCompare() {
        return (String)this._branchesCombo.getModel().getSelectedItem();
    }

    public String getTitleName() {
        return Resource.get("BRANCH_COMPARE_TITLE");
    }

    @Override
    protected Toolbar getToolbarImpl() {
        Toolbar toolbar = new Toolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._branchNameLabel = new JLabel();
        this._branchesCombo = new JComboBox(new BranchComboBoxModel());
        this._branchesCombo.setName("BranchCombo");
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){
            private Font _font = null;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null || !(value instanceof String)) {
                    return this;
                }
                this.setIcon(OracleIcons.getIcon((String)"branch.png"));
                this.setName((String)value);
                if (value.equals(GITBranchCompareWindow.this._trackBranch)) {
                    if (this._font == null) {
                        this._font = new Font(this.getFont().getFontName(), 1, this.getFont().getSize());
                    }
                    this.setFont(this._font);
                }
                return this;
            }
        };
        this._branchesCombo.setRenderer(renderer);
        this.addListener();
        Dimension d = new Dimension(SwingUtilities.computeStringWidth(this._branchesCombo.getFontMetrics(this._branchesCombo.getFont()), "ReasonablyLongGitBranchNameWithOrigin"), this._branchesCombo.getPreferredSize().height);
        this._branchesCombo.setMaximumSize(d);
        this._branchesCombo.setPreferredSize(d);
        this._branchesCombo.setMinimumSize(d);
        toolbar.add((Component)this._branchesCombo);
        toolbar.addSeparator();
        toolbar.add((ToggleAction)this.getLocalAction(51));
        toolbar.addFiller();
        toolbar.add((Component)this._branchNameLabel);
        return toolbar;
    }

    @Override
    protected final Node findOrCreateNode(ChangeListItem changeListItem, Project project) throws IllegalAccessException, InstantiationException {
        return changeListItem.findOrCreateNode();
    }

    protected IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    @Override
    protected void guiCreated() {
        this.getTable().addAncestorListener(new AncestorListener(){
            private BranchHoverable hoverable;
            {
                this.hoverable = new BranchHoverable();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                HoverableRegistry.registerComponent((Component)GITBranchCompareWindow.this.getTable(), (Hoverable)this.hoverable);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                HoverableRegistry.unregisterComponent((Component)GITBranchCompareWindow.this.getTable(), (Hoverable)this.hoverable);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    @Override
    protected String getThobberLabel() {
        return Resource.get("BRANCHLIST_IN_PROGRESS");
    }

    private void setBranchLabel(String text) {
        this._branchNameLabel.setText(text);
    }

    private void addListener() {
        if (this._listener == null) {
            this._listener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    GITBranchCompareWindow.this.refresh();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
        }
        this._branchesCombo.addPopupMenuListener(this._listener);
    }

    private void setBranchCombo(Map<String, GitBranch> branches) {
        BranchComboBoxModel model = (BranchComboBoxModel)this._branchesCombo.getModel();
        if (branches == null || branches.isEmpty()) {
            model.removeAllElements();
            return;
        }
        String branch = (String)model.getSelectedItem();
        HashSet<String> copyBranch = new HashSet<String>(branches.keySet());
        copyBranch.remove(this._activeBranch);
        model.add(copyBranch);
        if (branch != null && copyBranch.contains(branch)) {
            model.setSelectedItem(branch);
        } else if (this._trackBranch == null) {
            model.setSelectedItem(null);
        }
    }

    private URL getGitClientRoot(Workspace wks) {
        URL gitURL = GITUtil.getRootContaining(wks.getURL());
        if (gitURL == null) {
            URL url = wks.getActiveProjectURL();
            if (url == null) {
                return null;
            }
            gitURL = GITUtil.getRootContaining(url);
            if (gitURL != null) {
                return gitURL;
            }
            Project prj = wks.getActiveProject();
            if (prj.isOpen()) {
                Collection roots = ContentSetRoot.getContentSetRoots((Project)prj);
                for (ContentSetRoot root : roots) {
                    gitURL = GITUtil.getRootContaining(root.getURL());
                    if (gitURL == null) continue;
                    return gitURL;
                }
            }
        } else {
            return gitURL;
        }
        return null;
    }

    @Override
    protected final void refresh() {
        this.showMessage(Resource.get("BRANCHLIST_LOCATING"));
        SwingWorker<Runnable, Object> worker = new SwingWorker<Runnable, Object>(){
            private Exception _e;

            @Override
            protected Runnable doInBackground() throws Exception {
                return this._doInBackground();
            }

            @Override
            protected void done() {
                if (this._e != null) {
                    GITBranchCompareWindow.this.setBranchLabel("");
                    GITBranchCompareWindow.this.showMessage(this._e.getMessage());
                }
                try {
                    Runnable r = (Runnable)this.get();
                    if (r != null) {
                        r.run();
                    }
                    if (GITBranchCompareWindow.this._noBranch) {
                        GITBranchCompareWindow.this.setBranchLabel(Resource.get("BRANCH_NO_COMPARE_AGAINST"));
                        GITBranchCompareWindow.this.showMessage(Resource.get("BRANCH_NO_TRACKING"));
                        GITBranchCompareWindow.this._noBranch = false;
                    }
                    if (GITBranchCompareWindow.this._noDiffItems) {
                        GITBranchCompareWindow.this.setBranchLabel("");
                        GITBranchCompareWindow.this.showMessage(Resource.format("BRANCH_NO_ITEMS", GITBranchCompareWindow.this._activeBranch, GITBranchCompareWindow.this.getBranchCompare()));
                        GITBranchCompareWindow.this._noDiffItems = false;
                    }
                    if (this._e != null) {
                        GITBranchCompareWindow.this.setBranchLabel("");
                        GITBranchCompareWindow.this.showMessage(this._e.getMessage());
                    }
                    if (r == null) {
                        GITBranchCompareWindow.this.setBranchCombo(null);
                        GITBranchCompareWindow.this.setBranchLabel("");
                        GITBranchCompareWindow.this.showMessage(Resource.get("GIT_REPOS_NOT_DETERMINE"));
                    }
                }
                catch (Exception e) {
                    GITBranchCompareWindow.this.setBranchLabel("");
                    GITBranchCompareWindow.this.showMessage(e.getMessage());
                }
            }

            private Runnable _doInBackground() throws Exception {
                GitClient client = this.getGitClient();
                if (client == null) {
                    return null;
                }
                final HashMap<String, GitBranch> branches = new HashMap<String, GitBranch>();
                branches.putAll(this.getBranches(client));
                GitBranch activeBranch = GITUtil.getActiveBranch(branches);
                GitBranch trackBranch = activeBranch.getTrackedBranch();
                GITBranchCompareWindow.this._activeBranch = activeBranch.getName();
                if (trackBranch == null) {
                    GITBranchCompareWindow.this._trackBranch = null;
                } else {
                    GITBranchCompareWindow.this._trackBranch = trackBranch.getName();
                }
                final HashMap<VCSHashURL, GitRevisionInfo.GitFileInfo> trackUrls = new HashMap<VCSHashURL, GitRevisionInfo.GitFileInfo>();
                String cmpBranch = GITBranchCompareWindow.this.getCompareBranch(branches.keySet());
                final int trackNoCommits = this.getFiles(client, GITBranchCompareWindow.this._activeBranch, cmpBranch, trackUrls);
                final HashMap<VCSHashURL, GitRevisionInfo.GitFileInfo> activeUrls = new HashMap<VCSHashURL, GitRevisionInfo.GitFileInfo>();
                final int activeNoCommits = this.getFiles(client, cmpBranch, GITBranchCompareWindow.this._activeBranch, activeUrls);
                final boolean mergeResolved = GITBranchCompareWindow.this.conflictState(client);
                final Map bothUrls = GITBranchCompareWindow.this.pullInfoBothBranches(client, activeUrls, trackUrls, cmpBranch, mergeResolved);
                return new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            GITBranchCompareWindow.this.setBranchCombo(branches);
                            if (GITBranchCompareWindow.this._trackBranch == null && GITBranchCompareWindow.this.getBranchCompare() == null) {
                                GITBranchCompareWindow.this._noBranch = true;
                                return;
                            }
                            boolean selection = GITBranchCompareWindow.this._trackBranch == null || !GITBranchCompareWindow.this._trackBranch.equals(GITBranchCompareWindow.this.getBranchCompare());
                            this.setBranchLabel(GITBranchCompareWindow.this._activeBranch, selection ? GITBranchCompareWindow.this.getBranchCompare() : GITBranchCompareWindow.this._trackBranch, selection, !activeUrls.isEmpty(), !trackUrls.isEmpty(), activeNoCommits, trackNoCommits, mergeResolved);
                            ArrayList<BranchListItem> items = new ArrayList<BranchListItem>();
                            this.getItems(items, trackUrls, bothUrls, GITBranchCompareWindow.this.getBranchCompare());
                            this.getItems(items, activeUrls, bothUrls, GITBranchCompareWindow.this._activeBranch);
                            Object model = GITBranchCompareWindow.this.getTable().getModel();
                            if (!(model instanceof GITBranchTableModel)) {
                                DisplayProperty[] properties = this.getDisplayProperties();
                                model = new GITBranchTableModel(properties);
                                GITBranchCompareWindow.this.installModel((GITBranchTableModel)model);
                            }
                            ((GITBranchTableModel)model).addItems(items);
                            GITBranchCompareWindow.this.showResults();
                            if (items.size() == 0) {
                                GITBranchCompareWindow.this._noDiffItems = true;
                            }
                        }
                        catch (Exception e) {
                            _e = new Exception(Resource.get("BRANCH_ERROR"), e);
                            GITProfile.getQualifiedLogger(GITBranchCompareWindow.class.getName()).log(Level.WARNING, "_doInBackground - " + e.toString());
                        }
                    }

                    private void getItems(Collection<BranchListItem> items, Map<VCSHashURL, GitRevisionInfo.GitFileInfo> files, Map<VCSHashURL, Pair<String, Icon>> bothUrls2, String name) {
                        for (VCSHashURL vcsUrl : files.keySet()) {
                            GitRevisionInfo.GitFileInfo info = files.get(vcsUrl);
                            Pair<String, Icon> combined = bothUrls2.get(vcsUrl);
                            BranchListItem item = new BranchListItem(combined == null ? this.StatusLookup(info) : (String)combined.getFirst(), vcsUrl.getURL(), name);
                            if (info.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.RENAMED) || info.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.COPIED)) {
                                try {
                                    item.setOrginal(info.getOriginalFile().toURI().toURL());
                                }
                                catch (MalformedURLException e) {
                                    // empty catch block
                                }
                            }
                            if (combined != null) {
                                item.setIcon((Icon)combined.getSecond());
                            }
                            items.add(item);
                        }
                    }

                    private String StatusLookup(GitRevisionInfo.GitFileInfo info) {
                        if (info.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.ADDED)) {
                            return Resource.get("BRANCH_ADDED");
                        }
                        if (info.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.MODIFIED)) {
                            return Resource.get("BRANCH_MODIFIED");
                        }
                        if (info.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.COPIED)) {
                            return Resource.get("BRANCH_COPIED");
                        }
                        if (info.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.REMOVED)) {
                            return Resource.get("BRANCH_REMOVED");
                        }
                        if (info.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.RENAMED)) {
                            return Resource.get("BRANCH_RENAMED");
                        }
                        return Resource.get("BRANCH_UNKOWNED");
                    }

                    private void setBranchLabel(String activeBranch, String compareBranch, boolean branchSelection, boolean activeHead, boolean trackHead, int activeNo, int trackNo, boolean mergeResolved2) {
                        StringBuilder sb = new StringBuilder(Resource.format(branchSelection ? "BRANCH_LABEL_COMPARE" : "BRANCH_LABEL", activeBranch, compareBranch));
                        if (activeHead && trackHead) {
                            sb.append(Resource.format("BRANCH_LABEL_INFO1", activeNo, trackNo));
                            if (mergeResolved2) {
                                sb.append(Resource.get("BRANCH_LABEL_MERGE"));
                            }
                        } else if (activeHead) {
                            sb.append(Resource.format("BRANCH_LABEL_INFO3", activeNo));
                        } else if (trackHead) {
                            sb.append(Resource.format(branchSelection ? "BRANCH_LABEL_COMPARE_INFO2" : "BRANCH_LABEL_INFO2", trackNo));
                        }
                        GITBranchCompareWindow.this._branchNameLabel.setText(sb.toString());
                    }

                    private DisplayProperty[] getDisplayProperties() {
                        DisplayProperty[] props = new DisplayProperty[]{new ClientDisplayProperty(Resource.get("BRANCH_COLUMN_TYPE"), null, 2, (Object)" Renamed from ", null, String.class, 100), new ClientDisplayProperty(Resource.get("BRANCH_COLUMN_FILE"), null, 2, (Object)" a-reasonable-long-file-name ", null, String.class, 100), new ClientDisplayProperty(Resource.get("BRANCH_COLUMN_LOCATION"), null, 2, (Object)" /some/example/path/that/is/reasonably/long/for/a/file/that/is/under/git/control ", null, String.class, 600), new ClientDisplayProperty(Resource.get("BRANCH_COLUMN_BRANCH"), null, 2, (Object)" origin/master ", null, String.class, 100)};
                        return props;
                    }
                };
            }

            private int getFiles(GitClient client, String fromBranch, String toBranch, Map<VCSHashURL, GitRevisionInfo.GitFileInfo> modURLS) throws GitException.MissingObjectException, GitException {
                if (fromBranch == null) {
                    return 0;
                }
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
                SearchCriteria criteria = new SearchCriteria();
                criteria.setRevisionFrom(fromBranch);
                criteria.setRevisionTo(toBranch);
                criteria.setFollowRenames(true);
                criteria.setIncludeMerges(false);
                GitRevisionInfo revisionInfo = client.log(fromBranch, (ProgressMonitor)monitor);
                GitRevisionInfo[] infos = client.log(criteria, (ProgressMonitor)monitor);
                for (int i = infos.length - 1; i >= 0; --i) {
                    if (infos[i].getRevision().equals(revisionInfo.getRevision())) continue;
                    Map files = infos[i].getModifiedFiles();
                    for (File file : files.keySet()) {
                        GitRevisionInfo.GitFileInfo fInfo = (GitRevisionInfo.GitFileInfo)files.get(file);
                        modURLS.put(new VCSHashURL(URLFactory.newFileURL((File)fInfo.getFile())), fInfo);
                    }
                }
                return infos.length;
            }

            private GitClient getGitClient() throws GitException {
                URL tRoot = null;
                if (!Product.isJDeveloper()) {
                    NavigatorWindow window = Ide.getLastActiveNavigator();
                    if (window != null) {
                        Context context = window.getContext();
                        Node node = context.getNode();
                        if (node != null && node.getURL() != null) {
                            tRoot = GITUtil.getRootContaining(node.getURL());
                        } else {
                            Element elm = context.getElement();
                            if (elm != null && elm instanceof Locatable && ((Locatable)elm).getURL() != null) {
                                tRoot = GITUtil.getRootContaining(((Locatable)elm).getURL());
                            }
                        }
                    }
                } else {
                    URL gitUrl;
                    Workspace wks = Ide.getActiveWorkspace();
                    if (wks == null) {
                        return null;
                    }
                    tRoot = gitUrl = GITBranchCompareWindow.this.getGitClientRoot(wks);
                }
                if (tRoot != null) {
                    _gitRoot = tRoot;
                }
                if (_gitRoot == null) {
                    return null;
                }
                return GITClientAdaptor.getClient(_gitRoot);
            }

            private Map<String, GitBranch> getBranches(GitClient client) throws GitException {
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
                return client.getBranches(true, (ProgressMonitor)monitor);
            }
        };
        this.showProgress();
        worker.execute();
    }

    @Override
    protected Controller createController() {
        return new GITBranchMenuController();
    }

    @Override
    protected void createLocalActions() {
        int mnemonic = StringUtils.getMnemonicKeyCode((String)Resource.get("MENU_BRANCH_COMPARE"));
        IdeAction action = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)GITBranchCompare.COMMAND_ID), (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.git"), "oracle.jdevimpl.vcs.git.branchcompare.GITBranchCompare"), (String)Resource.get("MENU_BRANCH_COMPARE"), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(mnemonic), null, null, (boolean)true);
        action.addController(this.getController());
        action.putValue("LongDescription", (Object)Resource.get("MENU_BRANCH_COMPARE"));
        mnemonic = StringUtils.getMnemonicKeyCode((String)Resource.get("MENU_BRANCH_MERGE"));
        action = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)GITBranchMergeCommand.COMMAND_ID), (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.git"), "oracle.jdevimpl.vcs.git.branchcompare.GITBranchMergeCommand"), (String)Resource.get("MENU_BRANCH_MERGE"), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(mnemonic), null, null, (boolean)true);
        action.addController(this.getController());
    }

    @Override
    protected ContextMenuListener getContextMenuListener() {
        return new GITBranchCompareMenuListener();
    }

    @Override
    protected void registerMenuItems(ContextMenu contextMenu) {
    }

    private Map<VCSHashURL, Pair<String, Icon>> pullInfoBothBranches(GitClient client, Map<VCSHashURL, GitRevisionInfo.GitFileInfo> activeUrls, Map<VCSHashURL, GitRevisionInfo.GitFileInfo> trackUrls, String cmpBranch, boolean mergeResolved) throws GitException {
        if (activeUrls.isEmpty() || trackUrls.isEmpty() || mergeResolved) {
            return Collections.emptyMap();
        }
        HashMap<VCSHashURL, Pair<String, Icon>> combinedInfo = new HashMap<VCSHashURL, Pair<String, Icon>>();
        for (VCSHashURL url : trackUrls.keySet()) {
            if (!activeUrls.containsKey(url)) continue;
            GitRevisionInfo.GitFileInfo trStatus = trackUrls.get(url);
            GitRevisionInfo.GitFileInfo acStatus = activeUrls.get(url);
            if (!trStatus.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.MODIFIED) || !acStatus.getStatus().equals((Object)GitRevisionInfo.GitFileInfo.Status.MODIFIED) || !this.isConflict(client, url, this._activeBranch, cmpBranch)) continue;
            combinedInfo.put(url, (Pair<String, Icon>)new Pair((Object)Resource.get("BRANCH_CONFLICT"), (Object)OracleIcons.getIcon((String)"union.png")));
        }
        return combinedInfo;
    }

    private boolean conflictState(GitClient client) throws GitException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("getRepositoryState");
        GitRepositoryState state = client.getRepositoryState((ProgressMonitor)monitor);
        return state == GitRepositoryState.MERGING_RESOLVED;
    }

    private String getCompareBranch(Set<String> branches) {
        if (this.getBranchCompare() == null || !branches.contains(this.getBranchCompare())) {
            return this._trackBranch;
        }
        return this.getBranchCompare();
    }

    private boolean isConflict(GitClient client, VCSHashURL url, String actBranch, String cmpBranch) throws GitException {
        try {
            InputStreamTextContributor ancestorContributor;
            InputStreamTextContributor cmpContributor;
            InputStream actIo = GITHistoryEntryProducer.openInputStream(url.getURL(), actBranch);
            InputStream cmpIo = GITHistoryEntryProducer.openInputStream(url.getURL(), cmpBranch);
            InputStream ancesterIO = this.getAncestor(client, url.getURL(), actBranch, cmpBranch);
            if (ancesterIO == null) {
                return false;
            }
            String type = URLFileSystem.getSuffix((URL)url.getURL());
            InputStreamTextContributor actContributor = new InputStreamTextContributor(actIo, "", "", type);
            CompareModel model = CompareModelFactory.createMergeModel((CompareContributor)actContributor, (CompareContributor)(cmpContributor = new InputStreamTextContributor(cmpIo, "", "", type)), (CompareContributor)(ancestorContributor = new InputStreamTextContributor(ancesterIO, "", "", type)));
            return model.getConflictCount() > 0;
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Failed isConflict " + e.getMessage());
            return true;
        }
    }

    private InputStream getAncestor(GitClient client, URL url, String actBranch, String cmpBranch) throws GitException {
        String[] revisions = new String[]{actBranch, cmpBranch};
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("catFile");
        Collection<File> files = GITUtil.convertURLToFile(new URL[]{url});
        GitRevisionInfo info = client.getCommonAncestor(revisions, (ProgressMonitor)monitor);
        ByteArrayOutputStream ancestorOS = new ByteArrayOutputStream();
        if (client.catFile(files.toArray(new File[0])[0], info.getRevision(), (OutputStream)ancestorOS, (ProgressMonitor)monitor)) {
            return new ByteArrayInputStream(ancestorOS.toByteArray());
        }
        return null;
    }

    private void installModel(GITBranchTableModel model) {
        this.getTable().setModel((TableModel)((Object)model));
        if (this._labelEllipseRenderer == null) {
            this._labelEllipseRenderer = new GITLabelTableCellEllipseRenderer();
        }
        this.getTable().getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)((Object)this._labelEllipseRenderer)));
        if (this._labelIconRenderer == null) {
            this._labelIconRenderer = new GITLabelTableCellIconRenderer();
        }
        this.getTable().getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)this._labelIconRenderer));
        this.getTable().setSorted(true);
        this.autoSizeCoumnstoFit(model);
    }

    private void autoSizeCoumnstoFit(GITBranchTableModel model) {
        Object[] prototypeValues = new Object[model.getColumnCount()];
        for (int i = 0; i < prototypeValues.length; ++i) {
            prototypeValues[i] = model.getProperty(i).getPrototypeValue();
        }
        this.getTable().autoSizeColumnsToFit(prototypeValues);
    }

    private static class GITLabelTableCellIconRenderer
    extends DefaultTableCellRenderer {
        private GITLabelTableCellIconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            BranchListItem item = (BranchListItem)((GITBranchTableModel)((Object)table.getModel())).getItem(row);
            if (item.getIcon() != null) {
                this.setIcon(item.getIcon());
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private static class GITLabelTableCellEllipseRenderer
    extends LabelTableCellRenderer {
        private GITLabelTableCellEllipseRenderer() {
        }

        public void formatLabel(JLabel label, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Ellipses.setEllipsesLocation((JLabel)label, (int)10);
        }
    }

    private class BranchComboBoxModel
    extends DefaultComboBoxModel {
        private Comparator _compare = new BranchComparator();

        private BranchComboBoxModel() {
        }

        private void add(Set<String> branches) {
            this.removeAllElements();
            ArrayList<String> sBranches = new ArrayList<String>(branches);
            Collections.sort(sBranches, this._compare);
            for (int b = 0; b < branches.size(); ++b) {
                this.addElement(sBranches.get(b));
            }
        }

        private class BranchComparator
        implements Comparator {
            private BranchComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof String) && !(o2 instanceof String)) {
                    return 0;
                }
                String s1 = (String)o1;
                String s2 = (String)o2;
                if (s1.equals(GITBranchCompareWindow.this._trackBranch)) {
                    return -1;
                }
                if (s2.equals(GITBranchCompareWindow.this._trackBranch)) {
                    return 1;
                }
                if (s1.contains("/") && !s2.contains("/")) {
                    return -1;
                }
                if (s2.contains("/") && !s1.contains("/")) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        }
    }

    private class BranchHoverable
    implements Hoverable {
        private BranchHoverable() {
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            SwingUtilities.convertPointFromScreen(p, (Component)GITBranchCompareWindow.this.getTable());
            int row = GITBranchCompareWindow.this.getTable().rowAtPoint(p);
            int col = GITBranchCompareWindow.this.getTable().columnAtPoint(p);
            if (row < 0 || col < 0) {
                return null;
            }
            GITBranchTableModel model = (GITBranchTableModel)((Object)GITBranchCompareWindow.this.getTable().getModel());
            BranchListItem item = (BranchListItem)model.getItem(row);
            if (item.getOrginal() != null && flavors.contains(HoverFlavor.getFlavor((String)"info"))) {
                JPanel content = this.getContent(item);
                InfoTipHover hover = new InfoTipHover((Template)new ActionTemplate(null, item.getChangeType(), (JComponent)content, null), InfoTipStyles.DEFAULT, (JComponent)GITBranchCompareWindow.this.getTable(), this.getHoverBounds((JTable)GITBranchCompareWindow.this.getTable(), p), HoverFlavor.getFlavor((String)"data"));
                hover.showHover();
                return hover;
            }
            return null;
        }

        private JPanel getContent(BranchListItem item) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JLabel label = new JLabel(Resource.format("BRANCH_WASNOW", URLFileSystem.getPlatformPathName((URL)item.getOrginal()), URLFileSystem.getPlatformPathName((URL)item.getURL())));
            panel.add((Component)label, "Center");
            return panel;
        }

        protected Rectangle getHoverBounds(JTable table, Point p) {
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            Rectangle bounds = table.getCellRect(row, col, false);
            return new Rectangle(Math.max(0, p.x - 1), bounds.y, 3, bounds.height);
        }
    }
}

