/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.branchcompare.spi;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.controls.ThrobberLabel;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdevimpl.vcs.git.branchcompare.spi.VersionTableModel;
import oracle.jdevimpl.vcs.util.PopupMenuListener;

public abstract class TableDockableWindow
extends DockableWindow {
    private static final String GUI_PROGRESS = "Progress";
    private static final String GUI_MESSAGE = "Message";
    private static final String GUI_RESULTS = "Results";
    private final Controller _controller = this.createController();
    private boolean _initialized;
    private JPanel _gui;
    private JPanel _center;
    private Toolbar _toolbar;
    private ContextMenu _contextMenu;
    private boolean _busy;
    private CardLayout _layout;
    private ThrobberLabel _progress;
    private FocusableLabel _message;
    private BranchGenericTable _vop;

    protected abstract Controller createController();

    protected abstract void createLocalActions();

    protected abstract void refresh();

    protected abstract String getThobberLabel();

    protected abstract Toolbar getToolbarImpl();

    protected abstract ContextMenuListener getContextMenuListener();

    protected abstract void registerMenuItems(ContextMenu var1);

    protected abstract Node findOrCreateNode(ChangeListItem var1, Project var2) throws IllegalAccessException, InstantiationException;

    protected abstract void guiCreated();

    public TableDockableWindow(String viewId) {
        super(viewId);
        this.createLocalActions();
        this.setType(96);
    }

    public final void dockableShown(DockableEvent event) {
        super.dockableShown(event);
        if (this.isBusy()) {
            return;
        }
        this.initialize();
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public final Controller getController() {
        return this._controller;
    }

    protected Element[] getSelectionFromUI() {
        return this._vop.isShowing() ? this._vop.getSelection() : new Element[]{};
    }

    protected final GenericTable getTable() {
        if (this._vop == null) {
            this._vop = new BranchGenericTable();
            this._vop.addMouseListener(new TableMouseListener());
        }
        return this._vop;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = new JPanel(new BorderLayout());
            this._layout = new CardLayout();
            this._center = new JPanel(this._layout);
            this._progress = new ThrobberLabel(this.getThobberLabel());
            this._message = new FocusableLabel();
            this._message.setName("VersionMessageLabel");
            this._center.add((Component)this._progress, GUI_PROGRESS);
            this._center.add((Component)this._message, GUI_MESSAGE);
            this._center.add((Component)new JScrollPane((Component)this.getTable()), GUI_RESULTS);
            this._gui.add((Component)this.getToolbar(), "North");
            this._gui.add((Component)this._center, "Center");
            this.getTable().addMouseListener((MouseListener)new PopupMenuListener((View)this));
            this.guiCreated();
        }
        return this._gui;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = this.getToolbarImpl();
        }
        return this._toolbar;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu(new MnemonicSolver());
            this.registerMenuItems(this._contextMenu);
            this._contextMenu.addContextMenuListener(this.getContextMenuListener());
        }
        return this._contextMenu;
    }

    public final Context getContext(EventObject eo) {
        Context context = super.getContext(eo);
        Element[] selection = this.getSelectionFromUI();
        context.setSelection(selection);
        return context;
    }

    private final void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                TableDockableWindow.this.refresh();
            }
        });
    }

    public final boolean isBusy() {
        return this._busy;
    }

    protected final void showProgress() {
        this._busy = true;
        this._layout.show(this._center, GUI_PROGRESS);
        this._center.invalidate();
        this.updateVisibleActions();
        if (this.isWindowActive()) {
            this._progress.requestFocusInWindow();
        }
    }

    protected final void showMessage(String message) {
        this._busy = false;
        this._message.setText(message);
        this._layout.show(this._center, GUI_MESSAGE);
        this._center.invalidate();
        this.updateVisibleActions();
        if (this.isWindowActive()) {
            this._message.requestFocusInWindow();
        }
    }

    protected final void showResults() {
        this._busy = false;
        this._layout.show(this._center, GUI_RESULTS);
        this._center.invalidate();
        this.updateVisibleActions();
        if (this.isWindowActive()) {
            this._vop.requestFocusInWindow();
        }
    }

    private final boolean isWindowActive() {
        return (DockStation.getDockStation().getDockableStatus((Dockable)this) & 0x10) > 0;
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        private final void selectOnRightClick(MouseEvent me) {
            int row = TableDockableWindow.this.getTable().rowAtPoint(me.getPoint());
            if (row < 0 || row >= TableDockableWindow.this.getTable().getModel().getRowCount()) {
                return;
            }
            if (!TableDockableWindow.this.getTable().isRowSelected(row)) {
                TableDockableWindow.this.getTable().setRowSelectionInterval(row, row);
            }
            TableDockableWindow.this.getGUI().requestFocus();
        }
    }

    private class BranchGenericTable
    extends GenericTable {
        private BranchGenericTable() {
        }

        private Element[] getSelection() {
            int[] selectedRows;
            if (this.getModel().getRowCount() > 0 && (selectedRows = this.getSelectedRowsInModel()) != null && selectedRows.length > 0) {
                ArrayList<Element> selection = new ArrayList<Element>(selectedRows.length);
                for (int i = 0; i < selectedRows.length; ++i) {
                    int rowIndex = selectedRows[i];
                    if (rowIndex >= this.getModel().getRowCount()) continue;
                    selection.add(((VersionTableModel)((Object)this.getModel())).getItem(rowIndex));
                }
                Element[] arr = new Element[selection.size()];
                selection.toArray(arr);
                return arr;
            }
            return new Element[0];
        }
    }
}

