/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITStatusResolver;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedNodeAbstractOperation;
import oracle.jdevimpl.vcs.git.cmd.GITOperationAdd;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.cmd.GITStatusNotCommited;
import oracle.jdevimpl.vcs.git.cmd.custom.GITCommitCustomizer;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationCommit
extends GITExtendedNodeAbstractOperation {
    private static VCSRecentCommentsModel _recentCommentsModel;
    protected static final GITStatusFilter _filter;
    private Boolean _commitConflict;

    public GITOperationCommit() {
        super("oracle.jdeveloper.git.commit");
    }

    protected GITOperationCommit(String id) {
        super(id);
    }

    public static final VCSRecentCommentsModel getRecentCommentsModel() {
        if (_recentCommentsModel == null) {
            _recentCommentsModel = new VCSRecentCommentsModel();
        }
        return _recentCommentsModel;
    }

    protected boolean locatablesValid(VCSProfile profile) {
        Element elm = this.getContext().getElement();
        if (elm != null && elm.mayHaveChildren()) {
            return true;
        }
        return super.locatablesValid(profile);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] fileLocs;
        if (this.isCommitConflict()) {
            return this.getRootOperand(profile);
        }
        Collection<Locatable> flds = this.findFolders(profile);
        if (flds.isEmpty()) {
            return super.getOperands(profile);
        }
        ArrayList<Locatable> locs = new ArrayList<Locatable>();
        this.getFilteredCollectionWithProgress(locs, flds, _filter, Resource.get("COMMIT_ALL_PROGRESS_TITLE"), Resource.get("COMMIT_ALL_PROGRESS"));
        for (Locatable loc : fileLocs = super.getOperands(profile)) {
            if (URLFileSystem.isDirectoryPath((URL)loc.getURL())) continue;
            locs.add(loc);
        }
        return locs.toArray(new Locatable[0]);
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables) throws Exception {
        CommandState state = super.getCommandState(profile, locatables);
        if (state == null) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_NO_COMMITALL"), (String)Resource.get("INFO_NO_COMMITALL_TITLE"), null);
        }
        return state;
    }

    protected String getDialogHint() {
        if (this.isCommitConflict()) {
            return Resource.get("COMMIT_RESOLVE_CONFLICTS");
        }
        return super.getDialogHint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor(parentUi, Resource.get("OPERATION_COMMIT_PROGRESS_TITLE"));
        progress.setMillisToPopup(0);
        progress.setCloseOnFinish(true);
        progress.setCancellable(false);
        progress.start();
        try {
            boolean bl = this.invokeCommit(profile, commandState, options, progress);
            return bl;
        }
        finally {
            if (!progress.isCancelled()) {
                progress.finish();
            }
        }
    }

    @Override
    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return this.invokeCommit(profile, commandState, options, null);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        int stat;
        Collection<Locatable> flds = this.findFolders(profile);
        if (!flds.isEmpty() && (stat = this.saveNodesIfDirty(flds.toArray(new Locatable[0]))) != 0) {
            return stat;
        }
        Locatable[] locatables = this.getOperands(profile);
        int stat2 = this.saveNodesIfDirty(locatables);
        if (stat2 != 0) {
            return stat2;
        }
        return this.doitImplInvoke(profile, locatables);
    }

    protected void setCommandSpecificCustomizerOptions(VCSProfile profile, VCSOptionsCustomizer customizer) {
        String id = profile.getID();
        String key = id + ".pending_changes_comment";
        String comment = (String)profile.getObject(key);
        if (comment != null) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("setting_comments", comment);
            customizer.setOptions(m);
        }
    }

    private boolean invokeCommit(VCSProfile profile, CommandState commandState, Map options, IndeterminateProgressMonitor progress) throws Exception {
        String comment = (String)options.get("setting_comments");
        Boolean commitNonStaged = (Boolean)options.get("commit-not-staged") == null ? Boolean.FALSE : (Boolean)options.get("commit-not-staged");
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Commit");
            Locatable[] locs = commandState.getLocatables();
            monitor.setLog(true);
            if (!this.isCommitConflict()) {
                client = GITClientAdaptor.getClient(URLFileSystem.getParent((URL)locs[0].getURL()));
            }
            if (client == null) {
                client = GITClientAdaptor.getClient(locs[0].getURL());
            }
            Collection<URL> processed = this.getProcessedUrlsNotifier(commandState);
            Collection<URL> process = this.commit(locs, monitor, client, comment, commitNonStaged, progress);
            processed.addAll(process);
            commandState.setProperty("git.structure-changed", processed);
        }
        catch (GitException ge) {
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), (Exception)((Object)ge));
        }
        catch (GITProcessException gitpe) {
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), (Exception)((Object)gitpe));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.git", (VCSOptionsCustomizer)new GITCommitCustomizer(!this.isCommitConflict()));
        customizer.setShowReuseCommentsOption(false);
        customizer.setRecentCommentsModel(GITOperationCommit.getRecentCommentsModel());
        customizer.setShowTemplatesAndCommentsCombo(true);
        customizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get("VCS_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        if (this.isAutoAddFiles()) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("commit-not-staged", Boolean.TRUE);
            customizer.setOptions(options);
        }
        return customizer;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        Collection eventUrls = (Collection)commandState.getProperty("git.structure-changed");
        if (eventUrls.isEmpty()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_COMMIT_NO_FILES"), (String)Resource.get("INFO_COMMIT_NO_FILES_TITLE"), null);
            return;
        }
        super.postInvoke(profile, commandState);
    }

    private Collection<URL> commit(Locatable[] children, GITCommandProgressMonitor monitor, GitClient client, String comment, Boolean commitNonStaged, final IndeterminateProgressMonitor progress) throws Exception, Exception {
        Collection<File> cmFiles;
        Collection<File> files = GITUtil.convertLocatableToFile(children);
        if (commitNonStaged.booleanValue()) {
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return progress.isCanceled();
                }
            };
            monitor.setOperation("add");
            Collection<URL> urls = GITUtil.convertLocatableToURL(children);
            Collection<Locatable> toAdd = this.getFilteredCollection(urls.toArray(new URL[0]), new GITOperationAdd.GitStatusUnadded(), cancellable);
            if (!toAdd.isEmpty()) {
                Collection<File> addFiles = GITUtil.convertLocatableToFile(toAdd.toArray(new Locatable[0]));
                this.updateProgress(progress, Resource.get("COMMIT_PROGRESS_ADD"));
                client.add(addFiles.toArray(new File[0]), (ProgressMonitor)monitor);
            }
        }
        if (!(cmFiles = this.isCommitConflict() ? files : this.getCommitFiles(client, files)).isEmpty()) {
            monitor.setOperation("commit");
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), monitor.getError());
            }
            this.updateProgress(progress, Resource.get("COMMIT_PROGRESS_COMMIT"));
            GitRevisionInfo info = client.commit(cmFiles.toArray(new File[0]), comment, client.getUser(), client.getUser(), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), monitor.getError());
            }
            Map modified = info.getModifiedFiles();
            if (modified != null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                Iterator it = modified.keySet().iterator();
                while (it.hasNext()) {
                    urls.add(URLFactory.newFileURL((File)((File)it.next())));
                }
                return urls;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCommitConflict() {
        if (this._commitConflict != null) {
            return this._commitConflict;
        }
        this._commitConflict = new Boolean(false);
        Context context = this.getContext();
        GitClient client = null;
        try {
            URL url = this.getUrlFromContext(context);
            if (url != null) {
                client = GITClientAdaptor.getClient(url);
                if (client == null) {
                    boolean bl = false;
                    return bl;
                }
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("getRepositoryState");
                GitRepositoryState state = client.getRepositoryState((ProgressMonitor)monitor);
                if (state == GitRepositoryState.MERGING_RESOLVED) {
                    this._commitConflict = Boolean.TRUE;
                }
            }
        }
        catch (GitException gitException) {
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return this._commitConflict;
    }

    private URL getUrlFromContext(Context context) {
        Node node = context.getNode();
        if (node != null) {
            return node.getURL();
        }
        Element elm = context.getElement();
        if (elm != null && elm instanceof Locatable) {
            return ((Locatable)elm).getURL();
        }
        URL[] compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)elm);
        if (compositeFileUrls != null && compositeFileUrls.length > 0) {
            return compositeFileUrls[0];
        }
        return null;
    }

    private Collection<File> getCommitFiles(GitClient client, Collection<File> files) throws GitException {
        ArrayList<File> clFile = new ArrayList<File>();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("status");
        Map status = client.getStatus(files.toArray(new File[0]), (ProgressMonitor)monitor);
        for (File file : status.keySet()) {
            GitStatus stat = (GitStatus)status.get(file);
            if (stat.isRenamed()) {
                clFile.add(file);
                continue;
            }
            if (GITStatusResolver.isDeleted(stat)) {
                clFile.add(file);
                continue;
            }
            if (GITStatusResolver.isAddedModified(stat)) {
                clFile.add(file);
                continue;
            }
            if (stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL) && (stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) || stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_ADDED))) {
                clFile.add(file);
                continue;
            }
            if (!stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) || !stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED)) continue;
            clFile.add(file);
        }
        return clFile;
    }

    private Collection<File> getNonStagedFiles(Collection<File> files) {
        return null;
    }

    protected boolean isAutoAddFiles() {
        return VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.git").getAutoAddFiles();
    }

    static {
        _filter = new GITStatusNotCommited();
    }
}

